/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-08-06 18:58:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpev_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=93912 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=897 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_ewwwio_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `backup` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int(10) unsigned DEFAULT NULL,
  `pending` tinyint(4) NOT NULL DEFAULT '0',
  `updates` int(10) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1971-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  PRIMARY KEY (`id`),
  KEY `path` (`path`(191)),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2835 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_ewwwio_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(20) DEFAULT NULL,
  `scanned` tinyint(4) NOT NULL DEFAULT '0',
  `new` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=255 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=107302 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1978 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1425 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_entries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `unread` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referring_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_entry_data` (
  `entry_id` int(10) unsigned NOT NULL,
  `element_id` int(10) unsigned NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`entry_id`,`element_id`),
  KEY `element_id` (`element_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_entry_entry_labels` (
  `entry_id` int(10) unsigned NOT NULL,
  `entry_label_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`entry_id`,`entry_label_id`),
  KEY `entry_label_id` (`entry_label_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_entry_labels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `color` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `config` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `trashed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `active` (`active`),
  KEY `trashed` (`trashed`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_quform_sessions` (
  `id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_activity` int(10) unsigned NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `hover` longtext COLLATE utf8mb4_unicode_520_ci,
  `advanced` longtext COLLATE utf8mb4_unicode_520_ci,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `markup` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `alias` tinytext COLLATE utf8mb4_unicode_520_ci,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `type` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=1575 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=4676 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10888 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=3121 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1824 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=3189 DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpev_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=MyISAM AUTO_INCREMENT=389 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wpev_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpev_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1026 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wpev_actionscheduler_actions */
INSERT INTO `wpev_actionscheduler_actions` VALUES("289", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-28 15:12:06", "2021-07-28 15:12:06", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627485126;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627485126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-28 15:12:10", "2021-07-28 15:12:10", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("286", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-25 15:10:08", "2021-07-25 15:10:08", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627225808;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627225808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-25 15:10:09", "2021-07-25 15:10:09", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("287", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-26 15:10:09", "2021-07-26 15:10:09", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627312209;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627312209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-26 15:11:13", "2021-07-26 15:11:13", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("288", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-27 15:11:13", "2021-07-27 15:11:13", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627398673;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627398673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-27 15:12:06", "2021-07-27 15:12:06", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("280", "wpforms_admin_builder_templates_cache_update", "complete", "2021-07-29 16:22:38", "2021-07-29 16:22:38", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627575758;s:18:\"\0*\0first_timestamp\";i:1627575758;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627575758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-29 16:23:11", "2021-07-29 16:23:11", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("261", "wpforms_admin_addons_cache_update", "complete", "2021-06-17 21:05:08", "2021-06-17 21:05:08", "{\"tasks_meta_id\":22}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1623963908;s:18:\"\0*\0first_timestamp\";i:1617913608;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1623963908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-22 15:08:21", "2021-07-22 15:08:21", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("309", "wpforms_process_entry_emails_meta_cleanup", "pending", "2021-08-07 15:18:10", "2021-08-07 15:18:10", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628349490;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628349490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("299", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-01 15:15:15", "2021-08-01 15:15:15", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627830915;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627830915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-01 15:16:12", "2021-08-01 15:16:12", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("300", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-02 15:16:12", "2021-08-02 15:16:12", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627917372;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627917372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-02 15:16:17", "2021-08-02 15:16:17", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("301", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-03 15:16:17", "2021-08-03 15:16:17", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628003777;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628003777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-03 15:17:06", "2021-08-03 15:17:06", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("267", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-06-17 03:35:03", "2021-06-17 03:35:03", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1623900903;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1623900903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-22 15:08:21", "2021-07-22 15:08:21", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("291", "wpforms_admin_addons_cache_update", "complete", "2021-08-05 15:09:08", "2021-08-05 15:09:08", "{\"tasks_meta_id\":22}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628176148;s:18:\"\0*\0first_timestamp\";i:1617913608;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628176148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-08-05 15:09:27", "2021-08-05 15:09:27", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("276", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":24}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-07-22 15:08:58", "2021-07-22 15:08:58", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("277", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":25}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-07-22 15:08:59", "2021-07-22 15:08:59", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("310", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":30}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-08-06 18:57:19", "2021-08-06 18:57:19", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("290", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-29 15:12:10", "2021-07-29 15:12:10", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627571530;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627571530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-29 15:13:12", "2021-07-29 15:13:12", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("281", "action_scheduler/migration_hook", "complete", "2021-07-22 16:30:36", "2021-07-22 16:30:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1626971436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1626971436;}", "1", "1", "2021-07-22 16:30:37", "2021-07-22 16:30:37", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("282", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-24 15:09:09", "2021-07-24 15:09:09", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627139349;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627139349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-24 15:10:08", "2021-07-24 15:10:08", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("283", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":27}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-07-23 15:40:27", "2021-07-23 15:40:27", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("284", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":28}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-07-23 15:40:32", "2021-07-23 15:40:32", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("285", "action_scheduler/migration_hook", "complete", "2021-07-23 15:42:37", "2021-07-23 15:42:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1627054957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1627054957;}", "1", "1", "2021-07-23 15:43:06", "2021-07-23 15:43:06", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("268", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-06-23 12:45:07", "2021-06-23 12:45:07", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1624452307;s:18:\"\0*\0first_timestamp\";i:1616587533;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1624452307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-22 15:08:21", "2021-07-22 15:08:21", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("307", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-06 15:17:26", "2021-08-06 15:17:26", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628263046;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628263046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-06 15:18:10", "2021-08-06 15:18:10", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("308", "wpforms_admin_builder_templates_cache_update", "pending", "2021-08-12 16:24:30", "2021-08-12 16:24:30", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628785470;s:18:\"\0*\0first_timestamp\";i:1627575758;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628785470;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("302", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-04 15:17:06", "2021-08-04 15:17:06", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628090226;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628090226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-04 15:17:25", "2021-08-04 15:17:25", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("303", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-08-05 15:17:25", "2021-08-05 15:17:25", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628176645;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628176645;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-08-05 15:17:26", "2021-08-05 15:17:26", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("304", "wpforms_admin_addons_cache_update", "pending", "2021-08-12 15:09:27", "2021-08-12 15:09:27", "{\"tasks_meta_id\":22}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628780967;s:18:\"\0*\0first_timestamp\";i:1617913608;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628780967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("305", "wpforms_email_summaries_fetch_info_blocks", "pending", "2021-08-12 15:09:27", "2021-08-12 15:09:27", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628780967;s:18:\"\0*\0first_timestamp\";i:1616587533;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628780967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("306", "wpforms_email_summaries_fetch_info_blocks", "pending", "2021-08-12 15:09:27", "2021-08-12 15:09:27", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628780967;s:18:\"\0*\0first_timestamp\";i:1623851730;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628780967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("278", "action_scheduler/migration_hook", "complete", "2021-07-22 15:26:14", "2021-07-22 15:26:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1626967574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1626967574;}", "1", "1", "2021-07-22 15:26:56", "2021-07-22 15:26:56", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("279", "action_scheduler/migration_hook", "complete", "2021-07-22 15:31:43", "2021-07-22 15:31:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1626967903;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1626967903;}", "1", "1", "2021-07-22 15:32:07", "2021-07-22 15:32:07", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("270", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-06-23 13:58:46", "2021-06-23 13:58:46", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1624456726;s:18:\"\0*\0first_timestamp\";i:1623851730;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1624456726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-22 15:08:21", "2021-07-22 15:08:21", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("272", "wpforms_admin_addons_cache_update", "complete", "2021-07-29 15:08:21", "2021-07-29 15:08:21", "{\"tasks_meta_id\":22}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627571301;s:18:\"\0*\0first_timestamp\";i:1617913608;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627571301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-29 15:09:08", "2021-07-29 15:09:08", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("273", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-23 15:08:21", "2021-07-23 15:08:21", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627052901;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627052901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-23 15:09:09", "2021-07-23 15:09:09", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("274", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-07-29 15:08:21", "2021-07-29 15:08:21", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627571301;s:18:\"\0*\0first_timestamp\";i:1616587533;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627571301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-29 15:09:08", "2021-07-29 15:09:08", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("275", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-07-29 15:08:21", "2021-07-29 15:08:21", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627571301;s:18:\"\0*\0first_timestamp\";i:1623851730;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627571301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-07-29 15:09:08", "2021-07-29 15:09:08", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("292", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-08-05 15:09:08", "2021-08-05 15:09:08", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628176148;s:18:\"\0*\0first_timestamp\";i:1616587533;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628176148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-08-05 15:09:27", "2021-08-05 15:09:27", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("293", "wpforms_email_summaries_fetch_info_blocks", "complete", "2021-08-05 15:09:08", "2021-08-05 15:09:08", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628176148;s:18:\"\0*\0first_timestamp\";i:1623851730;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628176148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-08-05 15:09:27", "2021-08-05 15:09:27", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("294", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-30 15:13:12", "2021-07-30 15:13:12", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627657992;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627657992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-30 15:14:09", "2021-07-30 15:14:09", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("295", "wpforms_admin_builder_templates_cache_update", "complete", "2021-08-05 16:23:11", "2021-08-05 16:23:11", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1628180591;s:18:\"\0*\0first_timestamp\";i:1627575758;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1628180591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2021-08-05 16:24:30", "2021-08-05 16:24:30", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("296", "wpforms_process_entry_emails_meta_cleanup", "complete", "2021-07-31 15:14:09", "2021-07-31 15:14:09", "{\"tasks_meta_id\":19}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1627744449;s:18:\"\0*\0first_timestamp\";i:1616544000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1627744449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2021-07-31 15:15:15", "2021-07-31 15:15:15", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("297", "wpforms_admin_notifications_update", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "{\"tasks_meta_id\":29}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2021-07-30 23:20:58", "2021-07-30 23:20:58", "0", NULL);
INSERT INTO `wpev_actionscheduler_actions` VALUES("298", "action_scheduler/migration_hook", "complete", "2021-07-30 23:26:24", "2021-07-30 23:26:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1627687584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1627687584;}", "1", "1", "2021-07-30 23:27:06", "2021-07-30 23:27:06", "0", NULL);

/* INSERT TABLE DATA: wpev_actionscheduler_groups */
INSERT INTO `wpev_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wpev_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wpev_actionscheduler_groups` VALUES("3", "wpforms");

/* INSERT TABLE DATA: wpev_actionscheduler_logs */
INSERT INTO `wpev_actionscheduler_logs` VALUES("870", "301", "action started via WP Cron", "2021-08-03 15:17:06", "2021-08-03 15:17:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("869", "301", "action created", "2021-08-02 15:16:17", "2021-08-02 15:16:17");
INSERT INTO `wpev_actionscheduler_logs` VALUES("866", "300", "action created", "2021-08-01 15:16:12", "2021-08-01 15:16:12");
INSERT INTO `wpev_actionscheduler_logs` VALUES("867", "300", "action started via WP Cron", "2021-08-02 15:16:17", "2021-08-02 15:16:17");
INSERT INTO `wpev_actionscheduler_logs` VALUES("868", "300", "action complete via WP Cron", "2021-08-02 15:16:17", "2021-08-02 15:16:17");
INSERT INTO `wpev_actionscheduler_logs` VALUES("862", "296", "action complete via WP Cron", "2021-07-31 15:15:15", "2021-07-31 15:15:15");
INSERT INTO `wpev_actionscheduler_logs` VALUES("863", "299", "action created", "2021-07-31 15:15:15", "2021-07-31 15:15:15");
INSERT INTO `wpev_actionscheduler_logs` VALUES("864", "299", "action started via WP Cron", "2021-08-01 15:16:12", "2021-08-01 15:16:12");
INSERT INTO `wpev_actionscheduler_logs` VALUES("854", "296", "action created", "2021-07-30 15:14:09", "2021-07-30 15:14:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("855", "297", "action created", "2021-07-30 23:20:30", "2021-07-30 23:20:30");
INSERT INTO `wpev_actionscheduler_logs` VALUES("856", "297", "action started via Async Request", "2021-07-30 23:20:52", "2021-07-30 23:20:52");
INSERT INTO `wpev_actionscheduler_logs` VALUES("857", "297", "action complete via Async Request", "2021-07-30 23:20:58", "2021-07-30 23:20:58");
INSERT INTO `wpev_actionscheduler_logs` VALUES("858", "298", "action created", "2021-07-30 23:25:24", "2021-07-30 23:25:24");
INSERT INTO `wpev_actionscheduler_logs` VALUES("859", "298", "action started via WP Cron", "2021-07-30 23:27:06", "2021-07-30 23:27:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("860", "298", "action complete via WP Cron", "2021-07-30 23:27:06", "2021-07-30 23:27:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("861", "296", "action started via WP Cron", "2021-07-31 15:15:15", "2021-07-31 15:15:15");
INSERT INTO `wpev_actionscheduler_logs` VALUES("845", "293", "action created", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("778", "270", "action created", "2021-06-16 13:58:46", "2021-06-16 13:58:46");
INSERT INTO `wpev_actionscheduler_logs` VALUES("880", "292", "action complete via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("879", "292", "action started via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("871", "301", "action complete via WP Cron", "2021-08-03 15:17:06", "2021-08-03 15:17:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("872", "302", "action created", "2021-08-03 15:17:06", "2021-08-03 15:17:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("873", "302", "action started via WP Cron", "2021-08-04 15:17:25", "2021-08-04 15:17:25");
INSERT INTO `wpev_actionscheduler_logs` VALUES("874", "302", "action complete via WP Cron", "2021-08-04 15:17:25", "2021-08-04 15:17:25");
INSERT INTO `wpev_actionscheduler_logs` VALUES("875", "303", "action created", "2021-08-04 15:17:25", "2021-08-04 15:17:25");
INSERT INTO `wpev_actionscheduler_logs` VALUES("876", "291", "action started via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("877", "291", "action complete via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("786", "267", "action complete via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("787", "273", "action created", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("788", "268", "action started via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("789", "268", "action complete via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("790", "274", "action created", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("791", "270", "action started via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("792", "270", "action complete via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("793", "275", "action created", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("771", "267", "action created", "2021-06-16 03:35:03", "2021-06-16 03:35:03");
INSERT INTO `wpev_actionscheduler_logs` VALUES("878", "304", "action created", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("865", "299", "action complete via WP Cron", "2021-08-01 15:16:12", "2021-08-01 15:16:12");
INSERT INTO `wpev_actionscheduler_logs` VALUES("784", "272", "action created", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("785", "267", "action started via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("783", "261", "action complete via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("782", "261", "action started via WP Cron", "2021-07-22 15:08:21", "2021-07-22 15:08:21");
INSERT INTO `wpev_actionscheduler_logs` VALUES("774", "268", "action created", "2021-06-16 12:45:07", "2021-06-16 12:45:07");
INSERT INTO `wpev_actionscheduler_logs` VALUES("820", "285", "action started via WP Cron", "2021-07-23 15:43:06", "2021-07-23 15:43:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("819", "285", "action created", "2021-07-23 15:41:37", "2021-07-23 15:41:37");
INSERT INTO `wpev_actionscheduler_logs` VALUES("797", "276", "action complete via Async Request", "2021-07-22 15:08:58", "2021-07-22 15:08:58");
INSERT INTO `wpev_actionscheduler_logs` VALUES("798", "277", "action started via Async Request", "2021-07-22 15:08:58", "2021-07-22 15:08:58");
INSERT INTO `wpev_actionscheduler_logs` VALUES("799", "277", "action complete via Async Request", "2021-07-22 15:08:59", "2021-07-22 15:08:59");
INSERT INTO `wpev_actionscheduler_logs` VALUES("800", "278", "action created", "2021-07-22 15:25:14", "2021-07-22 15:25:14");
INSERT INTO `wpev_actionscheduler_logs` VALUES("801", "278", "action started via Async Request", "2021-07-22 15:26:56", "2021-07-22 15:26:56");
INSERT INTO `wpev_actionscheduler_logs` VALUES("802", "278", "action complete via Async Request", "2021-07-22 15:26:56", "2021-07-22 15:26:56");
INSERT INTO `wpev_actionscheduler_logs` VALUES("803", "279", "action created", "2021-07-22 15:30:43", "2021-07-22 15:30:43");
INSERT INTO `wpev_actionscheduler_logs` VALUES("804", "279", "action started via WP Cron", "2021-07-22 15:32:06", "2021-07-22 15:32:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("805", "279", "action complete via WP Cron", "2021-07-22 15:32:06", "2021-07-22 15:32:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("806", "280", "action created", "2021-07-22 16:22:38", "2021-07-22 16:22:38");
INSERT INTO `wpev_actionscheduler_logs` VALUES("807", "281", "action created", "2021-07-22 16:29:36", "2021-07-22 16:29:36");
INSERT INTO `wpev_actionscheduler_logs` VALUES("808", "281", "action started via Async Request", "2021-07-22 16:30:37", "2021-07-22 16:30:37");
INSERT INTO `wpev_actionscheduler_logs` VALUES("809", "281", "action complete via Async Request", "2021-07-22 16:30:37", "2021-07-22 16:30:37");
INSERT INTO `wpev_actionscheduler_logs` VALUES("810", "273", "action started via WP Cron", "2021-07-23 15:09:09", "2021-07-23 15:09:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("811", "273", "action complete via WP Cron", "2021-07-23 15:09:09", "2021-07-23 15:09:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("812", "282", "action created", "2021-07-23 15:09:09", "2021-07-23 15:09:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("813", "283", "action created", "2021-07-23 15:40:26", "2021-07-23 15:40:26");
INSERT INTO `wpev_actionscheduler_logs` VALUES("814", "283", "action started via Async Request", "2021-07-23 15:40:27", "2021-07-23 15:40:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("815", "283", "action complete via Async Request", "2021-07-23 15:40:27", "2021-07-23 15:40:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("816", "284", "action created", "2021-07-23 15:40:27", "2021-07-23 15:40:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("817", "284", "action started via Async Request", "2021-07-23 15:40:32", "2021-07-23 15:40:32");
INSERT INTO `wpev_actionscheduler_logs` VALUES("818", "284", "action complete via Async Request", "2021-07-23 15:40:32", "2021-07-23 15:40:32");
INSERT INTO `wpev_actionscheduler_logs` VALUES("753", "261", "action created", "2021-06-10 21:05:08", "2021-06-10 21:05:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("853", "294", "action complete via WP Cron", "2021-07-30 15:14:09", "2021-07-30 15:14:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("852", "294", "action started via WP Cron", "2021-07-30 15:14:08", "2021-07-30 15:14:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("847", "290", "action complete via WP Cron", "2021-07-29 15:13:12", "2021-07-29 15:13:12");
INSERT INTO `wpev_actionscheduler_logs` VALUES("848", "294", "action created", "2021-07-29 15:13:12", "2021-07-29 15:13:12");
INSERT INTO `wpev_actionscheduler_logs` VALUES("849", "280", "action started via WP Cron", "2021-07-29 16:23:10", "2021-07-29 16:23:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("850", "280", "action complete via WP Cron", "2021-07-29 16:23:11", "2021-07-29 16:23:11");
INSERT INTO `wpev_actionscheduler_logs` VALUES("851", "295", "action created", "2021-07-29 16:23:11", "2021-07-29 16:23:11");
INSERT INTO `wpev_actionscheduler_logs` VALUES("846", "290", "action started via WP Cron", "2021-07-29 15:13:11", "2021-07-29 15:13:11");
INSERT INTO `wpev_actionscheduler_logs` VALUES("821", "285", "action complete via WP Cron", "2021-07-23 15:43:06", "2021-07-23 15:43:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("822", "282", "action started via WP Cron", "2021-07-24 15:10:08", "2021-07-24 15:10:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("823", "282", "action complete via WP Cron", "2021-07-24 15:10:08", "2021-07-24 15:10:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("824", "286", "action created", "2021-07-24 15:10:08", "2021-07-24 15:10:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("825", "286", "action started via WP Cron", "2021-07-25 15:10:09", "2021-07-25 15:10:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("826", "286", "action complete via WP Cron", "2021-07-25 15:10:09", "2021-07-25 15:10:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("827", "287", "action created", "2021-07-25 15:10:09", "2021-07-25 15:10:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("828", "287", "action started via WP Cron", "2021-07-26 15:11:13", "2021-07-26 15:11:13");
INSERT INTO `wpev_actionscheduler_logs` VALUES("794", "276", "action created", "2021-07-22 15:08:57", "2021-07-22 15:08:57");
INSERT INTO `wpev_actionscheduler_logs` VALUES("795", "277", "action created", "2021-07-22 15:08:57", "2021-07-22 15:08:57");
INSERT INTO `wpev_actionscheduler_logs` VALUES("844", "275", "action complete via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("796", "276", "action started via Async Request", "2021-07-22 15:08:57", "2021-07-22 15:08:57");
INSERT INTO `wpev_actionscheduler_logs` VALUES("829", "287", "action complete via WP Cron", "2021-07-26 15:11:13", "2021-07-26 15:11:13");
INSERT INTO `wpev_actionscheduler_logs` VALUES("830", "288", "action created", "2021-07-26 15:11:13", "2021-07-26 15:11:13");
INSERT INTO `wpev_actionscheduler_logs` VALUES("831", "288", "action started via WP Cron", "2021-07-27 15:12:06", "2021-07-27 15:12:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("832", "288", "action complete via WP Cron", "2021-07-27 15:12:06", "2021-07-27 15:12:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("833", "289", "action created", "2021-07-27 15:12:06", "2021-07-27 15:12:06");
INSERT INTO `wpev_actionscheduler_logs` VALUES("834", "289", "action started via WP Cron", "2021-07-28 15:12:09", "2021-07-28 15:12:09");
INSERT INTO `wpev_actionscheduler_logs` VALUES("835", "289", "action complete via WP Cron", "2021-07-28 15:12:10", "2021-07-28 15:12:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("836", "290", "action created", "2021-07-28 15:12:10", "2021-07-28 15:12:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("837", "272", "action started via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("838", "272", "action complete via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("839", "291", "action created", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("840", "274", "action started via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("841", "274", "action complete via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("842", "292", "action created", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("843", "275", "action started via WP Cron", "2021-07-29 15:09:08", "2021-07-29 15:09:08");
INSERT INTO `wpev_actionscheduler_logs` VALUES("881", "305", "action created", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("882", "293", "action started via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("883", "293", "action complete via WP Cron", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("884", "306", "action created", "2021-08-05 15:09:27", "2021-08-05 15:09:27");
INSERT INTO `wpev_actionscheduler_logs` VALUES("885", "303", "action started via WP Cron", "2021-08-05 15:17:26", "2021-08-05 15:17:26");
INSERT INTO `wpev_actionscheduler_logs` VALUES("886", "303", "action complete via WP Cron", "2021-08-05 15:17:26", "2021-08-05 15:17:26");
INSERT INTO `wpev_actionscheduler_logs` VALUES("887", "307", "action created", "2021-08-05 15:17:26", "2021-08-05 15:17:26");
INSERT INTO `wpev_actionscheduler_logs` VALUES("888", "295", "action started via WP Cron", "2021-08-05 16:24:29", "2021-08-05 16:24:29");
INSERT INTO `wpev_actionscheduler_logs` VALUES("889", "295", "action complete via WP Cron", "2021-08-05 16:24:30", "2021-08-05 16:24:30");
INSERT INTO `wpev_actionscheduler_logs` VALUES("890", "308", "action created", "2021-08-05 16:24:30", "2021-08-05 16:24:30");
INSERT INTO `wpev_actionscheduler_logs` VALUES("891", "307", "action started via WP Cron", "2021-08-06 15:18:10", "2021-08-06 15:18:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("892", "307", "action complete via WP Cron", "2021-08-06 15:18:10", "2021-08-06 15:18:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("893", "309", "action created", "2021-08-06 15:18:10", "2021-08-06 15:18:10");
INSERT INTO `wpev_actionscheduler_logs` VALUES("894", "310", "action created", "2021-08-06 18:56:24", "2021-08-06 18:56:24");
INSERT INTO `wpev_actionscheduler_logs` VALUES("895", "310", "action started via Async Request", "2021-08-06 18:57:19", "2021-08-06 18:57:19");
INSERT INTO `wpev_actionscheduler_logs` VALUES("896", "310", "action complete via Async Request", "2021-08-06 18:57:19", "2021-08-06 18:57:19");

/* INSERT TABLE DATA: wpev_duplicator_packages */
INSERT INTO `wpev_duplicator_packages` VALUES("3", "20210722_atlasroofingco", "a2e74eaada7da8cd4307_20210722170053", "100", "2021-07-22 17:01:08", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-07-22 17:00:53\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:23:\"20210722_atlasroofingco\";s:4:\"Hash\";s:35:\"a2e74eaada7da8cd4307_20210722170053\";s:8:\"NameHash\";s:59:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"111.21 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:6:\"1.04GB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/atlasr/public_html\";s:4:\"Size\";i:1119143390;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:23824;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:33:\"/home/atlasr/public_html/wp-admin\";i:1;s:43:\"/home/atlasr/public_html/wp-content/uploads\";i:2;s:45:\"/home/atlasr/public_html/wp-content/languages\";i:3;s:42:\"/home/atlasr/public_html/wp-content/themes\";i:4;s:36:\"/home/atlasr/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:24:\"/home/atlasr/public_html\";i:1;s:35:\"/home/atlasr/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:36:\"/home/atlasr/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053_installer.php\";s:4:\"Size\";i:65807;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10357067;s:4:\"File\";s:72:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:2:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:9:\"atlasr_wp\";s:15:\"tablesBaseCount\";i:60;s:16:\"tablesFinalCount\";i:60;s:14:\"tablesRowCount\";s:6:\"35,150\";s:16:\"tablesSizeOnDisk\";s:7:\"11.19MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:60:{s:28:\"wpev_actionscheduler_actions\";s:2:\"14\";s:27:\"wpev_actionscheduler_claims\";s:1:\"0\";s:27:\"wpev_actionscheduler_groups\";s:1:\"3\";s:25:\"wpev_actionscheduler_logs\";s:2:\"32\";s:16:\"wpev_commentmeta\";s:1:\"0\";s:13:\"wpev_comments\";s:1:\"0\";s:24:\"wpev_duplicator_packages\";s:1:\"1\";s:18:\"wpev_ewwwio_images\";s:4:\"2834\";s:17:\"wpev_ewwwio_queue\";s:1:\"0\";s:16:\"wpev_layerslider\";s:1:\"0\";s:26:\"wpev_layerslider_revisions\";s:1:\"0\";s:10:\"wpev_links\";s:1:\"0\";s:12:\"wpev_options\";s:3:\"342\";s:13:\"wpev_postmeta\";s:4:\"1592\";s:10:\"wpev_posts\";s:3:\"348\";s:19:\"wpev_quform_entries\";s:1:\"9\";s:22:\"wpev_quform_entry_data\";s:2:\"42\";s:30:\"wpev_quform_entry_entry_labels\";s:1:\"0\";s:24:\"wpev_quform_entry_labels\";s:1:\"3\";s:17:\"wpev_quform_forms\";s:1:\"3\";s:20:\"wpev_quform_sessions\";s:4:\"3722\";s:18:\"wpev_revslider_css\";s:3:\"170\";s:31:\"wpev_revslider_layer_animations\";s:1:\"0\";s:26:\"wpev_revslider_navigations\";s:1:\"0\";s:22:\"wpev_revslider_sliders\";s:1:\"1\";s:21:\"wpev_revslider_slides\";s:1:\"2\";s:28:\"wpev_revslider_static_slides\";s:1:\"0\";s:23:\"wpev_term_relationships\";s:2:\"33\";s:18:\"wpev_term_taxonomy\";s:2:\"21\";s:13:\"wpev_termmeta\";s:1:\"0\";s:10:\"wpev_terms\";s:2:\"21\";s:13:\"wpev_usermeta\";s:2:\"35\";s:10:\"wpev_users\";s:1:\"1\";s:19:\"wpev_wfblockediplog\";s:1:\"3\";s:14:\"wpev_wfblocks7\";s:1:\"3\";s:13:\"wpev_wfconfig\";s:3:\"256\";s:15:\"wpev_wfcrawlers\";s:1:\"7\";s:18:\"wpev_wffilechanges\";s:1:\"0\";s:15:\"wpev_wffilemods\";s:5:\"11552\";s:11:\"wpev_wfhits\";s:2:\"22\";s:13:\"wpev_wfhoover\";s:1:\"0\";s:13:\"wpev_wfissues\";s:1:\"1\";s:20:\"wpev_wfknownfilelist\";s:5:\"11552\";s:23:\"wpev_wflivetraffichuman\";s:1:\"0\";s:11:\"wpev_wflocs\";s:1:\"7\";s:13:\"wpev_wflogins\";s:2:\"17\";s:21:\"wpev_wfls_2fa_secrets\";s:1:\"0\";s:18:\"wpev_wfls_settings\";s:2:\"19\";s:20:\"wpev_wfnotifications\";s:1:\"2\";s:20:\"wpev_wfpendingissues\";s:1:\"0\";s:19:\"wpev_wfreversecache\";s:1:\"8\";s:16:\"wpev_wfsnipcache\";s:1:\"0\";s:13:\"wpev_wfstatus\";s:4:\"1691\";s:19:\"wpev_wftrafficrates\";s:1:\"0\";s:23:\"wpev_wpforms_tasks_meta\";s:2:\"26\";s:20:\"wpev_yoast_indexable\";s:3:\"339\";s:30:\"wpev_yoast_indexable_hierarchy\";s:2:\"43\";s:21:\"wpev_yoast_migrations\";s:2:\"21\";s:23:\"wpev_yoast_primary_term\";s:1:\"1\";s:20:\"wpev_yoast_seo_links\";s:3:\"299\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:129:\"/home/atlasr/public_html/wp-content/backups-dup-lite/tmp/20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-07-22 17:00:53\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20210722_atlasroofingco\";s:4:\"Hash\";s:35:\"a2e74eaada7da8cd4307_20210722170053\";s:8:\"NameHash\";s:59:\"20210722_atlasroofingco_a2e74eaada7da8cd4307_20210722170053\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:184;}}}");
INSERT INTO `wpev_duplicator_packages` VALUES("4", "20210806_atlasroofingco", "fd7148579dbd2c963545_20210806185833", "21", "2021-08-06 18:58:44", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-08-06 18:58:33\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:23:\"20210806_atlasroofingco\";s:4:\"Hash\";s:35:\"fd7148579dbd2c963545_20210806185833\";s:8:\"NameHash\";s:59:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/atlasr/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-08-06 18:58:33\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20210806_atlasroofingco\";s:4:\"Hash\";s:35:\"fd7148579dbd2c963545_20210806185833\";s:8:\"NameHash\";s:59:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:72:\"20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:28:\"wpev_actionscheduler_actions\";s:2:\"43\";s:27:\"wpev_actionscheduler_claims\";s:1:\"0\";s:27:\"wpev_actionscheduler_groups\";s:1:\"3\";s:25:\"wpev_actionscheduler_logs\";s:3:\"119\";s:16:\"wpev_commentmeta\";s:1:\"0\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:129:\"/home/atlasr/public_html/wp-content/backups-dup-lite/tmp/20210806_atlasroofingco_fd7148579dbd2c963545_20210806185833_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:33:\"/home/atlasr/public_html/wp-admin\";i:1;s:43:\"/home/atlasr/public_html/wp-content/uploads\";i:2;s:45:\"/home/atlasr/public_html/wp-content/languages\";i:3;s:42:\"/home/atlasr/public_html/wp-content/themes\";i:4;s:36:\"/home/atlasr/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:24:\"/home/atlasr/public_html\";i:1;s:35:\"/home/atlasr/public_html/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:135;}");

/* INSERT TABLE DATA: wpev_ewwwio_images */
INSERT INTO `wpev_ewwwio_images` VALUES("1", "19", "media", "full", "ABSPATHwp-content/uploads/2016/02/parallax-1.jpg", "", "Reduced by 11.2% (8.5 KB)", "68657", "77321", "", "10", "0", "1", "2021-01-01 14:58:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2", "19", "media", "medium", "ABSPATHwp-content/uploads/2016/02/parallax-1-300x148.jpg", "", "Reduced by 24.1% (781 B)", "2466", "3247", "", "10", "0", "1", "2021-01-01 14:58:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("3", "19", "media", "large", "ABSPATHwp-content/uploads/2016/02/parallax-1-1024x507.jpg", "", "Reduced by 17.8% (4.8 KB)", "22531", "27402", "", "10", "0", "1", "2021-01-01 14:58:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("4", "19", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/parallax-1-150x150.jpg", "", "Reduced by 29.3% (592 B)", "1426", "2018", "", "10", "0", "1", "2021-01-01 14:58:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("5", "19", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/parallax-1-768x380.jpg", "", "Reduced by 18.1% (2.8 KB)", "13115", "16020", "", "10", "0", "1", "2021-01-01 14:58:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("6", "19", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/parallax-1-1536x760.jpg", "", "Reduced by 17.9% (10.1 KB)", "47479", "57860", "", "10", "0", "1", "2021-01-01 14:58:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("7", "19", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/parallax-1-570x570.jpg", "", "Reduced by 16.7% (3.1 KB)", "15646", "18792", "", "10", "0", "1", "2021-01-01 14:58:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("8", "19", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/parallax-1-600x800.jpg", "", "Reduced by 17.2% (4.3 KB)", "21170", "25560", "", "10", "0", "1", "2021-01-01 14:58:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("9", "19", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/parallax-1-800x600.jpg", "", "Reduced by 16.6% (4.4 KB)", "22578", "27072", "", "10", "0", "1", "2021-01-01 14:58:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("10", "19", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/parallax-1-345x198.jpg", "", "Reduced by 21.0% (993 B)", "3742", "4735", "", "10", "0", "1", "2021-01-01 14:58:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("11", "19", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/parallax-1-400x260.jpg", "", "Reduced by 19.3% (1.2 KB)", "5339", "6614", "", "10", "0", "1", "2021-01-01 14:58:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("12", "19", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/parallax-1-500x380.jpg", "", "Reduced by 17.7% (2.0 KB)", "9459", "11493", "", "10", "0", "1", "2021-01-01 14:58:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("13", "19", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/parallax-1-500x500.jpg", "", "Reduced by 18.2% (2.6 KB)", "12052", "14729", "", "10", "0", "1", "2021-01-01 14:58:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("14", "19", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/parallax-1-1000x500.jpg", "", "Reduced by 18.0% (4.7 KB)", "21900", "26719", "", "10", "0", "1", "2021-01-01 14:58:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("15", "19", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/parallax-1-500x950.jpg", "", "Reduced by 18.2% (4.5 KB)", "20686", "25283", "", "10", "0", "1", "2021-01-01 14:58:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("16", "19", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/parallax-1-1000x950.jpg", "", "Reduced by 16.2% (8.7 KB)", "46023", "54939", "", "10", "0", "1", "2021-01-01 14:58:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("17", "19", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/parallax-1-700x346.jpg", "", "Reduced by 18.6% (2.5 KB)", "11024", "13543", "", "10", "0", "1", "2021-01-01 14:58:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("18", "19", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/parallax-1-539x303.jpg", "", "Reduced by 18.1% (1.7 KB)", "7933", "9691", "", "10", "0", "1", "2021-01-01 14:58:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("19", "30", "media", "full", "ABSPATHwp-content/uploads/2016/02/slide1-1.jpg", "", "Reduced by 1.3% (2.4 KB)", "180810", "183239", "", "10", "0", "1", "2021-01-01 14:58:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("20", "30", "media", "medium", "ABSPATHwp-content/uploads/2016/02/slide1-1-300x125.jpg", "", "Reduced by 6.7% (634 B)", "8877", "9511", "", "10", "0", "1", "2021-01-01 14:58:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("21", "30", "media", "large", "ABSPATHwp-content/uploads/2016/02/slide1-1-1024x427.jpg", "", "Reduced by 4.5% (3.3 KB)", "72153", "75530", "", "10", "0", "1", "2021-01-01 14:58:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("22", "30", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/slide1-1-150x150.jpg", "", "Reduced by 7.1% (420 B)", "5472", "5892", "", "10", "0", "1", "2021-01-01 14:58:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("23", "30", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/slide1-1-768x320.jpg", "", "Reduced by 5.0% (2.3 KB)", "44415", "46745", "", "10", "0", "1", "2021-01-01 14:58:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("24", "30", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/slide1-1-1536x640.jpg", "", "Reduced by 4.1% (5.8 KB)", "137221", "143154", "", "10", "0", "1", "2021-01-01 14:58:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("25", "30", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/slide1-1-570x570.jpg", "", "Reduced by 4.2% (2.1 KB)", "48373", "50499", "", "10", "0", "1", "2021-01-01 14:58:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("26", "30", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/slide1-1-600x800.jpg", "", "Reduced by 4.2% (2.6 KB)", "61875", "64585", "", "10", "0", "1", "2021-01-01 14:58:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("27", "30", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/slide1-1-800x600.jpg", "", "Reduced by 4.4% (3.1 KB)", "70186", "73399", "", "10", "0", "1", "2021-01-01 14:58:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("28", "30", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/slide1-1-345x198.jpg", "", "Reduced by 5.9% (911 B)", "14539", "15450", "", "10", "0", "1", "2021-01-01 14:58:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("29", "30", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/slide1-1-400x260.jpg", "", "Reduced by 5.1% (1.1 KB)", "20444", "21540", "", "10", "0", "1", "2021-01-01 14:58:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("30", "30", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/slide1-1-500x380.jpg", "", "Reduced by 4.6% (1.6 KB)", "33223", "34828", "", "10", "0", "1", "2021-01-01 14:58:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("31", "30", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/slide1-1-500x500.jpg", "", "Reduced by 4.2% (1.7 KB)", "39541", "41288", "", "10", "0", "1", "2021-01-01 14:58:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("32", "30", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/slide1-1-1000x500.jpg", "", "Reduced by 4.5% (3.7 KB)", "79064", "82823", "", "10", "0", "1", "2021-01-01 14:58:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("33", "30", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/slide1-1-500x800.jpg", "", "Reduced by 3.9% (2.0 KB)", "51142", "53190", "", "10", "0", "1", "2021-01-01 14:58:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("34", "30", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/slide1-1-1000x800.jpg", "", "Reduced by 4.1% (4.5 KB)", "107335", "111918", "", "10", "0", "1", "2021-01-01 14:58:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("35", "30", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/slide1-1-700x292.jpg", "", "Reduced by 5.2% (2.0 KB)", "38215", "40308", "", "10", "0", "1", "2021-01-01 14:58:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("36", "30", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/slide1-1-539x303.jpg", "", "Reduced by 4.8% (1.5 KB)", "30688", "32228", "", "10", "0", "1", "2021-01-01 14:58:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("37", "49", "media", "full", "ABSPATHwp-content/uploads/2016/02/video-cover-1.jpg", "", "Reduced by 1.1% (418 B)", "37489", "37907", "", "10", "0", "1", "2021-01-01 14:58:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("38", "49", "media", "medium", "ABSPATHwp-content/uploads/2016/02/video-cover-1-300x205.jpg", "", "Reduced by 7.8% (1.1 KB)", "13529", "14676", "", "10", "0", "1", "2021-01-01 14:58:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("39", "49", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/video-cover-1-150x150.jpg", "", "Reduced by 8.0% (680 B)", "7789", "8469", "", "10", "0", "1", "2021-01-01 14:58:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("40", "49", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/video-cover-1-345x198.jpg", "", "Reduced by 8.3% (1.3 KB)", "14706", "16034", "", "10", "0", "1", "2021-01-01 14:58:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("41", "49", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/video-cover-1-400x260.jpg", "", "Reduced by 7.8% (1.7 KB)", "20613", "22348", "", "10", "0", "1", "2021-01-01 14:58:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("42", "49", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/video-cover-1-500x370.jpg", "", "Reduced by 7.2% (2.8 KB)", "37403", "40294", "", "10", "0", "1", "2021-01-01 14:58:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("43", "49", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/video-cover-1-539x303.jpg", "", "Reduced by 7.8% (2.3 KB)", "27975", "30331", "", "10", "0", "1", "2021-01-01 14:58:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("44", "83", "media", "full", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1.jpg", "", "Reduced by 1.5% (1.4 KB)", "96181", "97629", "", "10", "0", "1", "2021-01-01 14:59:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("45", "83", "media", "medium", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-300x138.jpg", "", "Reduced by 6.3% (719 B)", "10631", "11350", "", "10", "0", "1", "2021-01-01 14:59:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("46", "83", "media", "large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-1024x473.jpg", "", "Reduced by 3.9% (2.7 KB)", "70141", "72952", "", "10", "0", "1", "2021-01-01 14:59:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("47", "83", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-150x150.jpg", "", "Reduced by 8.1% (609 B)", "6913", "7522", "", "10", "0", "1", "2021-01-01 14:59:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("48", "83", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-768x354.jpg", "", "Reduced by 4.6% (2.1 KB)", "45154", "47307", "", "10", "0", "1", "2021-01-01 14:59:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("49", "83", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-570x570.jpg", "", "Reduced by 4.1% (2.2 KB)", "52646", "54891", "", "10", "0", "1", "2021-01-01 14:59:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("50", "83", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-600x600.jpg", "", "Reduced by 4.1% (2.5 KB)", "59790", "62348", "", "10", "0", "1", "2021-01-01 14:59:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("51", "83", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-800x600.jpg", "", "Reduced by 3.9% (3.1 KB)", "77957", "81136", "", "10", "0", "1", "2021-01-01 14:59:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("52", "83", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-345x198.jpg", "", "Reduced by 6.0% (1.0 KB)", "16047", "17078", "", "10", "0", "1", "2021-01-01 14:59:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("53", "83", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-400x260.jpg", "", "Reduced by 5.7% (1.3 KB)", "22475", "23836", "", "10", "0", "1", "2021-01-01 14:59:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("54", "83", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-500x380.jpg", "", "Reduced by 4.9% (1.8 KB)", "36527", "38416", "", "10", "0", "1", "2021-01-01 14:59:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("55", "83", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-500x500.jpg", "", "Reduced by 4.6% (2.0 KB)", "43338", "45429", "", "10", "0", "1", "2021-01-01 14:59:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("56", "83", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-1000x500.jpg", "", "Reduced by 4.0% (3.0 KB)", "72912", "75935", "", "10", "0", "1", "2021-01-01 14:59:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("57", "83", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-500x600.jpg", "", "Reduced by 3.9% (1.9 KB)", "47865", "49787", "", "10", "0", "1", "2021-01-01 14:59:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("58", "83", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-1000x600.jpg", "", "Reduced by 3.8% (3.5 KB)", "91072", "94621", "", "10", "0", "1", "2021-01-01 14:59:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("59", "83", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-700x323.jpg", "", "Reduced by 4.7% (1.9 KB)", "39315", "41254", "", "10", "0", "1", "2021-01-01 14:59:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("60", "83", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery-1-539x303.jpg", "", "Reduced by 4.9% (1.6 KB)", "31254", "32873", "", "10", "0", "1", "2021-01-01 14:59:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("61", "84", "media", "full", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1.jpg", "", "Reduced by 2.3% (1.7 KB)", "74622", "76391", "", "10", "0", "1", "2021-01-01 14:59:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("62", "84", "media", "medium", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-300x138.jpg", "", "Reduced by 5.8% (520 B)", "8450", "8970", "", "10", "0", "1", "2021-01-01 14:59:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("63", "84", "media", "large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-1024x473.jpg", "", "Reduced by 3.9% (1.9 KB)", "48310", "50266", "", "10", "0", "1", "2021-01-01 14:59:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("64", "84", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-150x150.jpg", "", "Reduced by 7.7% (386 B)", "4625", "5011", "", "10", "0", "1", "2021-01-01 14:59:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("65", "84", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-768x354.jpg", "", "Reduced by 3.9% (1.3 KB)", "31843", "33132", "", "10", "0", "1", "2021-01-01 14:59:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("66", "84", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-570x570.jpg", "", "Reduced by 4.8% (1.5 KB)", "29762", "31274", "", "10", "0", "1", "2021-01-01 14:59:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("67", "84", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-600x600.jpg", "", "Reduced by 4.7% (1.6 KB)", "32323", "33934", "", "10", "0", "1", "2021-01-01 14:59:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("68", "84", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-800x600.jpg", "", "Reduced by 4.5% (2.0 KB)", "43582", "45613", "", "10", "0", "1", "2021-01-01 14:59:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("69", "84", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-345x198.jpg", "", "Reduced by 5.3% (647 B)", "11481", "12128", "", "10", "0", "1", "2021-01-01 14:59:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("70", "84", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-400x260.jpg", "", "Reduced by 4.8% (771 B)", "15152", "15923", "", "10", "0", "1", "2021-01-01 14:59:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("71", "84", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-500x380.jpg", "", "Reduced by 4.6% (1.0 KB)", "22151", "23212", "", "10", "0", "1", "2021-01-01 14:59:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("72", "84", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-500x500.jpg", "", "Reduced by 4.9% (1.3 KB)", "24806", "26097", "", "10", "0", "1", "2021-01-01 14:59:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("73", "84", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-1000x500.jpg", "", "Reduced by 4.1% (2.0 KB)", "49142", "51231", "", "10", "0", "1", "2021-01-01 14:59:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("74", "84", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-500x600.jpg", "", "Reduced by 5.4% (1.5 KB)", "25922", "27416", "", "10", "0", "1", "2021-01-01 14:59:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("75", "84", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-1000x600.jpg", "", "Reduced by 4.1% (2.3 KB)", "53748", "56075", "", "10", "0", "1", "2021-01-01 14:59:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("76", "84", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-700x323.jpg", "", "Reduced by 4.1% (1.2 KB)", "28124", "29316", "", "10", "0", "1", "2021-01-01 14:59:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("77", "84", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery2-1-539x303.jpg", "", "Reduced by 4.5% (1,011 B)", "21452", "22463", "", "10", "0", "1", "2021-01-01 14:59:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("78", "85", "media", "full", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1.jpg", "", "Reduced by 1.9% (2.1 KB)", "110869", "112980", "", "10", "0", "1", "2021-01-01 14:59:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("79", "85", "media", "medium", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-300x138.jpg", "", "Reduced by 5.1% (485 B)", "8981", "9466", "", "10", "0", "1", "2021-01-01 14:59:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("80", "85", "media", "large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-1024x473.jpg", "", "Reduced by 5.7% (3.7 KB)", "62966", "66744", "", "10", "0", "1", "2021-01-01 14:59:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("81", "85", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-150x150.jpg", "", "Reduced by 6.3% (382 B)", "5712", "6094", "", "10", "0", "1", "2021-01-01 14:59:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("82", "85", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-768x354.jpg", "", "Reduced by 5.1% (2.1 KB)", "40602", "42781", "", "10", "0", "1", "2021-01-01 14:59:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("83", "85", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-570x570.jpg", "", "Reduced by 4.8% (2.2 KB)", "44906", "47153", "", "10", "0", "1", "2021-01-01 14:59:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("84", "85", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-600x600.jpg", "", "Reduced by 5.4% (2.9 KB)", "52368", "55369", "", "10", "0", "1", "2021-01-01 14:59:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("85", "85", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-800x600.jpg", "", "Reduced by 5.1% (3.6 KB)", "69275", "72999", "", "10", "0", "1", "2021-01-01 14:59:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("86", "85", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-345x198.jpg", "", "Reduced by 4.8% (699 B)", "14001", "14700", "", "10", "0", "1", "2021-01-01 14:59:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("87", "85", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-400x260.jpg", "", "Reduced by 4.9% (1.0 KB)", "19839", "20870", "", "10", "0", "1", "2021-01-01 14:59:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("88", "85", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-500x380.jpg", "", "Reduced by 4.6% (1.5 KB)", "32059", "33600", "", "10", "0", "1", "2021-01-01 14:59:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("89", "85", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-500x500.jpg", "", "Reduced by 4.9% (1.9 KB)", "37288", "39219", "", "10", "0", "1", "2021-01-01 14:59:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("90", "85", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-1000x500.jpg", "", "Reduced by 5.7% (3.9 KB)", "65935", "69953", "", "10", "0", "1", "2021-01-01 14:59:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("91", "85", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-500x600.jpg", "", "Reduced by 5.4% (2.0 KB)", "36408", "38483", "", "10", "0", "1", "2021-01-01 14:59:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("92", "85", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-1000x600.jpg", "", "Reduced by 5.6% (4.8 KB)", "83000", "87891", "", "10", "0", "1", "2021-01-01 14:59:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("93", "85", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-700x323.jpg", "", "Reduced by 5.2% (1.9 KB)", "35087", "37027", "", "10", "0", "1", "2021-01-01 14:59:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("94", "85", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/portfolio-gallery3-1-539x303.jpg", "", "Reduced by 4.8% (1.4 KB)", "27974", "29386", "", "10", "0", "1", "2021-01-01 14:59:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("95", "110", "media", "full", "ABSPATHwp-content/uploads/2016/02/title_image-1.jpg", "", "Reduced by 1.7% (1.7 KB)", "101658", "103407", "", "10", "0", "1", "2021-01-01 14:59:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("96", "110", "media", "medium", "ABSPATHwp-content/uploads/2016/02/title_image-1-300x70.jpg", "", "Reduced by 7.7% (526 B)", "6285", "6811", "", "10", "0", "1", "2021-01-01 14:59:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("97", "110", "media", "large", "ABSPATHwp-content/uploads/2016/02/title_image-1-1024x237.jpg", "", "Reduced by 5.1% (2.8 KB)", "53290", "56133", "", "10", "0", "1", "2021-01-01 14:59:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("98", "110", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/title_image-1-150x150.jpg", "", "Reduced by 7.1% (382 B)", "5024", "5406", "", "10", "0", "1", "2021-01-01 14:59:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("99", "110", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/title_image-1-768x178.jpg", "", "Reduced by 5.6% (1.9 KB)", "32824", "34768", "", "10", "0", "1", "2021-01-01 14:59:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("100", "110", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/title_image-1-1536x356.jpg", "", "Reduced by 4.6% (4.9 KB)", "105048", "110082", "", "10", "0", "1", "2021-01-01 14:59:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("101", "110", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/title_image-1-570x445.jpg", "", "Reduced by 3.4% (1.4 KB)", "41382", "42860", "", "10", "0", "1", "2021-01-01 14:59:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("102", "110", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/title_image-1-600x445.jpg", "", "Reduced by 3.9% (1.7 KB)", "43885", "45661", "", "10", "0", "1", "2021-01-01 14:59:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("103", "110", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/title_image-1-800x445.jpg", "", "Reduced by 15.6% (8.4 KB)", "46782", "55405", "", "10", "0", "1", "2021-01-01 14:59:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("104", "110", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/title_image-1-345x198.jpg", "", "Reduced by 5.5% (856 B)", "14688", "15544", "", "10", "0", "1", "2021-01-01 14:59:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("105", "110", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/title_image-1-400x260.jpg", "", "Reduced by 4.8% (1,019 B)", "20244", "21263", "", "10", "0", "1", "2021-01-01 14:59:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("106", "110", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/title_image-1-500x380.jpg", "", "Reduced by 3.9% (1.3 KB)", "31305", "32592", "", "10", "0", "1", "2021-01-01 14:59:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("107", "110", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/title_image-1-500x445.jpg", "", "Reduced by 3.5% (1.2 KB)", "34588", "35827", "", "10", "0", "1", "2021-01-01 14:59:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("108", "110", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/title_image-1-1000x445.jpg", "", "Reduced by 4.0% (3.2 KB)", "78134", "81390", "", "10", "0", "1", "2021-01-01 14:59:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("109", "110", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/title_image-1-700x162.jpg", "", "Reduced by 5.8% (1.7 KB)", "27743", "29437", "", "10", "0", "1", "2021-01-01 14:59:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("110", "110", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/title_image-1-539x303.jpg", "", "Reduced by 4.4% (1.4 KB)", "30383", "31774", "", "10", "0", "1", "2021-01-01 14:59:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("111", "156", "media", "full", "ABSPATHwp-content/uploads/2016/02/services-1.jpg", "", "Reduced by 4.8% (1.7 KB)", "34476", "36208", "", "10", "0", "1", "2021-01-01 14:59:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("112", "156", "media", "medium", "ABSPATHwp-content/uploads/2016/02/services-1-300x200.jpg", "", "Reduced by 6.0% (951 B)", "14915", "15866", "", "10", "0", "1", "2021-01-01 14:59:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("113", "156", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/services-1-150x150.jpg", "", "Reduced by 8.2% (624 B)", "7014", "7638", "", "10", "0", "1", "2021-01-01 14:59:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("114", "156", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/services-1-570x399.jpg", "", "Reduced by 4.4% (1.9 KB)", "43342", "45334", "", "10", "0", "1", "2021-01-01 14:59:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("115", "156", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/services-1-345x198.jpg", "", "Reduced by 5.6% (957 B)", "16037", "16994", "", "10", "0", "1", "2021-01-01 14:59:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("116", "156", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/services-1-400x260.jpg", "", "Reduced by 5.7% (1.3 KB)", "22598", "23974", "", "10", "0", "1", "2021-01-01 14:59:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("117", "156", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/services-1-500x380.jpg", "", "Reduced by 4.7% (1.7 KB)", "36150", "37930", "", "10", "0", "1", "2021-01-01 14:59:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("118", "156", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/services-1-500x399.jpg", "", "Reduced by 4.5% (1.9 KB)", "40118", "42025", "", "10", "0", "1", "2021-01-01 14:59:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("119", "156", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/services-1-539x303.jpg", "", "Reduced by 4.4% (1.4 KB)", "30773", "32192", "", "10", "0", "1", "2021-01-01 14:59:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("120", "157", "media", "full", "ABSPATHwp-content/uploads/2016/02/services2-1.jpg", "", "Reduced by 3.8% (1.3 KB)", "35190", "36572", "", "10", "0", "1", "2021-01-01 14:59:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("121", "157", "media", "medium", "ABSPATHwp-content/uploads/2016/02/services2-1-300x200.jpg", "", "Reduced by 5.6% (905 B)", "15358", "16263", "", "10", "0", "1", "2021-01-01 14:59:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("122", "157", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/services2-1-150x150.jpg", "", "Reduced by 7.6% (500 B)", "6071", "6571", "", "10", "0", "1", "2021-01-01 14:59:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("123", "157", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/services2-1-570x399.jpg", "", "Reduced by 4.5% (2.1 KB)", "46028", "48198", "", "10", "0", "1", "2021-01-01 14:59:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("124", "157", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/services2-1-345x198.jpg", "", "Reduced by 5.6% (985 B)", "16569", "17554", "", "10", "0", "1", "2021-01-01 14:59:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("125", "157", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/services2-1-400x260.jpg", "", "Reduced by 5.0% (1.2 KB)", "23837", "25104", "", "10", "0", "1", "2021-01-01 14:59:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("126", "157", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/services2-1-500x380.jpg", "", "Reduced by 4.1% (1.5 KB)", "36205", "37758", "", "10", "0", "1", "2021-01-01 14:59:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("127", "157", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/services2-1-500x399.jpg", "", "Reduced by 4.4% (1.8 KB)", "39707", "41515", "", "10", "0", "1", "2021-01-01 14:59:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("128", "157", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/services2-1-539x303.jpg", "", "Reduced by 4.2% (1.4 KB)", "32876", "34318", "", "10", "0", "1", "2021-01-01 14:59:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("129", "158", "media", "full", "ABSPATHwp-content/uploads/2016/02/services3-1-1.jpg", "", "Reduced by 1.5% (785 B)", "52739", "53524", "", "10", "0", "1", "2021-01-01 15:00:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("130", "158", "media", "medium", "ABSPATHwp-content/uploads/2016/02/services3-1-1-300x200.jpg", "", "Reduced by 6.3% (1.4 KB)", "21993", "23468", "", "10", "0", "1", "2021-01-01 15:00:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("131", "158", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/services3-1-1-150x150.jpg", "", "Reduced by 8.4% (847 B)", "9247", "10094", "", "10", "0", "1", "2021-01-01 15:00:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("132", "158", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/services3-1-1-570x399.jpg", "", "Reduced by 5.4% (4.0 KB)", "72162", "76266", "", "10", "0", "1", "2021-01-01 15:00:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("133", "158", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/services3-1-1-345x198.jpg", "", "Reduced by 6.6% (1.7 KB)", "24842", "26606", "", "10", "0", "1", "2021-01-01 15:00:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("134", "158", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/services3-1-1-400x260.jpg", "", "Reduced by 6.1% (2.3 KB)", "35664", "37996", "", "10", "0", "1", "2021-01-01 15:00:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("135", "158", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/services3-1-1-500x380.jpg", "", "Reduced by 5.8% (3.5 KB)", "57738", "61287", "", "10", "0", "1", "2021-01-01 15:00:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("136", "158", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/services3-1-1-500x399.jpg", "", "Reduced by 5.8% (4.0 KB)", "66721", "70850", "", "10", "0", "1", "2021-01-01 15:00:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("137", "158", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/services3-1-1-539x303.jpg", "", "Reduced by 5.9% (3.1 KB)", "51264", "54460", "", "10", "0", "1", "2021-01-01 15:00:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("138", "174", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1.jpg", "", "Reduced by 1.0% (536 B)", "54485", "55021", "", "10", "0", "1", "2021-01-01 15:00:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("139", "174", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-300x225.jpg", "", "Reduced by 5.5% (961 B)", "16497", "17458", "", "10", "0", "1", "2021-01-01 15:00:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("140", "174", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-150x150.jpg", "", "Reduced by 7.0% (491 B)", "6503", "6994", "", "10", "0", "1", "2021-01-01 15:00:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("141", "174", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-570x480.jpg", "", "Reduced by 3.6% (2.0 KB)", "54703", "56770", "", "10", "0", "1", "2021-01-01 15:00:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("142", "174", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-600x480.jpg", "", "Reduced by 3.7% (2.2 KB)", "57783", "60030", "", "10", "0", "1", "2021-01-01 15:00:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("143", "174", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-345x198.jpg", "", "Reduced by 5.9% (1.1 KB)", "17551", "18652", "", "10", "0", "1", "2021-01-01 15:00:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("144", "174", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-400x260.jpg", "", "Reduced by 5.3% (1.3 KB)", "24089", "25435", "", "10", "0", "1", "2021-01-01 15:00:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("145", "174", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-500x380.jpg", "", "Reduced by 4.2% (1.7 KB)", "38518", "40227", "", "10", "0", "1", "2021-01-01 15:00:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("146", "174", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-500x480.jpg", "", "Reduced by 3.6% (1.8 KB)", "48935", "50770", "", "10", "0", "1", "2021-01-01 15:00:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("147", "174", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-art-week-2014-malmo-1-539x303.jpg", "", "Reduced by 4.6% (1.7 KB)", "35492", "37200", "", "10", "0", "1", "2021-01-01 15:00:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("148", "175", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1.jpg", "", "Reduced by 1.1% (597 B)", "52918", "53515", "", "10", "0", "1", "2021-01-01 15:00:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("149", "175", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-300x225.jpg", "", "Reduced by 6.0% (1.2 KB)", "20023", "21291", "", "10", "0", "1", "2021-01-01 15:00:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("150", "175", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-150x150.jpg", "", "Reduced by 7.2% (644 B)", "8267", "8911", "", "10", "0", "1", "2021-01-01 15:00:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("151", "175", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-570x480.jpg", "", "Reduced by 4.6% (3.4 KB)", "72740", "76231", "", "10", "0", "1", "2021-01-01 15:00:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("152", "175", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-600x480.jpg", "", "Reduced by 4.8% (3.7 KB)", "75150", "78915", "", "10", "0", "1", "2021-01-01 15:00:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("153", "175", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-345x198.jpg", "", "Reduced by 5.5% (1.1 KB)", "19682", "20825", "", "10", "0", "1", "2021-01-01 15:00:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("154", "175", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-400x260.jpg", "", "Reduced by 5.3% (1.6 KB)", "28799", "30404", "", "10", "0", "1", "2021-01-01 15:00:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("155", "175", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-500x380.jpg", "", "Reduced by 4.7% (2.3 KB)", "48437", "50833", "", "10", "0", "1", "2021-01-01 15:00:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("156", "175", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-500x480.jpg", "", "Reduced by 4.6% (3.1 KB)", "65839", "69002", "", "10", "0", "1", "2021-01-01 15:00:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("157", "175", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-fast-vector-mobile-1-539x303.jpg", "", "Reduced by 4.7% (1.9 KB)", "40304", "42270", "", "10", "0", "1", "2021-01-01 15:00:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("158", "176", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1.jpg", "", "Reduced by 1.0% (499 B)", "52006", "52505", "", "10", "0", "1", "2021-01-01 15:00:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("159", "176", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-300x222.jpg", "", "Reduced by 6.0% (999 B)", "15724", "16723", "", "10", "0", "1", "2021-01-01 15:00:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("160", "176", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-150x150.jpg", "", "Reduced by 8.1% (626 B)", "7073", "7699", "", "10", "0", "1", "2021-01-01 15:00:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("161", "176", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-570x480.jpg", "", "Reduced by 4.0% (2.1 KB)", "50971", "53109", "", "10", "0", "1", "2021-01-01 15:00:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("162", "176", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-600x480.jpg", "", "Reduced by 4.1% (2.2 KB)", "52010", "54258", "", "10", "0", "1", "2021-01-01 15:00:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("163", "176", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-345x198.jpg", "", "Reduced by 5.9% (996 B)", "15926", "16922", "", "10", "0", "1", "2021-01-01 15:00:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("164", "176", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-400x260.jpg", "", "Reduced by 5.6% (1.3 KB)", "22136", "23439", "", "10", "0", "1", "2021-01-01 15:00:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("165", "176", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-500x380.jpg", "", "Reduced by 4.9% (1.8 KB)", "35953", "37807", "", "10", "0", "1", "2021-01-01 15:00:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("166", "176", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-500x480.jpg", "", "Reduced by 4.4% (2.1 KB)", "47246", "49401", "", "10", "0", "1", "2021-01-01 15:00:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("167", "176", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-vintage-vinyl-house-1-539x303.jpg", "", "Reduced by 4.7% (1.5 KB)", "30680", "32177", "", "10", "0", "1", "2021-01-01 15:00:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("168", "177", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1.jpg", "", "Reduced by 1.6% (798 B)", "47599", "48397", "", "10", "0", "1", "2021-01-01 15:00:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("169", "177", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-300x225.jpg", "", "Reduced by 5.9% (1.0 KB)", "16395", "17428", "", "10", "0", "1", "2021-01-01 15:00:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("170", "177", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-150x150.jpg", "", "Reduced by 8.3% (661 B)", "7276", "7937", "", "10", "0", "1", "2021-01-01 15:00:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("171", "177", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-570x480.jpg", "", "Reduced by 4.3% (2.4 KB)", "54768", "57241", "", "10", "0", "1", "2021-01-01 15:00:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("172", "177", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-600x480.jpg", "", "Reduced by 4.4% (2.5 KB)", "55947", "58502", "", "10", "0", "1", "2021-01-01 15:00:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("173", "177", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-345x198.jpg", "", "Reduced by 5.6% (882 B)", "14860", "15742", "", "10", "0", "1", "2021-01-01 15:00:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("174", "177", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-400x260.jpg", "", "Reduced by 5.1% (1.2 KB)", "22030", "23208", "", "10", "0", "1", "2021-01-01 15:00:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("175", "177", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-500x380.jpg", "", "Reduced by 4.8% (1.9 KB)", "37446", "39350", "", "10", "0", "1", "2021-01-01 15:00:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("176", "177", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-500x480.jpg", "", "Reduced by 4.7% (2.5 KB)", "51629", "54167", "", "10", "0", "1", "2021-01-01 15:00:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("177", "177", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-67b-construction-studio-1-539x303.jpg", "", "Reduced by 4.6% (1.3 KB)", "28622", "29990", "", "10", "0", "1", "2021-01-01 15:00:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("178", "178", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1.jpg", "", "Reduced by 0.7% (708 B)", "98105", "98813", "", "10", "0", "1", "2021-01-01 15:00:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("179", "178", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-300x225.jpg", "", "Reduced by 6.3% (1.4 KB)", "21003", "22416", "", "10", "0", "1", "2021-01-01 15:00:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("180", "178", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-150x150.jpg", "", "Reduced by 8.1% (733 B)", "8354", "9087", "", "10", "0", "1", "2021-01-01 15:00:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("181", "178", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-570x480.jpg", "", "Reduced by 5.7% (4.2 KB)", "70102", "74377", "", "10", "0", "1", "2021-01-01 15:00:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("182", "178", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-600x480.jpg", "", "Reduced by 5.9% (4.4 KB)", "72960", "77508", "", "10", "0", "1", "2021-01-01 15:00:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("183", "178", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-345x198.jpg", "", "Reduced by 6.8% (1.5 KB)", "21052", "22593", "", "10", "0", "1", "2021-01-01 15:00:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("184", "178", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-400x260.jpg", "", "Reduced by 6.5% (2.0 KB)", "29678", "31743", "", "10", "0", "1", "2021-01-01 15:00:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("185", "178", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-500x380.jpg", "", "Reduced by 6.2% (3.1 KB)", "48199", "51370", "", "10", "0", "1", "2021-01-01 15:00:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("186", "178", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-500x480.jpg", "", "Reduced by 5.9% (3.8 KB)", "62325", "66213", "", "10", "0", "1", "2021-01-01 15:00:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("187", "178", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-superdollz-showroom-1-539x303.jpg", "", "Reduced by 6.3% (2.7 KB)", "41990", "44790", "", "10", "0", "1", "2021-01-01 15:00:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("188", "179", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1.jpg", "", "Reduced by 2.2% (882 B)", "39008", "39890", "", "10", "0", "1", "2021-01-01 15:00:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("189", "179", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-300x225.jpg", "", "Reduced by 5.4% (792 B)", "13861", "14653", "", "10", "0", "1", "2021-01-01 15:00:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("190", "179", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-150x150.jpg", "", "Reduced by 7.6% (446 B)", "5442", "5888", "", "10", "0", "1", "2021-01-01 15:00:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("191", "179", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-570x480.jpg", "", "Reduced by 3.9% (1.7 KB)", "43046", "44778", "", "10", "0", "1", "2021-01-01 15:00:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("192", "179", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-600x480.jpg", "", "Reduced by 4.0% (1.9 KB)", "45362", "47276", "", "10", "0", "1", "2021-01-01 15:00:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("193", "179", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-345x198.jpg", "", "Reduced by 5.3% (775 B)", "13811", "14586", "", "10", "0", "1", "2021-01-01 15:00:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("194", "179", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-400x260.jpg", "", "Reduced by 4.9% (993 B)", "19455", "20448", "", "10", "0", "1", "2021-01-01 15:00:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("195", "179", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-500x380.jpg", "", "Reduced by 4.4% (1.4 KB)", "31140", "32559", "", "10", "0", "1", "2021-01-01 15:00:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("196", "179", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-500x480.jpg", "", "Reduced by 3.9% (1.5 KB)", "37724", "39270", "", "10", "0", "1", "2021-01-01 15:00:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("197", "179", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-mother-volcano-artwork-1-539x303.jpg", "", "Reduced by 4.0% (1.1 KB)", "26083", "27181", "", "10", "0", "1", "2021-01-01 15:00:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("198", "308", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1.jpg", "", "Reduced by 1.7% (1.1 KB)", "66102", "67237", "", "10", "0", "1", "2021-01-01 15:00:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("199", "308", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-300x188.jpg", "", "Reduced by 5.8% (892 B)", "14524", "15416", "", "10", "0", "1", "2021-01-01 15:00:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("200", "308", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-150x150.jpg", "", "Reduced by 7.2% (509 B)", "6570", "7079", "", "10", "0", "1", "2021-01-01 15:00:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("201", "308", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-768x480.jpg", "", "Reduced by 4.1% (2.9 KB)", "69164", "72099", "", "10", "0", "1", "2021-01-01 15:00:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("202", "308", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-570x570.jpg", "", "Reduced by 3.8% (2.2 KB)", "58507", "60796", "", "10", "0", "1", "2021-01-01 15:00:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("203", "308", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-600x597.jpg", "", "Reduced by 3.8% (2.5 KB)", "65084", "67657", "", "10", "0", "1", "2021-01-01 15:00:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("204", "308", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-800x597.jpg", "", "Reduced by 3.4% (3.1 KB)", "87589", "90715", "", "10", "0", "1", "2021-01-01 15:00:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("205", "308", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-345x198.jpg", "", "Reduced by 6.0% (1.1 KB)", "17352", "18456", "", "10", "0", "1", "2021-01-01 15:00:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("206", "308", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-400x260.jpg", "", "Reduced by 5.4% (1.3 KB)", "23973", "25329", "", "10", "0", "1", "2021-01-01 15:00:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("207", "308", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-500x380.jpg", "", "Reduced by 4.6% (1.9 KB)", "39378", "41286", "", "10", "0", "1", "2021-01-01 15:01:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("208", "308", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-500x500.jpg", "", "Reduced by 4.2% (2.0 KB)", "47629", "49692", "", "10", "0", "1", "2021-01-01 15:01:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("209", "308", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-955x500.jpg", "", "Reduced by 15.3% (13.2 KB)", "75052", "88564", "", "10", "0", "1", "2021-01-01 15:01:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("210", "308", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-500x597.jpg", "", "Reduced by 3.6% (2.1 KB)", "57284", "59427", "", "10", "0", "1", "2021-01-01 15:01:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("211", "308", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-700x438.jpg", "", "Reduced by 4.2% (2.6 KB)", "59925", "62566", "", "10", "0", "1", "2021-01-01 15:01:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("212", "308", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-recent-trends-in-storytelling-1-539x303.jpg", "", "Reduced by 4.9% (1.8 KB)", "36375", "38236", "", "10", "0", "1", "2021-01-01 15:01:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("213", "312", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1.jpg", "", "Reduced by 1.5% (1.2 KB)", "78405", "79629", "", "10", "0", "1", "2021-01-01 15:01:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("214", "312", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-300x188.jpg", "", "Reduced by 4.9% (620 B)", "12027", "12647", "", "10", "0", "1", "2021-01-01 15:01:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("215", "312", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-150x150.jpg", "", "Reduced by 6.4% (409 B)", "5957", "6366", "", "10", "0", "1", "2021-01-01 15:01:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("216", "312", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-768x480.jpg", "", "Reduced by 5.1% (2.8 KB)", "52906", "55750", "", "10", "0", "1", "2021-01-01 15:01:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("217", "312", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-570x570.jpg", "", "Reduced by 4.3% (2.1 KB)", "47600", "49761", "", "10", "0", "1", "2021-01-01 15:01:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("218", "312", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-600x597.jpg", "", "Reduced by 5.1% (2.9 KB)", "54541", "57474", "", "10", "0", "1", "2021-01-01 15:01:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("219", "312", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-800x597.jpg", "", "Reduced by 5.0% (3.7 KB)", "72212", "76047", "", "10", "0", "1", "2021-01-01 15:01:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("220", "312", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-345x198.jpg", "", "Reduced by 4.9% (722 B)", "13968", "14690", "", "10", "0", "1", "2021-01-01 15:01:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("221", "312", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-400x260.jpg", "", "Reduced by 4.8% (1,011 B)", "20135", "21146", "", "10", "0", "1", "2021-01-01 15:01:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("222", "312", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-500x380.jpg", "", "Reduced by 5.0% (1.7 KB)", "33003", "34740", "", "10", "0", "1", "2021-01-01 15:01:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("223", "312", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-500x500.jpg", "", "Reduced by 4.7% (1.9 KB)", "39384", "41343", "", "10", "0", "1", "2021-01-01 15:01:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("224", "312", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-955x500.jpg", "", "Reduced by 6.0% (4.1 KB)", "66599", "70847", "", "10", "0", "1", "2021-01-01 15:01:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("225", "312", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-500x597.jpg", "", "Reduced by 4.9% (2.4 KB)", "47334", "49779", "", "10", "0", "1", "2021-01-01 15:01:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("226", "312", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-700x438.jpg", "", "Reduced by 5.1% (2.5 KB)", "46533", "49054", "", "10", "0", "1", "2021-01-01 15:01:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("227", "312", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-oscar-wilde-1-539x303.jpg", "", "Reduced by 4.9% (1.4 KB)", "27847", "29273", "", "10", "0", "1", "2021-01-01 15:01:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("228", "508", "media", "full", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1.jpg", "", "Reduced by 1.7% (2.2 KB)", "128632", "130857", "", "10", "0", "1", "2021-01-01 15:01:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("229", "508", "media", "medium", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-300x80.jpg", "", "Reduced by 8.1% (384 B)", "4355", "4739", "", "10", "0", "1", "2021-01-01 15:01:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("230", "508", "media", "large", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-1024x273.jpg", "", "Reduced by 5.2% (1.9 KB)", "34751", "36668", "", "10", "0", "1", "2021-01-01 15:01:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("231", "508", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-150x150.jpg", "", "Reduced by 9.8% (388 B)", "3566", "3954", "", "10", "0", "1", "2021-01-01 15:01:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("232", "508", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-768x205.jpg", "", "Reduced by 5.1% (1.1 KB)", "21384", "22542", "", "10", "0", "1", "2021-01-01 15:01:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("233", "508", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-1536x410.jpg", "", "Reduced by 5.0% (3.4 KB)", "66564", "70069", "", "10", "0", "1", "2021-01-01 15:01:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("234", "508", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-570x512.jpg", "", "Reduced by 5.1% (1.7 KB)", "32645", "34403", "", "10", "0", "1", "2021-01-01 15:01:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("235", "508", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-600x512.jpg", "", "Reduced by 5.0% (1.8 KB)", "34300", "36113", "", "10", "0", "1", "2021-01-01 15:01:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("236", "508", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-800x512.jpg", "", "Reduced by 4.8% (2.3 KB)", "47042", "49433", "", "10", "0", "1", "2021-01-01 15:01:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("237", "508", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-345x198.jpg", "", "Reduced by 6.1% (676 B)", "10409", "11085", "", "10", "0", "1", "2021-01-01 15:01:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("238", "508", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-400x260.jpg", "", "Reduced by 5.7% (863 B)", "14311", "15174", "", "10", "0", "1", "2021-01-01 15:01:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("239", "508", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-500x380.jpg", "", "Reduced by 5.2% (1.2 KB)", "22859", "24122", "", "10", "0", "1", "2021-01-01 15:01:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("240", "508", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-500x500.jpg", "", "Reduced by 5.4% (1.5 KB)", "26645", "28159", "", "10", "0", "1", "2021-01-01 15:01:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("241", "508", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-1000x500.jpg", "", "Reduced by 4.6% (2.6 KB)", "55622", "58324", "", "10", "0", "1", "2021-01-01 15:01:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("242", "508", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-500x512.jpg", "", "Reduced by 5.3% (1.6 KB)", "28745", "30345", "", "10", "0", "1", "2021-01-01 15:01:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("243", "508", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-1000x512.jpg", "", "Reduced by 4.8% (3.0 KB)", "59803", "62825", "", "10", "0", "1", "2021-01-01 15:01:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("244", "508", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-700x187.jpg", "", "Reduced by 5.2% (1,015 B)", "18488", "19503", "", "10", "0", "1", "2021-01-01 15:01:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("245", "508", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/page-bg-img-1-539x303.jpg", "", "Reduced by 5.2% (1.2 KB)", "21656", "22847", "", "10", "0", "1", "2021-01-01 15:01:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("246", "518", "media", "full", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1.jpg", "", "Reduced by 1.0% (578 B)", "56770", "57348", "", "10", "0", "1", "2021-01-01 15:01:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("247", "518", "media", "medium", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-300x160.jpg", "", "Reduced by 5.9% (777 B)", "12480", "13257", "", "10", "0", "1", "2021-01-01 15:01:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("248", "518", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-150x150.jpg", "", "Reduced by 6.8% (451 B)", "6192", "6643", "", "10", "0", "1", "2021-01-01 15:01:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("249", "518", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-570x350.jpg", "", "Reduced by 4.9% (2.1 KB)", "40413", "42514", "", "10", "0", "1", "2021-01-01 15:01:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("250", "518", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-600x350.jpg", "", "Reduced by 4.9% (2.1 KB)", "42182", "44339", "", "10", "0", "1", "2021-01-01 15:01:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("251", "518", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-345x198.jpg", "", "Reduced by 5.9% (1.0 KB)", "16547", "17593", "", "10", "0", "1", "2021-01-01 15:01:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("252", "518", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-400x260.jpg", "", "Reduced by 5.8% (1.3 KB)", "22447", "23822", "", "10", "0", "1", "2021-01-01 15:01:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("253", "518", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-500x350.jpg", "", "Reduced by 5.3% (1.9 KB)", "35518", "37495", "", "10", "0", "1", "2021-01-01 15:01:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("254", "518", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/southern-colorado-1-539x303.jpg", "", "Reduced by 4.9% (1.6 KB)", "32624", "34293", "", "10", "0", "1", "2021-01-01 15:01:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("255", "300", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1.jpg", "", "Reduced by 3.3% (1.7 KB)", "50912", "52624", "", "10", "0", "1", "2021-01-01 15:01:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("256", "300", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-300x188.jpg", "", "Reduced by 5.5% (725 B)", "12463", "13188", "", "10", "0", "1", "2021-01-01 15:01:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("257", "300", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-150x150.jpg", "", "Reduced by 8.0% (541 B)", "6246", "6787", "", "10", "0", "1", "2021-01-01 15:01:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("258", "300", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-768x480.jpg", "", "Reduced by 4.2% (2.3 KB)", "52888", "55212", "", "10", "0", "1", "2021-01-01 15:01:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("259", "300", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-570x570.jpg", "", "Reduced by 4.3% (2.2 KB)", "50631", "52885", "", "10", "0", "1", "2021-01-01 15:01:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("260", "300", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-600x597.jpg", "", "Reduced by 4.4% (2.5 KB)", "55428", "57980", "", "10", "0", "1", "2021-01-01 15:01:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("261", "300", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-800x597.jpg", "", "Reduced by 4.1% (2.9 KB)", "68945", "71866", "", "10", "0", "1", "2021-01-01 15:01:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("262", "300", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-345x198.jpg", "", "Reduced by 6.2% (921 B)", "13972", "14893", "", "10", "0", "1", "2021-01-01 15:01:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("263", "300", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-400x260.jpg", "", "Reduced by 5.1% (1.1 KB)", "20228", "21314", "", "10", "0", "1", "2021-01-01 15:01:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("264", "300", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-500x380.jpg", "", "Reduced by 4.6% (1.5 KB)", "32714", "34275", "", "10", "0", "1", "2021-01-01 15:01:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("265", "300", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-500x500.jpg", "", "Reduced by 4.4% (1.9 KB)", "41767", "43689", "", "10", "0", "1", "2021-01-01 15:01:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("266", "300", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-955x500.jpg", "", "Reduced by 12.5% (7.2 KB)", "51918", "59306", "", "10", "0", "1", "2021-01-01 15:01:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("267", "300", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-500x597.jpg", "", "Reduced by 4.0% (2.1 KB)", "52291", "54489", "", "10", "0", "1", "2021-01-01 15:01:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("268", "300", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-700x438.jpg", "", "Reduced by 4.3% (2.0 KB)", "46421", "48498", "", "10", "0", "1", "2021-01-01 15:01:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("269", "300", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-transitions-in-ux-design-1-539x303.jpg", "", "Reduced by 4.6% (1.3 KB)", "27414", "28732", "", "10", "0", "1", "2021-01-01 15:01:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("270", "685", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-2-1.jpg", "", "Reduced by 1.8% (1.1 KB)", "62911", "64065", "", "10", "0", "1", "2021-01-01 15:01:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("271", "685", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-2-1-300x190.jpg", "", "Reduced by 6.0% (1.1 KB)", "17243", "18349", "", "10", "0", "1", "2021-01-01 15:01:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("272", "685", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-2-1-150x150.jpg", "", "Reduced by 7.5% (585 B)", "7251", "7836", "", "10", "0", "1", "2021-01-01 15:01:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("273", "685", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-2-1-570x380.jpg", "", "Reduced by 4.9% (2.6 KB)", "51807", "54481", "", "10", "0", "1", "2021-01-01 15:01:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("274", "685", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-2-1-345x198.jpg", "", "Reduced by 6.3% (1.3 KB)", "19252", "20556", "", "10", "0", "1", "2021-01-01 15:01:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("275", "685", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-2-1-400x260.jpg", "", "Reduced by 5.6% (1.6 KB)", "27225", "28853", "", "10", "0", "1", "2021-01-01 15:01:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("276", "685", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-2-1-500x380.jpg", "", "Reduced by 5.2% (2.4 KB)", "45692", "48180", "", "10", "0", "1", "2021-01-01 15:01:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("277", "685", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-2-1-539x303.jpg", "", "Reduced by 5.1% (2.0 KB)", "37584", "39611", "", "10", "0", "1", "2021-01-01 15:01:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("278", "687", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-4-1.jpg", "", "Reduced by 1.5% (770 B)", "51341", "52111", "", "10", "0", "1", "2021-01-01 15:01:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("279", "687", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-4-1-300x190.jpg", "", "Reduced by 5.7% (784 B)", "13015", "13799", "", "10", "0", "1", "2021-01-01 15:01:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("280", "687", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-4-1-150x150.jpg", "", "Reduced by 6.9% (475 B)", "6388", "6863", "", "10", "0", "1", "2021-01-01 15:01:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("281", "687", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-4-1-570x380.jpg", "", "Reduced by 5.6% (2.3 KB)", "39993", "42374", "", "10", "0", "1", "2021-01-01 15:01:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("282", "687", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-4-1-345x198.jpg", "", "Reduced by 5.9% (911 B)", "14505", "15416", "", "10", "0", "1", "2021-01-01 15:01:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("283", "687", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-4-1-400x260.jpg", "", "Reduced by 5.5% (1.2 KB)", "20478", "21667", "", "10", "0", "1", "2021-01-01 15:01:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("284", "687", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-4-1-500x380.jpg", "", "Reduced by 5.7% (2.2 KB)", "36631", "38842", "", "10", "0", "1", "2021-01-01 15:01:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("285", "687", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-4-1-539x303.jpg", "", "Reduced by 5.5% (1.6 KB)", "28574", "30237", "", "10", "0", "1", "2021-01-01 15:01:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("286", "689", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-6-1.jpg", "", "Reduced by 1.5% (1,022 B)", "67142", "68164", "", "10", "0", "1", "2021-01-01 15:01:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("287", "689", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-6-1-300x190.jpg", "", "Reduced by 6.4% (1.1 KB)", "16302", "17412", "", "10", "0", "1", "2021-01-01 15:01:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("288", "689", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-6-1-150x150.jpg", "", "Reduced by 7.7% (569 B)", "6787", "7356", "", "10", "0", "1", "2021-01-01 15:01:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("289", "689", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-6-1-570x380.jpg", "", "Reduced by 5.3% (3.0 KB)", "54612", "57698", "", "10", "0", "1", "2021-01-01 15:01:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("290", "689", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-6-1-345x198.jpg", "", "Reduced by 6.1% (1.2 KB)", "18250", "19431", "", "10", "0", "1", "2021-01-01 15:01:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("291", "689", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-6-1-400x260.jpg", "", "Reduced by 5.6% (1.5 KB)", "26040", "27595", "", "10", "0", "1", "2021-01-01 15:01:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("292", "689", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-6-1-500x380.jpg", "", "Reduced by 5.6% (2.8 KB)", "48206", "51055", "", "10", "0", "1", "2021-01-01 15:01:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("293", "689", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-6-1-539x303.jpg", "", "Reduced by 5.3% (2.1 KB)", "38476", "40612", "", "10", "0", "1", "2021-01-01 15:02:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("294", "688", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-5-1.jpg", "", "Reduced by 1.1% (603 B)", "55109", "55712", "", "10", "0", "1", "2021-01-01 15:02:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("295", "688", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-5-1-300x190.jpg", "", "Reduced by 5.8% (825 B)", "13485", "14310", "", "10", "0", "1", "2021-01-01 15:02:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("296", "688", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-5-1-150x150.jpg", "", "Reduced by 7.6% (458 B)", "5533", "5991", "", "10", "0", "1", "2021-01-01 15:02:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("297", "688", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-5-1-570x380.jpg", "", "Reduced by 4.6% (2.1 KB)", "43746", "45850", "", "10", "0", "1", "2021-01-01 15:02:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("298", "688", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-5-1-345x198.jpg", "", "Reduced by 5.9% (969 B)", "15334", "16303", "", "10", "0", "1", "2021-01-01 15:02:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("299", "688", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-5-1-400x260.jpg", "", "Reduced by 4.9% (1.1 KB)", "21159", "22260", "", "10", "0", "1", "2021-01-01 15:02:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("300", "688", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-5-1-500x380.jpg", "", "Reduced by 4.9% (1.9 KB)", "38722", "40704", "", "10", "0", "1", "2021-01-01 15:02:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("301", "688", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-5-1-539x303.jpg", "", "Reduced by 4.5% (1.5 KB)", "31824", "33320", "", "10", "0", "1", "2021-01-01 15:02:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("302", "902", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1.jpg", "", "Reduced by 5.5% (10.8 KB)", "191411", "202479", "", "10", "0", "1", "2021-01-01 15:02:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("303", "902", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-300x122.jpg", "", "Reduced by 10.2% (718 B)", "6337", "7055", "", "10", "0", "1", "2021-01-01 15:02:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("304", "902", "media", "large", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-1024x417.jpg", "", "Reduced by 10.6% (4.8 KB)", "41978", "46932", "", "10", "0", "1", "2021-01-01 15:02:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("305", "902", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-150x150.jpg", "", "Reduced by 15.0% (447 B)", "2537", "2984", "", "10", "0", "1", "2021-01-01 15:02:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("306", "902", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-768x313.jpg", "", "Reduced by 10.3% (3.0 KB)", "26698", "29766", "", "10", "0", "1", "2021-01-01 15:02:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("307", "902", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-1536x626.jpg", "", "Reduced by 11.5% (9.5 KB)", "75272", "85035", "", "10", "0", "1", "2021-01-01 15:02:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("308", "902", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-2048x835.jpg", "", "Reduced by 12.4% (15.9 KB)", "115035", "131344", "", "10", "0", "1", "2021-01-01 15:02:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("309", "902", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-570x570.jpg", "", "Reduced by 16.8% (3.1 KB)", "15827", "19020", "", "10", "0", "1", "2021-01-01 15:02:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("310", "902", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-600x800.jpg", "", "Reduced by 23.9% (4.8 KB)", "15634", "20542", "", "10", "0", "1", "2021-01-01 15:02:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("311", "902", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-800x600.jpg", "", "Reduced by 13.9% (4.5 KB)", "28389", "32953", "", "10", "0", "1", "2021-01-01 15:02:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("312", "902", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-345x198.jpg", "", "Reduced by 9.5% (903 B)", "8625", "9528", "", "10", "0", "1", "2021-01-01 15:02:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("313", "902", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-400x260.jpg", "", "Reduced by 10.5% (1.2 KB)", "10751", "12016", "", "10", "0", "1", "2021-01-01 15:02:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("314", "902", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-500x380.jpg", "", "Reduced by 12.5% (2.0 KB)", "14240", "16267", "", "10", "0", "1", "2021-01-01 15:02:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("315", "902", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-500x500.jpg", "", "Reduced by 16.4% (2.5 KB)", "13154", "15735", "", "10", "0", "1", "2021-01-01 15:02:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("316", "902", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-1000x500.jpg", "", "Reduced by 11.2% (5.1 KB)", "41734", "46986", "", "10", "0", "1", "2021-01-01 15:02:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("317", "902", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-500x978.jpg", "", "Reduced by 37.2% (5.7 KB)", "9846", "15668", "", "10", "0", "1", "2021-01-01 15:02:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("318", "902", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-1000x978.jpg", "", "Reduced by 20.7% (9.5 KB)", "37381", "47111", "", "10", "0", "1", "2021-01-01 15:02:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("319", "902", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-700x285.jpg", "", "Reduced by 10.0% (2.5 KB)", "23271", "25847", "", "10", "0", "1", "2021-01-01 15:02:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("320", "902", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-bg-1-1-539x303.jpg", "", "Reduced by 10.3% (1.8 KB)", "16039", "17888", "", "10", "0", "1", "2021-01-01 15:02:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("321", "904", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1.jpg", "", "Reduced by 1.7% (3.1 KB)", "181358", "184532", "", "10", "0", "1", "2021-01-01 15:02:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("322", "904", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-300x293.jpg", "", "Reduced by 6.2% (1.5 KB)", "23424", "24982", "", "10", "0", "1", "2021-01-01 15:02:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("323", "904", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-150x150.jpg", "", "Reduced by 8.2% (717 B)", "8026", "8743", "", "10", "0", "1", "2021-01-01 15:02:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("324", "904", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-768x751.jpg", "", "Reduced by 4.6% (4.4 KB)", "93105", "97630", "", "10", "0", "1", "2021-01-01 15:02:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("325", "904", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-570x570.jpg", "", "Reduced by 4.9% (3.1 KB)", "62078", "65248", "", "10", "0", "1", "2021-01-01 15:02:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("326", "904", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-600x800.jpg", "", "Reduced by 4.7% (3.8 KB)", "78501", "82350", "", "10", "0", "1", "2021-01-01 15:02:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("327", "904", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-800x600.jpg", "", "Reduced by 4.5% (3.8 KB)", "81020", "84876", "", "10", "0", "1", "2021-01-01 15:02:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("328", "904", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-345x198.jpg", "", "Reduced by 6.6% (1.3 KB)", "18995", "20327", "", "10", "0", "1", "2021-01-01 15:02:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("329", "904", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-400x260.jpg", "", "Reduced by 6.2% (1.7 KB)", "26653", "28414", "", "10", "0", "1", "2021-01-01 15:02:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("330", "904", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-500x380.jpg", "", "Reduced by 5.4% (2.4 KB)", "43126", "45602", "", "10", "0", "1", "2021-01-01 15:02:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("331", "904", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-500x500.jpg", "", "Reduced by 5.2% (2.8 KB)", "51422", "54262", "", "10", "0", "1", "2021-01-01 15:02:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("332", "904", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-1000x500.jpg", "", "Reduced by 4.7% (4.0 KB)", "82136", "86216", "", "10", "0", "1", "2021-01-01 15:02:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("333", "904", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-500x978.jpg", "", "Reduced by 5.3% (4.3 KB)", "79816", "84268", "", "10", "0", "1", "2021-01-01 15:02:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("334", "904", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-700x685.jpg", "", "Reduced by 4.5% (3.8 KB)", "82171", "86025", "", "10", "0", "1", "2021-01-01 15:02:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("335", "904", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-img-1-1-539x303.jpg", "", "Reduced by 4.9% (1.8 KB)", "35433", "37266", "", "10", "0", "1", "2021-01-01 15:02:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("336", "924", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1.jpg", "", "No savings", "156294", "156294", "", "10", "0", "1", "2021-01-01 15:02:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("337", "924", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-300x200.jpg", "", "Reduced by 35.1% (900 B)", "1667", "2567", "", "10", "0", "1", "2021-01-01 15:02:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("338", "924", "media", "large", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-1024x683.jpg", "", "Reduced by 35.2% (32.5 KB)", "61263", "94576", "", "10", "0", "1", "2021-01-01 15:02:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("339", "924", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-150x150.jpg", "", "Reduced by 42.7% (592 B)", "794", "1386", "", "10", "0", "1", "2021-01-01 15:02:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("340", "924", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-768x512.jpg", "", "Reduced by 53.8% (27.5 KB)", "24261", "52466", "", "10", "0", "1", "2021-01-01 15:02:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("341", "924", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-1536x1024.jpg", "", "Reduced by 26.2% (64.1 KB)", "184988", "250661", "", "10", "0", "1", "2021-01-01 15:02:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("342", "924", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-570x570.jpg", "", "Reduced by 50.6% (18.2 KB)", "18185", "36807", "", "10", "0", "1", "2021-01-01 15:02:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("343", "924", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-600x800.jpg", "", "Reduced by 22.6% (14.7 KB)", "51430", "66450", "", "10", "0", "1", "2021-01-01 15:02:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("344", "924", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-800x600.jpg", "", "Reduced by 44.4% (26.3 KB)", "33721", "60621", "", "10", "0", "1", "2021-01-01 15:02:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("345", "924", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-345x198.jpg", "", "Reduced by 32.4% (968 B)", "2024", "2992", "", "10", "0", "1", "2021-01-01 15:02:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("346", "924", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-400x260.jpg", "", "Reduced by 36.0% (1.3 KB)", "2402", "3754", "", "10", "0", "1", "2021-01-01 15:02:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("347", "924", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-500x380.jpg", "", "Reduced by 40.1% (2.3 KB)", "3487", "5821", "", "10", "0", "1", "2021-01-01 15:02:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("348", "924", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-500x500.jpg", "", "Reduced by 57.4% (11.1 KB)", "8450", "19849", "", "10", "0", "1", "2021-01-01 15:02:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("349", "924", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-1000x500.jpg", "", "Reduced by 39.0% (26.0 KB)", "41655", "68278", "", "10", "0", "1", "2021-01-01 15:02:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("350", "924", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-500x1000.jpg", "", "Reduced by 21.5% (15.5 KB)", "58120", "74041", "", "10", "0", "1", "2021-01-01 15:02:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("351", "924", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-1000x1000.jpg", "", "Reduced by 21.7% (31.6 KB)", "116733", "149107", "", "10", "0", "1", "2021-01-01 15:02:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("352", "924", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-700x467.jpg", "", "Reduced by 51.5% (8.7 KB)", "8412", "17328", "", "10", "0", "1", "2021-01-01 15:02:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("353", "924", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-bg-2-1-539x303.jpg", "", "Reduced by 38.1% (2.4 KB)", "3958", "6396", "", "10", "0", "1", "2021-01-01 15:02:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("354", "971", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1.jpg", "", "Reduced by 15.6% (24.2 KB)", "134543", "159353", "", "10", "0", "1", "2021-01-01 15:02:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("355", "971", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-300x137.jpg", "", "Reduced by 29.0% (666 B)", "1630", "2296", "", "10", "0", "1", "2021-01-01 15:02:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("356", "971", "media", "large", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-1024x466.jpg", "", "Reduced by 34.7% (22.3 KB)", "42988", "65858", "", "10", "0", "1", "2021-01-01 15:02:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("357", "971", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-150x150.jpg", "", "Reduced by 46.4% (621 B)", "718", "1339", "", "10", "0", "1", "2021-01-01 15:02:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("358", "971", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-768x350.jpg", "", "Reduced by 45.3% (11.7 KB)", "14472", "26458", "", "10", "0", "1", "2021-01-01 15:02:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("359", "971", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-1536x699.jpg", "", "Reduced by 19.5% (27.0 KB)", "114135", "141820", "", "10", "0", "1", "2021-01-01 15:02:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("360", "971", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-570x570.jpg", "", "Reduced by 22.2% (9.6 KB)", "34394", "44230", "", "10", "0", "1", "2021-01-01 15:02:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("361", "971", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-600x800.jpg", "", "Reduced by 22.1% (14.6 KB)", "52611", "67547", "", "10", "0", "1", "2021-01-01 15:02:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("362", "971", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-800x600.jpg", "", "Reduced by 24.0% (15.2 KB)", "49051", "64569", "", "10", "0", "1", "2021-01-01 15:02:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("363", "971", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-345x198.jpg", "", "Reduced by 33.8% (963 B)", "1884", "2847", "", "10", "0", "1", "2021-01-01 15:03:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("364", "971", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-400x260.jpg", "", "Reduced by 37.7% (1.3 KB)", "2273", "3649", "", "10", "0", "1", "2021-01-01 15:03:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("365", "971", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-500x380.jpg", "", "Reduced by 52.0% (10.0 KB)", "9485", "19754", "", "10", "0", "1", "2021-01-01 15:03:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("366", "971", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-500x500.jpg", "", "Reduced by 28.1% (9.3 KB)", "24219", "33701", "", "10", "0", "1", "2021-01-01 15:03:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("367", "971", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-1000x500.jpg", "", "Reduced by 25.6% (17.7 KB)", "52640", "70751", "", "10", "0", "1", "2021-01-01 15:03:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("368", "971", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-500x874.jpg", "", "Reduced by 46.5% (26.0 KB)", "30633", "57286", "", "10", "0", "1", "2021-01-01 15:03:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("369", "971", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-1000x874.jpg", "", "Reduced by 47.9% (56.8 KB)", "63288", "121481", "", "10", "0", "1", "2021-01-01 15:03:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("370", "971", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-700x319.jpg", "", "Reduced by 44.0% (5.1 KB)", "6614", "11811", "", "10", "0", "1", "2021-01-01 15:03:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("371", "971", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-bg-4-1-539x303.jpg", "", "Reduced by 33.0% (1.9 KB)", "3922", "5850", "", "10", "0", "1", "2021-01-01 15:03:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("372", "972", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1.jpg", "", "Reduced by 11.6% (14.9 KB)", "116221", "131449", "", "10", "0", "1", "2021-01-01 15:03:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("373", "972", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-300x74.jpg", "", "Reduced by 51.7% (618 B)", "578", "1196", "", "10", "0", "1", "2021-01-01 15:03:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("374", "972", "media", "large", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-1024x252.jpg", "", "Reduced by 37.6% (12.8 KB)", "21851", "35002", "", "10", "0", "1", "2021-01-01 15:03:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("375", "972", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-150x150.jpg", "", "Reduced by 53.1% (669 B)", "592", "1261", "", "10", "0", "1", "2021-01-01 15:03:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("376", "972", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-768x189.jpg", "", "Reduced by 55.1% (7.3 KB)", "6065", "13503", "", "10", "0", "1", "2021-01-01 15:03:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("377", "972", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-1536x378.jpg", "", "Reduced by 22.8% (20.1 KB)", "69897", "90493", "", "10", "0", "1", "2021-01-01 15:03:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("378", "972", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-570x473.jpg", "", "Reduced by 37.9% (17.7 KB)", "29698", "47845", "", "10", "0", "1", "2021-01-01 15:03:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("379", "972", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-600x473.jpg", "", "Reduced by 35.7% (19.2 KB)", "35379", "55054", "", "10", "0", "1", "2021-01-01 15:03:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("380", "972", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-800x473.jpg", "", "Reduced by 40.5% (30.9 KB)", "46518", "78197", "", "10", "0", "1", "2021-01-01 15:03:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("381", "972", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-345x198.jpg", "", "Reduced by 53.5% (4.2 KB)", "3738", "8038", "", "10", "0", "1", "2021-01-01 15:03:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("382", "972", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-400x260.jpg", "", "Reduced by 33.7% (4.9 KB)", "9935", "14982", "", "10", "0", "1", "2021-01-01 15:03:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("383", "972", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-500x380.jpg", "", "Reduced by 21.4% (6.2 KB)", "23157", "29455", "", "10", "0", "1", "2021-01-01 15:03:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("384", "972", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-500x473.jpg", "", "Reduced by 38.3% (18.0 KB)", "29576", "47967", "", "10", "0", "1", "2021-01-01 15:03:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("385", "972", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-1000x473.jpg", "", "Reduced by 36.5% (33.4 KB)", "59589", "93780", "", "10", "0", "1", "2021-01-01 15:03:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("386", "972", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-700x172.jpg", "", "Reduced by 60.6% (3.9 KB)", "2576", "6536", "", "10", "0", "1", "2021-01-01 15:03:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("387", "972", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-bg-5-1-539x303.jpg", "", "Reduced by 22.5% (5.1 KB)", "17945", "23167", "", "10", "0", "1", "2021-01-01 15:03:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("388", "1009", "media", "full", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1.jpg", "", "Reduced by 3.2% (6.1 KB)", "189199", "195464", "", "10", "0", "1", "2021-01-01 15:03:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("389", "1009", "media", "medium", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-300x140.jpg", "", "Reduced by 7.8% (680 B)", "8076", "8756", "", "10", "0", "1", "2021-01-01 15:03:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("390", "1009", "media", "large", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-1024x478.jpg", "", "Reduced by 5.6% (3.3 KB)", "57415", "60842", "", "10", "0", "1", "2021-01-01 15:03:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("391", "1009", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-150x150.jpg", "", "Reduced by 9.3% (498 B)", "4866", "5364", "", "10", "0", "1", "2021-01-01 15:03:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("392", "1009", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-768x359.jpg", "", "Reduced by 5.7% (2.2 KB)", "36465", "38675", "", "10", "0", "1", "2021-01-01 15:03:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("393", "1009", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-1536x718.jpg", "", "Reduced by 5.4% (6.0 KB)", "108454", "114648", "", "10", "0", "1", "2021-01-01 15:03:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("394", "1009", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-570x570.jpg", "", "Reduced by 5.2% (2.3 KB)", "42545", "44871", "", "10", "0", "1", "2021-01-01 15:03:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("395", "1009", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-600x800.jpg", "", "Reduced by 5.0% (2.9 KB)", "56468", "59432", "", "10", "0", "1", "2021-01-01 15:03:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("396", "1009", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-800x600.jpg", "", "Reduced by 5.3% (3.1 KB)", "57491", "60692", "", "10", "0", "1", "2021-01-01 15:03:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("397", "1009", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-345x198.jpg", "", "Reduced by 7.4% (959 B)", "12037", "12996", "", "10", "0", "1", "2021-01-01 15:03:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("398", "1009", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-400x260.jpg", "", "Reduced by 6.6% (1.2 KB)", "16785", "17969", "", "10", "0", "1", "2021-01-01 15:03:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("399", "1009", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-500x380.jpg", "", "Reduced by 5.8% (1.7 KB)", "27678", "29375", "", "10", "0", "1", "2021-01-01 15:03:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("400", "1009", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-500x500.jpg", "", "Reduced by 5.7% (2.0 KB)", "34314", "36372", "", "10", "0", "1", "2021-01-01 15:03:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("401", "1009", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-1000x500.jpg", "", "Reduced by 5.8% (3.5 KB)", "58666", "62254", "", "10", "0", "1", "2021-01-01 15:03:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("402", "1009", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-500x897.jpg", "", "Reduced by 5.6% (3.2 KB)", "56149", "59463", "", "10", "0", "1", "2021-01-01 15:03:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("403", "1009", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-1000x897.jpg", "", "Reduced by 5.9% (6.3 KB)", "103866", "110345", "", "10", "0", "1", "2021-01-01 15:03:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("404", "1009", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-700x327.jpg", "", "Reduced by 6.0% (1.9 KB)", "31243", "33228", "", "10", "0", "1", "2021-01-01 15:03:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("405", "1009", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/slider-2-banner-1-539x303.jpg", "", "Reduced by 6.1% (1.5 KB)", "24010", "25583", "", "10", "0", "1", "2021-01-01 15:03:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("406", "180", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1.jpg", "", "Reduced by 0.8% (833 B)", "108882", "109715", "", "10", "0", "1", "2021-01-01 15:03:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("407", "180", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-300x225.jpg", "", "Reduced by 7.4% (2.4 KB)", "30299", "32712", "", "10", "0", "1", "2021-01-01 15:03:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("408", "180", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-150x150.jpg", "", "Reduced by 8.8% (1,023 B)", "10590", "11613", "", "10", "0", "1", "2021-01-01 15:03:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("409", "180", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-570x480.jpg", "", "Reduced by 7.6% (9.1 KB)", "112669", "121977", "", "10", "0", "1", "2021-01-01 15:03:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("410", "180", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-600x480.jpg", "", "Reduced by 7.8% (9.8 KB)", "118467", "128472", "", "10", "0", "1", "2021-01-01 15:03:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("411", "180", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-345x198.jpg", "", "Reduced by 7.5% (2.5 KB)", "30862", "33377", "", "10", "0", "1", "2021-01-01 15:03:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("412", "180", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-400x260.jpg", "", "Reduced by 7.5% (3.6 KB)", "45479", "49144", "", "10", "0", "1", "2021-01-01 15:03:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("413", "180", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-500x380.jpg", "", "Reduced by 7.4% (5.9 KB)", "76194", "82253", "", "10", "0", "1", "2021-01-01 15:03:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("414", "180", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-500x480.jpg", "", "Reduced by 7.5% (7.8 KB)", "98425", "106387", "", "10", "0", "1", "2021-01-01 15:03:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("415", "180", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-amsterdam-jazz-festival-1-539x303.jpg", "", "Reduced by 7.6% (5.2 KB)", "65563", "70937", "", "10", "0", "1", "2021-01-01 15:03:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("416", "181", "media", "full", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1.jpg", "", "Reduced by 1.2% (718 B)", "60334", "61052", "", "10", "0", "1", "2021-01-01 15:03:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("417", "181", "media", "medium", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-300x225.jpg", "", "Reduced by 5.3% (835 B)", "14862", "15697", "", "10", "0", "1", "2021-01-01 15:03:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("418", "181", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-150x150.jpg", "", "Reduced by 6.6% (431 B)", "6110", "6541", "", "10", "0", "1", "2021-01-01 15:03:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("419", "181", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-570x480.jpg", "", "Reduced by 5.6% (2.8 KB)", "47651", "50470", "", "10", "0", "1", "2021-01-01 15:03:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("420", "181", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-600x480.jpg", "", "Reduced by 5.7% (2.9 KB)", "49584", "52577", "", "10", "0", "1", "2021-01-01 15:03:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("421", "181", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-345x198.jpg", "", "Reduced by 4.8% (745 B)", "14764", "15509", "", "10", "0", "1", "2021-01-01 15:03:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("422", "181", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-400x260.jpg", "", "Reduced by 5.0% (1.1 KB)", "20824", "21925", "", "10", "0", "1", "2021-01-01 15:03:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("423", "181", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-500x380.jpg", "", "Reduced by 5.3% (1.8 KB)", "33205", "35048", "", "10", "0", "1", "2021-01-01 15:03:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("424", "181", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-500x480.jpg", "", "Reduced by 5.2% (2.2 KB)", "41810", "44090", "", "10", "0", "1", "2021-01-01 15:03:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("425", "181", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/p-last-iceland-sunshine-1-539x303.jpg", "", "Reduced by 4.9% (1.5 KB)", "28846", "30343", "", "10", "0", "1", "2021-01-01 15:03:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("426", "302", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1.jpg", "", "Reduced by 1.0% (997 B)", "100354", "101351", "", "10", "0", "1", "2021-01-01 15:03:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("427", "302", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-300x188.jpg", "", "Reduced by 6.4% (1.2 KB)", "17257", "18441", "", "10", "0", "1", "2021-01-01 15:03:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("428", "302", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-150x150.jpg", "", "Reduced by 8.1% (716 B)", "8102", "8818", "", "10", "0", "1", "2021-01-01 15:03:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("429", "302", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-768x480.jpg", "", "Reduced by 5.4% (4.4 KB)", "79090", "83591", "", "10", "0", "1", "2021-01-01 15:03:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("430", "302", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-570x570.jpg", "", "Reduced by 5.3% (3.8 KB)", "70595", "74519", "", "10", "0", "1", "2021-01-01 15:03:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("431", "302", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-600x597.jpg", "", "Reduced by 5.2% (4.4 KB)", "81669", "86133", "", "10", "0", "1", "2021-01-01 15:03:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("432", "302", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-800x597.jpg", "", "Reduced by 5.2% (5.7 KB)", "106472", "112313", "", "10", "0", "1", "2021-01-01 15:03:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("433", "302", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-345x198.jpg", "", "Reduced by 6.4% (1.4 KB)", "20456", "21852", "", "10", "0", "1", "2021-01-01 15:03:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("434", "302", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-400x260.jpg", "", "Reduced by 6.1% (1.8 KB)", "28866", "30737", "", "10", "0", "1", "2021-01-01 15:03:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("435", "302", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-500x380.jpg", "", "Reduced by 6.0% (3.0 KB)", "47212", "50233", "", "10", "0", "1", "2021-01-01 15:03:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("436", "302", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-500x500.jpg", "", "Reduced by 5.7% (3.4 KB)", "57860", "61332", "", "10", "0", "1", "2021-01-01 15:03:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("437", "302", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-955x500.jpg", "", "Reduced by 8.3% (8.7 KB)", "98831", "107764", "", "10", "0", "1", "2021-01-01 15:03:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("438", "302", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-500x597.jpg", "", "Reduced by 5.3% (3.9 KB)", "71111", "75122", "", "10", "0", "1", "2021-01-01 15:03:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("439", "302", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-700x438.jpg", "", "Reduced by 5.5% (3.9 KB)", "68917", "72925", "", "10", "0", "1", "2021-01-01 15:03:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("440", "302", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-inspired-by-italian-style-1-539x303.jpg", "", "Reduced by 6.0% (2.6 KB)", "41670", "44309", "", "10", "0", "1", "2021-01-01 15:03:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("441", "303", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1.jpg", "", "Reduced by 0.7% (742 B)", "99127", "99869", "", "10", "0", "1", "2021-01-01 15:03:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("442", "303", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-300x188.jpg", "", "Reduced by 6.9% (990 B)", "13286", "14276", "", "10", "0", "1", "2021-01-01 15:03:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("443", "303", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-150x150.jpg", "", "Reduced by 7.9% (583 B)", "6838", "7421", "", "10", "0", "1", "2021-01-01 15:03:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("444", "303", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-768x480.jpg", "", "Reduced by 6.1% (4.2 KB)", "66091", "70394", "", "10", "0", "1", "2021-01-01 15:03:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("445", "303", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-570x570.jpg", "", "Reduced by 5.8% (4.0 KB)", "66727", "70806", "", "10", "0", "1", "2021-01-01 15:03:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("446", "303", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-600x597.jpg", "", "Reduced by 5.7% (4.6 KB)", "78418", "83143", "", "10", "0", "1", "2021-01-01 15:04:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("447", "303", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-800x597.jpg", "", "Reduced by 5.9% (6.0 KB)", "97828", "103932", "", "10", "0", "1", "2021-01-01 15:04:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("448", "303", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-345x198.jpg", "", "Reduced by 6.9% (1.1 KB)", "15610", "16758", "", "10", "0", "1", "2021-01-01 15:04:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("449", "303", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-400x260.jpg", "", "Reduced by 6.7% (1.6 KB)", "23029", "24684", "", "10", "0", "1", "2021-01-01 15:04:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("450", "303", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-500x380.jpg", "", "Reduced by 6.3% (2.7 KB)", "41382", "44185", "", "10", "0", "1", "2021-01-01 15:04:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("451", "303", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-500x500.jpg", "", "Reduced by 6.2% (3.5 KB)", "54417", "58010", "", "10", "0", "1", "2021-01-01 15:04:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("452", "303", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-955x500.jpg", "", "Reduced by 6.0% (5.4 KB)", "86197", "91707", "", "10", "0", "1", "2021-01-01 15:04:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("453", "303", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-500x597.jpg", "", "Reduced by 6.0% (4.1 KB)", "64930", "69091", "", "10", "0", "1", "2021-01-01 15:04:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("454", "303", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-700x438.jpg", "", "Reduced by 6.2% (3.7 KB)", "57410", "61228", "", "10", "0", "1", "2021-01-01 15:04:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("455", "303", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-josh-woodward-already-there-1-539x303.jpg", "", "Reduced by 6.2% (2.1 KB)", "33102", "35273", "", "10", "0", "1", "2021-01-01 15:04:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("456", "309", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1.jpg", "", "Reduced by 1.8% (1.0 KB)", "56154", "57179", "", "10", "0", "1", "2021-01-01 15:04:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("457", "309", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-300x188.jpg", "", "Reduced by 6.0% (867 B)", "13618", "14485", "", "10", "0", "1", "2021-01-01 15:04:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("458", "309", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-150x150.jpg", "", "Reduced by 7.7% (577 B)", "6913", "7490", "", "10", "0", "1", "2021-01-01 15:04:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("459", "309", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-768x480.jpg", "", "Reduced by 4.0% (2.4 KB)", "58497", "60952", "", "10", "0", "1", "2021-01-01 15:04:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("460", "309", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-570x570.jpg", "", "Reduced by 4.1% (2.3 KB)", "55719", "58118", "", "10", "0", "1", "2021-01-01 15:04:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("461", "309", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-600x597.jpg", "", "Reduced by 4.6% (2.9 KB)", "61473", "64452", "", "10", "0", "1", "2021-01-01 15:04:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("462", "309", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-800x597.jpg", "", "Reduced by 3.8% (3.0 KB)", "76413", "79455", "", "10", "0", "1", "2021-01-01 15:04:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("463", "309", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-345x198.jpg", "", "Reduced by 5.9% (991 B)", "15683", "16674", "", "10", "0", "1", "2021-01-01 15:04:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("464", "309", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-400x260.jpg", "", "Reduced by 5.2% (1.2 KB)", "22067", "23274", "", "10", "0", "1", "2021-01-01 15:04:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("465", "309", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-500x380.jpg", "", "Reduced by 5.0% (1.9 KB)", "36292", "38205", "", "10", "0", "1", "2021-01-01 15:04:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("466", "309", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-500x500.jpg", "", "Reduced by 4.6% (2.1 KB)", "45791", "47987", "", "10", "0", "1", "2021-01-01 15:04:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("467", "309", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-955x500.jpg", "", "Reduced by 13.8% (9.3 KB)", "58935", "68409", "", "10", "0", "1", "2021-01-01 15:04:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("468", "309", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-500x597.jpg", "", "Reduced by 4.1% (2.3 KB)", "54440", "56778", "", "10", "0", "1", "2021-01-01 15:04:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("469", "309", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-700x438.jpg", "", "Reduced by 4.4% (2.3 KB)", "51045", "53370", "", "10", "0", "1", "2021-01-01 15:04:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("470", "309", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-portugal-road-trip-gallery-1-539x303.jpg", "", "Reduced by 4.7% (1.5 KB)", "30958", "32489", "", "10", "0", "1", "2021-01-01 15:04:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("471", "314", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1.jpg", "", "Reduced by 2.2% (1.4 KB)", "65932", "67393", "", "10", "0", "1", "2021-01-01 15:04:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("472", "314", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-300x188.jpg", "", "Reduced by 5.2% (757 B)", "13679", "14436", "", "10", "0", "1", "2021-01-01 15:04:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("473", "314", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-150x150.jpg", "", "Reduced by 7.2% (443 B)", "5727", "6170", "", "10", "0", "1", "2021-01-01 15:04:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("474", "314", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-768x480.jpg", "", "Reduced by 3.9% (2.5 KB)", "63980", "66566", "", "10", "0", "1", "2021-01-01 15:04:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("475", "314", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-570x570.jpg", "", "Reduced by 3.5% (1.8 KB)", "49845", "51642", "", "10", "0", "1", "2021-01-01 15:04:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("476", "314", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-600x597.jpg", "", "Reduced by 4.3% (2.4 KB)", "55232", "57685", "", "10", "0", "1", "2021-01-01 15:04:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("477", "314", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-800x597.jpg", "", "Reduced by 3.7% (3.0 KB)", "78456", "81483", "", "10", "0", "1", "2021-01-01 15:04:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("478", "314", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-345x198.jpg", "", "Reduced by 5.8% (981 B)", "15928", "16909", "", "10", "0", "1", "2021-01-01 15:04:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("479", "314", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-400x260.jpg", "", "Reduced by 4.9% (1.1 KB)", "22282", "23433", "", "10", "0", "1", "2021-01-01 15:04:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("480", "314", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-500x380.jpg", "", "Reduced by 4.1% (1.5 KB)", "35475", "37002", "", "10", "0", "1", "2021-01-01 15:04:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("481", "314", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-500x500.jpg", "", "Reduced by 3.8% (1.6 KB)", "40448", "42050", "", "10", "0", "1", "2021-01-01 15:04:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("482", "314", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-955x500.jpg", "", "Reduced by 13.1% (10.0 KB)", "68128", "78361", "", "10", "0", "1", "2021-01-01 15:04:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("483", "314", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-500x597.jpg", "", "Reduced by 3.8% (1.9 KB)", "48616", "50527", "", "10", "0", "1", "2021-01-01 15:04:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("484", "314", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-700x438.jpg", "", "Reduced by 4.5% (2.6 KB)", "56200", "58825", "", "10", "0", "1", "2021-01-01 15:04:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("485", "314", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-jeffrey-ween-1-539x303.jpg", "", "Reduced by 4.8% (1.6 KB)", "33201", "34879", "", "10", "0", "1", "2021-01-01 15:04:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("486", "315", "media", "full", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1.jpg", "", "Reduced by 1.6% (1.7 KB)", "108859", "110633", "", "10", "0", "1", "2021-01-01 15:04:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("487", "315", "media", "medium", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-300x188.jpg", "", "Reduced by 7.5% (2.0 KB)", "25624", "27701", "", "10", "0", "1", "2021-01-01 15:04:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("488", "315", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-150x150.jpg", "", "Reduced by 8.4% (982 B)", "10716", "11698", "", "10", "0", "1", "2021-01-01 15:04:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("489", "315", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-768x480.jpg", "", "Reduced by 7.5% (10.9 KB)", "137080", "148232", "", "10", "0", "1", "2021-01-01 15:04:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("490", "315", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-570x570.jpg", "", "Reduced by 7.5% (9.1 KB)", "113722", "122990", "", "10", "0", "1", "2021-01-01 15:04:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("491", "315", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-600x597.jpg", "", "Reduced by 8.1% (11.2 KB)", "130246", "141667", "", "10", "0", "1", "2021-01-01 15:04:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("492", "315", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-800x597.jpg", "", "Reduced by 8.2% (15.7 KB)", "180081", "196201", "", "10", "0", "1", "2021-01-01 15:04:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("493", "315", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-345x198.jpg", "", "Reduced by 7.5% (2.5 KB)", "30981", "33497", "", "10", "0", "1", "2021-01-01 15:04:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("494", "315", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-400x260.jpg", "", "Reduced by 7.4% (3.5 KB)", "45323", "48926", "", "10", "0", "1", "2021-01-01 15:04:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("495", "315", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-500x380.jpg", "", "Reduced by 7.5% (6.1 KB)", "77711", "84003", "", "10", "0", "1", "2021-01-01 15:04:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("496", "315", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-500x500.jpg", "", "Reduced by 7.3% (7.1 KB)", "93096", "100417", "", "10", "0", "1", "2021-01-01 15:04:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("497", "315", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-955x500.jpg", "", "Reduced by 22.6% (38.8 KB)", "135854", "175606", "", "10", "0", "1", "2021-01-01 15:04:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("498", "315", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-500x597.jpg", "", "Reduced by 8.1% (9.8 KB)", "113887", "123874", "", "10", "0", "1", "2021-01-01 15:04:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("499", "315", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-700x438.jpg", "", "Reduced by 7.4% (9.3 KB)", "118941", "128487", "", "10", "0", "1", "2021-01-01 15:04:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("500", "315", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/b-supernatural-showreel-1-539x303.jpg", "", "Reduced by 7.5% (5.5 KB)", "69227", "74841", "", "10", "0", "1", "2021-01-01 15:04:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("501", "331", "media", "full", "ABSPATHwp-content/uploads/2016/07/slide-2-1.jpg", "", "Reduced by 4.1% (3.7 KB)", "87487", "91268", "", "10", "0", "1", "2021-01-01 15:04:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("502", "331", "media", "medium", "ABSPATHwp-content/uploads/2016/07/slide-2-1-300x125.jpg", "", "Reduced by 6.8% (680 B)", "9356", "10036", "", "10", "0", "1", "2021-01-01 15:04:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("503", "331", "media", "large", "ABSPATHwp-content/uploads/2016/07/slide-2-1-1024x427.jpg", "", "Reduced by 4.7% (2.8 KB)", "58118", "60992", "", "10", "0", "1", "2021-01-01 15:04:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("504", "331", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/07/slide-2-1-150x150.jpg", "", "Reduced by 8.1% (522 B)", "5904", "6426", "", "10", "0", "1", "2021-01-01 15:04:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("505", "331", "media", "medium_large", "ABSPATHwp-content/uploads/2016/07/slide-2-1-768x320.jpg", "", "Reduced by 5.3% (2.0 KB)", "37037", "39102", "", "10", "0", "1", "2021-01-01 15:04:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("506", "331", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/07/slide-2-1-1536x640.jpg", "", "Reduced by 4.5% (4.9 KB)", "105567", "110589", "", "10", "0", "1", "2021-01-01 15:04:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("507", "331", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/07/slide-2-1-570x570.jpg", "", "Reduced by 4.4% (2.0 KB)", "45726", "47824", "", "10", "0", "1", "2021-01-01 15:04:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("508", "331", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/07/slide-2-1-600x800.jpg", "", "Reduced by 3.8% (2.4 KB)", "62481", "64943", "", "10", "0", "1", "2021-01-01 15:04:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("509", "331", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/07/slide-2-1-800x600.jpg", "", "Reduced by 4.7% (3.0 KB)", "62500", "65577", "", "10", "0", "1", "2021-01-01 15:05:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("510", "331", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/07/slide-2-1-345x198.jpg", "", "Reduced by 6.4% (976 B)", "14283", "15259", "", "10", "0", "1", "2021-01-01 15:05:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("511", "331", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/07/slide-2-1-400x260.jpg", "", "Reduced by 5.7% (1.1 KB)", "19196", "20351", "", "10", "0", "1", "2021-01-01 15:05:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("512", "331", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/07/slide-2-1-500x380.jpg", "", "Reduced by 5.1% (1.6 KB)", "30373", "32008", "", "10", "0", "1", "2021-01-01 15:05:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("513", "331", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/07/slide-2-1-500x500.jpg", "", "Reduced by 5.1% (2.0 KB)", "37667", "39671", "", "10", "0", "1", "2021-01-01 15:05:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("514", "331", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/07/slide-2-1-1000x500.jpg", "", "Reduced by 5.1% (3.5 KB)", "66178", "69712", "", "10", "0", "1", "2021-01-01 15:05:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("515", "331", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/07/slide-2-1-500x800.jpg", "", "Reduced by 3.7% (2.0 KB)", "54012", "56090", "", "10", "0", "1", "2021-01-01 15:05:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("516", "331", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/07/slide-2-1-1000x800.jpg", "", "Reduced by 3.8% (3.7 KB)", "95302", "99044", "", "10", "0", "1", "2021-01-01 15:05:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("517", "331", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/07/slide-2-1-700x292.jpg", "", "Reduced by 5.3% (1.8 KB)", "32793", "34634", "", "10", "0", "1", "2021-01-01 15:05:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("518", "331", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/07/slide-2-1-539x303.jpg", "", "Reduced by 5.4% (1.5 KB)", "27374", "28950", "", "10", "0", "1", "2021-01-01 15:05:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("519", "394", "media", "full", "ABSPATHwp-content/uploads/2020/03/resource-1.jpg", "", "Reduced by 2.5% (1.8 KB)", "69309", "71103", "", "10", "0", "1", "2021-01-01 15:05:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("520", "394", "media", "medium", "ABSPATHwp-content/uploads/2020/03/resource-1-300x254.jpg", "", "Reduced by 7.1% (1,017 B)", "13242", "14259", "", "10", "0", "1", "2021-01-01 15:05:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("521", "394", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/resource-1-150x150.jpg", "", "Reduced by 8.3% (529 B)", "5851", "6380", "", "10", "0", "1", "2021-01-01 15:05:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("522", "394", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/resource-1-570x570.jpg", "", "Reduced by 6.7% (3.1 KB)", "44101", "47262", "", "10", "0", "1", "2021-01-01 15:05:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("523", "394", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/resource-1-600x604.jpg", "", "Reduced by 6.8% (3.8 KB)", "53038", "56920", "", "10", "0", "1", "2021-01-01 15:05:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("524", "394", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/resource-1-713x600.jpg", "", "Reduced by 7.8% (4.4 KB)", "53482", "58026", "", "10", "0", "1", "2021-01-01 15:05:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("525", "394", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/resource-1-345x198.jpg", "", "Reduced by 6.9% (1.0 KB)", "14440", "15502", "", "10", "0", "1", "2021-01-01 15:05:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("526", "394", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/resource-1-400x260.jpg", "", "Reduced by 7.0% (1.4 KB)", "19524", "21003", "", "10", "0", "1", "2021-01-01 15:05:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("527", "394", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/resource-1-500x380.jpg", "", "Reduced by 7.3% (2.2 KB)", "28608", "30862", "", "10", "0", "1", "2021-01-01 15:05:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("528", "394", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/resource-1-500x500.jpg", "", "Reduced by 7.0% (2.7 KB)", "36336", "39068", "", "10", "0", "1", "2021-01-01 15:05:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("529", "394", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/resource-1-713x500.jpg", "", "Reduced by 7.0% (3.8 KB)", "52100", "56002", "", "10", "0", "1", "2021-01-01 15:05:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("530", "394", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/resource-1-500x604.jpg", "", "Reduced by 6.4% (3.2 KB)", "48831", "52144", "", "10", "0", "1", "2021-01-01 15:05:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("531", "394", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/resource-1-700x593.jpg", "", "Reduced by 7.8% (3.9 KB)", "47574", "51618", "", "10", "0", "1", "2021-01-01 15:05:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("532", "394", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/resource-1-539x303.jpg", "", "Reduced by 6.8% (2.0 KB)", "28122", "30176", "", "10", "0", "1", "2021-01-01 15:05:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("533", "410", "media", "full", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1.jpg", "", "No savings", "30101", "30101", "", "10", "0", "1", "2021-01-01 15:05:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("534", "410", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-300x169.jpg", "", "Reduced by 25.5% (782 B)", "2284", "3066", "", "10", "0", "1", "2021-01-01 15:05:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("535", "410", "media", "large", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-1024x576.jpg", "", "Reduced by 34.3% (5.5 KB)", "10799", "16444", "", "10", "0", "1", "2021-01-01 15:05:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("536", "410", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-150x150.jpg", "", "Reduced by 30.3% (567 B)", "1305", "1872", "", "10", "0", "1", "2021-01-01 15:05:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("537", "410", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-768x432.jpg", "", "Reduced by 30.0% (3.0 KB)", "7291", "10412", "", "10", "0", "1", "2021-01-01 15:05:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("538", "410", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-1536x864.jpg", "", "Reduced by 41.5% (12.9 KB)", "18663", "31883", "", "10", "0", "1", "2021-01-01 15:05:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("539", "410", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-570x570.jpg", "", "Reduced by 33.2% (3.1 KB)", "6462", "9670", "", "10", "0", "1", "2021-01-01 15:05:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("540", "410", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-600x800.jpg", "", "Reduced by 38.8% (4.8 KB)", "7692", "12577", "", "10", "0", "1", "2021-01-01 15:05:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("541", "410", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-800x600.jpg", "", "Reduced by 35.3% (4.6 KB)", "8701", "13458", "", "10", "0", "1", "2021-01-01 15:05:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("542", "410", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-345x198.jpg", "", "Reduced by 25.6% (919 B)", "2677", "3596", "", "10", "0", "1", "2021-01-01 15:05:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("543", "410", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-400x260.jpg", "", "Reduced by 25.6% (1.2 KB)", "3477", "4674", "", "10", "0", "1", "2021-01-01 15:05:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("544", "410", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-500x380.jpg", "", "Reduced by 28.7% (1.9 KB)", "4801", "6732", "", "10", "0", "1", "2021-01-01 15:05:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("545", "410", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-500x500.jpg", "", "Reduced by 31.6% (2.5 KB)", "5573", "8143", "", "10", "0", "1", "2021-01-01 15:05:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("546", "410", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-1000x500.jpg", "", "Reduced by 34.9% (4.9 KB)", "9317", "14304", "", "10", "0", "1", "2021-01-01 15:05:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("547", "410", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-500x1000.jpg", "", "Reduced by 42.7% (5.2 KB)", "7190", "12545", "", "10", "0", "1", "2021-01-01 15:05:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("548", "410", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-1000x1000.jpg", "", "Reduced by 42.0% (9.9 KB)", "14027", "24204", "", "10", "0", "1", "2021-01-01 15:05:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("549", "410", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-700x394.jpg", "", "Reduced by 28.7% (2.6 KB)", "6593", "9245", "", "10", "0", "1", "2021-01-01 15:05:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("550", "410", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roofing-foo-bg-1-539x303.jpg", "", "Reduced by 25.9% (1.6 KB)", "4664", "6295", "", "10", "0", "1", "2021-01-01 15:05:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("551", "453", "media", "full", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1.jpg", "", "Reduced by 1.6% (3.3 KB)", "214220", "217593", "", "10", "0", "1", "2021-01-01 15:05:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("552", "453", "media", "medium", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-300x200.jpg", "", "Reduced by 10.7% (700 B)", "5817", "6517", "", "10", "0", "1", "2021-01-01 15:05:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("553", "453", "media", "large", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-1024x683.jpg", "", "Reduced by 10.0% (5.8 KB)", "53635", "59620", "", "10", "0", "1", "2021-01-01 15:05:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("554", "453", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-150x150.jpg", "", "Reduced by 13.4% (418 B)", "2712", "3130", "", "10", "0", "1", "2021-01-01 15:05:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("555", "453", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-768x512.jpg", "", "Reduced by 10.1% (3.4 KB)", "31188", "34678", "", "10", "0", "1", "2021-01-01 15:05:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("556", "453", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-1536x1024.jpg", "", "Reduced by 9.7% (12.0 KB)", "114376", "126688", "", "10", "0", "1", "2021-01-01 15:05:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("557", "453", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-570x570.jpg", "", "Reduced by 10.0% (2.9 KB)", "27118", "30132", "", "10", "0", "1", "2021-01-01 15:05:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("558", "453", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-600x800.jpg", "", "Reduced by 10.0% (4.2 KB)", "38898", "43235", "", "10", "0", "1", "2021-01-01 15:05:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("559", "453", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-800x600.jpg", "", "Reduced by 10.1% (4.2 KB)", "38256", "42543", "", "10", "0", "1", "2021-01-01 15:05:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("560", "453", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-345x198.jpg", "", "Reduced by 9.3% (701 B)", "6829", "7530", "", "10", "0", "1", "2021-01-01 15:05:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("561", "453", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-400x260.jpg", "", "Reduced by 9.3% (964 B)", "9417", "10381", "", "10", "0", "1", "2021-01-01 15:05:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("562", "453", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-500x380.jpg", "", "Reduced by 9.7% (1.7 KB)", "16391", "18150", "", "10", "0", "1", "2021-01-01 15:05:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("563", "453", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-500x500.jpg", "", "Reduced by 10.2% (2.4 KB)", "21422", "23845", "", "10", "0", "1", "2021-01-01 15:05:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("564", "453", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-1000x500.jpg", "", "Reduced by 10.2% (4.6 KB)", "41385", "46071", "", "10", "0", "1", "2021-01-01 15:05:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("565", "453", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-500x1000.jpg", "", "Reduced by 9.7% (4.2 KB)", "39720", "44001", "", "10", "0", "1", "2021-01-01 15:05:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("566", "453", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-1000x1000.jpg", "", "Reduced by 9.8% (8.2 KB)", "77017", "85403", "", "10", "0", "1", "2021-01-01 15:05:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("567", "453", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-700x467.jpg", "", "Reduced by 10.2% (2.9 KB)", "26434", "29441", "", "10", "0", "1", "2021-01-01 15:05:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("568", "453", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/mt-sample-background-1-539x303.jpg", "", "Reduced by 9.2% (1.4 KB)", "14419", "15880", "", "10", "0", "1", "2021-01-01 15:05:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("569", "514", "media", "full", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1.jpg", "", "Reduced by 0.9% (601 B)", "65043", "65644", "", "10", "0", "1", "2021-01-01 15:05:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("570", "514", "media", "medium", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-300x160.jpg", "", "Reduced by 5.7% (698 B)", "11575", "12273", "", "10", "0", "1", "2021-01-01 15:05:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("571", "514", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-150x150.jpg", "", "Reduced by 6.9% (441 B)", "5988", "6429", "", "10", "0", "1", "2021-01-01 15:05:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("572", "514", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-570x350.jpg", "", "Reduced by 4.3% (1.9 KB)", "42863", "44781", "", "10", "0", "1", "2021-01-01 15:05:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("573", "514", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-600x350.jpg", "", "Reduced by 4.2% (1.9 KB)", "44501", "46464", "", "10", "0", "1", "2021-01-01 15:05:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("574", "514", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-345x198.jpg", "", "Reduced by 5.4% (903 B)", "15840", "16743", "", "10", "0", "1", "2021-01-01 15:05:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("575", "514", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-400x260.jpg", "", "Reduced by 4.8% (1.1 KB)", "22277", "23411", "", "10", "0", "1", "2021-01-01 15:05:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("576", "514", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-500x350.jpg", "", "Reduced by 4.4% (1.7 KB)", "37747", "39470", "", "10", "0", "1", "2021-01-01 15:05:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("577", "514", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/northern-colorado-img-1-539x303.jpg", "", "Reduced by 4.5% (1.5 KB)", "33073", "34614", "", "10", "0", "1", "2021-01-01 15:05:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("578", "516", "media", "full", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1.jpg", "", "Reduced by 0.7% (581 B)", "78713", "79294", "", "10", "0", "1", "2021-01-01 15:06:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("579", "516", "media", "medium", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-300x160.jpg", "", "Reduced by 6.3% (950 B)", "14168", "15118", "", "10", "0", "1", "2021-01-01 15:06:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("580", "516", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-150x150.jpg", "", "Reduced by 6.5% (493 B)", "7094", "7587", "", "10", "0", "1", "2021-01-01 15:06:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("581", "516", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-570x350.jpg", "", "Reduced by 5.2% (2.8 KB)", "51109", "53925", "", "10", "0", "1", "2021-01-01 15:06:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("582", "516", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-600x350.jpg", "", "Reduced by 5.3% (2.9 KB)", "53273", "56250", "", "10", "0", "1", "2021-01-01 15:06:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("583", "516", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-345x198.jpg", "", "Reduced by 6.0% (1.2 KB)", "19080", "20289", "", "10", "0", "1", "2021-01-01 15:06:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("584", "516", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-400x260.jpg", "", "Reduced by 5.5% (1.5 KB)", "26439", "27978", "", "10", "0", "1", "2021-01-01 15:06:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("585", "516", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-500x350.jpg", "", "Reduced by 5.3% (2.4 KB)", "44894", "47395", "", "10", "0", "1", "2021-01-01 15:06:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("586", "516", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/Denver-Metro-1-539x303.jpg", "", "Reduced by 5.1% (2.1 KB)", "39233", "41358", "", "10", "0", "1", "2021-01-01 15:06:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("587", "623", "media", "full", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1.jpg", "", "Reduced by 1.4% (830 B)", "57074", "57904", "", "10", "0", "1", "2021-01-01 15:06:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("588", "623", "media", "medium", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-200x300.jpg", "", "Reduced by 12.1% (693 B)", "5046", "5739", "", "10", "0", "1", "2021-01-01 15:06:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("589", "623", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-150x150.jpg", "", "Reduced by 17.1% (500 B)", "2427", "2927", "", "10", "0", "1", "2021-01-01 15:06:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("590", "623", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-400x570.jpg", "", "Reduced by 8.8% (1.4 KB)", "15017", "16466", "", "10", "0", "1", "2021-01-01 15:06:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("591", "623", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-345x198.jpg", "", "Reduced by 9.8% (718 B)", "6576", "7294", "", "10", "0", "1", "2021-01-01 15:06:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("592", "623", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-400x260.jpg", "", "Reduced by 9.3% (975 B)", "9457", "10432", "", "10", "0", "1", "2021-01-01 15:06:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("593", "623", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-400x380.jpg", "", "Reduced by 8.1% (1.0 KB)", "11977", "13033", "", "10", "0", "1", "2021-01-01 15:06:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("594", "623", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-400x500.jpg", "", "Reduced by 9.4% (1.4 KB)", "13813", "15248", "", "10", "0", "1", "2021-01-01 15:06:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("595", "623", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/sidebar-request-bg-1-400x303.jpg", "", "Reduced by 8.5% (963 B)", "10387", "11350", "", "10", "0", "1", "2021-01-01 15:06:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("596", "683", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-0-1.jpg", "", "Reduced by 1.4% (835 B)", "60993", "61828", "", "10", "0", "1", "2021-01-01 15:06:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("597", "683", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-0-1-300x190.jpg", "", "Reduced by 5.3% (809 B)", "14495", "15304", "", "10", "0", "1", "2021-01-01 15:06:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("598", "683", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-0-1-150x150.jpg", "", "Reduced by 6.7% (479 B)", "6679", "7158", "", "10", "0", "1", "2021-01-01 15:06:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("599", "683", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-0-1-570x380.jpg", "", "Reduced by 4.2% (1.9 KB)", "44537", "46506", "", "10", "0", "1", "2021-01-01 15:06:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("600", "683", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-0-1-345x198.jpg", "", "Reduced by 5.1% (870 B)", "16343", "17213", "", "10", "0", "1", "2021-01-01 15:06:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("601", "683", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-0-1-400x260.jpg", "", "Reduced by 4.4% (1.0 KB)", "22542", "23575", "", "10", "0", "1", "2021-01-01 15:06:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("602", "683", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-0-1-500x380.jpg", "", "Reduced by 4.3% (1.8 KB)", "40422", "42247", "", "10", "0", "1", "2021-01-01 15:06:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("603", "683", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-0-1-539x303.jpg", "", "Reduced by 4.2% (1.4 KB)", "32439", "33869", "", "10", "0", "1", "2021-01-01 15:06:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("604", "684", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-1-1.jpg", "", "Reduced by 1.3% (1,021 B)", "80253", "81274", "", "10", "0", "1", "2021-01-01 15:06:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("605", "684", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-1-1-300x190.jpg", "", "Reduced by 5.9% (1.1 KB)", "17882", "19013", "", "10", "0", "1", "2021-01-01 15:06:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("606", "684", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-1-1-150x150.jpg", "", "Reduced by 7.5% (591 B)", "7315", "7906", "", "10", "0", "1", "2021-01-01 15:06:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("607", "684", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-1-1-570x380.jpg", "", "Reduced by 4.8% (3.0 KB)", "60583", "63655", "", "10", "0", "1", "2021-01-01 15:06:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("608", "684", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-1-1-345x198.jpg", "", "Reduced by 6.0% (1.2 KB)", "19931", "21198", "", "10", "0", "1", "2021-01-01 15:06:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("609", "684", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-1-1-400x260.jpg", "", "Reduced by 5.4% (1.6 KB)", "28445", "30072", "", "10", "0", "1", "2021-01-01 15:06:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("610", "684", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-1-1-500x380.jpg", "", "Reduced by 5.0% (2.7 KB)", "53353", "56153", "", "10", "0", "1", "2021-01-01 15:06:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("611", "684", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-1-1-539x303.jpg", "", "Reduced by 4.9% (2.1 KB)", "42531", "44722", "", "10", "0", "1", "2021-01-01 15:06:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("612", "686", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-3-1.jpg", "", "Reduced by 1.7% (1.0 KB)", "60920", "61945", "", "10", "0", "1", "2021-01-01 15:06:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("613", "686", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-3-1-300x190.jpg", "", "Reduced by 5.2% (791 B)", "14379", "15170", "", "10", "0", "1", "2021-01-01 15:06:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("614", "686", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-3-1-150x150.jpg", "", "Reduced by 6.9% (439 B)", "5953", "6392", "", "10", "0", "1", "2021-01-01 15:06:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("615", "686", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-3-1-570x380.jpg", "", "Reduced by 4.1% (2.0 KB)", "46855", "48879", "", "10", "0", "1", "2021-01-01 15:06:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("616", "686", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-3-1-345x198.jpg", "", "Reduced by 5.5% (933 B)", "16178", "17111", "", "10", "0", "1", "2021-01-01 15:06:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("617", "686", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-3-1-400x260.jpg", "", "Reduced by 4.5% (1.1 KB)", "22793", "23877", "", "10", "0", "1", "2021-01-01 15:06:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("618", "686", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-3-1-500x380.jpg", "", "Reduced by 4.2% (1.8 KB)", "41161", "42970", "", "10", "0", "1", "2021-01-01 15:06:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("619", "686", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-3-1-539x303.jpg", "", "Reduced by 4.0% (1.4 KB)", "33363", "34759", "", "10", "0", "1", "2021-01-01 15:06:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("620", "690", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-7-1.jpg", "", "Reduced by 1.3% (695 B)", "53434", "54129", "", "10", "0", "1", "2021-01-01 15:06:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("621", "690", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-7-1-300x190.jpg", "", "Reduced by 6.1% (875 B)", "13530", "14405", "", "10", "0", "1", "2021-01-01 15:06:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("622", "690", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-7-1-150x150.jpg", "", "Reduced by 7.8% (464 B)", "5501", "5965", "", "10", "0", "1", "2021-01-01 15:06:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("623", "690", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-7-1-570x380.jpg", "", "Reduced by 4.5% (1.8 KB)", "40131", "42012", "", "10", "0", "1", "2021-01-01 15:06:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("624", "690", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-7-1-345x198.jpg", "", "Reduced by 6.1% (969 B)", "14921", "15890", "", "10", "0", "1", "2021-01-01 15:06:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("625", "690", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-7-1-400x260.jpg", "", "Reduced by 4.9% (1.0 KB)", "20722", "21784", "", "10", "0", "1", "2021-01-01 15:06:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("626", "690", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-7-1-500x380.jpg", "", "Reduced by 4.5% (1.6 KB)", "34895", "36553", "", "10", "0", "1", "2021-01-01 15:06:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("627", "690", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-7-1-539x303.jpg", "", "Reduced by 4.2% (1.3 KB)", "28929", "30209", "", "10", "0", "1", "2021-01-01 15:06:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("628", "722", "media", "full", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1.jpg", "", "No savings", "120464", "120464", "", "10", "0", "1", "2021-01-01 15:06:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("629", "722", "media", "medium", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-300x172.jpg", "", "Reduced by 9.0% (607 B)", "6128", "6735", "", "10", "0", "1", "2021-01-01 15:06:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("630", "722", "media", "large", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-1024x587.jpg", "", "Reduced by 9.5% (5.3 KB)", "51418", "56795", "", "10", "0", "1", "2021-01-01 15:06:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("631", "722", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-150x150.jpg", "", "Reduced by 12.8% (400 B)", "2719", "3119", "", "10", "0", "1", "2021-01-01 15:06:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("632", "722", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-768x440.jpg", "", "Reduced by 9.2% (3.0 KB)", "30971", "34094", "", "10", "0", "1", "2021-01-01 15:06:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("633", "722", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-1536x880.jpg", "", "Reduced by 9.6% (10.5 KB)", "100512", "111219", "", "10", "0", "1", "2021-01-01 15:06:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("634", "722", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-570x570.jpg", "", "Reduced by 9.8% (2.6 KB)", "24359", "27001", "", "10", "0", "1", "2021-01-01 15:06:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("635", "722", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-600x800.jpg", "", "Reduced by 12.4% (3.6 KB)", "26049", "29743", "", "10", "0", "1", "2021-01-01 15:06:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("636", "722", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-800x600.jpg", "", "Reduced by 9.8% (4.0 KB)", "37466", "41521", "", "10", "0", "1", "2021-01-01 15:06:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("637", "722", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-345x198.jpg", "", "Reduced by 8.7% (741 B)", "7793", "8534", "", "10", "0", "1", "2021-01-01 15:06:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("638", "722", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-400x260.jpg", "", "Reduced by 9.0% (1.0 KB)", "10526", "11573", "", "10", "0", "1", "2021-01-01 15:06:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("639", "722", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-500x380.jpg", "", "Reduced by 9.0% (1.6 KB)", "16717", "18366", "", "10", "0", "1", "2021-01-01 15:06:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("640", "722", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-500x500.jpg", "", "Reduced by 10.2% (2.1 KB)", "19266", "21446", "", "10", "0", "1", "2021-01-01 15:06:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("641", "722", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-1000x500.jpg", "", "Reduced by 9.6% (4.4 KB)", "42071", "46542", "", "10", "0", "1", "2021-01-01 15:06:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("642", "722", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-500x1000.jpg", "", "Reduced by 18.9% (4.0 KB)", "17530", "21616", "", "10", "0", "1", "2021-01-01 15:06:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("643", "722", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-1000x1000.jpg", "", "Reduced by 11.2% (7.4 KB)", "60533", "68159", "", "10", "0", "1", "2021-01-01 15:06:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("644", "722", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-700x401.jpg", "", "Reduced by 9.2% (2.6 KB)", "26488", "29179", "", "10", "0", "1", "2021-01-01 15:06:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("645", "722", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/services-section-bg-1-539x303.jpg", "", "Reduced by 8.7% (1.5 KB)", "16095", "17627", "", "10", "0", "1", "2021-01-01 15:06:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("646", "811", "media", "full", "ABSPATHwp-content/uploads/2020/03/roof-bg-1.jpg", "", "Reduced by 5.2% (6.1 KB)", "113381", "119622", "", "10", "0", "1", "2021-01-01 15:06:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("647", "811", "media", "medium", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-300x120.jpg", "", "Reduced by 8.4% (466 B)", "5073", "5539", "", "10", "0", "1", "2021-01-01 15:06:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("648", "811", "media", "large", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-1024x409.jpg", "", "Reduced by 6.8% (2.6 KB)", "36137", "38767", "", "10", "0", "1", "2021-01-01 15:06:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("649", "811", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-150x150.jpg", "", "Reduced by 12.6% (418 B)", "2898", "3316", "", "10", "0", "1", "2021-01-01 15:06:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("650", "811", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-768x306.jpg", "", "Reduced by 6.3% (1.5 KB)", "23087", "24644", "", "10", "0", "1", "2021-01-01 15:06:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("651", "811", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-1536x613.jpg", "", "Reduced by 7.7% (5.6 KB)", "68527", "74247", "", "10", "0", "1", "2021-01-01 15:06:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("652", "811", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-570x570.jpg", "", "Reduced by 10.1% (2.3 KB)", "21093", "23462", "", "10", "0", "1", "2021-01-01 15:06:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("653", "811", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-600x766.jpg", "", "Reduced by 13.2% (3.8 KB)", "25780", "29697", "", "10", "0", "1", "2021-01-01 15:06:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("654", "811", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-800x600.jpg", "", "Reduced by 8.8% (3.0 KB)", "32328", "35429", "", "10", "0", "1", "2021-01-01 15:06:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("655", "811", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-345x198.jpg", "", "Reduced by 7.6% (677 B)", "8285", "8962", "", "10", "0", "1", "2021-01-01 15:06:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("656", "811", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-400x260.jpg", "", "Reduced by 6.8% (810 B)", "11026", "11836", "", "10", "0", "1", "2021-01-01 15:06:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("657", "811", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-500x380.jpg", "", "Reduced by 8.1% (1.4 KB)", "16488", "17939", "", "10", "0", "1", "2021-01-01 15:06:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("658", "811", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-500x500.jpg", "", "Reduced by 10.3% (2.0 KB)", "17456", "19460", "", "10", "0", "1", "2021-01-01 15:06:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("659", "811", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-1000x500.jpg", "", "Reduced by 7.0% (2.9 KB)", "39475", "42435", "", "10", "0", "1", "2021-01-01 15:06:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("660", "811", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-500x766.jpg", "", "Reduced by 12.6% (3.1 KB)", "21665", "24796", "", "10", "0", "1", "2021-01-01 15:06:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("661", "811", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-1000x766.jpg", "", "Reduced by 10.3% (5.3 KB)", "47246", "52651", "", "10", "0", "1", "2021-01-01 15:06:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("662", "811", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-700x279.jpg", "", "Reduced by 6.4% (1.3 KB)", "19638", "20980", "", "10", "0", "1", "2021-01-01 15:06:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("663", "811", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/roof-bg-1-539x303.jpg", "", "Reduced by 6.3% (1.1 KB)", "16195", "17277", "", "10", "0", "1", "2021-01-01 15:06:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("664", "1004", "media", "full", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1.jpg", "", "Reduced by 4.0% (3.8 KB)", "94782", "98694", "", "10", "0", "1", "2021-01-01 15:07:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("665", "1004", "media", "medium", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-300x140.jpg", "", "Reduced by 8.3% (443 B)", "4924", "5367", "", "10", "0", "1", "2021-01-01 15:07:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("666", "1004", "media", "large", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-1024x478.jpg", "", "Reduced by 7.2% (2.4 KB)", "31314", "33760", "", "10", "0", "1", "2021-01-01 15:07:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("667", "1004", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-150x150.jpg", "", "Reduced by 11.9% (393 B)", "2900", "3293", "", "10", "0", "1", "2021-01-01 15:07:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("668", "1004", "media", "medium_large", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-768x359.jpg", "", "Reduced by 7.1% (1.5 KB)", "20587", "22163", "", "10", "0", "1", "2021-01-01 15:07:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("669", "1004", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-1536x718.jpg", "", "Reduced by 8.9% (5.5 KB)", "57389", "63003", "", "10", "0", "1", "2021-01-01 15:07:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("670", "1004", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-570x570.jpg", "", "Reduced by 7.6% (1.7 KB)", "21257", "23007", "", "10", "0", "1", "2021-01-01 15:07:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("671", "1004", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-600x800.jpg", "", "Reduced by 8.8% (2.5 KB)", "26881", "29482", "", "10", "0", "1", "2021-01-01 15:07:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("672", "1004", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-800x600.jpg", "", "Reduced by 7.8% (2.5 KB)", "29687", "32207", "", "10", "0", "1", "2021-01-01 15:07:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("673", "1004", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-345x198.jpg", "", "Reduced by 6.5% (513 B)", "7339", "7852", "", "10", "0", "1", "2021-01-01 15:07:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("674", "1004", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-400x260.jpg", "", "Reduced by 6.1% (640 B)", "9782", "10422", "", "10", "0", "1", "2021-01-01 15:07:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("675", "1004", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-500x380.jpg", "", "Reduced by 7.1% (1.1 KB)", "14931", "16074", "", "10", "0", "1", "2021-01-01 15:07:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("676", "1004", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-500x500.jpg", "", "Reduced by 7.8% (1.5 KB)", "17580", "19067", "", "10", "0", "1", "2021-01-01 15:07:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("677", "1004", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-1000x500.jpg", "", "Reduced by 7.8% (2.6 KB)", "31823", "34498", "", "10", "0", "1", "2021-01-01 15:07:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("678", "1004", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-500x897.jpg", "", "Reduced by 9.0% (2.4 KB)", "24634", "27066", "", "10", "0", "1", "2021-01-01 15:07:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("679", "1004", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-1000x897.jpg", "", "Reduced by 9.8% (5.0 KB)", "47372", "52508", "", "10", "0", "1", "2021-01-01 15:07:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("680", "1004", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-700x327.jpg", "", "Reduced by 7.1% (1.3 KB)", "17633", "18971", "", "10", "0", "1", "2021-01-01 15:07:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("681", "1004", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/03/sliding-1-bg-1-539x303.jpg", "", "Reduced by 5.7% (850 B)", "13949", "14799", "", "10", "0", "1", "2021-01-01 15:07:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("682", "1051", "media", "full", "ABSPATHwp-content/uploads/2020/06/stylingpartners-1.jpg", "", "Reduced by 1.7% (406 B)", "23112", "23518", "", "10", "0", "1", "2021-01-01 15:07:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("683", "1051", "media", "medium", "ABSPATHwp-content/uploads/2020/06/stylingpartners-1-300x39.jpg", "", "Reduced by 11.2% (486 B)", "3837", "4323", "", "10", "0", "1", "2021-01-01 15:07:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("684", "1051", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/06/stylingpartners-1-150x65.jpg", "", "Reduced by 14.8% (421 B)", "2417", "2838", "", "10", "0", "1", "2021-01-01 15:07:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("685", "1051", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/06/stylingpartners-1-345x65.jpg", "", "Reduced by 13.0% (754 B)", "5024", "5778", "", "10", "0", "1", "2021-01-01 15:07:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("686", "1051", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/06/stylingpartners-1-400x65.jpg", "", "Reduced by 11.8% (812 B)", "6082", "6894", "", "10", "0", "1", "2021-01-01 15:07:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("687", "1056", "media", "full", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1.jpg", "", "Reduced by 0.6% (3.9 KB)", "675654", "679655", "", "10", "0", "1", "2021-01-01 15:07:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("688", "1056", "media", "medium", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-300x172.jpg", "", "Reduced by 5.6% (511 B)", "8671", "9182", "", "10", "0", "1", "2021-01-01 15:07:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("689", "1056", "media", "large", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-1024x587.jpg", "", "Reduced by 5.5% (3.3 KB)", "57148", "60488", "", "10", "0", "1", "2021-01-01 15:07:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("690", "1056", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-150x150.jpg", "", "Reduced by 7.6% (378 B)", "4611", "4989", "", "10", "0", "1", "2021-01-01 15:07:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("691", "1056", "media", "medium_large", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-768x440.jpg", "", "Reduced by 5.2% (2.0 KB)", "36673", "38676", "", "10", "0", "1", "2021-01-01 15:07:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("692", "1056", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-1536x880.jpg", "", "Reduced by 6.1% (6.7 KB)", "104659", "111504", "", "10", "0", "1", "2021-01-01 15:07:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("693", "1056", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-570x570.jpg", "", "Reduced by 4.1% (1.4 KB)", "33468", "34904", "", "10", "0", "1", "2021-01-01 15:07:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("694", "1056", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-600x800.jpg", "", "Reduced by 4.0% (1.7 KB)", "43396", "45183", "", "10", "0", "1", "2021-01-01 15:07:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("695", "1056", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-800x600.jpg", "", "Reduced by 4.9% (2.3 KB)", "46527", "48920", "", "10", "0", "1", "2021-01-01 15:07:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("696", "1056", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-345x198.jpg", "", "Reduced by 5.6% (631 B)", "10680", "11311", "", "10", "0", "1", "2021-01-01 15:07:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("697", "1056", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-400x260.jpg", "", "Reduced by 5.1% (789 B)", "14823", "15612", "", "10", "0", "1", "2021-01-01 15:07:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("698", "1056", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-500x380.jpg", "", "Reduced by 4.7% (1.1 KB)", "23264", "24414", "", "10", "0", "1", "2021-01-01 15:07:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("699", "1056", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-500x500.jpg", "", "Reduced by 4.2% (1.2 KB)", "27710", "28932", "", "10", "0", "1", "2021-01-01 15:07:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("700", "1056", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-1000x500.jpg", "", "Reduced by 5.7% (2.9 KB)", "49371", "52351", "", "10", "0", "1", "2021-01-01 15:07:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("701", "1056", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-500x1000.jpg", "", "Reduced by 4.5% (1.8 KB)", "40458", "42349", "", "10", "0", "1", "2021-01-01 15:07:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("702", "1056", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-1000x1000.jpg", "", "Reduced by 5.2% (4.1 KB)", "75958", "80117", "", "10", "0", "1", "2021-01-01 15:07:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("703", "1056", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-700x401.jpg", "", "Reduced by 5.4% (1.8 KB)", "32159", "34003", "", "10", "0", "1", "2021-01-01 15:07:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("704", "1056", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/06/atlasroofing-1-539x303.jpg", "", "Reduced by 5.0% (1.1 KB)", "20868", "21956", "", "10", "0", "1", "2021-01-01 15:07:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("705", "1058", "media", "full", "ABSPATHwp-content/uploads/2020/06/headerpicture-1.jpg", "", "Reduced by 2.1% (3.5 KB)", "170807", "174428", "", "10", "0", "1", "2021-01-01 15:07:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("706", "1058", "media", "medium", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-300x131.jpg", "", "Reduced by 5.2% (517 B)", "9416", "9933", "", "10", "0", "1", "2021-01-01 15:07:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("707", "1058", "media", "large", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-1024x447.jpg", "", "Reduced by 3.2% (1.6 KB)", "50714", "52400", "", "10", "0", "1", "2021-01-01 15:07:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("708", "1058", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-150x150.jpg", "", "Reduced by 6.5% (399 B)", "5707", "6106", "", "10", "0", "1", "2021-01-01 15:07:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("709", "1058", "media", "medium_large", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-768x335.jpg", "", "Reduced by 3.3% (1.2 KB)", "34052", "35230", "", "10", "0", "1", "2021-01-01 15:07:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("710", "1058", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-570x570.jpg", "", "Reduced by 3.0% (1.1 KB)", "35962", "37070", "", "10", "0", "1", "2021-01-01 15:07:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("711", "1058", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-600x662.jpg", "", "Reduced by 3.8% (1.6 KB)", "41664", "43288", "", "10", "0", "1", "2021-01-01 15:07:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("712", "1058", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-800x600.jpg", "", "Reduced by 3.5% (1.7 KB)", "47484", "49190", "", "10", "0", "1", "2021-01-01 15:07:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("713", "1058", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-345x198.jpg", "", "Reduced by 4.4% (614 B)", "13223", "13837", "", "10", "0", "1", "2021-01-01 15:07:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("714", "1058", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-400x260.jpg", "", "Reduced by 4.2% (746 B)", "17100", "17846", "", "10", "0", "1", "2021-01-01 15:07:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("715", "1058", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-500x380.jpg", "", "Reduced by 3.4% (891 B)", "25367", "26258", "", "10", "0", "1", "2021-01-01 15:07:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("716", "1058", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-500x500.jpg", "", "Reduced by 3.4% (1.0 KB)", "30063", "31111", "", "10", "0", "1", "2021-01-01 15:07:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("717", "1058", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-1000x500.jpg", "", "Reduced by 3.5% (1.9 KB)", "53398", "55318", "", "10", "0", "1", "2021-01-01 15:07:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("718", "1058", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-500x662.jpg", "", "Reduced by 3.5% (1.2 KB)", "34005", "35231", "", "10", "0", "1", "2021-01-01 15:07:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("719", "1058", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-1000x662.jpg", "", "Reduced by 4.0% (2.6 KB)", "62631", "65243", "", "10", "0", "1", "2021-01-01 15:07:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("720", "1058", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-700x306.jpg", "", "Reduced by 3.5% (1.1 KB)", "30486", "31589", "", "10", "0", "1", "2021-01-01 15:07:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("721", "1058", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/06/headerpicture-1-539x303.jpg", "", "Reduced by 3.5% (862 B)", "24068", "24930", "", "10", "0", "1", "2021-01-01 15:07:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("722", "1091", "media", "full", "ABSPATHwp-content/uploads/2020/10/fff-1-1.jpg", "", "Reduced by 4.2% (1.3 KB)", "30275", "31615", "", "10", "0", "1", "2021-01-01 15:07:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("723", "1091", "media", "medium", "ABSPATHwp-content/uploads/2020/10/fff-1-1-300x300.jpg", "", "Reduced by 24.7% (1.5 KB)", "4658", "6186", "", "10", "0", "1", "2021-01-01 15:07:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("724", "1091", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/fff-1-1-150x150.jpg", "", "Reduced by 22.9% (552 B)", "1860", "2412", "", "10", "0", "1", "2021-01-01 15:07:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("725", "1091", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/fff-1-1-345x198.jpg", "", "Reduced by 19.4% (1.3 KB)", "5483", "6800", "", "10", "0", "1", "2021-01-01 15:07:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("726", "1091", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/fff-1-1-400x260.jpg", "", "Reduced by 20.2% (1.8 KB)", "7401", "9278", "", "10", "0", "1", "2021-01-01 15:07:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("727", "1091", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/fff-1-1-400x380.jpg", "", "Reduced by 24.9% (2.5 KB)", "7616", "10138", "", "10", "0", "1", "2021-01-01 15:07:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("728", "1091", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/fff-1-1-400x303.jpg", "", "Reduced by 21.8% (2.0 KB)", "7431", "9501", "", "10", "0", "1", "2021-01-01 15:07:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("729", "1092", "media", "full", "ABSPATHwp-content/uploads/2020/10/gaf-1-1.jpg", "", "Reduced by 1.7% (547 B)", "31778", "32325", "", "10", "0", "1", "2021-01-01 15:08:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("730", "1092", "media", "medium", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-300x300.jpg", "", "Reduced by 16.9% (1.2 KB)", "5939", "7150", "", "10", "0", "1", "2021-01-01 15:08:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("731", "1092", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-150x150.jpg", "", "Reduced by 15.4% (552 B)", "3044", "3596", "", "10", "0", "1", "2021-01-01 15:08:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("732", "1092", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-345x198.jpg", "", "Reduced by 12.0% (897 B)", "6554", "7451", "", "10", "0", "1", "2021-01-01 15:08:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("733", "1092", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-400x260.jpg", "", "Reduced by 14.0% (1.3 KB)", "8075", "9390", "", "10", "0", "1", "2021-01-01 15:08:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("734", "1092", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-400x380.jpg", "", "Reduced by 18.5% (1.8 KB)", "8261", "10133", "", "10", "0", "1", "2021-01-01 15:08:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("735", "1092", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/gaf-1-1-400x303.jpg", "", "Reduced by 15.4% (1.4 KB)", "8054", "9525", "", "10", "0", "1", "2021-01-01 15:08:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("736", "1093", "media", "full", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1.jpg", "", "Reduced by 40.4% (13.7 KB)", "20705", "34730", "", "10", "0", "1", "2021-01-01 15:08:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("737", "1093", "media", "medium", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-300x300.jpg", "", "Reduced by 22.9% (1.6 KB)", "5644", "7317", "", "10", "0", "1", "2021-01-01 15:08:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("738", "1093", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-150x150.jpg", "", "Reduced by 19.6% (618 B)", "2537", "3155", "", "10", "0", "1", "2021-01-01 15:08:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("739", "1093", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-345x198.jpg", "", "Reduced by 18.9% (1.4 KB)", "6218", "7666", "", "10", "0", "1", "2021-01-01 15:08:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("740", "1093", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-400x260.jpg", "", "Reduced by 19.9% (2.0 KB)", "8038", "10035", "", "10", "0", "1", "2021-01-01 15:08:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("741", "1093", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-400x380.jpg", "", "Reduced by 23.8% (2.5 KB)", "8336", "10935", "", "10", "0", "1", "2021-01-01 15:08:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("742", "1093", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/malarkey-1-1-400x303.jpg", "", "Reduced by 21.4% (2.1 KB)", "7731", "9840", "", "10", "0", "1", "2021-01-01 15:08:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("743", "1094", "media", "full", "ABSPATHwp-content/uploads/2020/10/owenscorning-1.jpg", "", "Reduced by 1.8% (1.1 KB)", "58414", "59506", "", "10", "0", "1", "2021-01-01 15:08:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("744", "1094", "media", "medium", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-300x300.jpg", "", "Reduced by 12.1% (1.6 KB)", "12282", "13967", "", "10", "0", "1", "2021-01-01 15:08:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("745", "1094", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-150x150.jpg", "", "Reduced by 10.9% (668 B)", "5475", "6143", "", "10", "0", "1", "2021-01-01 15:08:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("746", "1094", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-345x198.jpg", "", "Reduced by 11.3% (1.2 KB)", "9914", "11172", "", "10", "0", "1", "2021-01-01 15:08:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("747", "1094", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-400x260.jpg", "", "Reduced by 12.5% (1.9 KB)", "13359", "15264", "", "10", "0", "1", "2021-01-01 15:08:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("748", "1094", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-400x380.jpg", "", "Reduced by 13.2% (2.5 KB)", "16508", "19020", "", "10", "0", "1", "2021-01-01 15:08:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("749", "1094", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/owenscorning-1-400x303.jpg", "", "Reduced by 12.1% (2.1 KB)", "15428", "17550", "", "10", "0", "1", "2021-01-01 15:08:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("750", "1096", "media", "full", "ABSPATHwp-content/uploads/2020/10/5-1.jpg", "", "Reduced by 3.3% (877 B)", "25809", "26686", "", "10", "0", "1", "2021-01-01 15:08:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("751", "1096", "media", "medium", "ABSPATHwp-content/uploads/2020/10/5-1-300x300.jpg", "", "Reduced by 16.0% (1.3 KB)", "6970", "8298", "", "10", "0", "1", "2021-01-01 15:08:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("752", "1096", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/5-1-150x150.jpg", "", "Reduced by 13.7% (530 B)", "3344", "3874", "", "10", "0", "1", "2021-01-01 15:08:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("753", "1096", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/5-1-345x198.jpg", "", "Reduced by 14.1% (1.2 KB)", "7418", "8635", "", "10", "0", "1", "2021-01-01 15:08:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("754", "1096", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/5-1-400x260.jpg", "", "Reduced by 15.6% (1.7 KB)", "9218", "10919", "", "10", "0", "1", "2021-01-01 15:08:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("755", "1096", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/5-1-400x380.jpg", "", "Reduced by 19.7% (2.2 KB)", "9139", "11380", "", "10", "0", "1", "2021-01-01 15:08:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("756", "1096", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/5-1-400x303.jpg", "", "Reduced by 16.0% (1.7 KB)", "9259", "11028", "", "10", "0", "1", "2021-01-01 15:08:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("757", "1097", "media", "full", "ABSPATHwp-content/uploads/2020/10/6-1.jpg", "", "Reduced by 1.7% (710 B)", "40761", "41471", "", "10", "0", "1", "2021-01-01 15:08:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("758", "1097", "media", "medium", "ABSPATHwp-content/uploads/2020/10/6-1-300x300.jpg", "", "Reduced by 10.1% (1.0 KB)", "9296", "10346", "", "10", "0", "1", "2021-01-01 15:08:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("759", "1097", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/6-1-150x150.jpg", "", "Reduced by 11.0% (508 B)", "4102", "4610", "", "10", "0", "1", "2021-01-01 15:08:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("760", "1097", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/6-1-345x198.jpg", "", "Reduced by 10.7% (881 B)", "7379", "8260", "", "10", "0", "1", "2021-01-01 15:08:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("761", "1097", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/6-1-400x260.jpg", "", "Reduced by 10.3% (1.2 KB)", "10766", "11998", "", "10", "0", "1", "2021-01-01 15:08:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("762", "1097", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/6-1-400x380.jpg", "", "Reduced by 10.9% (1.6 KB)", "13056", "14652", "", "10", "0", "1", "2021-01-01 15:08:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("763", "1097", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/6-1-400x303.jpg", "", "Reduced by 10.8% (1.4 KB)", "11501", "12888", "", "10", "0", "1", "2021-01-01 15:08:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("764", "1098", "media", "full", "ABSPATHwp-content/uploads/2020/10/7-1.jpg", "", "Reduced by 36.0% (15.7 KB)", "28532", "44590", "", "10", "0", "1", "2021-01-01 15:08:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("765", "1098", "media", "medium", "ABSPATHwp-content/uploads/2020/10/7-1-300x300.jpg", "", "Reduced by 17.7% (1.5 KB)", "6932", "8424", "", "10", "0", "1", "2021-01-01 15:08:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("766", "1098", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/7-1-150x150.jpg", "", "Reduced by 16.2% (580 B)", "2998", "3578", "", "10", "0", "1", "2021-01-01 15:08:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("767", "1098", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/7-1-345x198.jpg", "", "Reduced by 14.0% (1.2 KB)", "7541", "8765", "", "10", "0", "1", "2021-01-01 15:08:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("768", "1098", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/7-1-400x260.jpg", "", "Reduced by 15.1% (1.6 KB)", "9414", "11082", "", "10", "0", "1", "2021-01-01 15:08:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("769", "1098", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/7-1-400x380.jpg", "", "Reduced by 19.1% (2.2 KB)", "9309", "11513", "", "10", "0", "1", "2021-01-01 15:08:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("770", "1098", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/7-1-400x303.jpg", "", "Reduced by 16.3% (1.8 KB)", "9291", "11099", "", "10", "0", "1", "2021-01-01 15:08:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("771", "1099", "media", "full", "ABSPATHwp-content/uploads/2020/10/8-1.jpg", "", "Reduced by 2.3% (1.9 KB)", "84796", "86754", "", "10", "0", "1", "2021-01-01 15:08:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("772", "1099", "media", "medium", "ABSPATHwp-content/uploads/2020/10/8-1-300x300.jpg", "", "Reduced by 10.2% (1.5 KB)", "13716", "15279", "", "10", "0", "1", "2021-01-01 15:08:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("773", "1099", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/8-1-150x150.jpg", "", "Reduced by 10.9% (603 B)", "4932", "5535", "", "10", "0", "1", "2021-01-01 15:08:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("774", "1099", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/8-1-345x198.jpg", "", "Reduced by 7.4% (1.3 KB)", "16189", "17474", "", "10", "0", "1", "2021-01-01 15:08:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("775", "1099", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/8-1-400x260.jpg", "", "Reduced by 8.0% (1.8 KB)", "21493", "23354", "", "10", "0", "1", "2021-01-01 15:08:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("776", "1099", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/8-1-400x380.jpg", "", "Reduced by 10.0% (2.3 KB)", "21526", "23914", "", "10", "0", "1", "2021-01-01 15:08:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("777", "1099", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/8-1-400x303.jpg", "", "Reduced by 8.4% (1.9 KB)", "21498", "23475", "", "10", "0", "1", "2021-01-01 15:08:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("778", "1101", "media", "full", "ABSPATHwp-content/uploads/2020/10/yy-1.jpg", "", "Reduced by 4.2% (838 B)", "19158", "19996", "", "10", "0", "1", "2021-01-01 15:08:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("779", "1101", "media", "medium", "ABSPATHwp-content/uploads/2020/10/yy-1-300x300.jpg", "", "Reduced by 21.6% (1.3 KB)", "4940", "6305", "", "10", "0", "1", "2021-01-01 15:08:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("780", "1101", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/yy-1-150x150.jpg", "", "Reduced by 18.1% (535 B)", "2422", "2957", "", "10", "0", "1", "2021-01-01 15:08:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("781", "1101", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/yy-1-345x198.jpg", "", "Reduced by 17.6% (1.1 KB)", "5277", "6404", "", "10", "0", "1", "2021-01-01 15:08:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("782", "1101", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/yy-1-400x260.jpg", "", "Reduced by 20.5% (1.6 KB)", "6152", "7741", "", "10", "0", "1", "2021-01-01 15:08:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("783", "1101", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/yy-1-400x380.jpg", "", "Reduced by 23.6% (2.1 KB)", "6920", "9056", "", "10", "0", "1", "2021-01-01 15:08:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("784", "1101", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/yy-1-400x303.jpg", "", "Reduced by 20.6% (1.7 KB)", "6619", "8338", "", "10", "0", "1", "2021-01-01 15:08:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("785", "1102", "media", "full", "ABSPATHwp-content/uploads/2020/10/9-1.jpg", "", "Reduced by 4.0% (1.1 KB)", "26675", "27797", "", "10", "0", "1", "2021-01-01 15:08:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("786", "1102", "media", "medium", "ABSPATHwp-content/uploads/2020/10/9-1-300x300.jpg", "", "Reduced by 23.8% (1.7 KB)", "5689", "7465", "", "10", "0", "1", "2021-01-01 15:08:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("787", "1102", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/9-1-150x150.jpg", "", "Reduced by 18.5% (566 B)", "2491", "3057", "", "10", "0", "1", "2021-01-01 15:08:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("788", "1102", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/9-1-345x198.jpg", "", "Reduced by 20.9% (1.7 KB)", "6451", "8154", "", "10", "0", "1", "2021-01-01 15:08:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("789", "1102", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/9-1-400x260.jpg", "", "Reduced by 22.7% (2.2 KB)", "7715", "9978", "", "10", "0", "1", "2021-01-01 15:08:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("790", "1102", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/9-1-400x380.jpg", "", "Reduced by 26.9% (2.7 KB)", "7604", "10403", "", "10", "0", "1", "2021-01-01 15:08:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("791", "1102", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/9-1-400x303.jpg", "", "Reduced by 22.8% (2.4 KB)", "8380", "10855", "", "10", "0", "1", "2021-01-01 15:08:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("792", "1103", "media", "full", "ABSPATHwp-content/uploads/2020/10/met-2.jpg", "", "Reduced by 3.4% (933 B)", "26373", "27306", "", "10", "0", "1", "2021-01-01 15:08:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("793", "1103", "media", "medium", "ABSPATHwp-content/uploads/2020/10/met-2-300x300.jpg", "", "Reduced by 22.2% (1.6 KB)", "5878", "7557", "", "10", "0", "1", "2021-01-01 15:08:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("794", "1103", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/met-2-150x150.jpg", "", "Reduced by 21.1% (613 B)", "2298", "2911", "", "10", "0", "1", "2021-01-01 15:08:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("795", "1103", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/met-2-345x198.jpg", "", "Reduced by 18.0% (1.4 KB)", "6356", "7754", "", "10", "0", "1", "2021-01-01 15:08:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("796", "1103", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/met-2-400x260.jpg", "", "Reduced by 21.1% (2.2 KB)", "8294", "10517", "", "10", "0", "1", "2021-01-01 15:08:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("797", "1103", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/met-2-400x380.jpg", "", "Reduced by 23.7% (2.6 KB)", "8508", "11153", "", "10", "0", "1", "2021-01-01 15:08:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("798", "1103", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/met-2-400x303.jpg", "", "Reduced by 21.6% (2.3 KB)", "8379", "10683", "", "10", "0", "1", "2021-01-01 15:08:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("799", "1104", "media", "full", "ABSPATHwp-content/uploads/2020/10/boral-1.jpg", "", "Reduced by 3.1% (808 B)", "25526", "26334", "", "10", "0", "1", "2021-01-01 15:08:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("800", "1104", "media", "medium", "ABSPATHwp-content/uploads/2020/10/boral-1-300x300.jpg", "", "Reduced by 25.3% (2.5 KB)", "7715", "10325", "", "10", "0", "1", "2021-01-01 15:08:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("801", "1104", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/boral-1-150x150.jpg", "", "Reduced by 21.1% (978 B)", "3664", "4642", "", "10", "0", "1", "2021-01-01 15:08:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("802", "1104", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/boral-1-345x198.jpg", "", "Reduced by 24.4% (1.7 KB)", "5427", "7178", "", "10", "0", "1", "2021-01-01 15:08:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("803", "1104", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/boral-1-400x260.jpg", "", "Reduced by 24.2% (2.4 KB)", "7670", "10125", "", "10", "0", "1", "2021-01-01 15:08:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("804", "1104", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/boral-1-400x380.jpg", "", "Reduced by 25.3% (3.4 KB)", "10247", "13724", "", "10", "0", "1", "2021-01-01 15:08:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("805", "1104", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/boral-1-400x303.jpg", "", "Reduced by 23.2% (2.8 KB)", "9339", "12164", "", "10", "0", "1", "2021-01-01 15:08:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("806", "1105", "media", "full", "ABSPATHwp-content/uploads/2020/10/cr-1.jpg", "", "Reduced by 4.1% (1.2 KB)", "27484", "28667", "", "10", "0", "1", "2021-01-01 15:08:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("807", "1105", "media", "medium", "ABSPATHwp-content/uploads/2020/10/cr-1-300x300.jpg", "", "Reduced by 24.0% (1.9 KB)", "6042", "7953", "", "10", "0", "1", "2021-01-01 15:08:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("808", "1105", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/cr-1-150x150.jpg", "", "Reduced by 19.2% (618 B)", "2597", "3215", "", "10", "0", "1", "2021-01-01 15:08:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("809", "1105", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/cr-1-345x198.jpg", "", "Reduced by 19.8% (1.7 KB)", "7208", "8990", "", "10", "0", "1", "2021-01-01 15:08:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("810", "1105", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/cr-1-400x260.jpg", "", "Reduced by 21.4% (2.4 KB)", "8860", "11269", "", "10", "0", "1", "2021-01-01 15:08:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("811", "1105", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/cr-1-400x380.jpg", "", "Reduced by 25.0% (2.9 KB)", "9021", "12035", "", "10", "0", "1", "2021-01-01 15:08:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("812", "1105", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/cr-1-400x303.jpg", "", "Reduced by 22.6% (2.6 KB)", "9086", "11735", "", "10", "0", "1", "2021-01-01 15:08:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("813", "1106", "media", "full", "ABSPATHwp-content/uploads/2020/10/duro-1.jpg", "", "Reduced by 3.9% (1.1 KB)", "27997", "29144", "", "10", "0", "1", "2021-01-01 15:08:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("814", "1106", "media", "medium", "ABSPATHwp-content/uploads/2020/10/duro-1-300x300.jpg", "", "Reduced by 21.8% (1.5 KB)", "5642", "7211", "", "10", "0", "1", "2021-01-01 15:08:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("815", "1106", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/duro-1-150x150.jpg", "", "Reduced by 21.3% (614 B)", "2268", "2882", "", "10", "0", "1", "2021-01-01 15:08:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("816", "1106", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/duro-1-345x198.jpg", "", "Reduced by 17.5% (1.4 KB)", "6607", "8013", "", "10", "0", "1", "2021-01-01 15:08:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("817", "1106", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/duro-1-400x260.jpg", "", "Reduced by 18.4% (1.9 KB)", "8531", "10461", "", "10", "0", "1", "2021-01-01 15:09:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("818", "1106", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/duro-1-400x380.jpg", "", "Reduced by 23.5% (2.5 KB)", "8301", "10853", "", "10", "0", "1", "2021-01-01 15:09:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("819", "1106", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/duro-1-400x303.jpg", "", "Reduced by 19.5% (2.0 KB)", "8567", "10646", "", "10", "0", "1", "2021-01-01 15:09:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("820", "1107", "media", "full", "ABSPATHwp-content/uploads/2020/10/met-1-1.jpg", "", "Reduced by 3.4% (933 B)", "26373", "27306", "", "10", "0", "1", "2021-01-01 15:09:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("821", "1107", "media", "medium", "ABSPATHwp-content/uploads/2020/10/met-1-1-300x300.jpg", "", "Reduced by 22.2% (1.6 KB)", "5878", "7557", "", "10", "0", "1", "2021-01-01 15:09:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("822", "1107", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/met-1-1-150x150.jpg", "", "Reduced by 21.1% (613 B)", "2298", "2911", "", "10", "0", "1", "2021-01-01 15:09:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("823", "1107", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/met-1-1-345x198.jpg", "", "Reduced by 18.0% (1.4 KB)", "6356", "7754", "", "10", "0", "1", "2021-01-01 15:09:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("824", "1107", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/met-1-1-400x260.jpg", "", "Reduced by 21.1% (2.2 KB)", "8294", "10517", "", "10", "0", "1", "2021-01-01 15:09:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("825", "1107", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/met-1-1-400x380.jpg", "", "Reduced by 23.7% (2.6 KB)", "8508", "11153", "", "10", "0", "1", "2021-01-01 15:09:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("826", "1107", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/met-1-1-400x303.jpg", "", "Reduced by 21.6% (2.3 KB)", "8379", "10683", "", "10", "0", "1", "2021-01-01 15:09:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("827", "1108", "media", "full", "ABSPATHwp-content/uploads/2020/10/vlux-1.jpg", "", "Reduced by 3.3% (1,017 B)", "30203", "31220", "", "10", "0", "1", "2021-01-01 15:09:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("828", "1108", "media", "medium", "ABSPATHwp-content/uploads/2020/10/vlux-1-300x300.jpg", "", "Reduced by 22.8% (1.9 KB)", "6708", "8686", "", "10", "0", "1", "2021-01-01 15:09:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("829", "1108", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/vlux-1-150x150.jpg", "", "Reduced by 18.5% (740 B)", "3251", "3991", "", "10", "0", "1", "2021-01-01 15:09:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("830", "1108", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/vlux-1-345x198.jpg", "", "Reduced by 19.4% (1.8 KB)", "7834", "9717", "", "10", "0", "1", "2021-01-01 15:09:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("831", "1108", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/vlux-1-400x260.jpg", "", "Reduced by 21.1% (2.5 KB)", "9682", "12278", "", "10", "0", "1", "2021-01-01 15:09:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("832", "1108", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/10/vlux-1-400x380.jpg", "", "Reduced by 24.7% (3.1 KB)", "9668", "12831", "", "10", "0", "1", "2021-01-01 15:09:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("833", "1108", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/vlux-1-400x303.jpg", "", "Reduced by 22.3% (2.7 KB)", "9563", "12314", "", "10", "0", "1", "2021-01-01 15:09:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("834", "1118", "media", "full", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1.jpg", "", "Reduced by 1.7% (894 B)", "52397", "53291", "", "10", "0", "1", "2021-01-01 15:09:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("835", "1118", "media", "medium", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1-300x279.jpg", "", "Reduced by 9.8% (1.3 KB)", "11803", "13091", "", "10", "0", "1", "2021-01-01 15:09:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("836", "1118", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1-150x150.jpg", "", "Reduced by 9.3% (568 B)", "5568", "6136", "", "10", "0", "1", "2021-01-01 15:09:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("837", "1118", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1-345x198.jpg", "", "Reduced by 8.6% (1.1 KB)", "11979", "13105", "", "10", "0", "1", "2021-01-01 15:09:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("838", "1118", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1-377x260.jpg", "", "Reduced by 9.6% (1.6 KB)", "15015", "16610", "", "10", "0", "1", "2021-01-01 15:09:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("839", "1118", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/10/recomonded-brands-1-377x303.jpg", "", "Reduced by 9.6% (1.7 KB)", "16141", "17854", "", "10", "0", "1", "2021-01-01 15:09:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("840", "1146", "media", "full", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1.jpeg", "", "Reduced by 0.6% (1.2 KB)", "196703", "197957", "", "10", "0", "1", "2021-01-01 15:09:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("841", "1146", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-300x225.jpeg", "", "Reduced by 5.8% (843 B)", "13783", "14626", "", "10", "0", "1", "2021-01-01 15:09:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("842", "1146", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-150x150.jpeg", "", "Reduced by 7.0% (402 B)", "5314", "5716", "", "10", "0", "1", "2021-01-01 15:09:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("843", "1146", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-768x576.jpeg", "", "Reduced by 4.6% (3.1 KB)", "67186", "70405", "", "10", "0", "1", "2021-01-01 15:09:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("844", "1146", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-570x570.jpeg", "", "Reduced by 4.7% (2.4 KB)", "50477", "52982", "", "10", "0", "1", "2021-01-01 15:09:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("845", "1146", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-600x768.jpeg", "", "Reduced by 5.1% (3.7 KB)", "71933", "75771", "", "10", "0", "1", "2021-01-01 15:09:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("846", "1146", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-800x600.jpeg", "", "Reduced by 4.8% (3.5 KB)", "71602", "75229", "", "10", "0", "1", "2021-01-01 15:09:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("847", "1146", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-345x198.jpeg", "", "Reduced by 5.8% (798 B)", "13056", "13854", "", "10", "0", "1", "2021-01-01 15:09:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("848", "1146", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-400x260.jpeg", "", "Reduced by 5.2% (1.0 KB)", "19201", "20249", "", "10", "0", "1", "2021-01-01 15:09:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("849", "1146", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-500x380.jpeg", "", "Reduced by 5.0% (1.7 KB)", "33225", "34992", "", "10", "0", "1", "2021-01-01 15:09:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("850", "1146", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-500x500.jpeg", "", "Reduced by 5.1% (2.1 KB)", "40484", "42647", "", "10", "0", "1", "2021-01-01 15:09:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("851", "1146", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-1000x500.jpeg", "", "Reduced by 4.8% (3.1 KB)", "62282", "65438", "", "10", "0", "1", "2021-01-01 15:09:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("852", "1146", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-500x768.jpeg", "", "Reduced by 5.1% (3.2 KB)", "61337", "64660", "", "10", "0", "1", "2021-01-01 15:09:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("853", "1146", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-1000x768.jpeg", "", "Reduced by 4.9% (5.8 KB)", "115881", "121858", "", "10", "0", "1", "2021-01-01 15:09:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("854", "1146", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-700x525.jpeg", "", "Reduced by 4.6% (2.8 KB)", "57986", "60807", "", "10", "0", "1", "2021-01-01 15:09:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("855", "1146", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO3-1-539x303.jpeg", "", "Reduced by 4.9% (1.3 KB)", "26408", "27766", "", "10", "0", "1", "2021-01-01 15:09:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("856", "1147", "media", "full", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1.jpeg", "", "Reduced by 0.9% (1.4 KB)", "166877", "168360", "", "10", "0", "1", "2021-01-01 15:09:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("857", "1147", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-300x225.jpeg", "", "Reduced by 5.7% (708 B)", "11699", "12407", "", "10", "0", "1", "2021-01-01 15:09:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("858", "1147", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-150x150.jpeg", "", "Reduced by 7.1% (361 B)", "4693", "5054", "", "10", "0", "1", "2021-01-01 15:09:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("859", "1147", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-768x576.jpeg", "", "Reduced by 5.7% (3.4 KB)", "56284", "59715", "", "10", "0", "1", "2021-01-01 15:09:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("860", "1147", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-570x570.jpeg", "", "Reduced by 5.7% (2.5 KB)", "42780", "45343", "", "10", "0", "1", "2021-01-01 15:09:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("861", "1147", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-600x768.jpeg", "", "Reduced by 5.8% (3.7 KB)", "61540", "65349", "", "10", "0", "1", "2021-01-01 15:09:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("862", "1147", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-800x600.jpeg", "", "Reduced by 5.7% (3.5 KB)", "59782", "63382", "", "10", "0", "1", "2021-01-01 15:09:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("863", "1147", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-345x198.jpeg", "", "Reduced by 6.2% (845 B)", "12795", "13640", "", "10", "0", "1", "2021-01-01 15:09:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("864", "1147", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-400x260.jpeg", "", "Reduced by 5.6% (1,018 B)", "17170", "18188", "", "10", "0", "1", "2021-01-01 15:09:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("865", "1147", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-500x380.jpeg", "", "Reduced by 5.7% (1.6 KB)", "27543", "29198", "", "10", "0", "1", "2021-01-01 15:09:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("866", "1147", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-500x500.jpeg", "", "Reduced by 5.7% (2.0 KB)", "34328", "36399", "", "10", "0", "1", "2021-01-01 15:09:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("867", "1147", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-1000x500.jpeg", "", "Reduced by 5.1% (3.6 KB)", "68043", "71697", "", "10", "0", "1", "2021-01-01 15:09:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("868", "1147", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-500x768.jpeg", "", "Reduced by 5.9% (3.1 KB)", "51182", "54379", "", "10", "0", "1", "2021-01-01 15:09:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("869", "1147", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-1000x768.jpeg", "", "Reduced by 5.7% (5.9 KB)", "99712", "105749", "", "10", "0", "1", "2021-01-01 15:09:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("870", "1147", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-700x525.jpeg", "", "Reduced by 5.5% (2.8 KB)", "48077", "50899", "", "10", "0", "1", "2021-01-01 15:09:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("871", "1147", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO-1-539x303.jpeg", "", "Reduced by 5.4% (1.5 KB)", "26304", "27815", "", "10", "0", "1", "2021-01-01 15:09:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("872", "1148", "media", "full", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1.jpeg", "", "Reduced by 0.9% (2.1 KB)", "231940", "234123", "", "10", "0", "1", "2021-01-01 15:09:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("873", "1148", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-225x300.jpeg", "", "Reduced by 7.2% (1.0 KB)", "13682", "14737", "", "10", "0", "1", "2021-01-01 15:09:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("874", "1148", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-150x150.jpeg", "", "Reduced by 8.1% (534 B)", "6052", "6586", "", "10", "0", "1", "2021-01-01 15:09:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("875", "1148", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-570x570.jpeg", "", "Reduced by 6.2% (3.9 KB)", "59960", "63952", "", "10", "0", "1", "2021-01-01 15:09:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("876", "1148", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-600x800.jpeg", "", "Reduced by 6.5% (5.4 KB)", "79705", "85227", "", "10", "0", "1", "2021-01-01 15:09:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("877", "1148", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-768x600.jpeg", "", "Reduced by 6.1% (6.3 KB)", "100166", "106631", "", "10", "0", "1", "2021-01-01 15:09:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("878", "1148", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-345x198.jpeg", "", "Reduced by 7.2% (1.4 KB)", "18478", "19919", "", "10", "0", "1", "2021-01-01 15:09:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("879", "1148", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-400x260.jpeg", "", "Reduced by 6.8% (1.9 KB)", "25940", "27839", "", "10", "0", "1", "2021-01-01 15:09:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("880", "1148", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-500x380.jpeg", "", "Reduced by 6.4% (2.7 KB)", "41221", "44036", "", "10", "0", "1", "2021-01-01 15:09:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("881", "1148", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-500x500.jpeg", "", "Reduced by 6.4% (3.2 KB)", "47516", "50787", "", "10", "0", "1", "2021-01-01 15:09:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("882", "1148", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-768x500.jpeg", "", "Reduced by 6.0% (5.9 KB)", "93655", "99682", "", "10", "0", "1", "2021-01-01 15:09:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("883", "1148", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-500x1000.jpeg", "", "Reduced by 6.0% (4.5 KB)", "72095", "76662", "", "10", "0", "1", "2021-01-01 15:09:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("884", "1148", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-768x1000.jpeg", "", "Reduced by 6.4% (9.4 KB)", "141703", "151312", "", "10", "0", "1", "2021-01-01 15:09:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("885", "1148", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-700x933.jpeg", "", "Reduced by 6.1% (6.7 KB)", "106191", "113047", "", "10", "0", "1", "2021-01-01 15:09:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("886", "1148", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Apartment-Complex-Shingle-Project-Parker-CO2-1-539x303.jpeg", "", "Reduced by 6.7% (2.8 KB)", "39780", "42636", "", "10", "0", "1", "2021-01-01 15:09:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("887", "1149", "media", "full", "ABSPATHwp-content/uploads/2016/02/1-2.jpg", "", "Reduced by 0.6% (917 B)", "162270", "163187", "", "10", "0", "1", "2021-01-01 15:09:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("888", "1149", "media", "medium", "ABSPATHwp-content/uploads/2016/02/1-2-300x253.jpg", "", "Reduced by 6.1% (1.1 KB)", "17939", "19101", "", "10", "0", "1", "2021-01-01 15:09:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("889", "1149", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/1-2-150x150.jpg", "", "Reduced by 7.5% (512 B)", "6342", "6854", "", "10", "0", "1", "2021-01-01 15:09:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("890", "1149", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/1-2-345x198.jpg", "", "Reduced by 6.5% (1.2 KB)", "17399", "18616", "", "10", "0", "1", "2021-01-01 15:09:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("891", "1149", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/1-2-400x260.jpg", "", "Reduced by 6.1% (1.5 KB)", "24277", "25844", "", "10", "0", "1", "2021-01-01 15:09:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("892", "1149", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/1-2-475x380.jpg", "", "Reduced by 5.9% (2.6 KB)", "42733", "45402", "", "10", "0", "1", "2021-01-01 15:09:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("893", "1149", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/1-2-475x303.jpg", "", "Reduced by 6.2% (2.3 KB)", "36565", "38971", "", "10", "0", "1", "2021-01-01 15:09:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("894", "1150", "media", "full", "ABSPATHwp-content/uploads/2016/02/2-3.jpg", "", "Reduced by 0.4% (473 B)", "129493", "129966", "", "10", "0", "1", "2021-01-01 15:09:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("895", "1150", "media", "medium", "ABSPATHwp-content/uploads/2016/02/2-3-300x253.jpg", "", "Reduced by 5.2% (699 B)", "12642", "13341", "", "10", "0", "1", "2021-01-01 15:09:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("896", "1150", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/2-3-150x150.jpg", "", "Reduced by 7.0% (363 B)", "4786", "5149", "", "10", "0", "1", "2021-01-01 15:09:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("897", "1150", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/2-3-345x198.jpg", "", "Reduced by 5.2% (673 B)", "12207", "12880", "", "10", "0", "1", "2021-01-01 15:09:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("898", "1150", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/2-3-400x260.jpg", "", "Reduced by 4.9% (868 B)", "16974", "17842", "", "10", "0", "1", "2021-01-01 15:09:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("899", "1150", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/2-3-475x380.jpg", "", "Reduced by 4.3% (1.3 KB)", "29291", "30598", "", "10", "0", "1", "2021-01-01 15:10:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("900", "1150", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/2-3-475x303.jpg", "", "Reduced by 4.3% (1.1 KB)", "24481", "25579", "", "10", "0", "1", "2021-01-01 15:10:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("901", "1151", "media", "full", "ABSPATHwp-content/uploads/2016/02/3-3.jpg", "", "Reduced by 15.4% (28.6 KB)", "160993", "190291", "", "10", "0", "1", "2021-01-01 15:10:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("902", "1151", "media", "medium", "ABSPATHwp-content/uploads/2016/02/3-3-300x253.jpg", "", "Reduced by 5.8% (1.2 KB)", "19308", "20492", "", "10", "0", "1", "2021-01-01 15:10:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("903", "1151", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/3-3-150x150.jpg", "", "Reduced by 8.0% (582 B)", "6704", "7286", "", "10", "0", "1", "2021-01-01 15:10:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("904", "1151", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/3-3-345x198.jpg", "", "Reduced by 5.6% (973 B)", "16437", "17410", "", "10", "0", "1", "2021-01-01 15:10:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("905", "1151", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/3-3-400x260.jpg", "", "Reduced by 5.1% (1.2 KB)", "23343", "24595", "", "10", "0", "1", "2021-01-01 15:10:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("906", "1151", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/3-3-475x380.jpg", "", "Reduced by 4.8% (2.1 KB)", "43616", "45803", "", "10", "0", "1", "2021-01-01 15:10:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("907", "1151", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/3-3-475x303.jpg", "", "Reduced by 4.8% (1.7 KB)", "33870", "35586", "", "10", "0", "1", "2021-01-01 15:10:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("908", "1152", "media", "full", "ABSPATHwp-content/uploads/2016/02/4-2.jpg", "", "Reduced by 0.7% (1,006 B)", "141508", "142514", "", "10", "0", "1", "2021-01-01 15:10:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("909", "1152", "media", "medium", "ABSPATHwp-content/uploads/2016/02/4-2-300x253.jpg", "", "Reduced by 6.0% (1.1 KB)", "17064", "18144", "", "10", "0", "1", "2021-01-01 15:10:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("910", "1152", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/4-2-150x150.jpg", "", "Reduced by 7.4% (502 B)", "6278", "6780", "", "10", "0", "1", "2021-01-01 15:10:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("911", "1152", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/4-2-345x198.jpg", "", "Reduced by 6.3% (1.0 KB)", "15748", "16798", "", "10", "0", "1", "2021-01-01 15:10:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("912", "1152", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/4-2-400x260.jpg", "", "Reduced by 5.7% (1.3 KB)", "21768", "23086", "", "10", "0", "1", "2021-01-01 15:10:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("913", "1152", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/4-2-475x380.jpg", "", "Reduced by 5.2% (2.0 KB)", "38342", "40440", "", "10", "0", "1", "2021-01-01 15:10:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("914", "1152", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/4-2-475x303.jpg", "", "Reduced by 5.5% (1.8 KB)", "31429", "33263", "", "10", "0", "1", "2021-01-01 15:10:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("915", "1153", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1.jpg", "", "Reduced by 0.6% (3.3 KB)", "532469", "535856", "", "10", "0", "1", "2021-01-01 15:10:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("916", "1153", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-300x225.jpg", "", "Reduced by 5.2% (622 B)", "11281", "11903", "", "10", "0", "1", "2021-01-01 15:10:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("917", "1153", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-150x150.jpg", "", "Reduced by 7.3% (357 B)", "4506", "4863", "", "10", "0", "1", "2021-01-01 15:10:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("918", "1153", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-768x576.jpg", "", "Reduced by 4.6% (2.5 KB)", "53946", "56522", "", "10", "0", "1", "2021-01-01 15:10:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("919", "1153", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-570x570.jpg", "", "Reduced by 4.5% (1.9 KB)", "41100", "43016", "", "10", "0", "1", "2021-01-01 15:10:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("920", "1153", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-600x768.jpg", "", "Reduced by 5.3% (3.1 KB)", "57166", "60345", "", "10", "0", "1", "2021-01-01 15:10:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("921", "1153", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-800x600.jpg", "", "Reduced by 4.8% (2.8 KB)", "57304", "60174", "", "10", "0", "1", "2021-01-01 15:10:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("922", "1153", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-345x198.jpg", "", "Reduced by 5.3% (657 B)", "11793", "12450", "", "10", "0", "1", "2021-01-01 15:10:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("923", "1153", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-400x260.jpg", "", "Reduced by 5.0% (866 B)", "16446", "17312", "", "10", "0", "1", "2021-01-01 15:10:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("924", "1153", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-500x380.jpg", "", "Reduced by 4.9% (1.3 KB)", "26435", "27807", "", "10", "0", "1", "2021-01-01 15:10:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("925", "1153", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-500x500.jpg", "", "Reduced by 5.2% (1.8 KB)", "33117", "34926", "", "10", "0", "1", "2021-01-01 15:10:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("926", "1153", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-1000x500.jpg", "", "Reduced by 4.8% (3.0 KB)", "60826", "63887", "", "10", "0", "1", "2021-01-01 15:10:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("927", "1153", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-500x768.jpg", "", "Reduced by 5.6% (2.8 KB)", "47483", "50305", "", "10", "0", "1", "2021-01-01 15:10:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("928", "1153", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-1000x768.jpg", "", "Reduced by 5.0% (4.7 KB)", "92432", "97258", "", "10", "0", "1", "2021-01-01 15:10:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("929", "1153", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-700x525.jpg", "", "Reduced by 4.5% (2.1 KB)", "46002", "48162", "", "10", "0", "1", "2021-01-01 15:10:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("930", "1153", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY-1-539x303.jpg", "", "Reduced by 4.5% (1.1 KB)", "23964", "25099", "", "10", "0", "1", "2021-01-01 15:10:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("931", "1154", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1.jpg", "", "Reduced by 0.6% (3.4 KB)", "535550", "539007", "", "10", "0", "1", "2021-01-01 15:10:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("932", "1154", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-300x225.jpg", "", "Reduced by 5.8% (770 B)", "12491", "13261", "", "10", "0", "1", "2021-01-01 15:10:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("933", "1154", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-150x150.jpg", "", "Reduced by 7.0% (394 B)", "5198", "5592", "", "10", "0", "1", "2021-01-01 15:10:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("934", "1154", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-768x576.jpg", "", "Reduced by 5.1% (3.0 KB)", "56969", "60040", "", "10", "0", "1", "2021-01-01 15:10:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("935", "1154", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-570x570.jpg", "", "Reduced by 5.0% (2.2 KB)", "41933", "44145", "", "10", "0", "1", "2021-01-01 15:10:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("936", "1154", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-600x768.jpg", "", "Reduced by 4.9% (2.9 KB)", "58211", "61196", "", "10", "0", "1", "2021-01-01 15:10:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("937", "1154", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-800x600.jpg", "", "Reduced by 5.2% (3.3 KB)", "60233", "63563", "", "10", "0", "1", "2021-01-01 15:10:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("938", "1154", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-345x198.jpg", "", "Reduced by 5.8% (768 B)", "12411", "13179", "", "10", "0", "1", "2021-01-01 15:10:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("939", "1154", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-400x260.jpg", "", "Reduced by 5.3% (984 B)", "17660", "18644", "", "10", "0", "1", "2021-01-01 15:10:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("940", "1154", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-500x380.jpg", "", "Reduced by 5.2% (1.5 KB)", "28789", "30374", "", "10", "0", "1", "2021-01-01 15:10:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("941", "1154", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-500x500.jpg", "", "Reduced by 5.5% (1.9 KB)", "34086", "36072", "", "10", "0", "1", "2021-01-01 15:10:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("942", "1154", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-1000x500.jpg", "", "Reduced by 5.1% (3.1 KB)", "58576", "61731", "", "10", "0", "1", "2021-01-01 15:10:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("943", "1154", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-500x768.jpg", "", "Reduced by 5.0% (2.6 KB)", "49534", "52146", "", "10", "0", "1", "2021-01-01 15:10:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("944", "1154", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-1000x768.jpg", "", "Reduced by 5.2% (5.2 KB)", "95844", "101148", "", "10", "0", "1", "2021-01-01 15:10:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("945", "1154", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-700x525.jpg", "", "Reduced by 5.2% (2.6 KB)", "48867", "51554", "", "10", "0", "1", "2021-01-01 15:10:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("946", "1154", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY2-1-539x303.jpg", "", "Reduced by 5.0% (1.3 KB)", "25111", "26430", "", "10", "0", "1", "2021-01-01 15:10:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("947", "1155", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1.jpg", "", "Reduced by 0.5% (2.8 KB)", "516292", "519127", "", "10", "0", "1", "2021-01-01 15:10:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("948", "1155", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-300x225.jpg", "", "Reduced by 5.1% (653 B)", "12141", "12794", "", "10", "0", "1", "2021-01-01 15:10:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("949", "1155", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-150x150.jpg", "", "Reduced by 6.8% (358 B)", "4908", "5266", "", "10", "0", "1", "2021-01-01 15:10:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("950", "1155", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-768x576.jpg", "", "Reduced by 5.3% (3.0 KB)", "54896", "57974", "", "10", "0", "1", "2021-01-01 15:10:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("951", "1155", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-570x570.jpg", "", "Reduced by 5.2% (2.2 KB)", "40920", "43148", "", "10", "0", "1", "2021-01-01 15:10:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("952", "1155", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-600x768.jpg", "", "Reduced by 6.0% (3.4 KB)", "54524", "57989", "", "10", "0", "1", "2021-01-01 15:10:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("953", "1155", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-800x600.jpg", "", "Reduced by 5.2% (3.1 KB)", "58294", "61515", "", "10", "0", "1", "2021-01-01 15:10:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("954", "1155", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-345x198.jpg", "", "Reduced by 5.7% (745 B)", "12353", "13098", "", "10", "0", "1", "2021-01-01 15:10:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("955", "1155", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-400x260.jpg", "", "Reduced by 5.6% (1,004 B)", "17002", "18006", "", "10", "0", "1", "2021-01-01 15:10:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("956", "1155", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-500x380.jpg", "", "Reduced by 5.0% (1.4 KB)", "27975", "29436", "", "10", "0", "1", "2021-01-01 15:10:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("957", "1155", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-500x500.jpg", "", "Reduced by 5.5% (1.9 KB)", "33303", "35239", "", "10", "0", "1", "2021-01-01 15:10:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("958", "1155", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-1000x500.jpg", "", "Reduced by 5.2% (3.2 KB)", "60642", "63952", "", "10", "0", "1", "2021-01-01 15:10:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("959", "1155", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-500x768.jpg", "", "Reduced by 5.9% (2.8 KB)", "45813", "48673", "", "10", "0", "1", "2021-01-01 15:10:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("960", "1155", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-1000x768.jpg", "", "Reduced by 5.6% (5.4 KB)", "92399", "97891", "", "10", "0", "1", "2021-01-01 15:10:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("961", "1155", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-700x525.jpg", "", "Reduced by 5.1% (2.5 KB)", "47392", "49937", "", "10", "0", "1", "2021-01-01 15:10:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("962", "1155", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY3-1-539x303.jpg", "", "Reduced by 4.9% (1.3 KB)", "24943", "26228", "", "10", "0", "1", "2021-01-01 15:10:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("963", "1156", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1.jpg", "", "Reduced by 1.0% (6.1 KB)", "632249", "638453", "", "10", "0", "1", "2021-01-01 15:10:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("964", "1156", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-300x225.jpg", "", "Reduced by 5.5% (835 B)", "14217", "15052", "", "10", "0", "1", "2021-01-01 15:10:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("965", "1156", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-150x150.jpg", "", "Reduced by 7.5% (451 B)", "5570", "6021", "", "10", "0", "1", "2021-01-01 15:10:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("966", "1156", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-768x576.jpg", "", "Reduced by 4.1% (3.1 KB)", "73873", "77042", "", "10", "0", "1", "2021-01-01 15:10:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("967", "1156", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-570x570.jpg", "", "Reduced by 4.0% (2.2 KB)", "55891", "58192", "", "10", "0", "1", "2021-01-01 15:10:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("968", "1156", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-600x768.jpg", "", "Reduced by 4.5% (3.7 KB)", "80858", "84694", "", "10", "0", "1", "2021-01-01 15:10:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("969", "1156", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-800x600.jpg", "", "Reduced by 4.1% (3.3 KB)", "78543", "81897", "", "10", "0", "1", "2021-01-01 15:10:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("970", "1156", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-345x198.jpg", "", "Reduced by 5.7% (863 B)", "14320", "15183", "", "10", "0", "1", "2021-01-01 15:10:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("971", "1156", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-400x260.jpg", "", "Reduced by 4.8% (1.0 KB)", "20694", "21728", "", "10", "0", "1", "2021-01-01 15:10:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("972", "1156", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-500x380.jpg", "", "Reduced by 4.5% (1.6 KB)", "35471", "37126", "", "10", "0", "1", "2021-01-01 15:10:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("973", "1156", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-500x500.jpg", "", "Reduced by 4.4% (2.0 KB)", "44578", "46610", "", "10", "0", "1", "2021-01-01 15:10:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("974", "1156", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-1000x500.jpg", "", "Reduced by 4.2% (3.3 KB)", "77779", "81175", "", "10", "0", "1", "2021-01-01 15:10:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("975", "1156", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-500x768.jpg", "", "Reduced by 4.7% (3.2 KB)", "67465", "70783", "", "10", "0", "1", "2021-01-01 15:11:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("976", "1156", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-1000x768.jpg", "", "Reduced by 4.5% (5.9 KB)", "129235", "135270", "", "10", "0", "1", "2021-01-01 15:11:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("977", "1156", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-700x525.jpg", "", "Reduced by 4.1% (2.6 KB)", "62832", "65544", "", "10", "0", "1", "2021-01-01 15:11:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("978", "1156", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY4-1-539x303.jpg", "", "Reduced by 4.6% (1.5 KB)", "30709", "32203", "", "10", "0", "1", "2021-01-01 15:11:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("979", "1158", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1.jpg", "", "Reduced by 0.5% (3.3 KB)", "661812", "665231", "", "10", "0", "1", "2021-01-01 15:11:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("980", "1158", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-300x225.jpg", "", "Reduced by 5.7% (1.0 KB)", "16884", "17910", "", "10", "0", "1", "2021-01-01 15:11:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("981", "1158", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-150x150.jpg", "", "Reduced by 7.5% (523 B)", "6432", "6955", "", "10", "0", "1", "2021-01-01 15:11:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("982", "1158", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-768x576.jpg", "", "Reduced by 4.2% (3.5 KB)", "81506", "85064", "", "10", "0", "1", "2021-01-01 15:11:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("983", "1158", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-570x570.jpg", "", "Reduced by 4.1% (2.5 KB)", "59542", "62056", "", "10", "0", "1", "2021-01-01 15:11:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("984", "1158", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-600x768.jpg", "", "Reduced by 4.2% (3.6 KB)", "83554", "87255", "", "10", "0", "1", "2021-01-01 15:11:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("985", "1158", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-800x600.jpg", "", "Reduced by 4.1% (3.6 KB)", "86340", "90024", "", "10", "0", "1", "2021-01-01 15:11:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("986", "1158", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-345x198.jpg", "", "Reduced by 5.7% (1.0 KB)", "17063", "18102", "", "10", "0", "1", "2021-01-01 15:11:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("987", "1158", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-400x260.jpg", "", "Reduced by 5.1% (1.3 KB)", "24447", "25750", "", "10", "0", "1", "2021-01-01 15:11:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("988", "1158", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-500x380.jpg", "", "Reduced by 4.7% (1.9 KB)", "40333", "42316", "", "10", "0", "1", "2021-01-01 15:11:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("989", "1158", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-500x500.jpg", "", "Reduced by 4.3% (2.1 KB)", "48039", "50190", "", "10", "0", "1", "2021-01-01 15:11:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("990", "1158", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-1000x500.jpg", "", "Reduced by 3.8% (3.4 KB)", "88647", "92165", "", "10", "0", "1", "2021-01-01 15:11:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("991", "1158", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-500x768.jpg", "", "Reduced by 4.2% (3.0 KB)", "70408", "73458", "", "10", "0", "1", "2021-01-01 15:11:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("992", "1158", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-1000x768.jpg", "", "Reduced by 4.2% (5.8 KB)", "137931", "143911", "", "10", "0", "1", "2021-01-01 15:11:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("993", "1158", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-700x525.jpg", "", "Reduced by 4.0% (2.8 KB)", "70151", "73068", "", "10", "0", "1", "2021-01-01 15:11:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("994", "1158", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-PVC-Project-Green-River-WY5-1-539x303.jpg", "", "Reduced by 4.6% (1.7 KB)", "35645", "37380", "", "10", "0", "1", "2021-01-01 15:11:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("995", "1159", "media", "full", "ABSPATHwp-content/uploads/2016/02/2-1-1.jpg", "", "Reduced by 0.4% (473 B)", "129493", "129966", "", "10", "0", "1", "2021-01-01 15:11:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("996", "1159", "media", "medium", "ABSPATHwp-content/uploads/2016/02/2-1-1-300x253.jpg", "", "Reduced by 5.2% (699 B)", "12642", "13341", "", "10", "0", "1", "2021-01-01 15:11:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("997", "1159", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/2-1-1-150x150.jpg", "", "Reduced by 7.0% (363 B)", "4786", "5149", "", "10", "0", "1", "2021-01-01 15:11:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("998", "1159", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/2-1-1-345x198.jpg", "", "Reduced by 5.2% (673 B)", "12207", "12880", "", "10", "0", "1", "2021-01-01 15:11:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("999", "1159", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/2-1-1-400x260.jpg", "", "Reduced by 4.9% (868 B)", "16974", "17842", "", "10", "0", "1", "2021-01-01 15:11:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1000", "1159", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/2-1-1-475x380.jpg", "", "Reduced by 4.3% (1.3 KB)", "29291", "30598", "", "10", "0", "1", "2021-01-01 15:11:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1001", "1159", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/2-1-1-475x303.jpg", "", "Reduced by 4.3% (1.1 KB)", "24481", "25579", "", "10", "0", "1", "2021-01-01 15:11:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1002", "1162", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1.jpeg", "", "Reduced by 0.4% (1.3 KB)", "303944", "305245", "", "10", "0", "1", "2021-01-01 15:11:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1003", "1162", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-300x225.jpeg", "", "Reduced by 6.5% (1.2 KB)", "17709", "18932", "", "10", "0", "1", "2021-01-01 15:11:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1004", "1162", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-150x150.jpeg", "", "Reduced by 8.3% (615 B)", "6757", "7372", "", "10", "0", "1", "2021-01-01 15:11:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1005", "1162", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-768x576.jpeg", "", "Reduced by 5.0% (4.8 KB)", "93985", "98881", "", "10", "0", "1", "2021-01-01 15:11:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1006", "1162", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-570x570.jpeg", "", "Reduced by 4.7% (3.4 KB)", "69730", "73196", "", "10", "0", "1", "2021-01-01 15:11:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1007", "1162", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-600x768.jpeg", "", "Reduced by 5.1% (5.2 KB)", "100782", "106154", "", "10", "0", "1", "2021-01-01 15:11:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1008", "1162", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-800x600.jpeg", "", "Reduced by 4.8% (4.9 KB)", "99842", "104878", "", "10", "0", "1", "2021-01-01 15:11:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1009", "1162", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-345x198.jpeg", "", "Reduced by 6.7% (1.3 KB)", "18126", "19429", "", "10", "0", "1", "2021-01-01 15:11:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1010", "1162", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-400x260.jpeg", "", "Reduced by 6.1% (1.7 KB)", "25957", "27654", "", "10", "0", "1", "2021-01-01 15:11:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1011", "1162", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-500x380.jpeg", "", "Reduced by 5.6% (2.6 KB)", "44305", "46939", "", "10", "0", "1", "2021-01-01 15:11:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1012", "1162", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-500x500.jpeg", "", "Reduced by 5.2% (3.0 KB)", "55309", "58358", "", "10", "0", "1", "2021-01-01 15:11:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1013", "1162", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-1000x500.jpeg", "", "Reduced by 4.8% (5.1 KB)", "103438", "108624", "", "10", "0", "1", "2021-01-01 15:11:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1014", "1162", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-500x768.jpeg", "", "Reduced by 5.1% (4.4 KB)", "83166", "87677", "", "10", "0", "1", "2021-01-01 15:11:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1015", "1162", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-1000x768.jpeg", "", "Reduced by 5.1% (9.0 KB)", "171801", "181037", "", "10", "0", "1", "2021-01-01 15:11:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1016", "1162", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-700x525.jpeg", "", "Reduced by 4.9% (4.0 KB)", "79434", "83557", "", "10", "0", "1", "2021-01-01 15:11:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1017", "1162", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK-1-539x303.jpeg", "", "Reduced by 5.6% (2.3 KB)", "39224", "41552", "", "10", "0", "1", "2021-01-01 15:11:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1018", "1163", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1.jpeg", "", "Reduced by 0.5% (1.4 KB)", "296877", "298313", "", "10", "0", "1", "2021-01-01 15:11:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1019", "1163", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-300x225.jpeg", "", "Reduced by 6.8% (1.3 KB)", "17749", "19039", "", "10", "0", "1", "2021-01-01 15:11:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1020", "1163", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-150x150.jpeg", "", "Reduced by 7.9% (583 B)", "6807", "7390", "", "10", "0", "1", "2021-01-01 15:11:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1021", "1163", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-768x576.jpeg", "", "Reduced by 5.4% (5.1 KB)", "92286", "97542", "", "10", "0", "1", "2021-01-01 15:11:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1022", "1163", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-570x570.jpeg", "", "Reduced by 5.3% (3.7 KB)", "68124", "71899", "", "10", "0", "1", "2021-01-01 15:11:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1023", "1163", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-600x768.jpeg", "", "Reduced by 5.5% (5.9 KB)", "102529", "108524", "", "10", "0", "1", "2021-01-01 15:11:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1024", "1163", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-800x600.jpeg", "", "Reduced by 5.4% (5.4 KB)", "98059", "103611", "", "10", "0", "1", "2021-01-01 15:11:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1025", "1163", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-345x198.jpeg", "", "Reduced by 6.9% (1.3 KB)", "17961", "19290", "", "10", "0", "1", "2021-01-01 15:11:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1026", "1163", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-400x260.jpeg", "", "Reduced by 6.5% (1.8 KB)", "25871", "27684", "", "10", "0", "1", "2021-01-01 15:11:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1027", "1163", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-500x380.jpeg", "", "Reduced by 5.8% (2.7 KB)", "43987", "46718", "", "10", "0", "1", "2021-01-01 15:11:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1028", "1163", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-500x500.jpeg", "", "Reduced by 5.8% (3.3 KB)", "54406", "57740", "", "10", "0", "1", "2021-01-01 15:11:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1029", "1163", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-1000x500.jpeg", "", "Reduced by 5.0% (4.9 KB)", "94871", "99881", "", "10", "0", "1", "2021-01-01 15:11:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1030", "1163", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-500x768.jpeg", "", "Reduced by 5.6% (5.0 KB)", "86383", "91483", "", "10", "0", "1", "2021-01-01 15:11:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1031", "1163", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-1000x768.jpeg", "", "Reduced by 5.5% (9.6 KB)", "168769", "178567", "", "10", "0", "1", "2021-01-01 15:11:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1032", "1163", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-700x525.jpeg", "", "Reduced by 5.5% (4.4 KB)", "78345", "82865", "", "10", "0", "1", "2021-01-01 15:11:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1033", "1163", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK2-1-539x303.jpeg", "", "Reduced by 5.9% (2.3 KB)", "37663", "40042", "", "10", "0", "1", "2021-01-01 15:11:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1034", "1164", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1.jpeg", "", "Reduced by 7.8% (25.1 KB)", "303944", "329609", "", "10", "0", "1", "2021-01-01 15:11:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1035", "1164", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-300x225.jpeg", "", "Reduced by 6.5% (1.2 KB)", "17709", "18932", "", "10", "0", "1", "2021-01-01 15:11:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1036", "1164", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-150x150.jpeg", "", "Reduced by 8.3% (615 B)", "6757", "7372", "", "10", "0", "1", "2021-01-01 15:11:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1037", "1164", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-768x576.jpeg", "", "Reduced by 5.0% (4.8 KB)", "93985", "98881", "", "10", "0", "1", "2021-01-01 15:11:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1038", "1164", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-570x570.jpeg", "", "Reduced by 4.7% (3.4 KB)", "69730", "73196", "", "10", "0", "1", "2021-01-01 15:11:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1039", "1164", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-600x768.jpeg", "", "Reduced by 5.1% (5.2 KB)", "100782", "106154", "", "10", "0", "1", "2021-01-01 15:11:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1040", "1164", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-800x600.jpeg", "", "Reduced by 4.8% (4.9 KB)", "99842", "104878", "", "10", "0", "1", "2021-01-01 15:11:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1041", "1164", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-345x198.jpeg", "", "Reduced by 6.7% (1.3 KB)", "18126", "19429", "", "10", "0", "1", "2021-01-01 15:11:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1042", "1164", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-400x260.jpeg", "", "Reduced by 6.1% (1.7 KB)", "25957", "27654", "", "10", "0", "1", "2021-01-01 15:11:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1043", "1164", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-500x380.jpeg", "", "Reduced by 5.6% (2.6 KB)", "44305", "46939", "", "10", "0", "1", "2021-01-01 15:11:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1044", "1164", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-500x500.jpeg", "", "Reduced by 5.2% (3.0 KB)", "55309", "58358", "", "10", "0", "1", "2021-01-01 15:11:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1045", "1164", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-1000x500.jpeg", "", "Reduced by 4.8% (5.1 KB)", "103438", "108624", "", "10", "0", "1", "2021-01-01 15:11:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1046", "1164", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-500x768.jpeg", "", "Reduced by 5.1% (4.4 KB)", "83166", "87677", "", "10", "0", "1", "2021-01-01 15:11:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1047", "1164", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-1000x768.jpeg", "", "Reduced by 5.1% (9.0 KB)", "171801", "181037", "", "10", "0", "1", "2021-01-01 15:11:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1048", "1164", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-700x525.jpeg", "", "Reduced by 4.9% (4.0 KB)", "79434", "83557", "", "10", "0", "1", "2021-01-01 15:11:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1049", "1164", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK3-1-539x303.jpeg", "", "Reduced by 5.6% (2.3 KB)", "39224", "41552", "", "10", "0", "1", "2021-01-01 15:11:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1050", "1165", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1.jpeg", "", "Reduced by 0.4% (1.0 KB)", "289588", "290651", "", "10", "0", "1", "2021-01-01 15:12:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1051", "1165", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-300x225.jpeg", "", "Reduced by 6.3% (1.1 KB)", "16506", "17614", "", "10", "0", "1", "2021-01-01 15:12:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1052", "1165", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-150x150.jpeg", "", "Reduced by 8.0% (542 B)", "6228", "6770", "", "10", "0", "1", "2021-01-01 15:12:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1053", "1165", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-768x576.jpeg", "", "Reduced by 4.9% (4.5 KB)", "88463", "93054", "", "10", "0", "1", "2021-01-01 15:12:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1054", "1165", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-570x570.jpeg", "", "Reduced by 4.9% (3.2 KB)", "64873", "68198", "", "10", "0", "1", "2021-01-01 15:12:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1055", "1165", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-600x768.jpeg", "", "Reduced by 5.1% (5.1 KB)", "97880", "103153", "", "10", "0", "1", "2021-01-01 15:12:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1056", "1165", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-800x600.jpeg", "", "Reduced by 4.9% (4.7 KB)", "94108", "98912", "", "10", "0", "1", "2021-01-01 15:12:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1057", "1165", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-345x198.jpeg", "", "Reduced by 6.6% (1.2 KB)", "17287", "18509", "", "10", "0", "1", "2021-01-01 15:12:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1058", "1165", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-400x260.jpeg", "", "Reduced by 6.0% (1.5 KB)", "24641", "26221", "", "10", "0", "1", "2021-01-01 15:12:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1059", "1165", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-500x380.jpeg", "", "Reduced by 5.6% (2.4 KB)", "41586", "44033", "", "10", "0", "1", "2021-01-01 15:12:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1060", "1165", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-500x500.jpeg", "", "Reduced by 5.5% (2.9 KB)", "51553", "54549", "", "10", "0", "1", "2021-01-01 15:12:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1061", "1165", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-1000x500.jpeg", "", "Reduced by 4.9% (4.8 KB)", "95823", "100768", "", "10", "0", "1", "2021-01-01 15:12:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1062", "1165", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-500x768.jpeg", "", "Reduced by 5.4% (4.5 KB)", "80934", "85536", "", "10", "0", "1", "2021-01-01 15:12:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1063", "1165", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-1000x768.jpeg", "", "Reduced by 5.2% (8.7 KB)", "161494", "170394", "", "10", "0", "1", "2021-01-01 15:12:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1064", "1165", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-700x525.jpeg", "", "Reduced by 4.9% (3.8 KB)", "74801", "78665", "", "10", "0", "1", "2021-01-01 15:12:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1065", "1165", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK4-1-539x303.jpeg", "", "Reduced by 5.6% (2.1 KB)", "37035", "39226", "", "10", "0", "1", "2021-01-01 15:12:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1066", "1166", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1.jpeg", "", "Reduced by 7.2% (18.6 KB)", "245551", "264607", "", "10", "0", "1", "2021-01-01 15:12:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1067", "1166", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-300x225.jpeg", "", "Reduced by 6.1% (983 B)", "15201", "16184", "", "10", "0", "1", "2021-01-01 15:12:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1068", "1166", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-150x150.jpeg", "", "Reduced by 8.0% (490 B)", "5613", "6103", "", "10", "0", "1", "2021-01-01 15:12:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1069", "1166", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-768x576.jpeg", "", "Reduced by 5.1% (4.0 KB)", "76348", "80417", "", "10", "0", "1", "2021-01-01 15:12:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1070", "1166", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-570x570.jpeg", "", "Reduced by 4.9% (2.7 KB)", "54836", "57643", "", "10", "0", "1", "2021-01-01 15:12:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1071", "1166", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-600x768.jpeg", "", "Reduced by 5.5% (4.4 KB)", "77660", "82141", "", "10", "0", "1", "2021-01-01 15:12:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1072", "1166", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-800x600.jpeg", "", "Reduced by 4.7% (4.0 KB)", "81294", "85345", "", "10", "0", "1", "2021-01-01 15:12:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1073", "1166", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-345x198.jpeg", "", "Reduced by 6.3% (1.0 KB)", "15828", "16888", "", "10", "0", "1", "2021-01-01 15:12:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1074", "1166", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-400x260.jpeg", "", "Reduced by 5.7% (1.3 KB)", "22308", "23657", "", "10", "0", "1", "2021-01-01 15:12:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1075", "1166", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-500x380.jpeg", "", "Reduced by 5.5% (2.1 KB)", "36786", "38937", "", "10", "0", "1", "2021-01-01 15:12:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1076", "1166", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-500x500.jpeg", "", "Reduced by 5.2% (2.3 KB)", "43742", "46118", "", "10", "0", "1", "2021-01-01 15:12:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1077", "1166", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-1000x500.jpeg", "", "Reduced by 4.7% (4.0 KB)", "83304", "87390", "", "10", "0", "1", "2021-01-01 15:12:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1078", "1166", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-500x768.jpeg", "", "Reduced by 5.3% (3.5 KB)", "64220", "67844", "", "10", "0", "1", "2021-01-01 15:12:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1079", "1166", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-1000x768.jpeg", "", "Reduced by 5.3% (7.5 KB)", "135998", "143681", "", "10", "0", "1", "2021-01-01 15:12:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1080", "1166", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-700x525.jpeg", "", "Reduced by 4.9% (3.3 KB)", "65242", "68611", "", "10", "0", "1", "2021-01-01 15:12:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1081", "1166", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Ada-OK5-1-539x303.jpeg", "", "Reduced by 5.1% (1.7 KB)", "33189", "34969", "", "10", "0", "1", "2021-01-01 15:12:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1082", "1167", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1.jpeg", "", "Reduced by 0.9% (1.7 KB)", "191013", "192777", "", "10", "0", "1", "2021-01-01 15:12:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1083", "1167", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-300x225.jpeg", "", "Reduced by 6.1% (969 B)", "14933", "15902", "", "10", "0", "1", "2021-01-01 15:12:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1084", "1167", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-150x150.jpeg", "", "Reduced by 7.2% (467 B)", "5990", "6457", "", "10", "0", "1", "2021-01-01 15:12:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1085", "1167", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-768x576.jpeg", "", "Reduced by 5.2% (3.7 KB)", "70005", "73824", "", "10", "0", "1", "2021-01-01 15:12:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1086", "1167", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-570x570.jpeg", "", "Reduced by 5.3% (2.9 KB)", "53404", "56409", "", "10", "0", "1", "2021-01-01 15:12:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1087", "1167", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-600x768.jpeg", "", "Reduced by 5.6% (4.2 KB)", "73707", "78043", "", "10", "0", "1", "2021-01-01 15:12:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1088", "1167", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-800x600.jpeg", "", "Reduced by 5.2% (4.0 KB)", "74056", "78103", "", "10", "0", "1", "2021-01-01 15:12:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1089", "1167", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-345x198.jpeg", "", "Reduced by 6.3% (1.0 KB)", "15297", "16331", "", "10", "0", "1", "2021-01-01 15:12:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1090", "1167", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-400x260.jpeg", "", "Reduced by 5.8% (1.3 KB)", "21432", "22746", "", "10", "0", "1", "2021-01-01 15:12:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1091", "1167", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-500x380.jpeg", "", "Reduced by 5.5% (2.0 KB)", "35144", "37204", "", "10", "0", "1", "2021-01-01 15:12:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1092", "1167", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-500x500.jpeg", "", "Reduced by 5.8% (2.6 KB)", "43044", "45694", "", "10", "0", "1", "2021-01-01 15:12:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1093", "1167", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-1000x500.jpeg", "", "Reduced by 4.7% (3.6 KB)", "75980", "79702", "", "10", "0", "1", "2021-01-01 15:12:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1094", "1167", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-500x768.jpeg", "", "Reduced by 5.5% (3.6 KB)", "62181", "65823", "", "10", "0", "1", "2021-01-01 15:12:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1095", "1167", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-1000x768.jpeg", "", "Reduced by 5.2% (6.3 KB)", "118579", "125072", "", "10", "0", "1", "2021-01-01 15:12:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1096", "1167", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-700x525.jpeg", "", "Reduced by 5.1% (3.2 KB)", "60213", "63479", "", "10", "0", "1", "2021-01-01 15:12:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1097", "1167", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK-1-539x303.jpeg", "", "Reduced by 5.4% (1.7 KB)", "31270", "33039", "", "10", "0", "1", "2021-01-01 15:12:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1098", "1168", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1.jpeg", "", "Reduced by 1.7% (2.1 KB)", "129594", "131791", "", "10", "0", "1", "2021-01-01 15:12:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1099", "1168", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-300x225.jpeg", "", "Reduced by 7.0% (708 B)", "9456", "10164", "", "10", "0", "1", "2021-01-01 15:12:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1100", "1168", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-150x150.jpeg", "", "Reduced by 10.3% (409 B)", "3570", "3979", "", "10", "0", "1", "2021-01-01 15:12:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1101", "1168", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-768x576.jpeg", "", "Reduced by 7.0% (3.3 KB)", "44991", "48355", "", "10", "0", "1", "2021-01-01 15:12:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1102", "1168", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-570x570.jpeg", "", "Reduced by 7.4% (2.5 KB)", "32578", "35172", "", "10", "0", "1", "2021-01-01 15:12:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1103", "1168", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-600x768.jpeg", "", "Reduced by 7.6% (3.6 KB)", "44777", "48434", "", "10", "0", "1", "2021-01-01 15:12:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1104", "1168", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-800x600.jpeg", "", "Reduced by 7.2% (3.6 KB)", "47795", "51477", "", "10", "0", "1", "2021-01-01 15:12:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1105", "1168", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-345x198.jpeg", "", "Reduced by 7.2% (771 B)", "9881", "10652", "", "10", "0", "1", "2021-01-01 15:12:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1106", "1168", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-400x260.jpeg", "", "Reduced by 7.2% (1.0 KB)", "13629", "14689", "", "10", "0", "1", "2021-01-01 15:12:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1107", "1168", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-500x380.jpeg", "", "Reduced by 6.7% (1.5 KB)", "22155", "23737", "", "10", "0", "1", "2021-01-01 15:12:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1108", "1168", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-500x500.jpeg", "", "Reduced by 7.8% (2.2 KB)", "25996", "28201", "", "10", "0", "1", "2021-01-01 15:12:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1109", "1168", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-1000x500.jpeg", "", "Reduced by 6.3% (3.5 KB)", "53512", "57128", "", "10", "0", "1", "2021-01-01 15:12:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1110", "1168", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-500x768.jpeg", "", "Reduced by 8.3% (3.2 KB)", "36714", "40033", "", "10", "0", "1", "2021-01-01 15:12:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1111", "1168", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-1000x768.jpeg", "", "Reduced by 7.2% (5.9 KB)", "76825", "82822", "", "10", "0", "1", "2021-01-01 15:12:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1112", "1168", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-700x525.jpeg", "", "Reduced by 6.8% (2.8 KB)", "38482", "41299", "", "10", "0", "1", "2021-01-01 15:12:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1113", "1168", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK2-1-539x303.jpeg", "", "Reduced by 6.7% (1.4 KB)", "20487", "21966", "", "10", "0", "1", "2021-01-01 15:12:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1114", "1169", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1.jpeg", "", "Reduced by 1.4% (2.1 KB)", "145447", "147555", "", "10", "0", "1", "2021-01-01 15:12:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1115", "1169", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-300x225.jpeg", "", "Reduced by 6.7% (742 B)", "10362", "11104", "", "10", "0", "1", "2021-01-01 15:12:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1116", "1169", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-150x150.jpeg", "", "Reduced by 9.2% (386 B)", "3830", "4216", "", "10", "0", "1", "2021-01-01 15:12:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1117", "1169", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-768x576.jpeg", "", "Reduced by 6.1% (3.2 KB)", "50889", "54174", "", "10", "0", "1", "2021-01-01 15:12:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1118", "1169", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-570x570.jpeg", "", "Reduced by 6.4% (2.4 KB)", "35936", "38408", "", "10", "0", "1", "2021-01-01 15:12:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1119", "1169", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-600x768.jpeg", "", "Reduced by 7.1% (3.6 KB)", "48280", "51943", "", "10", "0", "1", "2021-01-01 15:12:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1120", "1169", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-800x600.jpeg", "", "Reduced by 6.1% (3.4 KB)", "53861", "57352", "", "10", "0", "1", "2021-01-01 15:12:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1121", "1169", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-345x198.jpeg", "", "Reduced by 6.5% (774 B)", "11136", "11910", "", "10", "0", "1", "2021-01-01 15:12:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1122", "1169", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-400x260.jpeg", "", "Reduced by 6.6% (1.0 KB)", "15151", "16214", "", "10", "0", "1", "2021-01-01 15:12:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1123", "1169", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-500x380.jpeg", "", "Reduced by 6.4% (1.7 KB)", "24646", "26341", "", "10", "0", "1", "2021-01-01 15:12:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1124", "1169", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-500x500.jpeg", "", "Reduced by 6.8% (2.0 KB)", "28731", "30814", "", "10", "0", "1", "2021-01-01 15:12:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1125", "1169", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-1000x500.jpeg", "", "Reduced by 5.7% (3.6 KB)", "60619", "64292", "", "10", "0", "1", "2021-01-01 15:12:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1126", "1169", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-500x768.jpeg", "", "Reduced by 8.0% (3.3 KB)", "39081", "42498", "", "10", "0", "1", "2021-01-01 15:12:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1127", "1169", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-1000x768.jpeg", "", "Reduced by 6.3% (5.7 KB)", "86704", "92547", "", "10", "0", "1", "2021-01-01 15:12:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1128", "1169", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-700x525.jpeg", "", "Reduced by 6.1% (2.7 KB)", "43469", "46273", "", "10", "0", "1", "2021-01-01 15:12:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1129", "1169", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK3-1-539x303.jpeg", "", "Reduced by 6.4% (1.5 KB)", "23130", "24710", "", "10", "0", "1", "2021-01-01 15:12:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1130", "1171", "media", "full", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1.jpeg", "", "Reduced by 0.7% (2.1 KB)", "322201", "324311", "", "10", "0", "1", "2021-01-01 15:13:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1131", "1171", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-300x225.jpeg", "", "Reduced by 6.2% (1.2 KB)", "19142", "20404", "", "10", "0", "1", "2021-01-01 15:13:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1132", "1171", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-150x150.jpeg", "", "Reduced by 7.2% (542 B)", "7026", "7568", "", "10", "0", "1", "2021-01-01 15:13:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1133", "1171", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-768x576.jpeg", "", "Reduced by 5.9% (6.7 KB)", "109050", "115871", "", "10", "0", "1", "2021-01-01 15:13:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1134", "1171", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-570x570.jpeg", "", "Reduced by 5.8% (4.9 KB)", "81136", "86113", "", "10", "0", "1", "2021-01-01 15:13:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1135", "1171", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-600x768.jpeg", "", "Reduced by 6.2% (8.0 KB)", "123998", "132225", "", "10", "0", "1", "2021-01-01 15:13:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1136", "1171", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-800x600.jpeg", "", "Reduced by 5.9% (7.1 KB)", "115897", "123145", "", "10", "0", "1", "2021-01-01 15:13:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1137", "1171", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-345x198.jpeg", "", "Reduced by 6.8% (1.5 KB)", "20750", "22274", "", "10", "0", "1", "2021-01-01 15:13:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1138", "1171", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-400x260.jpeg", "", "Reduced by 6.5% (2.0 KB)", "29180", "31215", "", "10", "0", "1", "2021-01-01 15:13:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1139", "1171", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-500x380.jpeg", "", "Reduced by 6.1% (3.2 KB)", "49884", "53129", "", "10", "0", "1", "2021-01-01 15:13:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1140", "1171", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-500x500.jpeg", "", "Reduced by 6.1% (4.1 KB)", "63867", "68042", "", "10", "0", "1", "2021-01-01 15:13:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1141", "1171", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-1000x500.jpeg", "", "Reduced by 5.8% (7.9 KB)", "132431", "140535", "", "10", "0", "1", "2021-01-01 15:13:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1142", "1171", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-500x768.jpeg", "", "Reduced by 6.2% (6.7 KB)", "103692", "110577", "", "10", "0", "1", "2021-01-01 15:13:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1143", "1171", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-1000x768.jpeg", "", "Reduced by 6.1% (12.8 KB)", "202739", "215826", "", "10", "0", "1", "2021-01-01 15:13:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1144", "1171", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-700x525.jpeg", "", "Reduced by 5.9% (5.7 KB)", "91744", "97536", "", "10", "0", "1", "2021-01-01 15:13:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1145", "1171", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Carlisle-TPO-Project-Tulsa-OK4-1-539x303.jpeg", "", "Reduced by 6.3% (3.1 KB)", "47152", "50300", "", "10", "0", "1", "2021-01-01 15:13:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1146", "1172", "media", "full", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1.jpg", "", "Reduced by 0.7% (5.4 KB)", "807977", "813505", "", "10", "0", "1", "2021-01-01 15:13:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1147", "1172", "media", "medium", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-300x169.jpg", "", "Reduced by 6.9% (1.1 KB)", "15194", "16319", "", "10", "0", "1", "2021-01-01 15:13:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1148", "1172", "media", "large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-1024x576.jpg", "", "Reduced by 6.1% (9.6 KB)", "150277", "160068", "", "10", "0", "1", "2021-01-01 15:13:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1149", "1172", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-150x150.jpg", "", "Reduced by 8.0% (596 B)", "6854", "7450", "", "10", "0", "1", "2021-01-01 15:13:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1150", "1172", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-768x432.jpg", "", "Reduced by 6.2% (5.6 KB)", "87007", "92752", "", "10", "0", "1", "2021-01-01 15:13:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1151", "1172", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-1536x864.jpg", "", "Reduced by 5.7% (18.6 KB)", "312573", "331606", "", "10", "0", "1", "2021-01-01 15:13:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1152", "1172", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-2048x1152.jpg", "", "Reduced by 5.4% (28.3 KB)", "504297", "533238", "", "10", "0", "1", "2021-01-01 15:13:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1153", "1172", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-570x570.jpg", "", "Reduced by 5.8% (5.0 KB)", "83275", "88396", "", "10", "0", "1", "2021-01-01 15:13:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1154", "1172", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-600x800.jpg", "", "Reduced by 5.8% (6.9 KB)", "115153", "122231", "", "10", "0", "1", "2021-01-01 15:13:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1155", "1172", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-800x600.jpg", "", "Reduced by 6.0% (7.5 KB)", "120859", "128574", "", "10", "0", "1", "2021-01-01 15:13:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1156", "1172", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-345x198.jpg", "", "Reduced by 6.6% (1.4 KB)", "19969", "21369", "", "10", "0", "1", "2021-01-01 15:13:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1157", "1172", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-400x260.jpg", "", "Reduced by 6.2% (1.9 KB)", "29124", "31060", "", "10", "0", "1", "2021-01-01 15:13:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1158", "1172", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-500x380.jpg", "", "Reduced by 6.2% (3.3 KB)", "50977", "54334", "", "10", "0", "1", "2021-01-01 15:13:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1159", "1172", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-500x500.jpg", "", "Reduced by 6.1% (4.1 KB)", "65000", "69198", "", "10", "0", "1", "2021-01-01 15:13:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1160", "1172", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-1000x500.jpg", "", "Reduced by 6.0% (8.0 KB)", "127850", "136041", "", "10", "0", "1", "2021-01-01 15:13:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1161", "1172", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-500x1000.jpg", "", "Reduced by 5.7% (6.5 KB)", "111174", "117851", "", "10", "0", "1", "2021-01-01 15:13:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1162", "1172", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-1000x1000.jpg", "", "Reduced by 5.7% (13.3 KB)", "224793", "238369", "", "10", "0", "1", "2021-01-01 15:13:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1163", "1172", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-700x394.jpg", "", "Reduced by 5.8% (4.5 KB)", "74133", "78725", "", "10", "0", "1", "2021-01-01 15:13:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1164", "1172", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO-scaled-1-539x303.jpg", "", "Reduced by 6.4% (3.0 KB)", "44765", "47801", "", "10", "0", "1", "2021-01-01 15:13:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1165", "1173", "media", "full", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1.jpg", "", "Reduced by 0.7% (5.3 KB)", "822444", "827895", "", "10", "0", "1", "2021-01-01 15:13:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1166", "1173", "media", "medium", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-300x169.jpg", "", "Reduced by 6.9% (1.1 KB)", "14664", "15745", "", "10", "0", "1", "2021-01-01 15:13:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1167", "1173", "media", "large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-1024x576.jpg", "", "Reduced by 6.0% (9.1 KB)", "146171", "155477", "", "10", "0", "1", "2021-01-01 15:13:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1168", "1173", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-150x150.jpg", "", "Reduced by 7.6% (555 B)", "6731", "7286", "", "10", "0", "1", "2021-01-01 15:13:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1169", "1173", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-768x432.jpg", "", "Reduced by 6.2% (5.4 KB)", "84074", "89601", "", "10", "0", "1", "2021-01-01 15:13:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1170", "1173", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-1536x864.jpg", "", "Reduced by 5.7% (18.2 KB)", "307526", "326193", "", "10", "0", "1", "2021-01-01 15:13:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1171", "1173", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-2048x1152.jpg", "", "Reduced by 5.3% (27.7 KB)", "504250", "532657", "", "10", "0", "1", "2021-01-01 15:13:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1172", "1173", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-570x570.jpg", "", "Reduced by 5.7% (4.8 KB)", "81286", "86219", "", "10", "0", "1", "2021-01-01 15:13:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1173", "1173", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-600x800.jpg", "", "Reduced by 5.8% (6.8 KB)", "112338", "119257", "", "10", "0", "1", "2021-01-01 15:13:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1174", "1173", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-800x600.jpg", "", "Reduced by 5.9% (7.3 KB)", "118465", "125893", "", "10", "0", "1", "2021-01-01 15:13:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1175", "1173", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-345x198.jpg", "", "Reduced by 6.5% (1.3 KB)", "19072", "20398", "", "10", "0", "1", "2021-01-01 15:13:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1176", "1173", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-400x260.jpg", "", "Reduced by 6.1% (1.7 KB)", "27580", "29368", "", "10", "0", "1", "2021-01-01 15:13:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1177", "1173", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-500x380.jpg", "", "Reduced by 6.1% (3.1 KB)", "49327", "52547", "", "10", "0", "1", "2021-01-01 15:13:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1178", "1173", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-500x500.jpg", "", "Reduced by 5.9% (3.9 KB)", "63475", "67437", "", "10", "0", "1", "2021-01-01 15:13:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1179", "1173", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-1000x500.jpg", "", "Reduced by 6.0% (7.7 KB)", "123741", "131588", "", "10", "0", "1", "2021-01-01 15:13:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1180", "1173", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-500x1000.jpg", "", "Reduced by 5.8% (6.6 KB)", "111336", "118138", "", "10", "0", "1", "2021-01-01 15:13:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1181", "1173", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-1000x1000.jpg", "", "Reduced by 5.7% (13.1 KB)", "222242", "235669", "", "10", "0", "1", "2021-01-01 15:13:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1182", "1173", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-700x394.jpg", "", "Reduced by 6.2% (4.6 KB)", "71254", "75934", "", "10", "0", "1", "2021-01-01 15:13:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1183", NULL, NULL, NULL, "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-100x50.jpg", "", "Reduced by 23.2% (374 B)", "1240", "1614", "", "10", "0", "1", "2021-01-01 15:13:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1184", "1173", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO2-scaled-1-539x303.jpg", "", "Reduced by 6.0% (2.7 KB)", "42935", "45675", "", "10", "0", "1", "2021-01-01 15:13:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1185", NULL, NULL, NULL, "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-100x50.jpg", "", "Reduced by 19.4% (385 B)", "1599", "1984", "", "10", "0", "1", "2021-01-01 15:13:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1186", "1174", "media", "full", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1.jpg", "", "Reduced by 0.7% (4.3 KB)", "615371", "619727", "", "10", "0", "1", "2021-01-01 15:13:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1187", "1174", "media", "medium", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-300x169.jpg", "", "Reduced by 6.2% (884 B)", "13273", "14157", "", "10", "0", "1", "2021-01-01 15:13:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1188", "1174", "media", "large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-1024x576.jpg", "", "Reduced by 5.3% (6.6 KB)", "119988", "126770", "", "10", "0", "1", "2021-01-01 15:13:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1189", "1174", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-150x150.jpg", "", "Reduced by 7.2% (471 B)", "6100", "6571", "", "10", "0", "1", "2021-01-01 15:13:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1190", "1174", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-768x432.jpg", "", "Reduced by 5.4% (4.0 KB)", "71415", "75497", "", "10", "0", "1", "2021-01-01 15:13:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1191", "1174", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-1536x864.jpg", "", "Reduced by 4.9% (12.2 KB)", "243168", "255622", "", "10", "0", "1", "2021-01-01 15:13:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1192", "1174", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-2048x1152.jpg", "", "Reduced by 4.7% (18.8 KB)", "390597", "409798", "", "10", "0", "1", "2021-01-01 15:13:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1193", "1174", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-570x570.jpg", "", "Reduced by 5.0% (3.1 KB)", "61767", "64989", "", "10", "0", "1", "2021-01-01 15:13:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1194", "1174", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-600x800.jpg", "", "Reduced by 4.8% (4.0 KB)", "81706", "85841", "", "10", "0", "1", "2021-01-01 15:13:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1195", "1174", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-800x600.jpg", "", "Reduced by 5.1% (4.9 KB)", "94138", "99206", "", "10", "0", "1", "2021-01-01 15:13:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1196", "1174", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-345x198.jpg", "", "Reduced by 6.2% (1.1 KB)", "17347", "18503", "", "10", "0", "1", "2021-01-01 15:13:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1197", "1174", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-400x260.jpg", "", "Reduced by 5.7% (1.5 KB)", "24787", "26281", "", "10", "0", "1", "2021-01-01 15:13:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1198", "1174", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-500x380.jpg", "", "Reduced by 5.2% (2.2 KB)", "41289", "43553", "", "10", "0", "1", "2021-01-01 15:13:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1199", "1174", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-500x500.jpg", "", "Reduced by 5.3% (2.7 KB)", "49085", "51842", "", "10", "0", "1", "2021-01-01 15:13:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1200", "1174", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-1000x500.jpg", "", "Reduced by 5.3% (5.6 KB)", "102527", "108266", "", "10", "0", "1", "2021-01-01 15:14:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1201", "1174", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-500x1000.jpg", "", "Reduced by 4.8% (4.0 KB)", "80234", "84290", "", "10", "0", "1", "2021-01-01 15:14:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1202", "1174", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-1000x1000.jpg", "", "Reduced by 4.9% (8.1 KB)", "160153", "168438", "", "10", "0", "1", "2021-01-01 15:14:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1203", "1174", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-700x394.jpg", "", "Reduced by 5.3% (3.3 KB)", "60832", "64250", "", "10", "0", "1", "2021-01-01 15:14:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1204", "1174", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO3-scaled-1-539x303.jpg", "", "Reduced by 5.5% (2.1 KB)", "37858", "40059", "", "10", "0", "1", "2021-01-01 15:14:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1205", "1176", "media", "full", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1.jpg", "", "Reduced by 1.1% (6.9 KB)", "635914", "642945", "", "10", "0", "1", "2021-01-01 15:14:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1206", "1176", "media", "medium", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-300x169.jpg", "", "Reduced by 6.0% (760 B)", "11862", "12622", "", "10", "0", "1", "2021-01-01 15:14:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1207", "1176", "media", "large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-1024x576.jpg", "", "Reduced by 5.2% (6.2 KB)", "114301", "120626", "", "10", "0", "1", "2021-01-01 15:14:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1208", "1176", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-150x150.jpg", "", "Reduced by 8.1% (474 B)", "5364", "5838", "", "10", "0", "1", "2021-01-01 15:14:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1209", "1176", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-768x432.jpg", "", "Reduced by 5.2% (3.6 KB)", "66249", "69886", "", "10", "0", "1", "2021-01-01 15:14:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1210", "1176", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-1536x864.jpg", "", "Reduced by 5.0% (12.4 KB)", "240231", "252966", "", "10", "0", "1", "2021-01-01 15:14:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1211", "1176", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-2048x1152.jpg", "", "Reduced by 5.0% (20.2 KB)", "393523", "414232", "", "10", "0", "1", "2021-01-01 15:14:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1212", "1176", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-570x570.jpg", "", "Reduced by 4.9% (2.9 KB)", "58835", "61847", "", "10", "0", "1", "2021-01-01 15:14:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1213", "1176", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-600x800.jpg", "", "Reduced by 5.4% (4.3 KB)", "76253", "80608", "", "10", "0", "1", "2021-01-01 15:14:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1214", "1176", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-800x600.jpg", "", "Reduced by 5.2% (4.8 KB)", "89989", "94908", "", "10", "0", "1", "2021-01-01 15:14:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1215", "1176", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-345x198.jpg", "", "Reduced by 6.2% (1,011 B)", "15369", "16380", "", "10", "0", "1", "2021-01-01 15:14:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1216", "1176", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-400x260.jpg", "", "Reduced by 5.4% (1.2 KB)", "22399", "23678", "", "10", "0", "1", "2021-01-01 15:14:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1217", "1176", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-500x380.jpg", "", "Reduced by 5.2% (2.1 KB)", "38183", "40296", "", "10", "0", "1", "2021-01-01 15:14:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1218", "1176", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-500x500.jpg", "", "Reduced by 5.1% (2.4 KB)", "46067", "48563", "", "10", "0", "1", "2021-01-01 15:14:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1219", "1176", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-1000x500.jpg", "", "Reduced by 5.1% (5.2 KB)", "99020", "104342", "", "10", "0", "1", "2021-01-01 15:14:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1220", "1176", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-500x1000.jpg", "", "Reduced by 5.9% (4.3 KB)", "69832", "74187", "", "10", "0", "1", "2021-01-01 15:14:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1221", "1176", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-1000x1000.jpg", "", "Reduced by 5.7% (9.4 KB)", "160690", "170352", "", "10", "0", "1", "2021-01-01 15:14:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1222", "1176", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-700x394.jpg", "", "Reduced by 5.2% (3.0 KB)", "56223", "59305", "", "10", "0", "1", "2021-01-01 15:14:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1223", "1176", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/DaVinci-Roof-Project-Fort-Collins-CO4-scaled-1-539x303.jpg", "", "Reduced by 5.1% (1.8 KB)", "34343", "36193", "", "10", "0", "1", "2021-01-01 15:14:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1224", "1177", "media", "full", "ABSPATHwp-content/uploads/2016/02/1-1-1.jpg", "", "Reduced by 0.7% (1.2 KB)", "170782", "172033", "", "10", "0", "1", "2021-01-01 15:14:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1225", "1177", "media", "medium", "ABSPATHwp-content/uploads/2016/02/1-1-1-300x253.jpg", "", "Reduced by 5.2% (930 B)", "16965", "17895", "", "10", "0", "1", "2021-01-01 15:14:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1226", "1177", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/1-1-1-150x150.jpg", "", "Reduced by 7.8% (464 B)", "5514", "5978", "", "10", "0", "1", "2021-01-01 15:14:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1227", "1177", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/1-1-1-345x198.jpg", "", "Reduced by 5.5% (945 B)", "16264", "17209", "", "10", "0", "1", "2021-01-01 15:14:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1228", "1177", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/1-1-1-400x260.jpg", "", "Reduced by 4.6% (1.1 KB)", "23117", "24243", "", "10", "0", "1", "2021-01-01 15:14:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1229", "1177", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/1-1-1-475x380.jpg", "", "Reduced by 4.9% (2.1 KB)", "41370", "43504", "", "10", "0", "1", "2021-01-01 15:14:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1230", "1177", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/1-1-1-475x303.jpg", "", "Reduced by 4.6% (1.6 KB)", "34976", "36652", "", "10", "0", "1", "2021-01-01 15:14:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1231", "1178", "media", "full", "ABSPATHwp-content/uploads/2016/02/2-2-1.jpg", "", "Reduced by 0.8% (1.4 KB)", "182993", "184413", "", "10", "0", "1", "2021-01-01 15:14:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1232", "1178", "media", "medium", "ABSPATHwp-content/uploads/2016/02/2-2-1-300x253.jpg", "", "Reduced by 6.3% (1.4 KB)", "21404", "22836", "", "10", "0", "1", "2021-01-01 15:14:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1233", "1178", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/2-2-1-150x150.jpg", "", "Reduced by 7.9% (606 B)", "7043", "7649", "", "10", "0", "1", "2021-01-01 15:14:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1234", "1178", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/2-2-1-345x198.jpg", "", "Reduced by 6.1% (1.2 KB)", "19257", "20516", "", "10", "0", "1", "2021-01-01 15:14:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1235", "1178", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/2-2-1-400x260.jpg", "", "Reduced by 5.7% (1.6 KB)", "27535", "29195", "", "10", "0", "1", "2021-01-01 15:14:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1236", "1178", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/2-2-1-475x380.jpg", "", "Reduced by 5.6% (3.1 KB)", "53166", "56321", "", "10", "0", "1", "2021-01-01 15:14:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1237", "1178", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/2-2-1-475x303.jpg", "", "Reduced by 5.7% (2.5 KB)", "42071", "44616", "", "10", "0", "1", "2021-01-01 15:14:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1238", "1179", "media", "full", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1.jpeg", "", "Reduced by 0.5% (1.6 KB)", "348461", "350052", "", "10", "0", "1", "2021-01-01 15:14:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1239", "1179", "media", "medium", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-300x225.jpeg", "", "Reduced by 6.9% (1.3 KB)", "18755", "20136", "", "10", "0", "1", "2021-01-01 15:14:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1240", "1179", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-150x150.jpeg", "", "Reduced by 7.9% (612 B)", "7107", "7719", "", "10", "0", "1", "2021-01-01 15:14:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1241", "1179", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-768x576.jpeg", "", "Reduced by 5.7% (6.4 KB)", "108415", "114936", "", "10", "0", "1", "2021-01-01 15:14:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1242", "1179", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-570x570.jpeg", "", "Reduced by 5.4% (4.5 KB)", "80034", "84610", "", "10", "0", "1", "2021-01-01 15:14:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1243", "1179", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-600x768.jpeg", "", "Reduced by 5.7% (7.3 KB)", "124029", "131462", "", "10", "0", "1", "2021-01-01 15:14:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1244", "1179", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-800x600.jpeg", "", "Reduced by 5.5% (6.6 KB)", "115109", "121867", "", "10", "0", "1", "2021-01-01 15:14:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1245", "1179", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-345x198.jpeg", "", "Reduced by 6.7% (1.3 KB)", "18200", "19497", "", "10", "0", "1", "2021-01-01 15:14:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1246", "1179", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-400x260.jpeg", "", "Reduced by 6.3% (1.8 KB)", "27081", "28889", "", "10", "0", "1", "2021-01-01 15:14:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1247", "1179", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-500x380.jpeg", "", "Reduced by 6.3% (3.2 KB)", "49347", "52665", "", "10", "0", "1", "2021-01-01 15:14:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1248", "1179", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-500x500.jpeg", "", "Reduced by 5.9% (3.8 KB)", "63085", "67012", "", "10", "0", "1", "2021-01-01 15:14:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1249", "1179", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-1000x500.jpeg", "", "Reduced by 5.5% (6.5 KB)", "114565", "121247", "", "10", "0", "1", "2021-01-01 15:14:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1250", "1179", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-500x768.jpeg", "", "Reduced by 5.4% (5.9 KB)", "105548", "111549", "", "10", "0", "1", "2021-01-01 15:14:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1251", "1179", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-1000x768.jpeg", "", "Reduced by 5.5% (11.8 KB)", "206313", "218434", "", "10", "0", "1", "2021-01-01 15:14:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1252", "1179", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-700x525.jpeg", "", "Reduced by 5.7% (5.3 KB)", "91000", "96470", "", "10", "0", "1", "2021-01-01 15:14:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1253", "1179", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO-1-539x303.jpeg", "", "Reduced by 6.0% (2.6 KB)", "40936", "43552", "", "10", "0", "1", "2021-01-01 15:14:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1254", "1180", "media", "full", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1.jpeg", "", "Reduced by 0.5% (1.2 KB)", "258609", "259837", "", "10", "0", "1", "2021-01-01 15:14:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1255", "1180", "media", "medium", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-300x225.jpeg", "", "Reduced by 6.5% (979 B)", "13999", "14978", "", "10", "0", "1", "2021-01-01 15:14:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1256", "1180", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-150x150.jpeg", "", "Reduced by 7.8% (458 B)", "5397", "5855", "", "10", "0", "1", "2021-01-01 15:14:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1257", "1180", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-768x576.jpeg", "", "Reduced by 5.6% (4.5 KB)", "77578", "82168", "", "10", "0", "1", "2021-01-01 15:14:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1258", "1180", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-570x570.jpeg", "", "Reduced by 5.3% (3.0 KB)", "54937", "58015", "", "10", "0", "1", "2021-01-01 15:14:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1259", "1180", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-600x768.jpeg", "", "Reduced by 5.3% (4.5 KB)", "81411", "85993", "", "10", "0", "1", "2021-01-01 15:14:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1260", "1180", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-800x600.jpeg", "", "Reduced by 5.4% (4.6 KB)", "82773", "87510", "", "10", "0", "1", "2021-01-01 15:14:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1261", "1180", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-345x198.jpeg", "", "Reduced by 6.9% (1.1 KB)", "15687", "16845", "", "10", "0", "1", "2021-01-01 15:14:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1262", "1180", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-400x260.jpeg", "", "Reduced by 6.2% (1.4 KB)", "21674", "23099", "", "10", "0", "1", "2021-01-01 15:14:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1263", "1180", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-500x380.jpeg", "", "Reduced by 6.0% (2.2 KB)", "35326", "37587", "", "10", "0", "1", "2021-01-01 15:14:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1264", "1180", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-500x500.jpeg", "", "Reduced by 5.8% (2.6 KB)", "43208", "45851", "", "10", "0", "1", "2021-01-01 15:14:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1265", "1180", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-1000x500.jpeg", "", "Reduced by 5.1% (5.2 KB)", "100695", "106062", "", "10", "0", "1", "2021-01-01 15:14:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1266", "1180", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-500x768.jpeg", "", "Reduced by 5.4% (3.7 KB)", "67538", "71366", "", "10", "0", "1", "2021-01-01 15:14:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1267", "1180", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-1000x768.jpeg", "", "Reduced by 5.7% (8.7 KB)", "146586", "155467", "", "10", "0", "1", "2021-01-01 15:14:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1268", "1180", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-700x525.jpeg", "", "Reduced by 5.5% (3.7 KB)", "65194", "68996", "", "10", "0", "1", "2021-01-01 15:14:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1269", "1180", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO2-1-539x303.jpeg", "", "Reduced by 5.9% (2.1 KB)", "34960", "37142", "", "10", "0", "1", "2021-01-01 15:14:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1270", "1181", "media", "full", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1.jpeg", "", "Reduced by 0.5% (1.2 KB)", "258581", "259839", "", "10", "0", "1", "2021-01-01 15:15:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1271", "1181", "media", "medium", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-300x225.jpeg", "", "Reduced by 6.2% (905 B)", "13677", "14582", "", "10", "0", "1", "2021-01-01 15:15:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1272", "1181", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-150x150.jpeg", "", "Reduced by 8.0% (459 B)", "5254", "5713", "", "10", "0", "1", "2021-01-01 15:15:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1273", "1181", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-768x576.jpeg", "", "Reduced by 5.8% (4.6 KB)", "76601", "81303", "", "10", "0", "1", "2021-01-01 15:15:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1274", "1181", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-570x570.jpeg", "", "Reduced by 5.5% (3.2 KB)", "56593", "59856", "", "10", "0", "1", "2021-01-01 15:15:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1275", "1181", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-600x768.jpeg", "", "Reduced by 6.3% (5.9 KB)", "89479", "95521", "", "10", "0", "1", "2021-01-01 15:15:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1276", "1181", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-800x600.jpeg", "", "Reduced by 5.7% (4.8 KB)", "81739", "86665", "", "10", "0", "1", "2021-01-01 15:15:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1277", "1181", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-345x198.jpeg", "", "Reduced by 6.7% (1.0 KB)", "14569", "15618", "", "10", "0", "1", "2021-01-01 15:15:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1278", "1181", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-400x260.jpeg", "", "Reduced by 6.2% (1.3 KB)", "20635", "21992", "", "10", "0", "1", "2021-01-01 15:15:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1279", "1181", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-500x380.jpeg", "", "Reduced by 6.2% (2.2 KB)", "34907", "37199", "", "10", "0", "1", "2021-01-01 15:15:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1280", "1181", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-500x500.jpeg", "", "Reduced by 5.9% (2.7 KB)", "44212", "46980", "", "10", "0", "1", "2021-01-01 15:15:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1281", "1181", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-1000x500.jpeg", "", "Reduced by 5.3% (5.0 KB)", "91235", "96306", "", "10", "0", "1", "2021-01-01 15:15:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1282", "1181", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-500x768.jpeg", "", "Reduced by 6.5% (5.3 KB)", "77652", "83035", "", "10", "0", "1", "2021-01-01 15:15:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1283", "1181", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-1000x768.jpeg", "", "Reduced by 6.3% (9.6 KB)", "147472", "157326", "", "10", "0", "1", "2021-01-01 15:15:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1284", "1181", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-700x525.jpeg", "", "Reduced by 5.7% (3.8 KB)", "64068", "67962", "", "10", "0", "1", "2021-01-01 15:15:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1285", "1181", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/F-Wave-Roof-Project-Fort-Collins-CO3-1-539x303.jpeg", "", "Reduced by 6.0% (2.0 KB)", "32384", "34453", "", "10", "0", "1", "2021-01-01 15:15:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1286", "1182", "media", "full", "ABSPATHwp-content/uploads/2016/02/3-1-1.jpg", "", "Reduced by 0.3% (529 B)", "153989", "154518", "", "10", "0", "1", "2021-01-01 15:15:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1287", "1182", "media", "medium", "ABSPATHwp-content/uploads/2016/02/3-1-1-300x253.jpg", "", "Reduced by 5.9% (852 B)", "13514", "14366", "", "10", "0", "1", "2021-01-01 15:15:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1288", "1182", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/3-1-1-150x150.jpg", "", "Reduced by 8.1% (424 B)", "4822", "5246", "", "10", "0", "1", "2021-01-01 15:15:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1289", "1182", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/3-1-1-345x198.jpg", "", "Reduced by 6.0% (799 B)", "12523", "13322", "", "10", "0", "1", "2021-01-01 15:15:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1290", "1182", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/3-1-1-400x260.jpg", "", "Reduced by 5.5% (1.0 KB)", "17903", "18947", "", "10", "0", "1", "2021-01-01 15:15:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1291", "1182", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/3-1-1-475x380.jpg", "", "Reduced by 5.2% (1.8 KB)", "32653", "34455", "", "10", "0", "1", "2021-01-01 15:15:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1292", "1182", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/3-1-1-475x303.jpg", "", "Reduced by 5.5% (1.5 KB)", "26839", "28394", "", "10", "0", "1", "2021-01-01 15:15:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1293", "1183", "media", "full", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1.jpg", "", "Reduced by 0.9% (6.4 KB)", "743448", "749995", "", "10", "0", "1", "2021-01-01 15:15:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1294", "1183", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-300x225.jpg", "", "Reduced by 6.1% (969 B)", "14920", "15889", "", "10", "0", "1", "2021-01-01 15:15:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1295", "1183", "media", "large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-1024x768.jpg", "", "Reduced by 5.3% (7.6 KB)", "138977", "146794", "", "10", "0", "1", "2021-01-01 15:15:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1296", "1183", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-150x150.jpg", "", "Reduced by 8.5% (521 B)", "5591", "6112", "", "10", "0", "1", "2021-01-01 15:15:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1297", "1183", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-768x576.jpg", "", "Reduced by 5.4% (4.6 KB)", "81577", "86258", "", "10", "0", "1", "2021-01-01 15:15:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1298", "1183", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-1536x1152.jpg", "", "Reduced by 5.0% (14.7 KB)", "287440", "302462", "", "10", "0", "1", "2021-01-01 15:15:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1299", "1183", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-2048x1536.jpg", "", "Reduced by 4.7% (22.4 KB)", "468251", "491231", "", "10", "0", "1", "2021-01-01 15:15:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1300", "1183", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-570x570.jpg", "", "Reduced by 5.4% (3.4 KB)", "60712", "64190", "", "10", "0", "1", "2021-01-01 15:15:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1301", "1183", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-600x800.jpg", "", "Reduced by 5.6% (4.9 KB)", "84589", "89623", "", "10", "0", "1", "2021-01-01 15:15:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1302", "1183", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-800x600.jpg", "", "Reduced by 5.5% (5.0 KB)", "87961", "93060", "", "10", "0", "1", "2021-01-01 15:15:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1303", "1183", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-345x198.jpg", "", "Reduced by 6.2% (995 B)", "15047", "16042", "", "10", "0", "1", "2021-01-01 15:15:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1304", "1183", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-400x260.jpg", "", "Reduced by 5.5% (1.2 KB)", "21704", "22956", "", "10", "0", "1", "2021-01-01 15:15:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1305", "1183", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-500x380.jpg", "", "Reduced by 5.3% (2.1 KB)", "37723", "39836", "", "10", "0", "1", "2021-01-01 15:15:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1306", "1183", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-500x500.jpg", "", "Reduced by 5.5% (2.7 KB)", "47792", "50593", "", "10", "0", "1", "2021-01-01 15:15:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1307", "1183", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-1000x500.jpg", "", "Reduced by 5.7% (5.5 KB)", "92655", "98304", "", "10", "0", "1", "2021-01-01 15:15:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1308", "1183", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-500x1000.jpg", "", "Reduced by 5.4% (4.8 KB)", "86548", "91460", "", "10", "0", "1", "2021-01-01 15:15:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1309", "1183", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-1000x1000.jpg", "", "Reduced by 5.2% (8.9 KB)", "165710", "174836", "", "10", "0", "1", "2021-01-01 15:15:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1310", "1183", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-700x525.jpg", "", "Reduced by 5.4% (3.9 KB)", "69001", "72951", "", "10", "0", "1", "2021-01-01 15:15:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1311", "1183", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO-scaled-1-539x303.jpg", "", "Reduced by 5.3% (1.8 KB)", "32868", "34704", "", "10", "0", "1", "2021-01-01 15:15:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1312", "1184", "media", "full", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1.jpg", "", "Reduced by 2.0% (11.5 KB)", "584543", "596306", "", "10", "0", "1", "2021-01-01 15:15:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1313", "1184", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-300x225.jpg", "", "Reduced by 6.3% (830 B)", "12379", "13209", "", "10", "0", "1", "2021-01-01 15:15:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1314", "1184", "media", "large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-1024x768.jpg", "", "Reduced by 5.8% (6.5 KB)", "108407", "115028", "", "10", "0", "1", "2021-01-01 15:15:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1315", "1184", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-150x150.jpg", "", "Reduced by 8.0% (429 B)", "4904", "5333", "", "10", "0", "1", "2021-01-01 15:15:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1316", "1184", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-768x576.jpg", "", "Reduced by 5.7% (3.8 KB)", "63802", "67674", "", "10", "0", "1", "2021-01-01 15:15:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1317", "1184", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-1536x1152.jpg", "", "Reduced by 5.4% (12.7 KB)", "226222", "239251", "", "10", "0", "1", "2021-01-01 15:15:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1318", "1184", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-2048x1536.jpg", "", "Reduced by 5.5% (21.0 KB)", "370855", "392391", "", "10", "0", "1", "2021-01-01 15:15:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1319", "1184", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-570x570.jpg", "", "Reduced by 5.9% (2.8 KB)", "46629", "49531", "", "10", "0", "1", "2021-01-01 15:15:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1320", "1184", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-600x800.jpg", "", "Reduced by 5.7% (3.8 KB)", "64239", "68141", "", "10", "0", "1", "2021-01-01 15:15:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1321", "1184", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-800x600.jpg", "", "Reduced by 5.7% (4.0 KB)", "68869", "73007", "", "10", "0", "1", "2021-01-01 15:15:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1322", "1184", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-345x198.jpg", "", "Reduced by 6.6% (863 B)", "12269", "13132", "", "10", "0", "1", "2021-01-01 15:15:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1323", "1184", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-400x260.jpg", "", "Reduced by 5.7% (1.0 KB)", "17607", "18674", "", "10", "0", "1", "2021-01-01 15:15:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1324", "1184", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-500x380.jpg", "", "Reduced by 6.0% (1.8 KB)", "29894", "31787", "", "10", "0", "1", "2021-01-01 15:15:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1325", "1184", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-500x500.jpg", "", "Reduced by 6.1% (2.3 KB)", "36849", "39255", "", "10", "0", "1", "2021-01-01 15:15:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1326", "1184", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-1000x500.jpg", "", "Reduced by 6.1% (4.5 KB)", "70797", "75380", "", "10", "0", "1", "2021-01-01 15:15:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1327", "1184", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-500x1000.jpg", "", "Reduced by 5.6% (3.8 KB)", "65770", "69698", "", "10", "0", "1", "2021-01-01 15:15:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1328", "1184", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-1000x1000.jpg", "", "Reduced by 5.7% (7.6 KB)", "129352", "137115", "", "10", "0", "1", "2021-01-01 15:15:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1329", "1184", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-700x525.jpg", "", "Reduced by 5.7% (3.2 KB)", "54228", "57531", "", "10", "0", "1", "2021-01-01 15:15:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1330", "1184", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO2-scaled-1-539x303.jpg", "", "Reduced by 5.9% (1.6 KB)", "25741", "27343", "", "10", "0", "1", "2021-01-01 15:15:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1331", "1185", "media", "full", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1.jpg", "", "Reduced by 0.5% (3.5 KB)", "729048", "732637", "", "10", "0", "1", "2021-01-01 15:15:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1332", "1185", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-300x225.jpg", "", "Reduced by 6.4% (1,019 B)", "14953", "15972", "", "10", "0", "1", "2021-01-01 15:15:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1333", "1185", "media", "large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-1024x768.jpg", "", "Reduced by 4.8% (6.8 KB)", "138919", "145851", "", "10", "0", "1", "2021-01-01 15:15:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1334", "1185", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-150x150.jpg", "", "Reduced by 8.6% (522 B)", "5513", "6035", "", "10", "0", "1", "2021-01-01 15:15:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1335", "1185", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-768x576.jpg", "", "Reduced by 5.0% (4.2 KB)", "82070", "86408", "", "10", "0", "1", "2021-01-01 15:15:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1336", "1185", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-1536x1152.jpg", "", "Reduced by 4.5% (13.0 KB)", "284121", "297395", "", "10", "0", "1", "2021-01-01 15:15:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1337", "1185", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-2048x1536.jpg", "", "Reduced by 4.5% (21.3 KB)", "459778", "481539", "", "10", "0", "1", "2021-01-01 15:16:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1338", "1185", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-570x570.jpg", "", "Reduced by 5.3% (3.4 KB)", "62540", "66014", "", "10", "0", "1", "2021-01-01 15:16:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1339", "1185", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-600x800.jpg", "", "Reduced by 5.4% (4.7 KB)", "85079", "89893", "", "10", "0", "1", "2021-01-01 15:16:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1340", "1185", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-800x600.jpg", "", "Reduced by 5.0% (4.5 KB)", "88477", "93135", "", "10", "0", "1", "2021-01-01 15:16:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1341", "1185", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-345x198.jpg", "", "Reduced by 6.9% (1.1 KB)", "14631", "15711", "", "10", "0", "1", "2021-01-01 15:16:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1342", "1185", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-400x260.jpg", "", "Reduced by 6.2% (1.4 KB)", "21692", "23134", "", "10", "0", "1", "2021-01-01 15:16:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1343", "1185", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-500x380.jpg", "", "Reduced by 5.7% (2.2 KB)", "38132", "40417", "", "10", "0", "1", "2021-01-01 15:16:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1344", "1185", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-500x500.jpg", "", "Reduced by 5.7% (2.9 KB)", "49050", "52015", "", "10", "0", "1", "2021-01-01 15:16:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1345", "1185", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-1000x500.jpg", "", "Reduced by 5.1% (4.6 KB)", "88369", "93098", "", "10", "0", "1", "2021-01-01 15:16:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1346", "1185", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-500x1000.jpg", "", "Reduced by 5.1% (4.4 KB)", "83608", "88145", "", "10", "0", "1", "2021-01-01 15:16:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1347", "1185", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-1000x1000.jpg", "", "Reduced by 4.8% (8.3 KB)", "169716", "178187", "", "10", "0", "1", "2021-01-01 15:16:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1348", "1185", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-700x525.jpg", "", "Reduced by 5.1% (3.7 KB)", "69653", "73412", "", "10", "0", "1", "2021-01-01 15:16:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1349", "1185", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO3-scaled-1-539x303.jpg", "", "Reduced by 5.8% (2.0 KB)", "32450", "34465", "", "10", "0", "1", "2021-01-01 15:16:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1350", "1186", "media", "full", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1.jpg", "", "Reduced by 1.4% (7.2 KB)", "525677", "533059", "", "10", "0", "1", "2021-01-01 15:16:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1351", "1186", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-300x225.jpg", "", "Reduced by 7.1% (984 B)", "12953", "13937", "", "10", "0", "1", "2021-01-01 15:16:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1352", "1186", "media", "large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-1024x768.jpg", "", "Reduced by 4.4% (4.7 KB)", "104432", "109219", "", "10", "0", "1", "2021-01-01 15:16:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1353", "1186", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-150x150.jpg", "", "Reduced by 9.6% (540 B)", "5080", "5620", "", "10", "0", "1", "2021-01-01 15:16:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1354", "1186", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-768x576.jpg", "", "Reduced by 5.0% (3.3 KB)", "63703", "67049", "", "10", "0", "1", "2021-01-01 15:16:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1355", "1186", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-1536x1152.jpg", "", "Reduced by 4.4% (9.3 KB)", "207460", "216955", "", "10", "0", "1", "2021-01-01 15:16:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1356", "1186", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-2048x1536.jpg", "", "Reduced by 4.9% (16.7 KB)", "334868", "351997", "", "10", "0", "1", "2021-01-01 15:16:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1357", "1186", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-570x570.jpg", "", "Reduced by 5.0% (2.4 KB)", "46887", "49342", "", "10", "0", "1", "2021-01-01 15:16:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1358", "1186", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-600x800.jpg", "", "Reduced by 4.6% (2.8 KB)", "60763", "63681", "", "10", "0", "1", "2021-01-01 15:16:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1359", "1186", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-800x600.jpg", "", "Reduced by 5.0% (3.5 KB)", "68270", "71863", "", "10", "0", "1", "2021-01-01 15:16:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1360", "1186", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-345x198.jpg", "", "Reduced by 7.9% (1.1 KB)", "13252", "14386", "", "10", "0", "1", "2021-01-01 15:16:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1361", "1186", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-400x260.jpg", "", "Reduced by 6.7% (1.3 KB)", "18624", "19963", "", "10", "0", "1", "2021-01-01 15:16:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1362", "1186", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-500x380.jpg", "", "Reduced by 5.5% (1.8 KB)", "31130", "32936", "", "10", "0", "1", "2021-01-01 15:16:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1363", "1186", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-500x500.jpg", "", "Reduced by 5.6% (2.2 KB)", "37434", "39648", "", "10", "0", "1", "2021-01-01 15:16:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1364", "1186", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-1000x500.jpg", "", "Reduced by 4.8% (3.4 KB)", "68812", "72276", "", "10", "0", "1", "2021-01-01 15:16:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1365", "1186", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-500x1000.jpg", "", "Reduced by 4.7% (2.8 KB)", "57996", "60888", "", "10", "0", "1", "2021-01-01 15:16:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1366", "1186", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-1000x1000.jpg", "", "Reduced by 4.4% (5.4 KB)", "120357", "125840", "", "10", "0", "1", "2021-01-01 15:16:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1367", "1186", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-700x525.jpg", "", "Reduced by 4.9% (2.8 KB)", "54695", "57536", "", "10", "0", "1", "2021-01-01 15:16:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1368", "1186", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Metal-Roof-Project-Livermore-CO4-scaled-1-539x303.jpg", "", "Reduced by 6.0% (1.7 KB)", "27290", "29038", "", "10", "0", "1", "2021-01-01 15:16:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1369", "1188", "media", "full", "ABSPATHwp-content/uploads/2016/02/3-2-1.jpg", "", "Reduced by 0.3% (529 B)", "153989", "154518", "", "10", "0", "1", "2021-01-01 15:16:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1370", "1188", "media", "medium", "ABSPATHwp-content/uploads/2016/02/3-2-1-300x253.jpg", "", "Reduced by 5.9% (852 B)", "13514", "14366", "", "10", "0", "1", "2021-01-01 15:16:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1371", "1188", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/3-2-1-150x150.jpg", "", "Reduced by 8.1% (424 B)", "4822", "5246", "", "10", "0", "1", "2021-01-01 15:16:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1372", "1188", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/3-2-1-345x198.jpg", "", "Reduced by 6.0% (799 B)", "12523", "13322", "", "10", "0", "1", "2021-01-01 15:16:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1373", "1188", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/3-2-1-400x260.jpg", "", "Reduced by 5.5% (1.0 KB)", "17903", "18947", "", "10", "0", "1", "2021-01-01 15:16:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1374", "1188", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/3-2-1-475x380.jpg", "", "Reduced by 5.2% (1.8 KB)", "32653", "34455", "", "10", "0", "1", "2021-01-01 15:16:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1375", "1188", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/3-2-1-475x303.jpg", "", "Reduced by 5.5% (1.5 KB)", "26839", "28394", "", "10", "0", "1", "2021-01-01 15:16:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1376", "1189", "media", "full", "ABSPATHwp-content/uploads/2016/02/4-1-1.jpg", "", "Reduced by 0.5% (775 B)", "159356", "160131", "", "10", "0", "1", "2021-01-01 15:16:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1377", "1189", "media", "medium", "ABSPATHwp-content/uploads/2016/02/4-1-1-300x253.jpg", "", "Reduced by 5.2% (990 B)", "17976", "18966", "", "10", "0", "1", "2021-01-01 15:16:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1378", "1189", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/4-1-1-150x150.jpg", "", "Reduced by 7.6% (540 B)", "6590", "7130", "", "10", "0", "1", "2021-01-01 15:16:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1379", "1189", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/4-1-1-345x198.jpg", "", "Reduced by 5.5% (1,003 B)", "17277", "18280", "", "10", "0", "1", "2021-01-01 15:16:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1380", "1189", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/4-1-1-400x260.jpg", "", "Reduced by 4.7% (1.1 KB)", "23668", "24832", "", "10", "0", "1", "2021-01-01 15:16:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1381", "1189", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/4-1-1-475x380.jpg", "", "Reduced by 4.5% (1.8 KB)", "39892", "41782", "", "10", "0", "1", "2021-01-01 15:16:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1382", "1189", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/4-1-1-475x303.jpg", "", "Reduced by 4.6% (1.6 KB)", "33785", "35405", "", "10", "0", "1", "2021-01-01 15:16:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1383", "1191", "media", "full", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1.jpeg", "", "Reduced by 0.5% (1.1 KB)", "213810", "214911", "", "10", "0", "1", "2021-01-01 15:16:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1384", "1191", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-300x199.jpeg", "", "Reduced by 8.1% (904 B)", "10223", "11127", "", "10", "0", "1", "2021-01-01 15:16:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1385", "1191", "media", "large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-1024x678.jpeg", "", "Reduced by 6.6% (6.4 KB)", "93442", "100007", "", "10", "0", "1", "2021-01-01 15:16:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1386", "1191", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-150x150.jpeg", "", "Reduced by 9.6% (475 B)", "4455", "4930", "", "10", "0", "1", "2021-01-01 15:16:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1387", "1191", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-768x508.jpeg", "", "Reduced by 6.5% (3.8 KB)", "56121", "60019", "", "10", "0", "1", "2021-01-01 15:16:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1388", "1191", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-570x570.jpeg", "", "Reduced by 6.1% (2.9 KB)", "45790", "48771", "", "10", "0", "1", "2021-01-01 15:16:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1389", "1191", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-600x721.jpeg", "", "Reduced by 7.3% (4.9 KB)", "63786", "68834", "", "10", "0", "1", "2021-01-01 15:16:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1390", "1191", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-800x600.jpeg", "", "Reduced by 6.5% (4.5 KB)", "66599", "71222", "", "10", "0", "1", "2021-01-01 15:16:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1391", "1191", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-345x198.jpeg", "", "Reduced by 7.0% (915 B)", "12091", "13006", "", "10", "0", "1", "2021-01-01 15:16:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1392", "1191", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-400x260.jpeg", "", "Reduced by 6.5% (1.2 KB)", "16989", "18169", "", "10", "0", "1", "2021-01-01 15:16:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1393", "1191", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-500x380.jpeg", "", "Reduced by 6.7% (2.1 KB)", "29169", "31277", "", "10", "0", "1", "2021-01-01 15:16:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1394", "1191", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-500x500.jpeg", "", "Reduced by 6.6% (2.5 KB)", "36222", "38767", "", "10", "0", "1", "2021-01-01 15:16:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1395", "1191", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-1000x500.jpeg", "", "Reduced by 6.4% (4.8 KB)", "73132", "78091", "", "10", "0", "1", "2021-01-01 15:16:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1396", "1191", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-500x721.jpeg", "", "Reduced by 7.2% (4.1 KB)", "53612", "57779", "", "10", "0", "1", "2021-01-01 15:16:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1397", "1191", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-1000x721.jpeg", "", "Reduced by 7.2% (8.3 KB)", "110362", "118907", "", "10", "0", "1", "2021-01-01 15:16:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1398", "1191", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-700x463.jpeg", "", "Reduced by 6.7% (3.3 KB)", "47512", "50900", "", "10", "0", "1", "2021-01-01 15:16:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1399", "1191", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK-1-539x303.jpeg", "", "Reduced by 6.3% (1.7 KB)", "26479", "28251", "", "10", "0", "1", "2021-01-01 15:16:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1400", "1192", "media", "full", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1.jpeg", "", "Reduced by 0.3% (888 B)", "257813", "258701", "", "10", "0", "1", "2021-01-01 15:16:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1401", "1192", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-300x199.jpeg", "", "Reduced by 7.0% (834 B)", "11117", "11951", "", "10", "0", "1", "2021-01-01 15:16:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1402", "1192", "media", "large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-1024x678.jpeg", "", "Reduced by 5.3% (6.0 KB)", "109748", "115903", "", "10", "0", "1", "2021-01-01 15:16:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1403", "1192", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-150x150.jpeg", "", "Reduced by 8.1% (442 B)", "5041", "5483", "", "10", "0", "1", "2021-01-01 15:17:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1404", "1192", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-768x508.jpeg", "", "Reduced by 5.6% (3.7 KB)", "64874", "68711", "", "10", "0", "1", "2021-01-01 15:17:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1405", "1192", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-570x570.jpeg", "", "Reduced by 5.3% (3.2 KB)", "57981", "61210", "", "10", "0", "1", "2021-01-01 15:17:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1406", "1192", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-600x721.jpeg", "", "Reduced by 6.1% (5.6 KB)", "87615", "93331", "", "10", "0", "1", "2021-01-01 15:17:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1407", "1192", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-800x600.jpeg", "", "Reduced by 5.5% (4.5 KB)", "79331", "83907", "", "10", "0", "1", "2021-01-01 15:17:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1408", "1192", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-345x198.jpeg", "", "Reduced by 6.5% (941 B)", "13519", "14460", "", "10", "0", "1", "2021-01-01 15:17:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1409", "1192", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-400x260.jpeg", "", "Reduced by 6.0% (1.2 KB)", "18657", "19847", "", "10", "0", "1", "2021-01-01 15:17:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1410", "1192", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-500x380.jpeg", "", "Reduced by 5.9% (2.0 KB)", "33758", "35856", "", "10", "0", "1", "2021-01-01 15:17:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1411", "1192", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-500x500.jpeg", "", "Reduced by 5.6% (2.6 KB)", "45248", "47910", "", "10", "0", "1", "2021-01-01 15:17:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1412", "1192", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-1000x500.jpeg", "", "Reduced by 5.1% (4.8 KB)", "90126", "94999", "", "10", "0", "1", "2021-01-01 15:17:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1413", "1192", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-500x721.jpeg", "", "Reduced by 6.2% (4.9 KB)", "76690", "81753", "", "10", "0", "1", "2021-01-01 15:17:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1414", "1192", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-1000x721.jpeg", "", "Reduced by 6.1% (8.5 KB)", "133333", "142016", "", "10", "0", "1", "2021-01-01 15:17:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1415", "1192", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-700x463.jpeg", "", "Reduced by 5.6% (3.2 KB)", "54361", "57607", "", "10", "0", "1", "2021-01-01 15:17:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1416", "1192", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK2-1-539x303.jpeg", "", "Reduced by 5.6% (1.8 KB)", "30421", "32214", "", "10", "0", "1", "2021-01-01 15:17:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1417", "1193", "media", "full", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1.jpeg", "", "Reduced by 0.9% (2.3 KB)", "267861", "270215", "", "10", "0", "1", "2021-01-01 15:17:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1418", "1193", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-300x199.jpeg", "", "Reduced by 6.3% (856 B)", "12804", "13660", "", "10", "0", "1", "2021-01-01 15:17:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1419", "1193", "media", "large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-1024x678.jpeg", "", "Reduced by 6.1% (7.9 KB)", "124492", "132590", "", "10", "0", "1", "2021-01-01 15:17:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1420", "1193", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-150x150.jpeg", "", "Reduced by 9.2% (475 B)", "4702", "5177", "", "10", "0", "1", "2021-01-01 15:17:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1421", "1193", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-768x508.jpeg", "", "Reduced by 6.1% (4.7 KB)", "73531", "78342", "", "10", "0", "1", "2021-01-01 15:17:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1422", "1193", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-570x570.jpeg", "", "Reduced by 6.5% (3.6 KB)", "52338", "55998", "", "10", "0", "1", "2021-01-01 15:17:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1423", "1193", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-600x721.jpeg", "", "Reduced by 7.6% (5.8 KB)", "72291", "78206", "", "10", "0", "1", "2021-01-01 15:17:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1424", "1193", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-800x600.jpeg", "", "Reduced by 6.3% (5.5 KB)", "84235", "89909", "", "10", "0", "1", "2021-01-01 15:17:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1425", "1193", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-345x198.jpeg", "", "Reduced by 6.1% (1,003 B)", "15401", "16404", "", "10", "0", "1", "2021-01-01 15:17:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1426", "1193", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-400x260.jpeg", "", "Reduced by 5.9% (1.3 KB)", "21305", "22638", "", "10", "0", "1", "2021-01-01 15:17:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1427", "1193", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-500x380.jpeg", "", "Reduced by 6.5% (2.4 KB)", "36002", "38509", "", "10", "0", "1", "2021-01-01 15:17:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1428", "1193", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-500x500.jpeg", "", "Reduced by 6.8% (2.9 KB)", "41161", "44179", "", "10", "0", "1", "2021-01-01 15:17:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1429", "1193", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-1000x500.jpeg", "", "Reduced by 6.0% (6.4 KB)", "102083", "108656", "", "10", "0", "1", "2021-01-01 15:17:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1430", "1193", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-500x721.jpeg", "", "Reduced by 7.7% (4.5 KB)", "55743", "60378", "", "10", "0", "1", "2021-01-01 15:17:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1431", "1193", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-1000x721.jpeg", "", "Reduced by 6.9% (10.8 KB)", "148671", "159729", "", "10", "0", "1", "2021-01-01 15:17:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1432", "1193", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-700x463.jpeg", "", "Reduced by 6.3% (4.1 KB)", "62175", "66327", "", "10", "0", "1", "2021-01-01 15:17:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1433", "1193", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK3-1-539x303.jpeg", "", "Reduced by 6.2% (2.2 KB)", "34887", "37181", "", "10", "0", "1", "2021-01-01 15:17:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1434", "1194", "media", "full", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1.jpeg", "", "Reduced by 0.8% (7.9 KB)", "1020148", "1028205", "", "10", "0", "1", "2021-01-01 15:17:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1435", "1194", "media", "medium", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-300x224.jpeg", "", "Reduced by 5.3% (834 B)", "14897", "15731", "", "10", "0", "1", "2021-01-01 15:17:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1436", "1194", "media", "large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-1024x765.jpeg", "", "Reduced by 5.2% (6.1 KB)", "112745", "118986", "", "10", "0", "1", "2021-01-01 15:17:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1437", "1194", "media", "thumbnail", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-150x150.jpeg", "", "Reduced by 6.8% (443 B)", "6051", "6494", "", "10", "0", "1", "2021-01-01 15:17:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1438", "1194", "media", "medium_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-768x574.jpeg", "", "Reduced by 4.4% (3.1 KB)", "69181", "72401", "", "10", "0", "1", "2021-01-01 15:17:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1439", "1194", "media", "1536x1536", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-1536x1148.jpeg", "", "Reduced by 6.8% (16.7 KB)", "236287", "253410", "", "10", "0", "1", "2021-01-01 15:17:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1440", "1194", "media", "2048x2048", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-2048x1530.jpeg", "", "Reduced by 7.5% (32.5 KB)", "412107", "445402", "", "10", "0", "1", "2021-01-01 15:17:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1441", "1194", "media", "portfolio-square", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-570x570.jpeg", "", "Reduced by 4.6% (2.4 KB)", "50723", "53147", "", "10", "0", "1", "2021-01-01 15:17:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1442", "1194", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-600x800.jpeg", "", "Reduced by 5.5% (3.8 KB)", "67331", "71224", "", "10", "0", "1", "2021-01-01 15:17:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1443", "1194", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-800x600.jpeg", "", "Reduced by 4.8% (3.7 KB)", "73978", "77717", "", "10", "0", "1", "2021-01-01 15:17:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1444", "1194", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-345x198.jpeg", "", "Reduced by 5.7% (956 B)", "15738", "16694", "", "10", "0", "1", "2021-01-01 15:17:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1445", "1194", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-400x260.jpeg", "", "Reduced by 5.1% (1.2 KB)", "21779", "22960", "", "10", "0", "1", "2021-01-01 15:17:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1446", "1194", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-500x380.jpeg", "", "Reduced by 4.7% (1.7 KB)", "34760", "36472", "", "10", "0", "1", "2021-01-01 15:17:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1447", "1194", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-500x500.jpeg", "", "Reduced by 4.9% (2.0 KB)", "40891", "42990", "", "10", "0", "1", "2021-01-01 15:17:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1448", "1194", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-1000x500.jpeg", "", "Reduced by 4.9% (4.0 KB)", "78417", "82470", "", "10", "0", "1", "2021-01-01 15:17:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1449", "1194", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-500x1000.jpeg", "", "Reduced by 6.1% (4.4 KB)", "69140", "73619", "", "10", "0", "1", "2021-01-01 15:17:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1450", "1194", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-1000x1000.jpeg", "", "Reduced by 6.5% (8.9 KB)", "131261", "140345", "", "10", "0", "1", "2021-01-01 15:17:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1451", "1194", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-700x523.jpeg", "", "Reduced by 4.4% (2.7 KB)", "59967", "62757", "", "10", "0", "1", "2021-01-01 15:17:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1452", "1194", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2016/02/Shingle-Roof-Project-Ada-OK4-1-539x303.jpeg", "", "Reduced by 4.7% (1.5 KB)", "31519", "33071", "", "10", "0", "1", "2021-01-01 15:17:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1453", "1195", "media", "full", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1.jpeg", "", "Reduced by 0.5% (1.2 KB)", "263091", "264306", "", "10", "0", "1", "2021-01-01 15:17:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1454", "1195", "media", "medium", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-300x225.jpeg", "", "Reduced by 6.0% (1.2 KB)", "19681", "20930", "", "10", "0", "1", "2021-01-01 15:17:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1455", "1195", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-150x150.jpeg", "", "Reduced by 7.0% (584 B)", "7704", "8288", "", "10", "0", "1", "2021-01-01 15:17:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1456", "1195", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-768x576.jpeg", "", "Reduced by 4.9% (4.8 KB)", "94821", "99755", "", "10", "0", "1", "2021-01-01 15:17:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1457", "1195", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-570x570.jpeg", "", "Reduced by 4.6% (3.4 KB)", "70962", "74411", "", "10", "0", "1", "2021-01-01 15:17:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1458", "1195", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-600x768.jpeg", "", "Reduced by 4.6% (4.7 KB)", "101787", "106641", "", "10", "0", "1", "2021-01-01 15:17:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1459", "1195", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-800x600.jpeg", "", "Reduced by 4.6% (4.7 KB)", "100544", "105402", "", "10", "0", "1", "2021-01-01 15:17:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1460", "1195", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-345x198.jpeg", "", "Reduced by 6.0% (1.2 KB)", "19886", "21159", "", "10", "0", "1", "2021-01-01 15:17:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1461", "1195", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-400x260.jpeg", "", "Reduced by 5.8% (1.7 KB)", "28451", "30208", "", "10", "0", "1", "2021-01-01 15:17:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1462", "1195", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-500x380.jpeg", "", "Reduced by 5.2% (2.5 KB)", "47194", "49757", "", "10", "0", "1", "2021-01-01 15:17:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1463", "1195", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-500x500.jpeg", "", "Reduced by 4.9% (2.9 KB)", "57601", "60565", "", "10", "0", "1", "2021-01-01 15:17:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1464", "1195", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-1000x500.jpeg", "", "Reduced by 4.6% (4.9 KB)", "103660", "108712", "", "10", "0", "1", "2021-01-01 15:17:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1465", "1195", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-500x768.jpeg", "", "Reduced by 4.6% (4.0 KB)", "86036", "90176", "", "10", "0", "1", "2021-01-01 15:17:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1466", "1195", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-1000x768.jpeg", "", "Reduced by 4.5% (7.7 KB)", "166692", "174623", "", "10", "0", "1", "2021-01-01 15:17:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1467", "1195", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-700x525.jpeg", "", "Reduced by 4.8% (4.0 KB)", "81534", "85670", "", "10", "0", "1", "2021-01-01 15:17:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1468", "1195", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/4ED5F45A-5EE7-4BA0-AF4C-278307C9A805_1_105_c-1-539x303.jpeg", "", "Reduced by 5.2% (2.2 KB)", "41523", "43820", "", "10", "0", "1", "2021-01-01 15:17:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1469", "1196", "media", "full", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1.jpeg", "", "Reduced by 0.9% (1.4 KB)", "166877", "168360", "", "10", "0", "1", "2021-01-01 15:18:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1470", "1196", "media", "medium", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-300x225.jpeg", "", "Reduced by 5.7% (708 B)", "11699", "12407", "", "10", "0", "1", "2021-01-01 15:18:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1471", "1196", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-150x150.jpeg", "", "Reduced by 7.1% (361 B)", "4693", "5054", "", "10", "0", "1", "2021-01-01 15:18:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1472", "1196", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-768x576.jpeg", "", "Reduced by 5.7% (3.4 KB)", "56284", "59715", "", "10", "0", "1", "2021-01-01 15:18:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1473", "1196", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-570x570.jpeg", "", "Reduced by 5.7% (2.5 KB)", "42780", "45343", "", "10", "0", "1", "2021-01-01 15:18:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1474", "1196", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-600x768.jpeg", "", "Reduced by 5.8% (3.7 KB)", "61540", "65349", "", "10", "0", "1", "2021-01-01 15:18:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1475", "1196", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-800x600.jpeg", "", "Reduced by 5.7% (3.5 KB)", "59782", "63382", "", "10", "0", "1", "2021-01-01 15:18:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1476", "1196", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-345x198.jpeg", "", "Reduced by 6.2% (845 B)", "12795", "13640", "", "10", "0", "1", "2021-01-01 15:18:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1477", "1196", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-400x260.jpeg", "", "Reduced by 5.6% (1,018 B)", "17170", "18188", "", "10", "0", "1", "2021-01-01 15:18:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1478", "1196", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-500x380.jpeg", "", "Reduced by 5.7% (1.6 KB)", "27543", "29198", "", "10", "0", "1", "2021-01-01 15:18:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1479", "1196", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-500x500.jpeg", "", "Reduced by 5.7% (2.0 KB)", "34328", "36399", "", "10", "0", "1", "2021-01-01 15:18:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1480", "1196", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.1% (3.6 KB)", "68043", "71697", "", "10", "0", "1", "2021-01-01 15:18:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1481", "1196", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-500x768.jpeg", "", "Reduced by 5.9% (3.1 KB)", "51182", "54379", "", "10", "0", "1", "2021-01-01 15:18:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1482", "1196", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-1000x768.jpeg", "", "Reduced by 5.7% (5.9 KB)", "99712", "105749", "", "10", "0", "1", "2021-01-01 15:18:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1483", "1196", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-700x525.jpeg", "", "Reduced by 5.5% (2.8 KB)", "48077", "50899", "", "10", "0", "1", "2021-01-01 15:18:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1484", "1196", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/8380CCEB-4AEE-4C33-8FEC-C9304B0FD63B_1_105_c-1-539x303.jpeg", "", "Reduced by 5.4% (1.5 KB)", "26304", "27815", "", "10", "0", "1", "2021-01-01 15:18:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1485", "1197", "media", "full", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1.jpeg", "", "Reduced by 4.4% (6.6 KB)", "145447", "152184", "", "10", "0", "1", "2021-01-01 15:18:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1486", "1197", "media", "medium", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-300x225.jpeg", "", "Reduced by 6.7% (742 B)", "10362", "11104", "", "10", "0", "1", "2021-01-01 15:18:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1487", "1197", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-150x150.jpeg", "", "Reduced by 9.2% (386 B)", "3830", "4216", "", "10", "0", "1", "2021-01-01 15:18:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1488", "1197", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-768x576.jpeg", "", "Reduced by 6.1% (3.2 KB)", "50889", "54174", "", "10", "0", "1", "2021-01-01 15:18:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1489", "1197", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-570x570.jpeg", "", "Reduced by 6.4% (2.4 KB)", "35936", "38408", "", "10", "0", "1", "2021-01-01 15:18:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1490", "1197", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-600x768.jpeg", "", "Reduced by 7.1% (3.6 KB)", "48280", "51943", "", "10", "0", "1", "2021-01-01 15:18:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1491", "1197", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-800x600.jpeg", "", "Reduced by 6.1% (3.4 KB)", "53861", "57352", "", "10", "0", "1", "2021-01-01 15:18:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1492", "1197", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-345x198.jpeg", "", "Reduced by 6.5% (774 B)", "11136", "11910", "", "10", "0", "1", "2021-01-01 15:18:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1493", "1197", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-400x260.jpeg", "", "Reduced by 6.6% (1.0 KB)", "15151", "16214", "", "10", "0", "1", "2021-01-01 15:18:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1494", "1197", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-500x380.jpeg", "", "Reduced by 6.4% (1.7 KB)", "24646", "26341", "", "10", "0", "1", "2021-01-01 15:18:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1495", "1197", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-500x500.jpeg", "", "Reduced by 6.8% (2.0 KB)", "28731", "30814", "", "10", "0", "1", "2021-01-01 15:18:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1496", "1197", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.7% (3.6 KB)", "60619", "64292", "", "10", "0", "1", "2021-01-01 15:18:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1497", "1197", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-500x768.jpeg", "", "Reduced by 8.0% (3.3 KB)", "39081", "42498", "", "10", "0", "1", "2021-01-01 15:18:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1498", "1197", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-1000x768.jpeg", "", "Reduced by 6.3% (5.7 KB)", "86704", "92547", "", "10", "0", "1", "2021-01-01 15:18:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1499", "1197", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-700x525.jpeg", "", "Reduced by 6.1% (2.7 KB)", "43469", "46273", "", "10", "0", "1", "2021-01-01 15:18:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1500", "1197", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/79722C8A-C597-4254-8323-EBC6B40E53A0_1_105_c-1-539x303.jpeg", "", "Reduced by 6.4% (1.5 KB)", "23130", "24710", "", "10", "0", "1", "2021-01-01 15:18:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1501", "1198", "media", "full", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1.jpeg", "", "Reduced by 0.5% (1.4 KB)", "296877", "298313", "", "10", "0", "1", "2021-01-01 15:18:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1502", "1198", "media", "medium", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-300x225.jpeg", "", "Reduced by 6.8% (1.3 KB)", "17749", "19039", "", "10", "0", "1", "2021-01-01 15:18:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1503", "1198", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-150x150.jpeg", "", "Reduced by 7.9% (583 B)", "6807", "7390", "", "10", "0", "1", "2021-01-01 15:18:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1504", "1198", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-768x576.jpeg", "", "Reduced by 5.4% (5.1 KB)", "92286", "97542", "", "10", "0", "1", "2021-01-01 15:18:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1505", "1198", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-570x570.jpeg", "", "Reduced by 5.3% (3.7 KB)", "68124", "71899", "", "10", "0", "1", "2021-01-01 15:18:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1506", "1198", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-600x768.jpeg", "", "Reduced by 5.5% (5.9 KB)", "102529", "108524", "", "10", "0", "1", "2021-01-01 15:18:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1507", "1198", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-800x600.jpeg", "", "Reduced by 5.4% (5.4 KB)", "98059", "103611", "", "10", "0", "1", "2021-01-01 15:18:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1508", "1198", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-345x198.jpeg", "", "Reduced by 6.9% (1.3 KB)", "17961", "19290", "", "10", "0", "1", "2021-01-01 15:18:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1509", "1198", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-400x260.jpeg", "", "Reduced by 6.5% (1.8 KB)", "25871", "27684", "", "10", "0", "1", "2021-01-01 15:18:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1510", "1198", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-500x380.jpeg", "", "Reduced by 5.8% (2.7 KB)", "43987", "46718", "", "10", "0", "1", "2021-01-01 15:18:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1511", "1198", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-500x500.jpeg", "", "Reduced by 5.8% (3.3 KB)", "54406", "57740", "", "10", "0", "1", "2021-01-01 15:18:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1512", "1198", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.0% (4.9 KB)", "94871", "99881", "", "10", "0", "1", "2021-01-01 15:18:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1513", "1198", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-500x768.jpeg", "", "Reduced by 5.6% (5.0 KB)", "86383", "91483", "", "10", "0", "1", "2021-01-01 15:18:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1514", "1198", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-1000x768.jpeg", "", "Reduced by 5.5% (9.6 KB)", "168769", "178567", "", "10", "0", "1", "2021-01-01 15:18:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1515", "1198", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-700x525.jpeg", "", "Reduced by 5.5% (4.4 KB)", "78345", "82865", "", "10", "0", "1", "2021-01-01 15:18:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1516", "1198", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/86981F74-FC0E-44D8-9360-85261EB0E50B_1_105_c-1-539x303.jpeg", "", "Reduced by 5.9% (2.3 KB)", "37663", "40042", "", "10", "0", "1", "2021-01-01 15:18:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1517", "1199", "media", "full", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2.jpeg", "", "Reduced by 2.5% (2.7 KB)", "107263", "109980", "", "10", "0", "1", "2021-01-01 15:18:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1518", "1199", "media", "medium", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-300x146.jpeg", "", "Reduced by 7.8% (527 B)", "6190", "6717", "", "10", "0", "1", "2021-01-01 15:18:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1519", "1199", "media", "large", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-1024x498.jpeg", "", "Reduced by 9.9% (4.4 KB)", "41244", "45753", "", "10", "0", "1", "2021-01-01 15:18:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1520", "1199", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-150x150.jpeg", "", "Reduced by 10.7% (408 B)", "3390", "3798", "", "10", "0", "1", "2021-01-01 15:18:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1521", "1199", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-768x373.jpeg", "", "Reduced by 8.8% (2.5 KB)", "25969", "28483", "", "10", "0", "1", "2021-01-01 15:18:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1522", "1199", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-570x570.jpeg", "", "Reduced by 9.6% (2.6 KB)", "25010", "27652", "", "10", "0", "1", "2021-01-01 15:18:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1523", "1199", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-600x618.jpeg", "", "Reduced by 10.3% (3.6 KB)", "32283", "35974", "", "10", "0", "1", "2021-01-01 15:18:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1524", "1199", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-800x600.jpeg", "", "Reduced by 10.6% (4.0 KB)", "34730", "38850", "", "10", "0", "1", "2021-01-01 15:18:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1525", "1199", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-345x198.jpeg", "", "Reduced by 8.3% (757 B)", "8388", "9145", "", "10", "0", "1", "2021-01-01 15:18:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1526", "1199", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-400x260.jpeg", "", "Reduced by 8.1% (968 B)", "11032", "12000", "", "10", "0", "1", "2021-01-01 15:18:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1527", "1199", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-500x380.jpeg", "", "Reduced by 9.1% (1.7 KB)", "17476", "19231", "", "10", "0", "1", "2021-01-01 15:18:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1528", "1199", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-500x500.jpeg", "", "Reduced by 9.7% (2.1 KB)", "20489", "22687", "", "10", "0", "1", "2021-01-01 15:18:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1529", "1199", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-1000x500.jpeg", "", "Reduced by 9.6% (4.2 KB)", "40411", "44719", "", "10", "0", "1", "2021-01-01 15:18:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1530", "1199", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-500x618.jpeg", "", "Reduced by 9.3% (2.6 KB)", "26080", "28767", "", "10", "0", "1", "2021-01-01 15:18:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1531", "1199", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-1000x618.jpeg", "", "Reduced by 11.0% (6.3 KB)", "52517", "59008", "", "10", "0", "1", "2021-01-01 15:18:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1532", "1199", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-700x340.jpeg", "", "Reduced by 9.1% (2.2 KB)", "22895", "25179", "", "10", "0", "1", "2021-01-01 15:18:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1533", "1199", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-2-539x303.jpeg", "", "Reduced by 8.5% (1.5 KB)", "16321", "17835", "", "10", "0", "1", "2021-01-01 15:18:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1534", "1200", "media", "full", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1.jpeg", "", "Reduced by 1.2% (3.1 KB)", "257595", "260794", "", "10", "0", "1", "2021-01-01 15:18:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1535", "1200", "media", "medium", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-300x225.jpeg", "", "Reduced by 7.0% (1.1 KB)", "14346", "15427", "", "10", "0", "1", "2021-01-01 15:18:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1536", "1200", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-150x150.jpeg", "", "Reduced by 8.9% (567 B)", "5834", "6401", "", "10", "0", "1", "2021-01-01 15:18:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1537", "1200", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-768x576.jpeg", "", "Reduced by 6.4% (5.4 KB)", "81229", "86770", "", "10", "0", "1", "2021-01-01 15:18:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1538", "1200", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-570x570.jpeg", "", "Reduced by 6.3% (4.3 KB)", "65585", "69959", "", "10", "0", "1", "2021-01-01 15:18:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1539", "1200", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-600x768.jpeg", "", "Reduced by 7.5% (8.5 KB)", "107786", "116481", "", "10", "0", "1", "2021-01-01 15:18:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1540", "1200", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-800x600.jpeg", "", "Reduced by 6.4% (5.8 KB)", "87697", "93645", "", "10", "0", "1", "2021-01-01 15:18:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1541", "1200", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-345x198.jpeg", "", "Reduced by 7.3% (1.3 KB)", "16217", "17500", "", "10", "0", "1", "2021-01-01 15:18:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1542", "1200", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-400x260.jpeg", "", "Reduced by 7.2% (1.7 KB)", "22275", "24006", "", "10", "0", "1", "2021-01-01 15:18:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1543", "1200", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-500x380.jpeg", "", "Reduced by 6.9% (2.7 KB)", "37107", "39862", "", "10", "0", "1", "2021-01-01 15:18:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1544", "1200", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-500x500.jpeg", "", "Reduced by 6.6% (3.6 KB)", "51255", "54894", "", "10", "0", "1", "2021-01-01 15:18:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1545", "1200", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-1000x500.jpeg", "", "Reduced by 6.2% (6.9 KB)", "107002", "114059", "", "10", "0", "1", "2021-01-01 15:18:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1546", "1200", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-500x768.jpeg", "", "Reduced by 7.4% (7.2 KB)", "91460", "98787", "", "10", "0", "1", "2021-01-01 15:18:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1547", "1200", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-1000x768.jpeg", "", "Reduced by 7.0% (11.9 KB)", "161331", "173553", "", "10", "0", "1", "2021-01-01 15:18:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1548", "1200", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-700x525.jpeg", "", "Reduced by 6.3% (4.5 KB)", "68822", "73425", "", "10", "0", "1", "2021-01-01 15:18:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1549", "1200", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/B627A9AA-1E71-4FCA-A0C8-D67BDED8D4F4_1_105_c-1-539x303.jpeg", "", "Reduced by 6.7% (2.5 KB)", "36366", "38960", "", "10", "0", "1", "2021-01-01 15:18:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1550", "1201", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_7761-1.jpg", "", "Reduced by 0.8% (5.7 KB)", "684840", "690633", "", "10", "0", "1", "2021-01-01 15:18:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1551", "1201", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_7761-1-300x225.jpg", "", "Reduced by 6.5% (1.3 KB)", "18952", "20271", "", "10", "0", "1", "2021-01-01 15:18:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1552", "1201", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_7761-1-150x150.jpg", "", "Reduced by 8.4% (678 B)", "7399", "8077", "", "10", "0", "1", "2021-01-01 15:18:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1553", "1201", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_7761-1-768x576.jpg", "", "Reduced by 4.8% (4.6 KB)", "92895", "97615", "", "10", "0", "1", "2021-01-01 15:18:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1554", "1201", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_7761-1-570x570.jpg", "", "Reduced by 5.0% (3.7 KB)", "71033", "74775", "", "10", "0", "1", "2021-01-01 15:18:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1555", "1201", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_7761-1-600x768.jpg", "", "Reduced by 5.1% (5.2 KB)", "99481", "104810", "", "10", "0", "1", "2021-01-01 15:19:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1556", "1201", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_7761-1-800x600.jpg", "", "Reduced by 4.9% (4.9 KB)", "98518", "103569", "", "10", "0", "1", "2021-01-01 15:19:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1557", "1201", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_7761-1-345x198.jpg", "", "Reduced by 6.8% (1.4 KB)", "19935", "21384", "", "10", "0", "1", "2021-01-01 15:19:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1558", "1201", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_7761-1-400x260.jpg", "", "Reduced by 6.3% (1.9 KB)", "28414", "30331", "", "10", "0", "1", "2021-01-01 15:19:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1559", "1201", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_7761-1-500x380.jpg", "", "Reduced by 5.9% (2.8 KB)", "45897", "48781", "", "10", "0", "1", "2021-01-01 15:19:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1560", "1201", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_7761-1-500x500.jpg", "", "Reduced by 5.6% (3.3 KB)", "57136", "60502", "", "10", "0", "1", "2021-01-01 15:19:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1561", "1201", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_7761-1-1000x500.jpg", "", "Reduced by 4.6% (4.8 KB)", "101856", "106790", "", "10", "0", "1", "2021-01-01 15:19:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1562", "1201", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_7761-1-500x768.jpg", "", "Reduced by 5.0% (4.2 KB)", "80607", "84890", "", "10", "0", "1", "2021-01-01 15:19:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1563", "1201", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_7761-1-1000x768.jpg", "", "Reduced by 4.9% (8.1 KB)", "159420", "167691", "", "10", "0", "1", "2021-01-01 15:19:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1564", "1201", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_7761-1-700x525.jpg", "", "Reduced by 5.2% (4.2 KB)", "79706", "84036", "", "10", "0", "1", "2021-01-01 15:19:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1565", "1201", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_7761-1-539x303.jpg", "", "Reduced by 5.8% (2.5 KB)", "42018", "44612", "", "10", "0", "1", "2021-01-01 15:19:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1566", "1202", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_7774-1.jpg", "", "Reduced by 0.7% (4.2 KB)", "575787", "580044", "", "10", "0", "1", "2021-01-01 15:19:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1567", "1202", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_7774-1-300x225.jpg", "", "Reduced by 5.3% (784 B)", "13920", "14704", "", "10", "0", "1", "2021-01-01 15:19:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1568", "1202", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_7774-1-150x150.jpg", "", "Reduced by 7.6% (456 B)", "5556", "6012", "", "10", "0", "1", "2021-01-01 15:19:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1569", "1202", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_7774-1-768x576.jpg", "", "Reduced by 4.7% (3.2 KB)", "66321", "69573", "", "10", "0", "1", "2021-01-01 15:19:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1570", "1202", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_7774-1-570x570.jpg", "", "Reduced by 4.7% (2.4 KB)", "49892", "52353", "", "10", "0", "1", "2021-01-01 15:19:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1571", "1202", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_7774-1-600x768.jpg", "", "Reduced by 4.7% (3.3 KB)", "69368", "72781", "", "10", "0", "1", "2021-01-01 15:19:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1572", "1202", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_7774-1-800x600.jpg", "", "Reduced by 4.6% (3.3 KB)", "70149", "73496", "", "10", "0", "1", "2021-01-01 15:19:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1573", "1202", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_7774-1-345x198.jpg", "", "Reduced by 6.1% (893 B)", "13857", "14750", "", "10", "0", "1", "2021-01-01 15:19:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1574", "1202", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_7774-1-400x260.jpg", "", "Reduced by 5.7% (1.1 KB)", "19478", "20646", "", "10", "0", "1", "2021-01-01 15:19:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1575", "1202", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_7774-1-500x380.jpg", "", "Reduced by 5.0% (1.7 KB)", "32961", "34683", "", "10", "0", "1", "2021-01-01 15:19:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1576", "1202", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_7774-1-500x500.jpg", "", "Reduced by 5.2% (2.1 KB)", "40267", "42462", "", "10", "0", "1", "2021-01-01 15:19:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1577", "1202", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_7774-1-1000x500.jpg", "", "Reduced by 4.7% (3.4 KB)", "69318", "72768", "", "10", "0", "1", "2021-01-01 15:19:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1578", "1202", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_7774-1-500x768.jpg", "", "Reduced by 4.7% (2.8 KB)", "57909", "60748", "", "10", "0", "1", "2021-01-01 15:19:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1579", "1202", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_7774-1-1000x768.jpg", "", "Reduced by 4.4% (5.1 KB)", "112802", "118050", "", "10", "0", "1", "2021-01-01 15:19:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1580", "1202", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_7774-1-700x525.jpg", "", "Reduced by 4.6% (2.6 KB)", "56600", "59301", "", "10", "0", "1", "2021-01-01 15:19:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1581", "1202", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_7774-1-539x303.jpg", "", "Reduced by 5.1% (1.5 KB)", "28626", "30152", "", "10", "0", "1", "2021-01-01 15:19:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1582", "1204", "media", "full", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1.jpeg", "", "Reduced by 0.7% (2.9 KB)", "405431", "408404", "", "10", "0", "1", "2021-01-01 15:19:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1583", "1204", "media", "medium", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-300x200.jpeg", "", "Reduced by 7.3% (1.6 KB)", "20299", "21901", "", "10", "0", "1", "2021-01-01 15:19:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1584", "1204", "media", "large", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-1024x681.jpeg", "", "Reduced by 6.1% (12.0 KB)", "187693", "199987", "", "10", "0", "1", "2021-01-01 15:19:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1585", "1204", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-150x150.jpeg", "", "Reduced by 8.4% (753 B)", "8183", "8936", "", "10", "0", "1", "2021-01-01 15:19:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1586", "1204", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-768x511.jpeg", "", "Reduced by 6.6% (7.9 KB)", "114456", "122593", "", "10", "0", "1", "2021-01-01 15:19:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1587", "1204", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-570x570.jpeg", "", "Reduced by 6.3% (6.1 KB)", "93235", "99517", "", "10", "0", "1", "2021-01-01 15:19:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1588", "1204", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-600x723.jpeg", "", "Reduced by 6.3% (8.6 KB)", "130169", "138982", "", "10", "0", "1", "2021-01-01 15:19:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1589", "1204", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-800x600.jpeg", "", "Reduced by 6.4% (9.0 KB)", "135591", "144812", "", "10", "0", "1", "2021-01-01 15:19:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1590", "1204", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-345x198.jpeg", "", "Reduced by 7.5% (1.8 KB)", "22944", "24794", "", "10", "0", "1", "2021-01-01 15:19:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1591", "1204", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-400x260.jpeg", "", "Reduced by 7.1% (2.5 KB)", "33993", "36597", "", "10", "0", "1", "2021-01-01 15:19:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1592", "1204", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-500x380.jpeg", "", "Reduced by 6.9% (4.4 KB)", "60473", "64988", "", "10", "0", "1", "2021-01-01 15:19:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1593", "1204", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-500x500.jpeg", "", "Reduced by 6.7% (5.2 KB)", "74475", "79809", "", "10", "0", "1", "2021-01-01 15:19:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1594", "1204", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-1000x500.jpeg", "", "Reduced by 6.0% (8.4 KB)", "134570", "143208", "", "10", "0", "1", "2021-01-01 15:19:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1595", "1204", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-500x723.jpeg", "", "Reduced by 6.2% (7.0 KB)", "108597", "115815", "", "10", "0", "1", "2021-01-01 15:19:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1596", "1204", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-1000x723.jpeg", "", "Reduced by 6.7% (15.5 KB)", "220259", "236109", "", "10", "0", "1", "2021-01-01 15:19:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1597", "1204", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-700x466.jpeg", "", "Reduced by 6.8% (7.0 KB)", "98557", "105757", "", "10", "0", "1", "2021-01-01 15:19:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1598", "1204", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/8E82921E-4CD5-4581-BAFE-51FE26E209D6_1_105_c-1-539x303.jpeg", "", "Reduced by 6.8% (3.6 KB)", "51344", "55065", "", "10", "0", "1", "2021-01-01 15:19:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1599", "1205", "media", "full", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1.jpeg", "", "Reduced by 0.7% (2.3 KB)", "332170", "334532", "", "10", "0", "1", "2021-01-01 15:19:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1600", "1205", "media", "medium", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-300x200.jpeg", "", "Reduced by 7.3% (1.4 KB)", "18480", "19930", "", "10", "0", "1", "2021-01-01 15:19:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1601", "1205", "media", "large", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-1024x681.jpeg", "", "Reduced by 6.0% (10.3 KB)", "166375", "176927", "", "10", "0", "1", "2021-01-01 15:19:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1602", "1205", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-150x150.jpeg", "", "Reduced by 7.8% (552 B)", "6543", "7095", "", "10", "0", "1", "2021-01-01 15:19:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1603", "1205", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-768x511.jpeg", "", "Reduced by 6.4% (6.8 KB)", "101582", "108547", "", "10", "0", "1", "2021-01-01 15:19:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1604", "1205", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-570x570.jpeg", "", "Reduced by 5.5% (4.1 KB)", "72885", "77106", "", "10", "0", "1", "2021-01-01 15:19:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1605", "1205", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-600x723.jpeg", "", "Reduced by 5.7% (5.9 KB)", "100148", "106168", "", "10", "0", "1", "2021-01-01 15:19:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1606", "1205", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-800x600.jpeg", "", "Reduced by 5.9% (7.0 KB)", "114258", "121415", "", "10", "0", "1", "2021-01-01 15:19:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1607", "1205", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-345x198.jpeg", "", "Reduced by 7.4% (1.7 KB)", "21496", "23215", "", "10", "0", "1", "2021-01-01 15:19:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1608", "1205", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-400x260.jpeg", "", "Reduced by 7.0% (2.3 KB)", "30967", "33301", "", "10", "0", "1", "2021-01-01 15:19:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1609", "1205", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-500x380.jpeg", "", "Reduced by 6.1% (3.2 KB)", "51042", "54353", "", "10", "0", "1", "2021-01-01 15:19:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1610", "1205", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-500x500.jpeg", "", "Reduced by 5.8% (3.5 KB)", "58010", "61591", "", "10", "0", "1", "2021-01-01 15:19:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1611", "1205", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-1000x500.jpeg", "", "Reduced by 6.0% (8.1 KB)", "128921", "137194", "", "10", "0", "1", "2021-01-01 15:19:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1612", "1205", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-500x723.jpeg", "", "Reduced by 5.6% (4.7 KB)", "81661", "86491", "", "10", "0", "1", "2021-01-01 15:19:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1613", "1205", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-1000x723.jpeg", "", "Reduced by 6.3% (12.6 KB)", "190311", "203191", "", "10", "0", "1", "2021-01-01 15:19:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1614", "1205", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-700x466.jpeg", "", "Reduced by 6.5% (5.9 KB)", "87438", "93509", "", "10", "0", "1", "2021-01-01 15:19:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1615", "1205", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/10AFD744-BEC9-46D7-88EA-813CC6C3A857_1_105_c-1-539x303.jpeg", "", "Reduced by 6.6% (3.3 KB)", "47678", "51068", "", "10", "0", "1", "2021-01-01 15:19:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1616", "1206", "media", "full", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1.jpeg", "", "Reduced by 0.6% (2.1 KB)", "389237", "391422", "", "10", "0", "1", "2021-01-01 15:19:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1617", "1206", "media", "medium", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-300x225.jpeg", "", "Reduced by 7.9% (1.8 KB)", "21138", "22941", "", "10", "0", "1", "2021-01-01 15:19:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1618", "1206", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-150x150.jpeg", "", "Reduced by 9.0% (760 B)", "7708", "8468", "", "10", "0", "1", "2021-01-01 15:19:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1619", "1206", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-768x576.jpeg", "", "Reduced by 6.5% (8.3 KB)", "123661", "132209", "", "10", "0", "1", "2021-01-01 15:19:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1620", "1206", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-570x570.jpeg", "", "Reduced by 6.1% (5.8 KB)", "90532", "96453", "", "10", "0", "1", "2021-01-01 15:19:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1621", "1206", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-600x768.jpeg", "", "Reduced by 6.4% (9.4 KB)", "141532", "151180", "", "10", "0", "1", "2021-01-01 15:19:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1622", "1206", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-800x600.jpeg", "", "Reduced by 6.2% (8.5 KB)", "131422", "140083", "", "10", "0", "1", "2021-01-01 15:19:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1623", "1206", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-345x198.jpeg", "", "Reduced by 7.6% (1.7 KB)", "21406", "23174", "", "10", "0", "1", "2021-01-01 15:19:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1624", "1206", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-400x260.jpeg", "", "Reduced by 7.2% (2.4 KB)", "31628", "34079", "", "10", "0", "1", "2021-01-01 15:19:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1625", "1206", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-500x380.jpeg", "", "Reduced by 6.9% (4.1 KB)", "56419", "60571", "", "10", "0", "1", "2021-01-01 15:19:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1626", "1206", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-500x500.jpeg", "", "Reduced by 6.5% (4.8 KB)", "71064", "75988", "", "10", "0", "1", "2021-01-01 15:19:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1627", "1206", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.7% (7.7 KB)", "130794", "138628", "", "10", "0", "1", "2021-01-01 15:19:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1628", "1206", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-500x768.jpeg", "", "Reduced by 6.3% (7.8 KB)", "119232", "127215", "", "10", "0", "1", "2021-01-01 15:19:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1629", "1206", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-1000x768.jpeg", "", "Reduced by 6.5% (16.1 KB)", "235808", "252253", "", "10", "0", "1", "2021-01-01 15:19:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1630", "1206", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-700x525.jpeg", "", "Reduced by 6.4% (7.0 KB)", "104037", "111164", "", "10", "0", "1", "2021-01-01 15:19:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1631", "1206", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/25F208E6-0013-4E1C-B852-45F402912BE3_1_105_c-1-539x303.jpeg", "", "Reduced by 6.6% (3.4 KB)", "48488", "51937", "", "10", "0", "1", "2021-01-01 15:19:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1632", "1207", "media", "full", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1.jpeg", "", "Reduced by 0.5% (1.8 KB)", "353188", "355052", "", "10", "0", "1", "2021-01-01 15:20:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1633", "1207", "media", "medium", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-300x225.jpeg", "", "Reduced by 6.5% (1.2 KB)", "17317", "18526", "", "10", "0", "1", "2021-01-01 15:20:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1634", "1207", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-150x150.jpeg", "", "Reduced by 9.0% (605 B)", "6114", "6719", "", "10", "0", "1", "2021-01-01 15:20:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1635", "1207", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-768x576.jpeg", "", "Reduced by 5.6% (6.1 KB)", "105870", "112096", "", "10", "0", "1", "2021-01-01 15:20:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1636", "1207", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-570x570.jpeg", "", "Reduced by 5.4% (4.3 KB)", "77192", "81610", "", "10", "0", "1", "2021-01-01 15:20:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1637", "1207", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-600x768.jpeg", "", "Reduced by 5.5% (6.8 KB)", "119533", "126521", "", "10", "0", "1", "2021-01-01 15:20:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1638", "1207", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-800x600.jpeg", "", "Reduced by 5.4% (6.3 KB)", "112925", "119366", "", "10", "0", "1", "2021-01-01 15:20:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1639", "1207", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-345x198.jpeg", "", "Reduced by 6.3% (1.1 KB)", "17358", "18527", "", "10", "0", "1", "2021-01-01 15:20:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1640", "1207", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-400x260.jpeg", "", "Reduced by 6.1% (1.7 KB)", "25928", "27625", "", "10", "0", "1", "2021-01-01 15:20:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1641", "1207", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-500x380.jpeg", "", "Reduced by 6.1% (3.0 KB)", "46867", "49897", "", "10", "0", "1", "2021-01-01 15:20:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1642", "1207", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-500x500.jpeg", "", "Reduced by 5.9% (3.7 KB)", "60273", "64064", "", "10", "0", "1", "2021-01-01 15:20:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1643", "1207", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-1000x500.jpeg", "", "Reduced by 4.8% (5.6 KB)", "113213", "118904", "", "10", "0", "1", "2021-01-01 15:20:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1644", "1207", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-500x768.jpeg", "", "Reduced by 5.7% (5.9 KB)", "100323", "106365", "", "10", "0", "1", "2021-01-01 15:20:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1645", "1207", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-1000x768.jpeg", "", "Reduced by 5.6% (11.7 KB)", "202768", "214700", "", "10", "0", "1", "2021-01-01 15:20:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1646", "1207", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-700x525.jpeg", "", "Reduced by 5.7% (5.2 KB)", "88344", "93679", "", "10", "0", "1", "2021-01-01 15:20:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1647", "1207", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/665A4A31-2E1A-4EBB-8373-D63BA652BCAC_1_105_c-1-539x303.jpeg", "", "Reduced by 6.0% (2.5 KB)", "40379", "42945", "", "10", "0", "1", "2021-01-01 15:20:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1648", "1210", "media", "full", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1.jpeg", "", "Reduced by 0.6% (2.1 KB)", "379037", "381228", "", "10", "0", "1", "2021-01-01 15:20:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1649", "1210", "media", "medium", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-300x225.jpeg", "", "Reduced by 7.4% (1.6 KB)", "20819", "22483", "", "10", "0", "1", "2021-01-01 15:20:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1650", "1210", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-150x150.jpeg", "", "Reduced by 8.0% (643 B)", "7354", "7997", "", "10", "0", "1", "2021-01-01 15:20:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1651", "1210", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-768x576.jpeg", "", "Reduced by 6.3% (7.9 KB)", "120522", "128654", "", "10", "0", "1", "2021-01-01 15:20:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1652", "1210", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-570x570.jpeg", "", "Reduced by 5.7% (5.0 KB)", "84995", "90145", "", "10", "0", "1", "2021-01-01 15:20:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1653", "1210", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-600x768.jpeg", "", "Reduced by 5.8% (7.7 KB)", "128317", "136159", "", "10", "0", "1", "2021-01-01 15:20:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1654", "1210", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-800x600.jpeg", "", "Reduced by 6.1% (8.2 KB)", "128186", "136570", "", "10", "0", "1", "2021-01-01 15:20:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1655", "1210", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-345x198.jpeg", "", "Reduced by 7.2% (1.6 KB)", "20997", "22632", "", "10", "0", "1", "2021-01-01 15:20:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1656", "1210", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-400x260.jpeg", "", "Reduced by 7.2% (2.4 KB)", "31161", "33577", "", "10", "0", "1", "2021-01-01 15:20:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1657", "1210", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-500x380.jpeg", "", "Reduced by 6.8% (3.9 KB)", "54802", "58777", "", "10", "0", "1", "2021-01-01 15:20:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1658", "1210", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-500x500.jpeg", "", "Reduced by 6.3% (4.4 KB)", "66512", "71012", "", "10", "0", "1", "2021-01-01 15:20:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1659", "1210", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.7% (7.5 KB)", "128013", "135733", "", "10", "0", "1", "2021-01-01 15:20:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1660", "1210", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-500x768.jpeg", "", "Reduced by 5.6% (6.0 KB)", "104466", "110619", "", "10", "0", "1", "2021-01-01 15:20:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1661", "1210", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-1000x768.jpeg", "", "Reduced by 6.4% (15.2 KB)", "227631", "243208", "", "10", "0", "1", "2021-01-01 15:20:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1662", "1210", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-700x525.jpeg", "", "Reduced by 6.6% (6.9 KB)", "101047", "108163", "", "10", "0", "1", "2021-01-01 15:20:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1663", "1210", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/BDB7644B-C2F9-40F9-866D-E67B905A679B_1_105_c-1-539x303.jpeg", "", "Reduced by 6.7% (3.3 KB)", "47289", "50663", "", "10", "0", "1", "2021-01-01 15:20:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1664", "1211", "media", "full", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1.jpeg", "", "Reduced by 0.7% (1.4 KB)", "212648", "214099", "", "10", "0", "1", "2021-01-01 15:20:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1665", "1211", "media", "medium", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-300x200.jpeg", "", "Reduced by 6.3% (649 B)", "9684", "10333", "", "10", "0", "1", "2021-01-01 15:20:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1666", "1211", "media", "large", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-1024x681.jpeg", "", "Reduced by 5.7% (4.5 KB)", "77753", "82412", "", "10", "0", "1", "2021-01-01 15:20:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1667", "1211", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-150x150.jpeg", "", "Reduced by 8.5% (394 B)", "4253", "4647", "", "10", "0", "1", "2021-01-01 15:20:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1668", "1211", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-768x511.jpeg", "", "Reduced by 5.7% (2.8 KB)", "47049", "49875", "", "10", "0", "1", "2021-01-01 15:20:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1669", "1211", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-570x570.jpeg", "", "Reduced by 5.9% (2.3 KB)", "37452", "39821", "", "10", "0", "1", "2021-01-01 15:20:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1670", "1211", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-600x723.jpeg", "", "Reduced by 6.2% (3.3 KB)", "52196", "55623", "", "10", "0", "1", "2021-01-01 15:20:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1671", "1211", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-800x600.jpeg", "", "Reduced by 5.9% (3.2 KB)", "52816", "56120", "", "10", "0", "1", "2021-01-01 15:20:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1672", "1211", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-345x198.jpeg", "", "Reduced by 6.4% (745 B)", "10940", "11685", "", "10", "0", "1", "2021-01-01 15:20:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1673", "1211", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-400x260.jpeg", "", "Reduced by 6.1% (993 B)", "15270", "16263", "", "10", "0", "1", "2021-01-01 15:20:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1674", "1211", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-500x380.jpeg", "", "Reduced by 6.3% (1.6 KB)", "24185", "25817", "", "10", "0", "1", "2021-01-01 15:20:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1675", "1211", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-500x500.jpeg", "", "Reduced by 6.2% (1.9 KB)", "30063", "32045", "", "10", "0", "1", "2021-01-01 15:20:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1676", "1211", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.8% (3.4 KB)", "56875", "60352", "", "10", "0", "1", "2021-01-01 15:20:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1677", "1211", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-500x723.jpeg", "", "Reduced by 6.1% (2.8 KB)", "44341", "47234", "", "10", "0", "1", "2021-01-01 15:20:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1678", "1211", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-1000x723.jpeg", "", "Reduced by 6.2% (5.4 KB)", "84699", "90270", "", "10", "0", "1", "2021-01-01 15:20:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1679", "1211", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-700x466.jpeg", "", "Reduced by 5.8% (2.5 KB)", "41098", "43625", "", "10", "0", "1", "2021-01-01 15:20:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1680", "1211", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/C100539D-EE79-43C0-9D18-84CD0C20C24D_1_105_c-1-539x303.jpeg", "", "Reduced by 6.0% (1.4 KB)", "22597", "24046", "", "10", "0", "1", "2021-01-01 15:20:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1681", "1212", "media", "full", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1.jpeg", "", "Reduced by 0.2% (521 B)", "274421", "274942", "", "10", "0", "1", "2021-01-01 15:20:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1682", "1212", "media", "medium", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-300x199.jpeg", "", "Reduced by 5.2% (740 B)", "13510", "14250", "", "10", "0", "1", "2021-01-01 15:20:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1683", "1212", "media", "large", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-1024x678.jpeg", "", "Reduced by 5.5% (7.2 KB)", "126250", "133627", "", "10", "0", "1", "2021-01-01 15:20:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1684", "1212", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-150x150.jpeg", "", "Reduced by 7.4% (444 B)", "5580", "6024", "", "10", "0", "1", "2021-01-01 15:20:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1685", "1212", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-768x508.jpeg", "", "Reduced by 5.7% (4.5 KB)", "76331", "80911", "", "10", "0", "1", "2021-01-01 15:20:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1686", "1212", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-570x570.jpeg", "", "Reduced by 5.7% (3.8 KB)", "63274", "67117", "", "10", "0", "1", "2021-01-01 15:20:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1687", "1212", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-600x721.jpeg", "", "Reduced by 6.4% (6.0 KB)", "88577", "94680", "", "10", "0", "1", "2021-01-01 15:20:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1688", "1212", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-800x600.jpeg", "", "Reduced by 5.7% (5.3 KB)", "90176", "95579", "", "10", "0", "1", "2021-01-01 15:20:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1689", "1212", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-345x198.jpeg", "", "Reduced by 5.1% (839 B)", "15609", "16448", "", "10", "0", "1", "2021-01-01 15:20:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1690", "1212", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-400x260.jpeg", "", "Reduced by 5.4% (1.3 KB)", "22491", "23784", "", "10", "0", "1", "2021-01-01 15:20:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1691", "1212", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-500x380.jpeg", "", "Reduced by 6.1% (2.5 KB)", "39009", "41526", "", "10", "0", "1", "2021-01-01 15:20:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1692", "1212", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-500x500.jpeg", "", "Reduced by 6.3% (3.3 KB)", "49836", "53204", "", "10", "0", "1", "2021-01-01 15:20:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1693", "1212", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-1000x500.jpeg", "", "Reduced by 5.4% (5.5 KB)", "98172", "103769", "", "10", "0", "1", "2021-01-01 15:20:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1694", "1212", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-500x721.jpeg", "", "Reduced by 6.6% (5.2 KB)", "75045", "80329", "", "10", "0", "1", "2021-01-01 15:20:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1695", "1212", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-1000x721.jpeg", "", "Reduced by 6.2% (9.4 KB)", "145596", "155264", "", "10", "0", "1", "2021-01-01 15:20:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1696", "1212", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-700x463.jpeg", "", "Reduced by 5.9% (3.9 KB)", "64484", "68494", "", "10", "0", "1", "2021-01-01 15:20:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1697", "1212", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/D6DCFE8F-47A1-48B7-BC69-BD7E19DE9C59_1_105_c-1-539x303.jpeg", "", "Reduced by 6.0% (2.2 KB)", "34820", "37024", "", "10", "0", "1", "2021-01-01 15:20:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1698", "1213", "media", "full", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1.jpeg", "", "Reduced by 0.7% (2.3 KB)", "325974", "328330", "", "10", "0", "1", "2021-01-01 15:20:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1699", "1213", "media", "medium", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-300x225.jpeg", "", "Reduced by 6.0% (1.0 KB)", "16873", "17945", "", "10", "0", "1", "2021-01-01 15:20:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1700", "1213", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-150x150.jpeg", "", "Reduced by 7.4% (492 B)", "6174", "6666", "", "10", "0", "1", "2021-01-01 15:20:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1701", "1213", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-768x576.jpeg", "", "Reduced by 5.1% (4.6 KB)", "88665", "93395", "", "10", "0", "1", "2021-01-01 15:20:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1702", "1213", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-570x570.jpeg", "", "Reduced by 5.0% (3.4 KB)", "65206", "68656", "", "10", "0", "1", "2021-01-01 15:20:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1703", "1213", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-600x768.jpeg", "", "Reduced by 5.6% (5.3 KB)", "91688", "97140", "", "10", "0", "1", "2021-01-01 15:20:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1704", "1213", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-800x600.jpeg", "", "Reduced by 5.1% (5.0 KB)", "95472", "100616", "", "10", "0", "1", "2021-01-01 15:20:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1705", "1213", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-345x198.jpeg", "", "Reduced by 6.3% (1.1 KB)", "17189", "18350", "", "10", "0", "1", "2021-01-01 15:20:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1706", "1213", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-400x260.jpeg", "", "Reduced by 5.8% (1.5 KB)", "24871", "26393", "", "10", "0", "1", "2021-01-01 15:20:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1707", "1213", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-500x380.jpeg", "", "Reduced by 5.8% (2.6 KB)", "42878", "45511", "", "10", "0", "1", "2021-01-01 15:20:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1708", "1213", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-500x500.jpeg", "", "Reduced by 5.5% (2.9 KB)", "52038", "55058", "", "10", "0", "1", "2021-01-01 15:20:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1709", "1213", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-1000x500.jpeg", "", "Reduced by 4.8% (4.6 KB)", "94602", "99324", "", "10", "0", "1", "2021-01-01 15:20:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1710", "1213", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-500x768.jpeg", "", "Reduced by 5.4% (4.2 KB)", "75184", "79440", "", "10", "0", "1", "2021-01-01 15:20:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1711", "1213", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-1000x768.jpeg", "", "Reduced by 5.6% (9.3 KB)", "160165", "169656", "", "10", "0", "1", "2021-01-01 15:20:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1712", "1213", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-700x525.jpeg", "", "Reduced by 5.3% (4.2 KB)", "76645", "80913", "", "10", "0", "1", "2021-01-01 15:21:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1713", "1213", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/EB132D80-445E-40C4-9CF0-9275BD8B832E_1_105_c-1-539x303.jpeg", "", "Reduced by 5.5% (2.1 KB)", "37279", "39454", "", "10", "0", "1", "2021-01-01 15:21:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1714", "1219", "media", "full", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1.jpeg", "", "Reduced by 1.4% (3.4 KB)", "246334", "249777", "", "10", "0", "1", "2021-01-01 15:21:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1715", "1219", "media", "medium", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-300x225.jpeg", "", "Reduced by 7.7% (707 B)", "8496", "9203", "", "10", "0", "1", "2021-01-01 15:21:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1716", "1219", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-150x150.jpeg", "", "Reduced by 10.1% (395 B)", "3519", "3914", "", "10", "0", "1", "2021-01-01 15:21:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1717", "1219", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-768x576.jpeg", "", "Reduced by 9.5% (3.7 KB)", "35671", "39428", "", "10", "0", "1", "2021-01-01 15:21:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1718", "1219", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-570x570.jpeg", "", "Reduced by 10.1% (2.8 KB)", "25763", "28667", "", "10", "0", "1", "2021-01-01 15:21:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1719", "1219", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-600x768.jpeg", "", "Reduced by 11.7% (4.1 KB)", "31616", "35815", "", "10", "0", "1", "2021-01-01 15:21:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1720", "1219", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-800x600.jpeg", "", "Reduced by 9.9% (4.0 KB)", "37459", "41570", "", "10", "0", "1", "2021-01-01 15:21:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1721", "1219", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-345x198.jpeg", "", "Reduced by 8.3% (853 B)", "9481", "10334", "", "10", "0", "1", "2021-01-01 15:21:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1722", "1219", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-400x260.jpeg", "", "Reduced by 8.2% (1.1 KB)", "12437", "13547", "", "10", "0", "1", "2021-01-01 15:21:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1723", "1219", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-500x380.jpeg", "", "Reduced by 8.5% (1.7 KB)", "18745", "20482", "", "10", "0", "1", "2021-01-01 15:21:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1724", "1219", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-500x500.jpeg", "", "Reduced by 10.0% (2.3 KB)", "21151", "23489", "", "10", "0", "1", "2021-01-01 15:21:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1725", "1219", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-1000x500.jpeg", "", "Reduced by 9.3% (4.4 KB)", "44330", "48850", "", "10", "0", "1", "2021-01-01 15:21:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1726", "1219", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-500x768.jpeg", "", "Reduced by 11.8% (3.4 KB)", "26298", "29824", "", "10", "0", "1", "2021-01-01 15:21:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1727", "1219", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-1000x768.jpeg", "", "Reduced by 10.3% (6.3 KB)", "56343", "62797", "", "10", "0", "1", "2021-01-01 15:21:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1728", "1219", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-700x525.jpeg", "", "Reduced by 9.5% (3.2 KB)", "30886", "34120", "", "10", "0", "1", "2021-01-01 15:21:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1729", "1219", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/A886E335-5510-49DF-951E-E25BE765E66F_1_105_c-1-1-539x303.jpeg", "", "Reduced by 7.7% (1.5 KB)", "18771", "20337", "", "10", "0", "1", "2021-01-01 15:21:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1730", "1223", "media", "full", "ABSPATHwp-content/uploads/2020/12/1562805695363-1.jpg", "", "Reduced by 0.9% (7.4 KB)", "801458", "809053", "", "10", "0", "1", "2021-01-01 15:21:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1731", "1223", "media", "medium", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-300x225.jpg", "", "Reduced by 6.1% (1.3 KB)", "19644", "20925", "", "10", "0", "1", "2021-01-01 15:21:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1732", "1223", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-150x150.jpg", "", "Reduced by 7.6% (591 B)", "7153", "7744", "", "10", "0", "1", "2021-01-01 15:21:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1733", "1223", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-768x576.jpg", "", "Reduced by 5.5% (6.8 KB)", "119033", "125961", "", "10", "0", "1", "2021-01-01 15:21:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1734", "1223", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-570x570.jpg", "", "Reduced by 5.2% (4.7 KB)", "87476", "92298", "", "10", "0", "1", "2021-01-01 15:21:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1735", "1223", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-600x768.jpg", "", "Reduced by 5.1% (7.2 KB)", "136894", "144288", "", "10", "0", "1", "2021-01-01 15:21:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1736", "1223", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-800x600.jpg", "", "Reduced by 5.3% (6.9 KB)", "126878", "133987", "", "10", "0", "1", "2021-01-01 15:21:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1737", "1223", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-345x198.jpg", "", "Reduced by 6.2% (1.2 KB)", "19331", "20600", "", "10", "0", "1", "2021-01-01 15:21:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1738", "1223", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-400x260.jpg", "", "Reduced by 5.8% (1.8 KB)", "29004", "30805", "", "10", "0", "1", "2021-01-01 15:21:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1739", "1223", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-500x380.jpg", "", "Reduced by 5.8% (3.2 KB)", "52801", "56047", "", "10", "0", "1", "2021-01-01 15:21:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1740", "1223", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-500x500.jpg", "", "Reduced by 5.6% (4.0 KB)", "68337", "72399", "", "10", "0", "1", "2021-01-01 15:21:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1741", "1223", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-1000x500.jpg", "", "Reduced by 4.8% (6.1 KB)", "124250", "130524", "", "10", "0", "1", "2021-01-01 15:21:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1742", "1223", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-500x768.jpg", "", "Reduced by 5.2% (6.2 KB)", "115729", "122038", "", "10", "0", "1", "2021-01-01 15:21:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1743", "1223", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-1000x768.jpg", "", "Reduced by 5.2% (12.3 KB)", "227149", "239694", "", "10", "0", "1", "2021-01-01 15:21:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1744", "1223", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-700x525.jpg", "", "Reduced by 5.4% (5.6 KB)", "99431", "105161", "", "10", "0", "1", "2021-01-01 15:21:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1745", "1223", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/1562805695363-1-539x303.jpg", "", "Reduced by 5.6% (2.6 KB)", "44437", "47056", "", "10", "0", "1", "2021-01-01 15:21:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1746", "1224", "media", "full", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1.jpg", "", "Reduced by 0.7% (4.6 KB)", "642034", "646770", "", "10", "0", "1", "2021-01-01 15:21:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1747", "1224", "media", "medium", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-300x225.jpg", "", "Reduced by 8.4% (2.0 KB)", "22072", "24094", "", "10", "0", "1", "2021-01-01 15:21:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1748", "1224", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-150x150.jpg", "", "Reduced by 9.9% (979 B)", "8881", "9860", "", "10", "0", "1", "2021-01-01 15:21:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1749", "1224", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-768x576.jpg", "", "Reduced by 6.3% (7.1 KB)", "109269", "116575", "", "10", "0", "1", "2021-01-01 15:21:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1750", "1224", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-570x570.jpg", "", "Reduced by 6.3% (5.6 KB)", "85616", "91362", "", "10", "0", "1", "2021-01-01 15:21:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1751", "1224", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-600x768.jpg", "", "Reduced by 6.4% (8.7 KB)", "129997", "138890", "", "10", "0", "1", "2021-01-01 15:21:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1752", "1224", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-800x600.jpg", "", "Reduced by 6.2% (7.4 KB)", "115793", "123414", "", "10", "0", "1", "2021-01-01 15:21:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1753", "1224", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-345x198.jpg", "", "Reduced by 7.9% (1.8 KB)", "21389", "23227", "", "10", "0", "1", "2021-01-01 15:21:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1754", "1224", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-400x260.jpg", "", "Reduced by 7.8% (2.5 KB)", "31026", "33636", "", "10", "0", "1", "2021-01-01 15:21:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1755", "1224", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-500x380.jpg", "", "Reduced by 7.2% (4.0 KB)", "53640", "57778", "", "10", "0", "1", "2021-01-01 15:21:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1756", "1224", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-500x500.jpg", "", "Reduced by 6.8% (4.9 KB)", "68613", "73595", "", "10", "0", "1", "2021-01-01 15:21:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1757", "1224", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-1000x500.jpg", "", "Reduced by 5.5% (6.2 KB)", "110347", "116712", "", "10", "0", "1", "2021-01-01 15:21:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1758", "1224", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-500x768.jpg", "", "Reduced by 6.5% (7.6 KB)", "111776", "119608", "", "10", "0", "1", "2021-01-01 15:21:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1759", "1224", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-1000x768.jpg", "", "Reduced by 6.0% (12.0 KB)", "192247", "204518", "", "10", "0", "1", "2021-01-01 15:21:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1760", "1224", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-700x525.jpg", "", "Reduced by 6.5% (6.3 KB)", "93334", "99778", "", "10", "0", "1", "2021-01-01 15:21:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1761", "1224", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/15532044241315943054486179913295-1-539x303.jpg", "", "Reduced by 6.8% (3.1 KB)", "44332", "47552", "", "10", "0", "1", "2021-01-01 15:21:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1762", "1225", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_5897-1.jpg", "", "Reduced by 1.1% (7.0 KB)", "640316", "647483", "", "10", "0", "1", "2021-01-01 15:21:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1763", "1225", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_5897-1-300x225.jpg", "", "Reduced by 6.3% (1.1 KB)", "16954", "18085", "", "10", "0", "1", "2021-01-01 15:21:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1764", "1225", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_5897-1-150x150.jpg", "", "Reduced by 7.8% (537 B)", "6370", "6907", "", "10", "0", "1", "2021-01-01 15:21:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1765", "1225", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_5897-1-768x576.jpg", "", "Reduced by 5.1% (4.2 KB)", "79704", "84006", "", "10", "0", "1", "2021-01-01 15:21:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1766", "1225", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_5897-1-570x570.jpg", "", "Reduced by 5.3% (3.1 KB)", "56671", "59818", "", "10", "0", "1", "2021-01-01 15:21:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1767", "1225", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_5897-1-600x768.jpg", "", "Reduced by 5.4% (4.2 KB)", "75169", "79494", "", "10", "0", "1", "2021-01-01 15:21:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1768", "1225", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_5897-1-800x600.jpg", "", "Reduced by 5.0% (4.4 KB)", "84638", "89115", "", "10", "0", "1", "2021-01-01 15:21:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1769", "1225", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_5897-1-345x198.jpg", "", "Reduced by 6.1% (1,008 B)", "15432", "16440", "", "10", "0", "1", "2021-01-01 15:21:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1770", "1225", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_5897-1-400x260.jpg", "", "Reduced by 5.8% (1.4 KB)", "22813", "24214", "", "10", "0", "1", "2021-01-01 15:21:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1771", "1225", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_5897-1-500x380.jpg", "", "Reduced by 5.7% (2.4 KB)", "40325", "42749", "", "10", "0", "1", "2021-01-01 15:21:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1772", "1225", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_5897-1-500x500.jpg", "", "Reduced by 5.5% (2.6 KB)", "45911", "48580", "", "10", "0", "1", "2021-01-01 15:21:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1773", "1225", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_5897-1-1000x500.jpg", "", "Reduced by 5.3% (4.0 KB)", "72274", "76333", "", "10", "0", "1", "2021-01-01 15:21:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1774", "1225", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_5897-1-500x768.jpg", "", "Reduced by 5.6% (3.6 KB)", "61841", "65507", "", "10", "0", "1", "2021-01-01 15:21:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1775", "1225", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_5897-1-1000x768.jpg", "", "Reduced by 5.4% (7.3 KB)", "132193", "139666", "", "10", "0", "1", "2021-01-01 15:21:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1776", "1225", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_5897-1-700x525.jpg", "", "Reduced by 5.2% (3.7 KB)", "68975", "72724", "", "10", "0", "1", "2021-01-01 15:21:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1777", "1225", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_5897-1-539x303.jpg", "", "Reduced by 5.4% (1.7 KB)", "31395", "33171", "", "10", "0", "1", "2021-01-01 15:21:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1778", "1226", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_5934-1.jpg", "", "Reduced by 0.7% (1.8 KB)", "272965", "274824", "", "10", "0", "1", "2021-01-01 15:21:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1779", "1226", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_5934-1-300x225.jpg", "", "Reduced by 7.4% (689 B)", "8647", "9336", "", "10", "0", "1", "2021-01-01 15:21:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1780", "1226", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_5934-1-150x150.jpg", "", "Reduced by 9.8% (399 B)", "3683", "4082", "", "10", "0", "1", "2021-01-01 15:21:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1781", "1226", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_5934-1-768x576.jpg", "", "Reduced by 7.1% (2.7 KB)", "36211", "38994", "", "10", "0", "1", "2021-01-01 15:21:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1782", "1226", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_5934-1-570x570.jpg", "", "Reduced by 7.0% (2.0 KB)", "27809", "29893", "", "10", "0", "1", "2021-01-01 15:21:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1783", "1226", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_5934-1-600x768.jpg", "", "Reduced by 7.6% (2.9 KB)", "36533", "39538", "", "10", "0", "1", "2021-01-01 15:21:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1784", "1226", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_5934-1-800x600.jpg", "", "Reduced by 7.5% (3.0 KB)", "38192", "41270", "", "10", "0", "1", "2021-01-01 15:21:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1785", "1226", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_5934-1-345x198.jpg", "", "Reduced by 9.0% (672 B)", "6767", "7439", "", "10", "0", "1", "2021-01-01 15:21:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1786", "1226", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_5934-1-400x260.jpg", "", "Reduced by 7.9% (883 B)", "10252", "11135", "", "10", "0", "1", "2021-01-01 15:21:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1787", "1226", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_5934-1-500x380.jpg", "", "Reduced by 7.1% (1.4 KB)", "19170", "20635", "", "10", "0", "1", "2021-01-01 15:21:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1788", "1226", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_5934-1-500x500.jpg", "", "Reduced by 7.1% (1.7 KB)", "22770", "24510", "", "10", "0", "1", "2021-01-01 15:21:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1789", "1226", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_5934-1-1000x500.jpg", "", "Reduced by 12.0% (3.6 KB)", "27057", "30733", "", "10", "0", "1", "2021-01-01 15:21:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1790", "1226", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_5934-1-500x768.jpg", "", "Reduced by 7.5% (2.5 KB)", "31574", "34144", "", "10", "0", "1", "2021-01-01 15:21:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1791", "1226", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_5934-1-1000x768.jpg", "", "Reduced by 8.0% (4.9 KB)", "57690", "62723", "", "10", "0", "1", "2021-01-01 15:21:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1792", "1226", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_5934-1-700x525.jpg", "", "Reduced by 7.0% (2.3 KB)", "31686", "34088", "", "10", "0", "1", "2021-01-01 15:21:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1793", "1226", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_5934-1-539x303.jpg", "", "Reduced by 8.8% (1.2 KB)", "12828", "14073", "", "10", "0", "1", "2021-01-01 15:21:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1794", "1227", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_7753-1.jpg", "", "Reduced by 0.9% (3.9 KB)", "447403", "451353", "", "10", "0", "1", "2021-01-01 15:22:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1795", "1227", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_7753-1-300x225.jpg", "", "Reduced by 7.5% (788 B)", "9667", "10455", "", "10", "0", "1", "2021-01-01 15:22:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1796", "1227", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_7753-1-150x150.jpg", "", "Reduced by 9.2% (409 B)", "4044", "4453", "", "10", "0", "1", "2021-01-01 15:22:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1797", "1227", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_7753-1-768x576.jpg", "", "Reduced by 6.6% (3.1 KB)", "45315", "48531", "", "10", "0", "1", "2021-01-01 15:22:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1798", "1227", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_7753-1-570x570.jpg", "", "Reduced by 6.5% (2.3 KB)", "33748", "36078", "", "10", "0", "1", "2021-01-01 15:22:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1799", "1227", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_7753-1-600x768.jpg", "", "Reduced by 7.4% (3.4 KB)", "44093", "47597", "", "10", "0", "1", "2021-01-01 15:22:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1800", "1227", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_7753-1-800x600.jpg", "", "Reduced by 7.0% (3.5 KB)", "48068", "51667", "", "10", "0", "1", "2021-01-01 15:22:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1801", "1227", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_7753-1-345x198.jpg", "", "Reduced by 7.0% (824 B)", "10915", "11739", "", "10", "0", "1", "2021-01-01 15:22:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1802", "1227", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_7753-1-400x260.jpg", "", "Reduced by 7.1% (1.1 KB)", "14199", "15281", "", "10", "0", "1", "2021-01-01 15:22:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1803", "1227", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_7753-1-500x380.jpg", "", "Reduced by 6.0% (1.4 KB)", "22594", "24026", "", "10", "0", "1", "2021-01-01 15:22:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1804", "1227", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_7753-1-500x500.jpg", "", "Reduced by 6.3% (1.8 KB)", "27334", "29180", "", "10", "0", "1", "2021-01-01 15:22:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1805", "1227", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_7753-1-1000x500.jpg", "", "Reduced by 6.4% (3.8 KB)", "56965", "60829", "", "10", "0", "1", "2021-01-01 15:22:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1806", "1227", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_7753-1-500x768.jpg", "", "Reduced by 7.9% (3.0 KB)", "35721", "38788", "", "10", "0", "1", "2021-01-01 15:22:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1807", "1227", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_7753-1-1000x768.jpg", "", "Reduced by 7.1% (5.8 KB)", "77237", "83132", "", "10", "0", "1", "2021-01-01 15:22:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1808", "1227", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_7753-1-700x525.jpg", "", "Reduced by 6.6% (2.7 KB)", "38849", "41593", "", "10", "0", "1", "2021-01-01 15:22:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1809", "1227", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_7753-1-539x303.jpg", "", "Reduced by 6.8% (1.6 KB)", "21842", "23442", "", "10", "0", "1", "2021-01-01 15:22:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1810", "1228", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_7766-1.jpg", "", "Reduced by 0.7% (3.5 KB)", "551122", "554747", "", "10", "0", "1", "2021-01-01 15:22:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1811", "1228", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_7766-1-300x225.jpg", "", "Reduced by 6.1% (928 B)", "14342", "15270", "", "10", "0", "1", "2021-01-01 15:22:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1812", "1228", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_7766-1-150x150.jpg", "", "Reduced by 7.2% (445 B)", "5766", "6211", "", "10", "0", "1", "2021-01-01 15:22:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1813", "1228", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_7766-1-768x576.jpg", "", "Reduced by 5.5% (3.7 KB)", "65339", "69178", "", "10", "0", "1", "2021-01-01 15:22:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1814", "1228", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_7766-1-570x570.jpg", "", "Reduced by 5.5% (2.7 KB)", "48508", "51309", "", "10", "0", "1", "2021-01-01 15:22:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1815", "1228", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_7766-1-600x768.jpg", "", "Reduced by 5.7% (4.0 KB)", "67580", "71696", "", "10", "0", "1", "2021-01-01 15:22:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1816", "1228", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_7766-1-800x600.jpg", "", "Reduced by 5.5% (3.9 KB)", "69428", "73465", "", "10", "0", "1", "2021-01-01 15:22:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1817", "1228", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_7766-1-345x198.jpg", "", "Reduced by 6.2% (918 B)", "13916", "14834", "", "10", "0", "1", "2021-01-01 15:22:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1818", "1228", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_7766-1-400x260.jpg", "", "Reduced by 5.8% (1.2 KB)", "19822", "21047", "", "10", "0", "1", "2021-01-01 15:22:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1819", "1228", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_7766-1-500x380.jpg", "", "Reduced by 5.7% (2.0 KB)", "33082", "35083", "", "10", "0", "1", "2021-01-01 15:22:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1820", "1228", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_7766-1-500x500.jpg", "", "Reduced by 5.9% (2.4 KB)", "39325", "41769", "", "10", "0", "1", "2021-01-01 15:22:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1821", "1228", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_7766-1-1000x500.jpg", "", "Reduced by 5.5% (3.7 KB)", "65156", "68955", "", "10", "0", "1", "2021-01-01 15:22:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1822", "1228", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_7766-1-500x768.jpg", "", "Reduced by 5.7% (3.4 KB)", "57881", "61384", "", "10", "0", "1", "2021-01-01 15:22:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1823", "1228", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_7766-1-1000x768.jpg", "", "Reduced by 5.7% (6.6 KB)", "110483", "117206", "", "10", "0", "1", "2021-01-01 15:22:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1824", "1228", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_7766-1-700x525.jpg", "", "Reduced by 5.5% (3.2 KB)", "56300", "59571", "", "10", "0", "1", "2021-01-01 15:22:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1825", "1228", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_7766-1-539x303.jpg", "", "Reduced by 5.4% (1.6 KB)", "27840", "29438", "", "10", "0", "1", "2021-01-01 15:22:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1826", "1229", "media", "full", "ABSPATHwp-content/uploads/2020/12/img_7767-1.jpg", "", "Reduced by 0.8% (4.2 KB)", "542346", "546653", "", "10", "0", "1", "2021-01-01 15:22:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1827", "1229", "media", "medium", "ABSPATHwp-content/uploads/2020/12/img_7767-1-300x225.jpg", "", "Reduced by 6.6% (860 B)", "12204", "13064", "", "10", "0", "1", "2021-01-01 15:22:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1828", "1229", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/img_7767-1-150x150.jpg", "", "Reduced by 8.1% (407 B)", "4590", "4997", "", "10", "0", "1", "2021-01-01 15:22:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1829", "1229", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/img_7767-1-768x576.jpg", "", "Reduced by 5.6% (3.6 KB)", "62680", "66408", "", "10", "0", "1", "2021-01-01 15:22:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1830", "1229", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/img_7767-1-570x570.jpg", "", "Reduced by 5.8% (2.7 KB)", "45252", "48016", "", "10", "0", "1", "2021-01-01 15:22:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1831", "1229", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/img_7767-1-600x768.jpg", "", "Reduced by 5.8% (3.9 KB)", "64028", "68006", "", "10", "0", "1", "2021-01-01 15:22:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1832", "1229", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/img_7767-1-800x600.jpg", "", "Reduced by 5.8% (4.0 KB)", "66507", "70636", "", "10", "0", "1", "2021-01-01 15:22:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1833", "1229", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/img_7767-1-345x198.jpg", "", "Reduced by 6.3% (863 B)", "12869", "13732", "", "10", "0", "1", "2021-01-01 15:22:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1834", "1229", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/img_7767-1-400x260.jpg", "", "Reduced by 6.4% (1.2 KB)", "18150", "19401", "", "10", "0", "1", "2021-01-01 15:22:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1835", "1229", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/img_7767-1-500x380.jpg", "", "Reduced by 6.2% (1.9 KB)", "29966", "31961", "", "10", "0", "1", "2021-01-01 15:22:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1836", "1229", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/img_7767-1-500x500.jpg", "", "Reduced by 6.4% (2.4 KB)", "36198", "38663", "", "10", "0", "1", "2021-01-01 15:22:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1837", "1229", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/img_7767-1-1000x500.jpg", "", "Reduced by 5.3% (3.8 KB)", "69193", "73052", "", "10", "0", "1", "2021-01-01 15:22:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1838", "1229", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/img_7767-1-500x768.jpg", "", "Reduced by 6.1% (3.4 KB)", "53304", "56750", "", "10", "0", "1", "2021-01-01 15:22:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1839", "1229", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/img_7767-1-1000x768.jpg", "", "Reduced by 5.8% (6.6 KB)", "108781", "115492", "", "10", "0", "1", "2021-01-01 15:22:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1840", "1229", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/img_7767-1-700x525.jpg", "", "Reduced by 5.9% (3.3 KB)", "53301", "56665", "", "10", "0", "1", "2021-01-01 15:22:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1841", "1229", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/img_7767-1-539x303.jpg", "", "Reduced by 5.5% (1.6 KB)", "27359", "28957", "", "10", "0", "1", "2021-01-01 15:22:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1842", "1230", "media", "full", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1.jpg", "", "Reduced by 1.0% (1.5 KB)", "155932", "157456", "", "10", "0", "1", "2021-01-01 15:22:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1843", "1230", "media", "medium", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-300x225.jpg", "", "Reduced by 6.5% (788 B)", "11404", "12192", "", "10", "0", "1", "2021-01-01 15:22:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1844", "1230", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-150x150.jpg", "", "Reduced by 8.6% (434 B)", "4586", "5020", "", "10", "0", "1", "2021-01-01 15:22:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1845", "1230", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-768x576.jpg", "", "Reduced by 5.8% (3.2 KB)", "53448", "56758", "", "10", "0", "1", "2021-01-01 15:22:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1846", "1230", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-570x570.jpg", "", "Reduced by 5.7% (2.3 KB)", "39683", "42083", "", "10", "0", "1", "2021-01-01 15:22:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1847", "1230", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-600x768.jpg", "", "Reduced by 5.9% (3.5 KB)", "57111", "60691", "", "10", "0", "1", "2021-01-01 15:22:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1848", "1230", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-800x600.jpg", "", "Reduced by 6.0% (3.5 KB)", "56699", "60306", "", "10", "0", "1", "2021-01-01 15:22:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1849", "1230", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-345x198.jpg", "", "Reduced by 7.0% (745 B)", "9925", "10670", "", "10", "0", "1", "2021-01-01 15:22:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1850", "1230", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-400x260.jpg", "", "Reduced by 6.2% (1,012 B)", "15217", "16229", "", "10", "0", "1", "2021-01-01 15:22:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1851", "1230", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-500x380.jpg", "", "Reduced by 6.0% (1.7 KB)", "26799", "28507", "", "10", "0", "1", "2021-01-01 15:22:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1852", "1230", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-500x500.jpg", "", "Reduced by 6.1% (2.0 KB)", "31989", "34075", "", "10", "0", "1", "2021-01-01 15:22:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1853", "1230", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-1000x500.jpg", "", "Reduced by 7.1% (3.3 KB)", "44090", "47461", "", "10", "0", "1", "2021-01-01 15:22:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1854", "1230", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-500x768.jpg", "", "Reduced by 5.8% (2.9 KB)", "48698", "51698", "", "10", "0", "1", "2021-01-01 15:22:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1855", "1230", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-1000x768.jpg", "", "Reduced by 6.2% (6.0 KB)", "92626", "98751", "", "10", "0", "1", "2021-01-01 15:22:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1856", "1230", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-700x525.jpg", "", "Reduced by 5.8% (2.8 KB)", "46076", "48927", "", "10", "0", "1", "2021-01-01 15:22:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1857", "1230", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-539x303.jpg", "", "Reduced by 6.3% (1.3 KB)", "19427", "20737", "", "10", "0", "1", "2021-01-01 15:22:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1858", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/UNADJUSTEDNONRAW_thumb_9d66-1-300x200.jpg", "", "Reduced by 6.3% (667 B)", "9906", "10573", "", "10", "0", "1", "2021-01-01 15:22:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1859", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-300x200.jpeg", "", "Reduced by 4.9% (689 B)", "13475", "14164", "", "10", "0", "1", "2021-01-01 15:22:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1860", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-300x200.jpg", "", "Reduced by 7.6% (1.2 KB)", "14402", "15585", "", "10", "0", "1", "2021-01-01 15:22:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1861", "1231", "media", "full", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1.jpeg", "", "Reduced by 0.2% (521 B)", "274421", "274942", "", "10", "0", "1", "2021-01-01 15:22:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1862", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-300x200.jpg", "", "Reduced by 6.9% (1.0 KB)", "14076", "15113", "", "10", "0", "1", "2021-01-01 15:22:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1863", "1231", "media", "medium", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-300x199.jpeg", "", "Reduced by 5.2% (740 B)", "13510", "14250", "", "10", "0", "1", "2021-01-01 15:22:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1864", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-300x200.jpg", "", "Reduced by 6.1% (943 B)", "14413", "15356", "", "10", "0", "1", "2021-01-01 15:22:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1865", "1231", "media", "large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-1024x678.jpeg", "", "Reduced by 5.5% (7.2 KB)", "126250", "133627", "", "10", "0", "1", "2021-01-01 15:22:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1866", "1231", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-150x150.jpeg", "", "Reduced by 7.4% (444 B)", "5580", "6024", "", "10", "0", "1", "2021-01-01 15:22:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1867", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-300x200.jpg", "", "Reduced by 7.3% (1.2 KB)", "15451", "16661", "", "10", "0", "1", "2021-01-01 15:22:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1868", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-300x200.jpeg", "", "Reduced by 5.8% (919 B)", "15004", "15923", "", "10", "0", "1", "2021-01-01 15:22:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1869", "1231", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-768x508.jpeg", "", "Reduced by 5.7% (4.5 KB)", "76331", "80911", "", "10", "0", "1", "2021-01-01 15:22:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1870", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-300x200.jpeg", "", "Reduced by 5.9% (1,006 B)", "15942", "16948", "", "10", "0", "1", "2021-01-01 15:22:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1871", "1231", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-570x570.jpeg", "", "Reduced by 5.7% (3.8 KB)", "63274", "67117", "", "10", "0", "1", "2021-01-01 15:22:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1872", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-300x200.jpg", "", "Reduced by 7.4% (1.2 KB)", "15123", "16336", "", "10", "0", "1", "2021-01-01 15:22:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1873", "1231", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-600x721.jpeg", "", "Reduced by 6.4% (6.0 KB)", "88577", "94680", "", "10", "0", "1", "2021-01-01 15:22:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1874", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-300x200.jpg", "", "Reduced by 6.4% (1.1 KB)", "16534", "17670", "", "10", "0", "1", "2021-01-01 15:22:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1875", "1231", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-800x600.jpeg", "", "Reduced by 5.7% (5.3 KB)", "90176", "95579", "", "10", "0", "1", "2021-01-01 15:22:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1876", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-300x200.jpeg", "", "Reduced by 6.5% (1.0 KB)", "15235", "16292", "", "10", "0", "1", "2021-01-01 15:22:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1877", "1231", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-345x198.jpeg", "", "Reduced by 5.1% (839 B)", "15609", "16448", "", "10", "0", "1", "2021-01-01 15:22:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1878", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-300x200.jpeg", "", "Reduced by 6.9% (966 B)", "13043", "14009", "", "10", "0", "1", "2021-01-01 15:22:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1879", "1231", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-400x260.jpeg", "", "Reduced by 5.4% (1.3 KB)", "22491", "23784", "", "10", "0", "1", "2021-01-01 15:22:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1880", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-300x200.jpeg", "", "Reduced by 7.2% (1.4 KB)", "18577", "20023", "", "10", "0", "1", "2021-01-01 15:22:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1881", "1231", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-500x380.jpeg", "", "Reduced by 6.1% (2.5 KB)", "39009", "41526", "", "10", "0", "1", "2021-01-01 15:22:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1882", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-300x200.jpeg", "", "Reduced by 7.5% (1.5 KB)", "18892", "20415", "", "10", "0", "1", "2021-01-01 15:22:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1883", "1231", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-500x500.jpeg", "", "Reduced by 6.3% (3.3 KB)", "49836", "53204", "", "10", "0", "1", "2021-01-01 15:22:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1884", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-300x200.jpeg", "", "Reduced by 7.7% (1.5 KB)", "18980", "20553", "", "10", "0", "1", "2021-01-01 15:22:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1885", "1231", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-1000x500.jpeg", "", "Reduced by 5.4% (5.5 KB)", "98172", "103769", "", "10", "0", "1", "2021-01-01 15:22:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1886", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-300x200.jpeg", "", "Reduced by 7.0% (1.1 KB)", "14831", "15945", "", "10", "0", "1", "2021-01-01 15:22:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1887", "1231", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-500x721.jpeg", "", "Reduced by 6.6% (5.2 KB)", "75045", "80329", "", "10", "0", "1", "2021-01-01 15:22:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1888", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-300x200.jpeg", "", "Reduced by 7.6% (1.2 KB)", "15536", "16806", "", "10", "0", "1", "2021-01-01 15:22:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1889", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-300x200.jpeg", "", "Reduced by 6.8% (660 B)", "9014", "9674", "", "10", "0", "1", "2021-01-01 15:22:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1890", "1231", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-1000x721.jpeg", "", "Reduced by 6.2% (9.4 KB)", "145596", "155264", "", "10", "0", "1", "2021-01-01 15:22:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1891", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-300x200.jpeg", "", "Reduced by 6.2% (856 B)", "12958", "13814", "", "10", "0", "1", "2021-01-01 15:22:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1892", "1231", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-700x463.jpeg", "", "Reduced by 5.9% (3.9 KB)", "64484", "68494", "", "10", "0", "1", "2021-01-01 15:22:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1893", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-300x200.jpeg", "", "Reduced by 6.2% (856 B)", "12958", "13814", "", "10", "0", "1", "2021-01-01 15:22:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1894", "1231", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Grand-Manor-Colonial-Slate-1-539x303.jpeg", "", "Reduced by 6.0% (2.2 KB)", "34820", "37024", "", "10", "0", "1", "2021-01-01 15:22:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1895", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-300x200.jpeg", "", "Reduced by 6.7% (631 B)", "8793", "9424", "", "10", "0", "1", "2021-01-01 15:22:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1896", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-300x200.jpeg", "", "Reduced by 6.7% (631 B)", "8793", "9424", "", "10", "0", "1", "2021-01-01 15:22:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1897", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-300x200.jpeg", "", "Reduced by 8.7% (779 B)", "8214", "8993", "", "10", "0", "1", "2021-01-01 15:22:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1898", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-300x200.jpeg", "", "Reduced by 5.8% (669 B)", "10910", "11579", "", "10", "0", "1", "2021-01-01 15:22:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1899", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-300x200.jpeg", "", "Reduced by 5.8% (669 B)", "10910", "11579", "", "10", "0", "1", "2021-01-01 15:22:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1900", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-300x200.jpeg", "", "Reduced by 5.9% (547 B)", "8664", "9211", "", "10", "0", "1", "2021-01-01 15:22:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1901", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-300x200.jpeg", "", "Reduced by 5.9% (547 B)", "8664", "9211", "", "10", "0", "1", "2021-01-01 15:22:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1902", "1232", "media", "full", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1.jpg", "", "Reduced by 0.5% (7.2 KB)", "1503613", "1511017", "", "10", "0", "1", "2021-01-01 15:23:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1903", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-300x200.jpeg", "", "Reduced by 8.3% (698 B)", "7713", "8411", "", "10", "0", "1", "2021-01-01 15:23:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1904", "1232", "media", "medium", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-300x225.jpg", "", "Reduced by 7.3% (1.3 KB)", "16288", "17579", "", "10", "0", "1", "2021-01-01 15:23:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1905", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-300x200.jpeg", "", "Reduced by 8.3% (698 B)", "7713", "8411", "", "10", "0", "1", "2021-01-01 15:23:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1906", "1232", "media", "large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-1024x768.jpg", "", "Reduced by 8.0% (19.2 KB)", "224791", "244405", "", "10", "0", "1", "2021-01-01 15:23:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1907", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-300x200.jpeg", "", "Reduced by 6.2% (748 B)", "11331", "12079", "", "10", "0", "1", "2021-01-01 15:23:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1908", "1232", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-150x150.jpg", "", "Reduced by 9.3% (599 B)", "5816", "6415", "", "10", "0", "1", "2021-01-01 15:23:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1909", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-300x200.jpeg", "", "Reduced by 6.2% (748 B)", "11331", "12079", "", "10", "0", "1", "2021-01-01 15:23:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1910", "1232", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-768x576.jpg", "", "Reduced by 8.0% (10.1 KB)", "118808", "129117", "", "10", "0", "1", "2021-01-01 15:23:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1911", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-300x200.jpg", "", "Reduced by 7.4% (936 B)", "11649", "12585", "", "10", "0", "1", "2021-01-01 15:23:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1912", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-300x200.jpg", "", "Reduced by 7.4% (936 B)", "11649", "12585", "", "10", "0", "1", "2021-01-01 15:23:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1913", "1232", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-1536x1152.jpg", "", "Reduced by 7.7% (42.3 KB)", "516619", "559942", "", "10", "0", "1", "2021-01-01 15:23:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1914", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-300x200.jpg", "", "Reduced by 6.5% (912 B)", "13158", "14070", "", "10", "0", "1", "2021-01-01 15:23:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1915", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-300x200.jpg", "", "Reduced by 6.5% (912 B)", "13158", "14070", "", "10", "0", "1", "2021-01-01 15:23:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1916", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-300x200.jpg", "", "Reduced by 6.2% (865 B)", "13147", "14012", "", "10", "0", "1", "2021-01-01 15:23:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1917", "1232", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-2048x1536.jpg", "", "Reduced by 7.4% (68.4 KB)", "879912", "949989", "", "10", "0", "1", "2021-01-01 15:23:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1918", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-300x200.jpg", "", "Reduced by 6.2% (865 B)", "13147", "14012", "", "10", "0", "1", "2021-01-01 15:23:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1919", "1232", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-570x570.jpg", "", "Reduced by 8.0% (7.6 KB)", "88388", "96122", "", "10", "0", "1", "2021-01-01 15:23:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1920", NULL, NULL, NULL, "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-300x200.jpg", "", "Reduced by 7.1% (484 B)", "6314", "6798", "", "10", "0", "1", "2021-01-01 15:23:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1921", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-300x200.jpg", "", "Reduced by 5.8% (724 B)", "11794", "12518", "", "10", "0", "1", "2021-01-01 15:23:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1922", "1232", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-600x800.jpg", "", "Reduced by 8.3% (12.4 KB)", "140902", "153583", "", "10", "0", "1", "2021-01-01 15:23:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1923", NULL, NULL, NULL, "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-300x200.jpg", "", "Reduced by 7.5% (877 B)", "10859", "11736", "", "10", "0", "1", "2021-01-01 15:23:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1924", "1232", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-800x600.jpg", "", "Reduced by 8.1% (11.2 KB)", "129796", "141263", "", "10", "0", "1", "2021-01-01 15:23:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1925", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-300x200.jpg", "", "Reduced by 6.1% (779 B)", "12037", "12816", "", "10", "0", "1", "2021-01-01 15:23:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1926", "1232", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-345x198.jpg", "", "Reduced by 7.9% (1.4 KB)", "16768", "18210", "", "10", "0", "1", "2021-01-01 15:23:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1927", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-300x200.jpg", "", "Reduced by 6.1% (779 B)", "12037", "12816", "", "10", "0", "1", "2021-01-01 15:23:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1928", "1232", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-400x260.jpg", "", "Reduced by 7.7% (2.0 KB)", "24977", "27061", "", "10", "0", "1", "2021-01-01 15:23:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1929", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO-1-300x200.jpeg", "", "Reduced by 9.2% (703 B)", "6921", "7624", "", "10", "0", "1", "2021-01-01 15:23:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1930", "1232", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-500x380.jpg", "", "Reduced by 7.6% (3.8 KB)", "47104", "50960", "", "10", "0", "1", "2021-01-01 15:23:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1931", NULL, NULL, NULL, "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO-2-300x200.jpeg", "", "Reduced by 9.2% (703 B)", "6921", "7624", "", "10", "0", "1", "2021-01-01 15:23:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1932", "1232", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-500x500.jpg", "", "Reduced by 8.1% (5.7 KB)", "65907", "71748", "", "10", "0", "1", "2021-01-01 15:23:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1933", "1232", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-1000x500.jpg", "", "Reduced by 8.3% (12.9 KB)", "146219", "159382", "", "10", "0", "1", "2021-01-01 15:23:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1934", "1232", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-500x1000.jpg", "", "Reduced by 8.2% (13.5 KB)", "154310", "168157", "", "10", "0", "1", "2021-01-01 15:23:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1935", "1232", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-1000x1000.jpg", "", "Reduced by 8.1% (25.1 KB)", "293459", "319164", "", "10", "0", "1", "2021-01-01 15:23:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1936", "1232", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-700x525.jpg", "", "Reduced by 8.0% (8.2 KB)", "97009", "105399", "", "10", "0", "1", "2021-01-01 15:23:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1937", "1232", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-2-scaled-1-539x303.jpg", "", "Reduced by 7.9% (3.5 KB)", "41522", "45104", "", "10", "0", "1", "2021-01-01 15:23:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1938", "1233", "media", "full", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1.jpg", "", "Reduced by 0.8% (8.9 KB)", "1190113", "1199206", "", "10", "0", "1", "2021-01-01 15:23:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1939", "1233", "media", "medium", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-300x225.jpg", "", "Reduced by 6.9% (1.2 KB)", "16226", "17426", "", "10", "0", "1", "2021-01-01 15:23:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1940", "1233", "media", "large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-1024x768.jpg", "", "Reduced by 7.1% (14.6 KB)", "195268", "210188", "", "10", "0", "1", "2021-01-01 15:23:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1941", "1233", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-150x150.jpg", "", "Reduced by 8.0% (508 B)", "5853", "6361", "", "10", "0", "1", "2021-01-01 15:23:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1942", "1233", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-768x576.jpg", "", "Reduced by 7.3% (8.3 KB)", "107323", "115790", "", "10", "0", "1", "2021-01-01 15:23:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1943", "1233", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-1536x1152.jpg", "", "Reduced by 6.6% (29.5 KB)", "430306", "460508", "", "10", "0", "1", "2021-01-01 15:23:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1944", "1233", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-2048x1536.jpg", "", "Reduced by 6.1% (45.1 KB)", "717492", "763697", "", "10", "0", "1", "2021-01-01 15:23:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1945", "1233", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-570x570.jpg", "", "Reduced by 7.1% (5.9 KB)", "79473", "85524", "", "10", "0", "1", "2021-01-01 15:23:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1946", "1233", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-600x800.jpg", "", "Reduced by 7.1% (8.7 KB)", "116794", "125692", "", "10", "0", "1", "2021-01-01 15:23:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1947", "1233", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-800x600.jpg", "", "Reduced by 7.2% (8.9 KB)", "116740", "125865", "", "10", "0", "1", "2021-01-01 15:23:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1948", "1233", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-345x198.jpg", "", "Reduced by 7.2% (1.2 KB)", "15749", "16980", "", "10", "0", "1", "2021-01-01 15:23:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1949", "1233", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-400x260.jpg", "", "Reduced by 6.8% (1.7 KB)", "23965", "25703", "", "10", "0", "1", "2021-01-01 15:23:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1950", "1233", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-500x380.jpg", "", "Reduced by 7.0% (3.3 KB)", "45108", "48486", "", "10", "0", "1", "2021-01-01 15:23:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1951", "1233", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-500x500.jpg", "", "Reduced by 7.3% (4.7 KB)", "60610", "65387", "", "10", "0", "1", "2021-01-01 15:23:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1952", "1233", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-1000x500.jpg", "", "Reduced by 7.1% (8.8 KB)", "116589", "125566", "", "10", "0", "1", "2021-01-01 15:23:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1953", "1233", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-500x1000.jpg", "", "Reduced by 6.8% (8.6 KB)", "120023", "128809", "", "10", "0", "1", "2021-01-01 15:23:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1954", "1233", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-1000x1000.jpg", "", "Reduced by 6.7% (17.1 KB)", "244221", "261781", "", "10", "0", "1", "2021-01-01 15:23:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1955", "1233", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-700x525.jpg", "", "Reduced by 7.1% (6.7 KB)", "88797", "95624", "", "10", "0", "1", "2021-01-01 15:23:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1956", "1233", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/CertainTeed-Landmark-IR-Weathered-Wood-scaled-1-539x303.jpg", "", "Reduced by 7.0% (2.7 KB)", "36897", "39665", "", "10", "0", "1", "2021-01-01 15:23:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1957", "1234", "media", "full", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1.jpg", "", "Reduced by 0.5% (4.7 KB)", "881391", "886210", "", "10", "0", "1", "2021-01-01 15:23:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1958", "1234", "media", "medium", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-300x146.jpg", "", "Reduced by 6.2% (725 B)", "10992", "11717", "", "10", "0", "1", "2021-01-01 15:23:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1959", "1234", "media", "large", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-1024x498.jpg", "", "Reduced by 6.6% (9.1 KB)", "131368", "140707", "", "10", "0", "1", "2021-01-01 15:23:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1960", "1234", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-150x150.jpg", "", "Reduced by 7.5% (468 B)", "5791", "6259", "", "10", "0", "1", "2021-01-01 15:23:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1961", "1234", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-768x373.jpg", "", "Reduced by 6.5% (4.8 KB)", "70748", "75703", "", "10", "0", "1", "2021-01-01 15:23:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1962", "1234", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-1536x746.jpg", "", "Reduced by 6.4% (20.0 KB)", "300151", "320581", "", "10", "0", "1", "2021-01-01 15:23:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1963", "1234", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-2048x995.jpg", "", "Reduced by 5.6% (30.2 KB)", "517979", "548878", "", "10", "0", "1", "2021-01-01 15:23:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1964", "1234", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-570x570.jpg", "", "Reduced by 7.4% (7.5 KB)", "96206", "103923", "", "10", "0", "1", "2021-01-01 15:23:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1965", "1234", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-600x800.jpg", "", "Reduced by 7.2% (11.2 KB)", "147018", "158504", "", "10", "0", "1", "2021-01-01 15:23:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1966", "1234", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-800x600.jpg", "", "Reduced by 7.1% (10.1 KB)", "134962", "145318", "", "10", "0", "1", "2021-01-01 15:23:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1967", "1234", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-345x198.jpg", "", "Reduced by 6.5% (1.1 KB)", "16338", "17466", "", "10", "0", "1", "2021-01-01 15:23:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1968", "1234", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-400x260.jpg", "", "Reduced by 6.6% (1.7 KB)", "25211", "26990", "", "10", "0", "1", "2021-01-01 15:23:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1969", "1234", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-500x380.jpg", "", "Reduced by 7.0% (3.6 KB)", "49753", "53482", "", "10", "0", "1", "2021-01-01 15:23:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1970", "1234", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-500x500.jpg", "", "Reduced by 7.5% (5.7 KB)", "71894", "77758", "", "10", "0", "1", "2021-01-01 15:23:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1971", "1234", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-1000x500.jpg", "", "Reduced by 6.7% (9.0 KB)", "128387", "137629", "", "10", "0", "1", "2021-01-01 15:23:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1972", "1234", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-500x1000.jpg", "", "Reduced by 6.7% (10.7 KB)", "153425", "164406", "", "10", "0", "1", "2021-01-01 15:23:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1973", "1234", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-1000x1000.jpg", "", "Reduced by 6.6% (20.6 KB)", "300085", "321167", "", "10", "0", "1", "2021-01-01 15:23:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1974", "1234", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-700x340.jpg", "", "Reduced by 6.4% (3.9 KB)", "58152", "62130", "", "10", "0", "1", "2021-01-01 15:23:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1975", "1234", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/GAF-Armorshield-II-Weathered-Wood-scaled-1-539x303.jpg", "", "Reduced by 6.4% (2.6 KB)", "39520", "42214", "", "10", "0", "1", "2021-01-01 15:23:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1976", "1235", "media", "full", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1.jpeg", "", "Reduced by 0.7% (2.7 KB)", "376664", "379460", "", "10", "0", "1", "2021-01-01 15:23:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1977", "1235", "media", "medium", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-300x200.jpeg", "", "Reduced by 7.0% (1.4 KB)", "19187", "20636", "", "10", "0", "1", "2021-01-01 15:23:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1978", "1235", "media", "large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-1024x681.jpeg", "", "Reduced by 5.9% (11.3 KB)", "183150", "194673", "", "10", "0", "1", "2021-01-01 15:23:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1979", "1235", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-150x150.jpeg", "", "Reduced by 8.1% (648 B)", "7379", "8027", "", "10", "0", "1", "2021-01-01 15:23:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1980", "1235", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-768x511.jpeg", "", "Reduced by 6.6% (7.5 KB)", "109983", "117713", "", "10", "0", "1", "2021-01-01 15:23:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1981", "1235", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-570x570.jpeg", "", "Reduced by 6.2% (5.7 KB)", "88656", "94517", "", "10", "0", "1", "2021-01-01 15:23:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1982", "1235", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-600x723.jpeg", "", "Reduced by 6.5% (8.6 KB)", "127043", "135872", "", "10", "0", "1", "2021-01-01 15:23:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1983", "1235", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-800x600.jpeg", "", "Reduced by 6.0% (8.1 KB)", "129267", "137512", "", "10", "0", "1", "2021-01-01 15:23:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1984", "1235", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-345x198.jpeg", "", "Reduced by 7.1% (1.6 KB)", "21498", "23147", "", "10", "0", "1", "2021-01-01 15:23:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1985", "1235", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-400x260.jpeg", "", "Reduced by 7.0% (2.4 KB)", "32303", "34718", "", "10", "0", "1", "2021-01-01 15:23:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1986", "1235", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-500x380.jpeg", "", "Reduced by 6.7% (3.9 KB)", "56527", "60567", "", "10", "0", "1", "2021-01-01 15:23:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1987", "1235", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-500x500.jpeg", "", "Reduced by 6.5% (4.7 KB)", "69878", "74699", "", "10", "0", "1", "2021-01-01 15:23:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1988", "1235", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-1000x500.jpeg", "", "Reduced by 5.6% (7.3 KB)", "126780", "134246", "", "10", "0", "1", "2021-01-01 15:23:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1989", "1235", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-500x723.jpeg", "", "Reduced by 6.4% (6.9 KB)", "104256", "111371", "", "10", "0", "1", "2021-01-01 15:23:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1990", "1235", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-1000x723.jpeg", "", "Reduced by 6.6% (15.1 KB)", "218447", "233877", "", "10", "0", "1", "2021-01-01 15:24:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1991", "1235", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-700x466.jpeg", "", "Reduced by 6.4% (6.3 KB)", "93929", "100378", "", "10", "0", "1", "2021-01-01 15:24:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1992", "1235", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Slate-1-539x303.jpeg", "", "Reduced by 6.5% (3.3 KB)", "48236", "51570", "", "10", "0", "1", "2021-01-01 15:24:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1993", "1236", "media", "full", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1.jpeg", "", "Reduced by 0.9% (1.8 KB)", "198258", "200076", "", "10", "0", "1", "2021-01-01 15:24:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1994", "1236", "media", "medium", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-300x200.jpeg", "", "Reduced by 7.2% (766 B)", "9834", "10600", "", "10", "0", "1", "2021-01-01 15:24:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1995", "1236", "media", "large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-1024x681.jpeg", "", "Reduced by 6.0% (5.8 KB)", "92133", "98041", "", "10", "0", "1", "2021-01-01 15:24:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1996", "1236", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-150x150.jpeg", "", "Reduced by 8.6% (429 B)", "4578", "5007", "", "10", "0", "1", "2021-01-01 15:24:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1997", "1236", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-768x511.jpeg", "", "Reduced by 5.8% (3.3 KB)", "54698", "58038", "", "10", "0", "1", "2021-01-01 15:24:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1998", "1236", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-570x570.jpeg", "", "Reduced by 5.5% (2.8 KB)", "48864", "51722", "", "10", "0", "1", "2021-01-01 15:24:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("1999", "1236", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-600x723.jpeg", "", "Reduced by 6.7% (5.0 KB)", "71501", "76671", "", "10", "0", "1", "2021-01-01 15:24:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2000", "1236", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-800x600.jpeg", "", "Reduced by 5.9% (4.0 KB)", "65838", "69966", "", "10", "0", "1", "2021-01-01 15:24:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2001", "1236", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-345x198.jpeg", "", "Reduced by 7.4% (902 B)", "11229", "12131", "", "10", "0", "1", "2021-01-01 15:24:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2002", "1236", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-400x260.jpeg", "", "Reduced by 6.8% (1.2 KB)", "16177", "17364", "", "10", "0", "1", "2021-01-01 15:24:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2003", "1236", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-500x380.jpeg", "", "Reduced by 6.0% (1.8 KB)", "28718", "30535", "", "10", "0", "1", "2021-01-01 15:24:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2004", "1236", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-500x500.jpeg", "", "Reduced by 5.7% (2.3 KB)", "38579", "40908", "", "10", "0", "1", "2021-01-01 15:24:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2005", "1236", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-1000x500.jpeg", "", "Reduced by 6.4% (4.8 KB)", "72245", "77156", "", "10", "0", "1", "2021-01-01 15:24:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2006", "1236", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-500x723.jpeg", "", "Reduced by 6.6% (4.1 KB)", "59263", "63461", "", "10", "0", "1", "2021-01-01 15:24:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2007", "1236", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-1000x723.jpeg", "", "Reduced by 6.9% (8.0 KB)", "110255", "118402", "", "10", "0", "1", "2021-01-01 15:24:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2008", "1236", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-700x466.jpeg", "", "Reduced by 5.9% (2.9 KB)", "47004", "49927", "", "10", "0", "1", "2021-01-01 15:24:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2009", "1236", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/GAF-Timberline-Weathered-Wood-1-539x303.jpeg", "", "Reduced by 5.8% (1.5 KB)", "25303", "26868", "", "10", "0", "1", "2021-01-01 15:24:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2010", "1237", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1.jpeg", "", "Reduced by 0.6% (1.9 KB)", "334448", "336399", "", "10", "0", "1", "2021-01-01 15:24:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2011", "1237", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-300x200.jpeg", "", "Reduced by 6.1% (1.1 KB)", "17403", "18535", "", "10", "0", "1", "2021-01-01 15:24:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2012", "1237", "media", "large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-1024x681.jpeg", "", "Reduced by 5.6% (9.4 KB)", "162597", "172212", "", "10", "0", "1", "2021-01-01 15:24:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2013", "1237", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-150x150.jpeg", "", "Reduced by 6.6% (478 B)", "6765", "7243", "", "10", "0", "1", "2021-01-01 15:24:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2014", "1237", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-768x511.jpeg", "", "Reduced by 5.9% (6.0 KB)", "98341", "104488", "", "10", "0", "1", "2021-01-01 15:24:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2015", "1237", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-570x570.jpeg", "", "Reduced by 5.4% (4.3 KB)", "77570", "82008", "", "10", "0", "1", "2021-01-01 15:24:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2016", "1237", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-600x723.jpeg", "", "Reduced by 5.9% (7.0 KB)", "113808", "121002", "", "10", "0", "1", "2021-01-01 15:24:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2017", "1237", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-800x600.jpeg", "", "Reduced by 5.7% (6.7 KB)", "112851", "119706", "", "10", "0", "1", "2021-01-01 15:24:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2018", "1237", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-345x198.jpeg", "", "Reduced by 6.2% (1.3 KB)", "20493", "21839", "", "10", "0", "1", "2021-01-01 15:24:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2019", "1237", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-400x260.jpeg", "", "Reduced by 6.3% (1.9 KB)", "29364", "31343", "", "10", "0", "1", "2021-01-01 15:24:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2020", "1237", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-500x380.jpeg", "", "Reduced by 5.9% (3.1 KB)", "49666", "52806", "", "10", "0", "1", "2021-01-01 15:24:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2021", "1237", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-500x500.jpeg", "", "Reduced by 5.7% (3.6 KB)", "61451", "65153", "", "10", "0", "1", "2021-01-01 15:24:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2022", "1237", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-1000x500.jpeg", "", "Reduced by 5.7% (7.4 KB)", "126370", "133944", "", "10", "0", "1", "2021-01-01 15:24:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2023", "1237", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-500x723.jpeg", "", "Reduced by 5.9% (5.8 KB)", "94928", "100876", "", "10", "0", "1", "2021-01-01 15:24:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2024", "1237", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-1000x723.jpeg", "", "Reduced by 6.1% (12.1 KB)", "190589", "202980", "", "10", "0", "1", "2021-01-01 15:24:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2025", "1237", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-700x466.jpeg", "", "Reduced by 6.0% (5.3 KB)", "84420", "89815", "", "10", "0", "1", "2021-01-01 15:24:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2026", "1237", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Driftwood-1-539x303.jpeg", "", "Reduced by 6.0% (2.9 KB)", "46017", "48938", "", "10", "0", "1", "2021-01-01 15:24:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2027", "1238", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1.jpeg", "", "Reduced by 0.5% (1.9 KB)", "368715", "370645", "", "10", "0", "1", "2021-01-01 15:24:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2028", "1238", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-300x200.jpeg", "", "Reduced by 6.2% (1.1 KB)", "17601", "18762", "", "10", "0", "1", "2021-01-01 15:24:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2029", "1238", "media", "large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-1024x681.jpeg", "", "Reduced by 5.2% (9.5 KB)", "175895", "185619", "", "10", "0", "1", "2021-01-01 15:24:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2030", "1238", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-150x150.jpeg", "", "Reduced by 7.4% (574 B)", "7161", "7735", "", "10", "0", "1", "2021-01-01 15:24:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2031", "1238", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-768x511.jpeg", "", "Reduced by 5.7% (6.2 KB)", "104261", "110578", "", "10", "0", "1", "2021-01-01 15:24:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2032", "1238", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-570x570.jpeg", "", "Reduced by 5.5% (4.9 KB)", "87022", "92061", "", "10", "0", "1", "2021-01-01 15:24:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2033", "1238", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-600x723.jpeg", "", "Reduced by 5.9% (8.1 KB)", "131630", "139881", "", "10", "0", "1", "2021-01-01 15:24:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2034", "1238", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-800x600.jpeg", "", "Reduced by 5.4% (7.0 KB)", "125192", "132311", "", "10", "0", "1", "2021-01-01 15:24:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2035", "1238", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-345x198.jpeg", "", "Reduced by 5.7% (1.2 KB)", "20140", "21359", "", "10", "0", "1", "2021-01-01 15:24:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2036", "1238", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-400x260.jpeg", "", "Reduced by 5.5% (1.7 KB)", "30003", "31734", "", "10", "0", "1", "2021-01-01 15:24:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2037", "1238", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-500x380.jpeg", "", "Reduced by 5.8% (3.2 KB)", "53218", "56512", "", "10", "0", "1", "2021-01-01 15:24:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2038", "1238", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-500x500.jpeg", "", "Reduced by 5.7% (4.0 KB)", "68549", "72692", "", "10", "0", "1", "2021-01-01 15:24:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2039", "1238", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-1000x500.jpeg", "", "Reduced by 5.2% (6.7 KB)", "126003", "132875", "", "10", "0", "1", "2021-01-01 15:24:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2040", "1238", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-500x723.jpeg", "", "Reduced by 6.0% (7.0 KB)", "112379", "119584", "", "10", "0", "1", "2021-01-01 15:24:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2041", "1238", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-1000x723.jpeg", "", "Reduced by 5.9% (12.9 KB)", "212195", "225434", "", "10", "0", "1", "2021-01-01 15:24:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2042", "1238", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-700x466.jpeg", "", "Reduced by 5.7% (5.2 KB)", "88782", "94104", "", "10", "0", "1", "2021-01-01 15:24:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2043", "1238", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Estate-Gray-1-539x303.jpeg", "", "Reduced by 5.4% (2.6 KB)", "45594", "48217", "", "10", "0", "1", "2021-01-01 15:24:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2044", "1239", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1.jpg", "", "Reduced by 0.4% (4.0 KB)", "906041", "910125", "", "10", "0", "1", "2021-01-01 15:24:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2045", "1239", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-300x146.jpg", "", "Reduced by 6.6% (839 B)", "11786", "12625", "", "10", "0", "1", "2021-01-01 15:24:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2046", "1239", "media", "large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-1024x498.jpg", "", "Reduced by 6.9% (10.0 KB)", "137760", "147977", "", "10", "0", "1", "2021-01-01 15:24:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2047", "1239", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-150x150.jpg", "", "Reduced by 8.6% (574 B)", "6118", "6692", "", "10", "0", "1", "2021-01-01 15:24:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2048", "1239", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-768x374.jpg", "", "Reduced by 6.9% (5.4 KB)", "74591", "80123", "", "10", "0", "1", "2021-01-01 15:24:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2049", "1239", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-1536x747.jpg", "", "Reduced by 6.6% (21.6 KB)", "311396", "333520", "", "10", "0", "1", "2021-01-01 15:24:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2050", "1239", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-2048x996.jpg", "", "Reduced by 6.0% (33.3 KB)", "531514", "565579", "", "10", "0", "1", "2021-01-01 15:24:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2051", "1239", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-570x570.jpg", "", "Reduced by 7.2% (6.7 KB)", "88970", "95840", "", "10", "0", "1", "2021-01-01 15:24:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2052", "1239", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-600x800.jpg", "", "Reduced by 7.1% (9.9 KB)", "131899", "142020", "", "10", "0", "1", "2021-01-01 15:24:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2053", "1239", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-800x600.jpg", "", "Reduced by 7.0% (9.6 KB)", "129755", "139536", "", "10", "0", "1", "2021-01-01 15:24:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2054", "1239", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-345x198.jpg", "", "Reduced by 7.0% (1.3 KB)", "17892", "19241", "", "10", "0", "1", "2021-01-01 15:24:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2055", "1239", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-400x260.jpg", "", "Reduced by 6.9% (1.9 KB)", "26716", "28699", "", "10", "0", "1", "2021-01-01 15:24:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2056", "1239", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-500x380.jpg", "", "Reduced by 7.1% (3.8 KB)", "50104", "53960", "", "10", "0", "1", "2021-01-01 15:24:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2057", "1239", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-500x500.jpg", "", "Reduced by 7.3% (5.2 KB)", "67419", "72724", "", "10", "0", "1", "2021-01-01 15:24:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2058", "1239", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-1000x500.jpg", "", "Reduced by 6.9% (9.7 KB)", "133674", "143590", "", "10", "0", "1", "2021-01-01 15:24:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2059", "1239", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-500x1000.jpg", "", "Reduced by 6.6% (9.5 KB)", "138174", "147886", "", "10", "0", "1", "2021-01-01 15:24:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2060", "1239", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-1000x1000.jpg", "", "Reduced by 6.4% (17.8 KB)", "268287", "286561", "", "10", "0", "1", "2021-01-01 15:24:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2061", "1239", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-700x340.jpg", "", "Reduced by 6.9% (4.4 KB)", "61605", "66140", "", "10", "0", "1", "2021-01-01 15:24:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2062", "1239", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Flex-Antique-Silver-scaled-1-539x303.jpg", "", "Reduced by 6.8% (3.0 KB)", "41910", "44987", "", "10", "0", "1", "2021-01-01 15:25:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2063", "1240", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1.jpeg", "", "Reduced by 1.2% (2.2 KB)", "185242", "187483", "", "10", "0", "1", "2021-01-01 15:25:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2064", "1240", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-300x200.jpeg", "", "Reduced by 6.6% (695 B)", "9903", "10598", "", "10", "0", "1", "2021-01-01 15:25:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2065", "1240", "media", "large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-1024x681.jpeg", "", "Reduced by 5.5% (4.9 KB)", "87592", "92660", "", "10", "0", "1", "2021-01-01 15:25:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2066", "1240", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-150x150.jpeg", "", "Reduced by 8.6% (403 B)", "4263", "4666", "", "10", "0", "1", "2021-01-01 15:25:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2067", "1240", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-768x511.jpeg", "", "Reduced by 5.6% (3.0 KB)", "51933", "55029", "", "10", "0", "1", "2021-01-01 15:25:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2068", "1240", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-570x570.jpeg", "", "Reduced by 5.8% (2.6 KB)", "43359", "46009", "", "10", "0", "1", "2021-01-01 15:25:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2069", "1240", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-600x723.jpeg", "", "Reduced by 5.6% (3.7 KB)", "63293", "67049", "", "10", "0", "1", "2021-01-01 15:25:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2070", "1240", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-800x600.jpeg", "", "Reduced by 5.5% (3.5 KB)", "61521", "65103", "", "10", "0", "1", "2021-01-01 15:25:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2071", "1240", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-345x198.jpeg", "", "Reduced by 6.4% (791 B)", "11583", "12374", "", "10", "0", "1", "2021-01-01 15:25:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2072", "1240", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-400x260.jpeg", "", "Reduced by 6.0% (1.0 KB)", "16343", "17382", "", "10", "0", "1", "2021-01-01 15:25:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2073", "1240", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-500x380.jpeg", "", "Reduced by 5.8% (1.6 KB)", "27262", "28926", "", "10", "0", "1", "2021-01-01 15:25:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2074", "1240", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-500x500.jpeg", "", "Reduced by 6.1% (2.2 KB)", "34336", "36557", "", "10", "0", "1", "2021-01-01 15:25:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2075", "1240", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-1000x500.jpeg", "", "Reduced by 5.8% (4.2 KB)", "69913", "74186", "", "10", "0", "1", "2021-01-01 15:25:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2076", "1240", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-500x723.jpeg", "", "Reduced by 5.8% (3.2 KB)", "53028", "56272", "", "10", "0", "1", "2021-01-01 15:25:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2077", "1240", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-1000x723.jpeg", "", "Reduced by 5.6% (5.9 KB)", "101533", "107545", "", "10", "0", "1", "2021-01-01 15:25:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2078", "1240", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-700x466.jpeg", "", "Reduced by 5.7% (2.6 KB)", "44708", "47404", "", "10", "0", "1", "2021-01-01 15:25:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2079", "1240", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Harbor-Blue-1-539x303.jpeg", "", "Reduced by 5.9% (1.5 KB)", "24883", "26447", "", "10", "0", "1", "2021-01-01 15:25:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2080", "1241", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1.jpeg", "", "Reduced by 10.0% (35.4 KB)", "325974", "362197", "", "10", "0", "1", "2021-01-01 15:25:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2081", "1241", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-300x225.jpeg", "", "Reduced by 6.0% (1.0 KB)", "16873", "17945", "", "10", "0", "1", "2021-01-01 15:25:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2082", "1241", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-150x150.jpeg", "", "Reduced by 7.4% (492 B)", "6174", "6666", "", "10", "0", "1", "2021-01-01 15:25:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2083", "1241", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-768x576.jpeg", "", "Reduced by 5.1% (4.6 KB)", "88665", "93395", "", "10", "0", "1", "2021-01-01 15:25:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2084", "1241", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-570x570.jpeg", "", "Reduced by 5.0% (3.4 KB)", "65206", "68656", "", "10", "0", "1", "2021-01-01 15:25:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2085", "1241", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-600x768.jpeg", "", "Reduced by 5.6% (5.3 KB)", "91688", "97140", "", "10", "0", "1", "2021-01-01 15:25:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2086", "1241", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-800x600.jpeg", "", "Reduced by 5.1% (5.0 KB)", "95472", "100616", "", "10", "0", "1", "2021-01-01 15:25:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2087", "1241", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-345x198.jpeg", "", "Reduced by 6.3% (1.1 KB)", "17189", "18350", "", "10", "0", "1", "2021-01-01 15:25:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2088", "1241", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-400x260.jpeg", "", "Reduced by 5.8% (1.5 KB)", "24871", "26393", "", "10", "0", "1", "2021-01-01 15:25:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2089", "1241", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-500x380.jpeg", "", "Reduced by 5.8% (2.6 KB)", "42878", "45511", "", "10", "0", "1", "2021-01-01 15:25:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2090", "1241", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-500x500.jpeg", "", "Reduced by 5.5% (2.9 KB)", "52038", "55058", "", "10", "0", "1", "2021-01-01 15:25:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2091", "1241", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-1000x500.jpeg", "", "Reduced by 4.8% (4.6 KB)", "94602", "99324", "", "10", "0", "1", "2021-01-01 15:25:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2092", "1241", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-500x768.jpeg", "", "Reduced by 5.4% (4.2 KB)", "75184", "79440", "", "10", "0", "1", "2021-01-01 15:25:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2093", "1241", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-1000x768.jpeg", "", "Reduced by 5.6% (9.3 KB)", "160165", "169656", "", "10", "0", "1", "2021-01-01 15:25:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2094", "1241", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-700x525.jpeg", "", "Reduced by 5.3% (4.2 KB)", "76645", "80913", "", "10", "0", "1", "2021-01-01 15:25:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2095", "1241", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Onyx-Black-1-539x303.jpeg", "", "Reduced by 5.5% (2.1 KB)", "37279", "39454", "", "10", "0", "1", "2021-01-01 15:25:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2096", "1242", "media", "full", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1.jpeg", "", "Reduced by 0.3% (944 B)", "307780", "308724", "", "10", "0", "1", "2021-01-01 15:25:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2097", "1242", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-300x199.jpeg", "", "Reduced by 6.1% (1,019 B)", "15748", "16767", "", "10", "0", "1", "2021-01-01 15:25:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2098", "1242", "media", "large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-1024x678.jpeg", "", "Reduced by 4.2% (6.0 KB)", "141602", "147775", "", "10", "0", "1", "2021-01-01 15:25:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2099", "1242", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-150x150.jpeg", "", "Reduced by 7.3% (527 B)", "6694", "7221", "", "10", "0", "1", "2021-01-01 15:25:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2100", "1242", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-768x508.jpeg", "", "Reduced by 4.4% (3.9 KB)", "87084", "91089", "", "10", "0", "1", "2021-01-01 15:25:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2101", "1242", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-570x570.jpeg", "", "Reduced by 4.4% (3.3 KB)", "72776", "76106", "", "10", "0", "1", "2021-01-01 15:25:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2102", "1242", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-600x721.jpeg", "", "Reduced by 4.8% (4.8 KB)", "99029", "103987", "", "10", "0", "1", "2021-01-01 15:25:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2103", "1242", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-800x600.jpeg", "", "Reduced by 4.3% (4.5 KB)", "103001", "107592", "", "10", "0", "1", "2021-01-01 15:25:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2104", "1242", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-345x198.jpeg", "", "Reduced by 6.0% (1.1 KB)", "17664", "18800", "", "10", "0", "1", "2021-01-01 15:25:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2105", "1242", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-400x260.jpeg", "", "Reduced by 5.8% (1.6 KB)", "26246", "27851", "", "10", "0", "1", "2021-01-01 15:25:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2106", "1242", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-500x380.jpeg", "", "Reduced by 4.8% (2.3 KB)", "46201", "48554", "", "10", "0", "1", "2021-01-01 15:25:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2107", "1242", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-500x500.jpeg", "", "Reduced by 4.8% (2.8 KB)", "58279", "61191", "", "10", "0", "1", "2021-01-01 15:25:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2108", "1242", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-1000x500.jpeg", "", "Reduced by 4.2% (4.4 KB)", "102494", "106949", "", "10", "0", "1", "2021-01-01 15:25:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2109", "1242", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-500x721.jpeg", "", "Reduced by 4.6% (3.8 KB)", "81638", "85579", "", "10", "0", "1", "2021-01-01 15:25:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2110", "1242", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-1000x721.jpeg", "", "Reduced by 4.6% (7.7 KB)", "164610", "172490", "", "10", "0", "1", "2021-01-01 15:25:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2111", "1242", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-700x463.jpeg", "", "Reduced by 4.5% (3.4 KB)", "74332", "77840", "", "10", "0", "1", "2021-01-01 15:25:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2112", "1242", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Owens-Corning-Duration-Teak-1-539x303.jpeg", "", "Reduced by 5.1% (2.1 KB)", "39326", "41430", "", "10", "0", "1", "2021-01-01 15:25:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2113", "1243", "media", "full", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1.jpg", "", "Reduced by 0.4% (5.1 KB)", "1273174", "1278400", "", "10", "0", "1", "2021-01-01 15:25:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2114", "1243", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-225x300.jpg", "", "Reduced by 6.5% (1.1 KB)", "16413", "17563", "", "10", "0", "1", "2021-01-01 15:25:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2115", "1243", "media", "large", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-768x1024.jpg", "", "Reduced by 7.0% (15.2 KB)", "207979", "223555", "", "10", "0", "1", "2021-01-01 15:25:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2116", "1243", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-150x150.jpg", "", "Reduced by 8.4% (571 B)", "6196", "6767", "", "10", "0", "1", "2021-01-01 15:25:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2117", "1243", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-1152x1536.jpg", "", "Reduced by 6.6% (32.0 KB)", "462240", "494987", "", "10", "0", "1", "2021-01-01 15:25:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2118", "1243", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-1536x2048.jpg", "", "Reduced by 6.2% (49.9 KB)", "770286", "821401", "", "10", "0", "1", "2021-01-01 15:25:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2119", "1243", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-570x570.jpg", "", "Reduced by 7.2% (6.6 KB)", "87071", "93791", "", "10", "0", "1", "2021-01-01 15:25:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2120", "1243", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-600x800.jpg", "", "Reduced by 7.0% (9.0 KB)", "123111", "132355", "", "10", "0", "1", "2021-01-01 15:25:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2121", "1243", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-800x600.jpg", "", "Reduced by 7.6% (10.9 KB)", "135234", "146363", "", "10", "0", "1", "2021-01-01 15:25:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2122", "1243", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-345x198.jpg", "", "Reduced by 7.8% (1.4 KB)", "17248", "18702", "", "10", "0", "1", "2021-01-01 15:25:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2123", "1243", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-400x260.jpg", "", "Reduced by 7.5% (2.1 KB)", "26626", "28775", "", "10", "0", "1", "2021-01-01 15:25:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2124", "1243", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-500x380.jpg", "", "Reduced by 7.5% (4.0 KB)", "50660", "54747", "", "10", "0", "1", "2021-01-01 15:25:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2125", "1243", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-500x500.jpg", "", "Reduced by 7.4% (5.1 KB)", "65288", "70480", "", "10", "0", "1", "2021-01-01 15:25:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2126", "1243", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-1000x500.jpg", "", "Reduced by 7.6% (11.5 KB)", "143494", "155242", "", "10", "0", "1", "2021-01-01 15:25:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2127", "1243", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-500x1000.jpg", "", "Reduced by 7.1% (9.9 KB)", "132865", "143017", "", "10", "0", "1", "2021-01-01 15:25:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2128", "1243", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-1000x1000.jpg", "", "Reduced by 7.1% (20.7 KB)", "276519", "297689", "", "10", "0", "1", "2021-01-01 15:25:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2129", "1243", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-700x933.jpg", "", "Reduced by 6.9% (12.5 KB)", "171109", "183866", "", "10", "0", "1", "2021-01-01 15:25:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2130", "1243", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray-scaled-1-539x303.jpg", "", "Reduced by 7.5% (3.5 KB)", "43587", "47132", "", "10", "0", "1", "2021-01-01 15:25:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2131", "1244", "media", "full", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1.jpg", "", "Reduced by 0.8% (7.7 KB)", "978060", "985943", "", "10", "0", "1", "2021-01-01 15:25:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2132", "1244", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-300x225.jpg", "", "Reduced by 6.5% (1.2 KB)", "17592", "18809", "", "10", "0", "1", "2021-01-01 15:25:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2133", "1244", "media", "large", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-1024x768.jpg", "", "Reduced by 5.9% (10.5 KB)", "171923", "182667", "", "10", "0", "1", "2021-01-01 15:26:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2134", "1244", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-150x150.jpg", "", "Reduced by 8.3% (595 B)", "6562", "7157", "", "10", "0", "1", "2021-01-01 15:26:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2135", "1244", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-768x576.jpg", "", "Reduced by 5.9% (6.0 KB)", "98675", "104860", "", "10", "0", "1", "2021-01-01 15:26:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2136", "1244", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-1536x1152.jpg", "", "Reduced by 5.6% (21.2 KB)", "364197", "385865", "", "10", "0", "1", "2021-01-01 15:26:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2137", "1244", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-2048x1536.jpg", "", "Reduced by 5.2% (32.2 KB)", "599341", "632344", "", "10", "0", "1", "2021-01-01 15:26:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2138", "1244", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-570x570.jpg", "", "Reduced by 6.0% (4.7 KB)", "75799", "80649", "", "10", "0", "1", "2021-01-01 15:26:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2139", "1244", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-600x800.jpg", "", "Reduced by 6.3% (7.4 KB)", "112282", "119854", "", "10", "0", "1", "2021-01-01 15:26:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2140", "1244", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-800x600.jpg", "", "Reduced by 6.1% (6.7 KB)", "106538", "113405", "", "10", "0", "1", "2021-01-01 15:26:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2141", "1244", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-345x198.jpg", "", "Reduced by 6.6% (1.3 KB)", "19297", "20657", "", "10", "0", "1", "2021-01-01 15:26:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2142", "1244", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-400x260.jpg", "", "Reduced by 6.0% (1.7 KB)", "26819", "28531", "", "10", "0", "1", "2021-01-01 15:26:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2143", "1244", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-500x380.jpg", "", "Reduced by 5.8% (2.7 KB)", "44819", "47567", "", "10", "0", "1", "2021-01-01 15:26:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2144", "1244", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-500x500.jpg", "", "Reduced by 6.2% (3.8 KB)", "58977", "62883", "", "10", "0", "1", "2021-01-01 15:26:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2145", "1244", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-1000x500.jpg", "", "Reduced by 6.2% (8.2 KB)", "126292", "134693", "", "10", "0", "1", "2021-01-01 15:26:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2146", "1244", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-500x1000.jpg", "", "Reduced by 6.4% (7.9 KB)", "117863", "125928", "", "10", "0", "1", "2021-01-01 15:26:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2147", "1244", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-1000x1000.jpg", "", "Reduced by 6.0% (13.5 KB)", "218260", "232094", "", "10", "0", "1", "2021-01-01 15:26:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2148", "1244", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-700x525.jpg", "", "Reduced by 6.0% (5.2 KB)", "83057", "88355", "", "10", "0", "1", "2021-01-01 15:26:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2149", "1244", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Tamko-Heritage-IR-Thunder-Gray2-scaled-1-539x303.jpg", "", "Reduced by 6.2% (2.7 KB)", "42654", "45457", "", "10", "0", "1", "2021-01-01 15:26:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2150", "1245", "media", "full", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1.jpg", "", "Reduced by 0.7% (5.3 KB)", "822444", "827895", "", "10", "0", "1", "2021-01-01 15:26:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2151", "1245", "media", "medium", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-300x169.jpg", "", "Reduced by 6.9% (1.1 KB)", "14664", "15745", "", "10", "0", "1", "2021-01-01 15:26:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2152", "1245", "media", "large", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-1024x576.jpg", "", "Reduced by 6.0% (9.1 KB)", "146171", "155477", "", "10", "0", "1", "2021-01-01 15:26:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2153", "1245", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-150x150.jpg", "", "Reduced by 7.6% (555 B)", "6731", "7286", "", "10", "0", "1", "2021-01-01 15:26:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2154", "1245", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-768x432.jpg", "", "Reduced by 6.2% (5.4 KB)", "84074", "89601", "", "10", "0", "1", "2021-01-01 15:26:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2155", "1245", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-1536x864.jpg", "", "Reduced by 5.7% (18.2 KB)", "307526", "326193", "", "10", "0", "1", "2021-01-01 15:26:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2156", "1245", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-2048x1152.jpg", "", "Reduced by 5.3% (27.7 KB)", "504250", "532657", "", "10", "0", "1", "2021-01-01 15:26:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2157", "1245", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-570x570.jpg", "", "Reduced by 5.7% (4.8 KB)", "81286", "86219", "", "10", "0", "1", "2021-01-01 15:26:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2158", "1245", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-600x800.jpg", "", "Reduced by 5.8% (6.8 KB)", "112338", "119257", "", "10", "0", "1", "2021-01-01 15:26:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2159", "1245", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-800x600.jpg", "", "Reduced by 5.9% (7.3 KB)", "118465", "125893", "", "10", "0", "1", "2021-01-01 15:26:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2160", "1245", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-345x198.jpg", "", "Reduced by 6.5% (1.3 KB)", "19072", "20398", "", "10", "0", "1", "2021-01-01 15:26:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2161", "1245", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-400x260.jpg", "", "Reduced by 6.1% (1.7 KB)", "27580", "29368", "", "10", "0", "1", "2021-01-01 15:26:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2162", "1245", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-500x380.jpg", "", "Reduced by 6.1% (3.1 KB)", "49327", "52547", "", "10", "0", "1", "2021-01-01 15:26:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2163", "1245", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-500x500.jpg", "", "Reduced by 5.9% (3.9 KB)", "63475", "67437", "", "10", "0", "1", "2021-01-01 15:26:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2164", "1245", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-1000x500.jpg", "", "Reduced by 6.0% (7.7 KB)", "123741", "131588", "", "10", "0", "1", "2021-01-01 15:26:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2165", "1245", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-500x1000.jpg", "", "Reduced by 5.8% (6.6 KB)", "111336", "118138", "", "10", "0", "1", "2021-01-01 15:26:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2166", "1245", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-1000x1000.jpg", "", "Reduced by 5.7% (13.1 KB)", "222242", "235669", "", "10", "0", "1", "2021-01-01 15:26:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2167", "1245", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-700x394.jpg", "", "Reduced by 6.2% (4.6 KB)", "71254", "75934", "", "10", "0", "1", "2021-01-01 15:26:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2168", "1245", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/DaVinci-Bellaforte-Shake-Tahoe-scaled-1-539x303.jpg", "", "Reduced by 6.0% (2.7 KB)", "42935", "45675", "", "10", "0", "1", "2021-01-01 15:26:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2169", "1246", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1.jpeg", "", "Reduced by 0.5% (1.8 KB)", "353188", "355052", "", "10", "0", "1", "2021-01-01 15:26:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2170", "1246", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-300x225.jpeg", "", "Reduced by 6.5% (1.2 KB)", "17317", "18526", "", "10", "0", "1", "2021-01-01 15:26:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2171", "1246", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-150x150.jpeg", "", "Reduced by 9.0% (605 B)", "6114", "6719", "", "10", "0", "1", "2021-01-01 15:26:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2172", "1246", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-768x576.jpeg", "", "Reduced by 5.6% (6.1 KB)", "105870", "112096", "", "10", "0", "1", "2021-01-01 15:26:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2173", "1246", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-570x570.jpeg", "", "Reduced by 5.4% (4.3 KB)", "77192", "81610", "", "10", "0", "1", "2021-01-01 15:26:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2174", "1246", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-600x768.jpeg", "", "Reduced by 5.5% (6.8 KB)", "119533", "126521", "", "10", "0", "1", "2021-01-01 15:26:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2175", "1246", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-800x600.jpeg", "", "Reduced by 5.4% (6.3 KB)", "112925", "119366", "", "10", "0", "1", "2021-01-01 15:26:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2176", "1246", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-345x198.jpeg", "", "Reduced by 6.3% (1.1 KB)", "17358", "18527", "", "10", "0", "1", "2021-01-01 15:26:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2177", "1246", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-400x260.jpeg", "", "Reduced by 6.1% (1.7 KB)", "25928", "27625", "", "10", "0", "1", "2021-01-01 15:26:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2178", "1246", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-500x380.jpeg", "", "Reduced by 6.1% (3.0 KB)", "46867", "49897", "", "10", "0", "1", "2021-01-01 15:26:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2179", "1246", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-500x500.jpeg", "", "Reduced by 5.9% (3.7 KB)", "60273", "64064", "", "10", "0", "1", "2021-01-01 15:26:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2180", "1246", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-1000x500.jpeg", "", "Reduced by 4.8% (5.6 KB)", "113213", "118904", "", "10", "0", "1", "2021-01-01 15:26:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2181", "1246", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-500x768.jpeg", "", "Reduced by 5.7% (5.9 KB)", "100323", "106365", "", "10", "0", "1", "2021-01-01 15:26:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2182", "1246", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-1000x768.jpeg", "", "Reduced by 5.6% (11.7 KB)", "202768", "214700", "", "10", "0", "1", "2021-01-01 15:26:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2183", "1246", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-700x525.jpeg", "", "Reduced by 5.7% (5.2 KB)", "88344", "93679", "", "10", "0", "1", "2021-01-01 15:26:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2184", "1246", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Shake-Mountain-Cedar-1-539x303.jpeg", "", "Reduced by 6.0% (2.5 KB)", "40379", "42945", "", "10", "0", "1", "2021-01-01 15:26:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2185", "1247", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1.jpeg", "", "Reduced by 0.5% (1.2 KB)", "258609", "259837", "", "10", "0", "1", "2021-01-01 15:26:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2186", "1247", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-300x225.jpeg", "", "Reduced by 6.5% (979 B)", "13999", "14978", "", "10", "0", "1", "2021-01-01 15:26:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2187", "1247", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-150x150.jpeg", "", "Reduced by 7.8% (458 B)", "5397", "5855", "", "10", "0", "1", "2021-01-01 15:26:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2188", "1247", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-768x576.jpeg", "", "Reduced by 5.6% (4.5 KB)", "77578", "82168", "", "10", "0", "1", "2021-01-01 15:26:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2189", "1247", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-570x570.jpeg", "", "Reduced by 5.3% (3.0 KB)", "54937", "58015", "", "10", "0", "1", "2021-01-01 15:26:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2190", "1247", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-600x768.jpeg", "", "Reduced by 5.3% (4.5 KB)", "81411", "85993", "", "10", "0", "1", "2021-01-01 15:26:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2191", "1247", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-800x600.jpeg", "", "Reduced by 5.4% (4.6 KB)", "82773", "87510", "", "10", "0", "1", "2021-01-01 15:26:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2192", "1247", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-345x198.jpeg", "", "Reduced by 6.9% (1.1 KB)", "15687", "16845", "", "10", "0", "1", "2021-01-01 15:26:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2193", "1247", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-400x260.jpeg", "", "Reduced by 6.2% (1.4 KB)", "21674", "23099", "", "10", "0", "1", "2021-01-01 15:26:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2194", "1247", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-500x380.jpeg", "", "Reduced by 6.0% (2.2 KB)", "35326", "37587", "", "10", "0", "1", "2021-01-01 15:26:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2195", "1247", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-500x500.jpeg", "", "Reduced by 5.8% (2.6 KB)", "43208", "45851", "", "10", "0", "1", "2021-01-01 15:26:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2196", "1247", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-1000x500.jpeg", "", "Reduced by 5.1% (5.2 KB)", "100695", "106062", "", "10", "0", "1", "2021-01-01 15:26:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2197", "1247", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-500x768.jpeg", "", "Reduced by 5.4% (3.7 KB)", "67538", "71366", "", "10", "0", "1", "2021-01-01 15:26:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2198", "1247", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-1000x768.jpeg", "", "Reduced by 5.7% (8.7 KB)", "146586", "155467", "", "10", "0", "1", "2021-01-01 15:26:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2199", "1247", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-700x525.jpeg", "", "Reduced by 5.5% (3.7 KB)", "65194", "68996", "", "10", "0", "1", "2021-01-01 15:26:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2200", "1247", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal-1-539x303.jpeg", "", "Reduced by 5.9% (2.1 KB)", "34960", "37142", "", "10", "0", "1", "2021-01-01 15:26:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2201", "1248", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1.jpeg", "", "Reduced by 0.6% (2.1 KB)", "379037", "381228", "", "10", "0", "1", "2021-01-01 15:26:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2202", "1248", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-300x225.jpeg", "", "Reduced by 7.4% (1.6 KB)", "20819", "22483", "", "10", "0", "1", "2021-01-01 15:26:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2203", "1248", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-150x150.jpeg", "", "Reduced by 8.0% (643 B)", "7354", "7997", "", "10", "0", "1", "2021-01-01 15:26:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2204", "1248", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-768x576.jpeg", "", "Reduced by 6.3% (7.9 KB)", "120522", "128654", "", "10", "0", "1", "2021-01-01 15:26:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2205", "1248", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-570x570.jpeg", "", "Reduced by 5.7% (5.0 KB)", "84995", "90145", "", "10", "0", "1", "2021-01-01 15:26:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2206", "1248", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-600x768.jpeg", "", "Reduced by 5.8% (7.7 KB)", "128317", "136159", "", "10", "0", "1", "2021-01-01 15:26:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2207", "1248", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-800x600.jpeg", "", "Reduced by 6.1% (8.2 KB)", "128186", "136570", "", "10", "0", "1", "2021-01-01 15:27:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2208", "1248", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-345x198.jpeg", "", "Reduced by 7.2% (1.6 KB)", "20997", "22632", "", "10", "0", "1", "2021-01-01 15:27:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2209", "1248", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-400x260.jpeg", "", "Reduced by 7.2% (2.4 KB)", "31161", "33577", "", "10", "0", "1", "2021-01-01 15:27:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2210", "1248", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-500x380.jpeg", "", "Reduced by 6.8% (3.9 KB)", "54802", "58777", "", "10", "0", "1", "2021-01-01 15:27:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2211", "1248", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-500x500.jpeg", "", "Reduced by 6.3% (4.4 KB)", "66512", "71012", "", "10", "0", "1", "2021-01-01 15:27:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2212", "1248", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-1000x500.jpeg", "", "Reduced by 5.7% (7.5 KB)", "128013", "135733", "", "10", "0", "1", "2021-01-01 15:27:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2213", "1248", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-500x768.jpeg", "", "Reduced by 5.6% (6.0 KB)", "104466", "110619", "", "10", "0", "1", "2021-01-01 15:27:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2214", "1248", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-1000x768.jpeg", "", "Reduced by 6.4% (15.2 KB)", "227631", "243208", "", "10", "0", "1", "2021-01-01 15:27:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2215", "1248", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-700x525.jpeg", "", "Reduced by 6.6% (6.9 KB)", "101047", "108163", "", "10", "0", "1", "2021-01-01 15:27:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2216", "1248", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-American-Blend-Charcoal2-1-539x303.jpeg", "", "Reduced by 6.7% (3.3 KB)", "47289", "50663", "", "10", "0", "1", "2021-01-01 15:27:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2217", "1249", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1.jpeg", "", "Reduced by 0.6% (2.1 KB)", "389237", "391422", "", "10", "0", "1", "2021-01-01 15:27:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2218", "1249", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-300x225.jpeg", "", "Reduced by 7.9% (1.8 KB)", "21138", "22941", "", "10", "0", "1", "2021-01-01 15:27:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2219", "1249", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-150x150.jpeg", "", "Reduced by 9.0% (760 B)", "7708", "8468", "", "10", "0", "1", "2021-01-01 15:27:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2220", "1249", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-768x576.jpeg", "", "Reduced by 6.5% (8.3 KB)", "123661", "132209", "", "10", "0", "1", "2021-01-01 15:27:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2221", "1249", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-570x570.jpeg", "", "Reduced by 6.1% (5.8 KB)", "90532", "96453", "", "10", "0", "1", "2021-01-01 15:27:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2222", "1249", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-600x768.jpeg", "", "Reduced by 6.4% (9.4 KB)", "141532", "151180", "", "10", "0", "1", "2021-01-01 15:27:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2223", "1249", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-800x600.jpeg", "", "Reduced by 6.2% (8.5 KB)", "131422", "140083", "", "10", "0", "1", "2021-01-01 15:27:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2224", "1249", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-345x198.jpeg", "", "Reduced by 7.6% (1.7 KB)", "21406", "23174", "", "10", "0", "1", "2021-01-01 15:27:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2225", "1249", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-400x260.jpeg", "", "Reduced by 7.2% (2.4 KB)", "31628", "34079", "", "10", "0", "1", "2021-01-01 15:27:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2226", "1249", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-500x380.jpeg", "", "Reduced by 6.9% (4.1 KB)", "56419", "60571", "", "10", "0", "1", "2021-01-01 15:27:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2227", "1249", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-500x500.jpeg", "", "Reduced by 6.5% (4.8 KB)", "71064", "75988", "", "10", "0", "1", "2021-01-01 15:27:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2228", "1249", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-1000x500.jpeg", "", "Reduced by 5.7% (7.7 KB)", "130794", "138628", "", "10", "0", "1", "2021-01-01 15:27:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2229", "1249", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-500x768.jpeg", "", "Reduced by 6.3% (7.8 KB)", "119232", "127215", "", "10", "0", "1", "2021-01-01 15:27:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2230", "1249", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-1000x768.jpeg", "", "Reduced by 6.5% (16.1 KB)", "235808", "252253", "", "10", "0", "1", "2021-01-01 15:27:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2231", "1249", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-700x525.jpeg", "", "Reduced by 6.4% (7.0 KB)", "104037", "111164", "", "10", "0", "1", "2021-01-01 15:27:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2232", "1249", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate-1-539x303.jpeg", "", "Reduced by 6.6% (3.4 KB)", "48488", "51937", "", "10", "0", "1", "2021-01-01 15:27:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2233", "1252", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1.jpeg", "", "Reduced by 0.9% (3.6 KB)", "399634", "403293", "", "10", "0", "1", "2021-01-01 15:27:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2234", "1252", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-300x225.jpeg", "", "Reduced by 7.6% (1.7 KB)", "21623", "23407", "", "10", "0", "1", "2021-01-01 15:27:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2235", "1252", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-150x150.jpeg", "", "Reduced by 8.9% (765 B)", "7786", "8551", "", "10", "0", "1", "2021-01-01 15:27:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2236", "1252", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-768x576.jpeg", "", "Reduced by 6.8% (9.0 KB)", "126761", "135949", "", "10", "0", "1", "2021-01-01 15:27:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2237", "1252", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-570x570.jpeg", "", "Reduced by 6.7% (6.5 KB)", "93677", "100373", "", "10", "0", "1", "2021-01-01 15:27:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2238", "1252", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-600x768.jpeg", "", "Reduced by 6.9% (10.4 KB)", "144277", "154976", "", "10", "0", "1", "2021-01-01 15:27:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2239", "1252", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-800x600.jpeg", "", "Reduced by 6.8% (9.6 KB)", "135060", "144868", "", "10", "0", "1", "2021-01-01 15:27:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2240", "1252", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-345x198.jpeg", "", "Reduced by 7.6% (1.7 KB)", "21256", "23010", "", "10", "0", "1", "2021-01-01 15:27:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2241", "1252", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-400x260.jpeg", "", "Reduced by 7.4% (2.5 KB)", "31829", "34390", "", "10", "0", "1", "2021-01-01 15:27:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2242", "1252", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-500x380.jpeg", "", "Reduced by 7.2% (4.4 KB)", "57333", "61811", "", "10", "0", "1", "2021-01-01 15:27:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2243", "1252", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-500x500.jpeg", "", "Reduced by 7.0% (5.4 KB)", "73608", "79122", "", "10", "0", "1", "2021-01-01 15:27:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2244", "1252", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-1000x500.jpeg", "", "Reduced by 6.1% (8.4 KB)", "131846", "140473", "", "10", "0", "1", "2021-01-01 15:27:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2245", "1252", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-500x768.jpeg", "", "Reduced by 6.9% (8.6 KB)", "119236", "128060", "", "10", "0", "1", "2021-01-01 15:27:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2246", "1252", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-1000x768.jpeg", "", "Reduced by 6.9% (17.5 KB)", "242400", "260365", "", "10", "0", "1", "2021-01-01 15:27:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2247", "1252", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-700x525.jpeg", "", "Reduced by 6.8% (7.6 KB)", "106184", "113966", "", "10", "0", "1", "2021-01-01 15:27:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2248", "1252", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Colonial-Estate2-1-539x303.jpeg", "", "Reduced by 7.1% (3.6 KB)", "47894", "51552", "", "10", "0", "1", "2021-01-01 15:27:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2249", "1253", "media", "full", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1.jpeg", "", "Reduced by 0.4% (1.2 KB)", "284600", "285838", "", "10", "0", "1", "2021-01-01 15:27:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2250", "1253", "media", "medium", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-300x225.jpeg", "", "Reduced by 7.1% (1.3 KB)", "16774", "18056", "", "10", "0", "1", "2021-01-01 15:27:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2251", "1253", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-150x150.jpeg", "", "Reduced by 8.6% (573 B)", "6061", "6634", "", "10", "0", "1", "2021-01-01 15:27:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2252", "1253", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-768x576.jpeg", "", "Reduced by 5.3% (4.9 KB)", "90526", "95590", "", "10", "0", "1", "2021-01-01 15:27:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2253", "1253", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-570x570.jpeg", "", "Reduced by 5.1% (3.3 KB)", "63348", "66758", "", "10", "0", "1", "2021-01-01 15:27:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2254", "1253", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-600x768.jpeg", "", "Reduced by 4.4% (3.9 KB)", "87144", "91141", "", "10", "0", "1", "2021-01-01 15:27:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2255", "1253", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-800x600.jpeg", "", "Reduced by 5.2% (5.2 KB)", "96208", "101511", "", "10", "0", "1", "2021-01-01 15:27:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2256", "1253", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-345x198.jpeg", "", "Reduced by 7.1% (1.2 KB)", "16473", "17730", "", "10", "0", "1", "2021-01-01 15:27:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2257", "1253", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-400x260.jpeg", "", "Reduced by 6.8% (1.7 KB)", "24110", "25872", "", "10", "0", "1", "2021-01-01 15:27:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2258", "1253", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-500x380.jpeg", "", "Reduced by 6.2% (2.8 KB)", "42336", "45157", "", "10", "0", "1", "2021-01-01 15:27:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2259", "1253", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-500x500.jpeg", "", "Reduced by 5.5% (2.8 KB)", "50148", "53061", "", "10", "0", "1", "2021-01-01 15:27:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2260", "1253", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-1000x500.jpeg", "", "Reduced by 4.5% (4.5 KB)", "96826", "101391", "", "10", "0", "1", "2021-01-01 15:27:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2261", "1253", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-500x768.jpeg", "", "Reduced by 4.3% (3.1 KB)", "70248", "73403", "", "10", "0", "1", "2021-01-01 15:27:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2262", "1253", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-1000x768.jpeg", "", "Reduced by 5.1% (8.5 KB)", "162937", "171659", "", "10", "0", "1", "2021-01-01 15:27:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2263", "1253", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-700x525.jpeg", "", "Reduced by 5.5% (4.4 KB)", "76815", "81271", "", "10", "0", "1", "2021-01-01 15:27:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2264", "1253", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/F-Wave-Revia-Slate-Sonoma-Estate-1-539x303.jpeg", "", "Reduced by 6.3% (2.4 KB)", "36197", "38624", "", "10", "0", "1", "2021-01-01 15:27:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2265", "1254", "media", "full", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1.jpeg", "", "Reduced by 0.8% (2.6 KB)", "345681", "348388", "", "10", "0", "1", "2021-01-01 15:27:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2266", "1254", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-225x300.jpeg", "", "Reduced by 6.7% (1.2 KB)", "17550", "18806", "", "10", "0", "1", "2021-01-01 15:27:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2267", "1254", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-150x150.jpeg", "", "Reduced by 8.2% (521 B)", "5849", "6370", "", "10", "0", "1", "2021-01-01 15:27:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2268", "1254", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-570x570.jpeg", "", "Reduced by 5.9% (5.2 KB)", "84382", "89705", "", "10", "0", "1", "2021-01-01 15:27:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2269", "1254", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-600x800.jpeg", "", "Reduced by 5.8% (7.3 KB)", "119778", "127202", "", "10", "0", "1", "2021-01-01 15:27:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2270", "1254", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-768x600.jpeg", "", "Reduced by 6.5% (9.7 KB)", "141588", "151471", "", "10", "0", "1", "2021-01-01 15:27:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2271", "1254", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-345x198.jpeg", "", "Reduced by 7.3% (1.4 KB)", "18183", "19619", "", "10", "0", "1", "2021-01-01 15:27:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2272", "1254", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-400x260.jpeg", "", "Reduced by 6.8% (2.0 KB)", "27763", "29789", "", "10", "0", "1", "2021-01-01 15:27:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2273", "1254", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-500x380.jpeg", "", "Reduced by 6.5% (3.5 KB)", "50727", "54268", "", "10", "0", "1", "2021-01-01 15:27:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2274", "1254", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-500x500.jpeg", "", "Reduced by 6.5% (4.4 KB)", "65148", "69669", "", "10", "0", "1", "2021-01-01 15:27:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2275", "1254", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-768x500.jpeg", "", "Reduced by 6.5% (8.2 KB)", "121474", "129877", "", "10", "0", "1", "2021-01-01 15:27:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2276", "1254", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-500x1000.jpeg", "", "Reduced by 5.4% (6.9 KB)", "124262", "131293", "", "10", "0", "1", "2021-01-01 15:27:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2277", "1254", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-768x1000.jpeg", "", "Reduced by 6.4% (14.6 KB)", "219706", "234645", "", "10", "0", "1", "2021-01-01 15:27:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2278", "1254", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-700x933.jpeg", "", "Reduced by 5.4% (8.9 KB)", "159908", "168997", "", "10", "0", "1", "2021-01-01 15:27:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2279", "1254", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers-1-539x303.jpeg", "", "Reduced by 6.5% (3.0 KB)", "44434", "47548", "", "10", "0", "1", "2021-01-01 15:27:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2280", "1255", "media", "full", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1.jpeg", "", "Reduced by 1.4% (299 B)", "20672", "20971", "", "10", "0", "1", "2021-01-01 15:28:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2281", "1255", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-222x300.jpeg", "", "Reduced by 6.0% (745 B)", "11572", "12317", "", "10", "0", "1", "2021-01-01 15:28:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2282", "1255", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-150x150.jpeg", "", "Reduced by 9.3% (447 B)", "4346", "4793", "", "10", "0", "1", "2021-01-01 15:28:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2283", "1255", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-345x198.jpeg", "", "Reduced by 6.6% (704 B)", "9949", "10653", "", "10", "0", "1", "2021-01-01 15:28:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2284", "1255", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-384x260.jpeg", "", "Reduced by 6.7% (1.0 KB)", "14794", "15857", "", "10", "0", "1", "2021-01-01 15:28:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2285", "1255", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-384x380.jpeg", "", "Reduced by 5.3% (1.3 KB)", "22866", "24156", "", "10", "0", "1", "2021-01-01 15:28:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2286", "1255", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-384x500.jpeg", "", "Reduced by 5.0% (1.6 KB)", "30579", "32202", "", "10", "0", "1", "2021-01-01 15:28:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2287", "1255", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Westile-Concrete-Pavers2-1-384x303.jpeg", "", "Reduced by 6.0% (1.1 KB)", "17692", "18821", "", "10", "0", "1", "2021-01-01 15:28:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2288", "1256", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1.jpeg", "", "Reduced by 0.7% (1.5 KB)", "207731", "209272", "", "10", "0", "1", "2021-01-01 15:28:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2289", "1256", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-300x225.jpeg", "", "Reduced by 6.0% (881 B)", "13801", "14682", "", "10", "0", "1", "2021-01-01 15:28:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2290", "1256", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-150x150.jpeg", "", "Reduced by 7.6% (465 B)", "5660", "6125", "", "10", "0", "1", "2021-01-01 15:28:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2291", "1256", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-768x576.jpeg", "", "Reduced by 5.5% (4.0 KB)", "70994", "75088", "", "10", "0", "1", "2021-01-01 15:28:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2292", "1256", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-570x570.jpeg", "", "Reduced by 5.8% (3.2 KB)", "52636", "55878", "", "10", "0", "1", "2021-01-01 15:28:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2293", "1256", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-600x768.jpeg", "", "Reduced by 5.5% (4.4 KB)", "77117", "81591", "", "10", "0", "1", "2021-01-01 15:28:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2294", "1256", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-800x600.jpeg", "", "Reduced by 5.6% (4.4 KB)", "75488", "79952", "", "10", "0", "1", "2021-01-01 15:28:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2295", "1256", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-345x198.jpeg", "", "Reduced by 6.3% (1,014 B)", "15007", "16021", "", "10", "0", "1", "2021-01-01 15:28:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2296", "1256", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-400x260.jpeg", "", "Reduced by 5.9% (1.3 KB)", "20785", "22077", "", "10", "0", "1", "2021-01-01 15:28:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2297", "1256", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-500x380.jpeg", "", "Reduced by 5.7% (2.0 KB)", "33922", "35977", "", "10", "0", "1", "2021-01-01 15:28:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2298", "1256", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-500x500.jpeg", "", "Reduced by 5.9% (2.5 KB)", "41866", "44471", "", "10", "0", "1", "2021-01-01 15:28:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2299", "1256", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-1000x500.jpeg", "", "Reduced by 4.9% (4.4 KB)", "86479", "90974", "", "10", "0", "1", "2021-01-01 15:28:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2300", "1256", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-500x768.jpeg", "", "Reduced by 5.7% (3.8 KB)", "63559", "67403", "", "10", "0", "1", "2021-01-01 15:28:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2301", "1256", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-1000x768.jpeg", "", "Reduced by 5.5% (7.2 KB)", "127836", "135249", "", "10", "0", "1", "2021-01-01 15:28:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2302", "1256", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-700x525.jpeg", "", "Reduced by 6.0% (3.7 KB)", "60094", "63922", "", "10", "0", "1", "2021-01-01 15:28:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2303", "1256", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-1-539x303.jpeg", "", "Reduced by 5.6% (1.9 KB)", "32239", "34140", "", "10", "0", "1", "2021-01-01 15:28:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2304", "1257", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2.jpeg", "", "Reduced by 0.7% (1.5 KB)", "207731", "209272", "", "10", "0", "1", "2021-01-01 15:28:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2305", "1257", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-300x225.jpeg", "", "Reduced by 6.0% (881 B)", "13801", "14682", "", "10", "0", "1", "2021-01-01 15:28:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2306", "1257", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-150x150.jpeg", "", "Reduced by 7.6% (465 B)", "5660", "6125", "", "10", "0", "1", "2021-01-01 15:28:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2307", "1257", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-768x576.jpeg", "", "Reduced by 5.5% (4.0 KB)", "70994", "75088", "", "10", "0", "1", "2021-01-01 15:28:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2308", "1257", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-570x570.jpeg", "", "Reduced by 5.8% (3.2 KB)", "52636", "55878", "", "10", "0", "1", "2021-01-01 15:28:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2309", "1257", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-600x768.jpeg", "", "Reduced by 5.5% (4.4 KB)", "77117", "81591", "", "10", "0", "1", "2021-01-01 15:28:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2310", "1257", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-800x600.jpeg", "", "Reduced by 5.6% (4.4 KB)", "75488", "79952", "", "10", "0", "1", "2021-01-01 15:28:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2311", "1257", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-345x198.jpeg", "", "Reduced by 6.3% (1,014 B)", "15007", "16021", "", "10", "0", "1", "2021-01-01 15:28:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2312", "1257", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-400x260.jpeg", "", "Reduced by 5.9% (1.3 KB)", "20785", "22077", "", "10", "0", "1", "2021-01-01 15:28:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2313", "1257", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-500x380.jpeg", "", "Reduced by 5.7% (2.0 KB)", "33922", "35977", "", "10", "0", "1", "2021-01-01 15:28:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2314", "1257", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-500x500.jpeg", "", "Reduced by 5.9% (2.5 KB)", "41866", "44471", "", "10", "0", "1", "2021-01-01 15:28:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2315", "1257", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-1000x500.jpeg", "", "Reduced by 4.9% (4.4 KB)", "86479", "90974", "", "10", "0", "1", "2021-01-01 15:28:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2316", "1257", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-500x768.jpeg", "", "Reduced by 5.7% (3.8 KB)", "63559", "67403", "", "10", "0", "1", "2021-01-01 15:28:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2317", "1257", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-1000x768.jpeg", "", "Reduced by 5.5% (7.2 KB)", "127836", "135249", "", "10", "0", "1", "2021-01-01 15:28:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2318", "1257", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-700x525.jpeg", "", "Reduced by 6.0% (3.7 KB)", "60094", "63922", "", "10", "0", "1", "2021-01-01 15:28:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2319", "1257", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping-2-539x303.jpeg", "", "Reduced by 5.6% (1.9 KB)", "32239", "34140", "", "10", "0", "1", "2021-01-01 15:28:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2320", "1258", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1.jpeg", "", "Reduced by 2.0% (2.3 KB)", "120588", "122992", "", "10", "0", "1", "2021-01-01 15:28:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2321", "1258", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-300x225.jpeg", "", "Reduced by 6.1% (624 B)", "9662", "10286", "", "10", "0", "1", "2021-01-01 15:28:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2322", "1258", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-150x150.jpeg", "", "Reduced by 9.0% (395 B)", "3986", "4381", "", "10", "0", "1", "2021-01-01 15:28:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2323", "1258", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-768x576.jpeg", "", "Reduced by 7.3% (3.2 KB)", "42036", "45345", "", "10", "0", "1", "2021-01-01 15:28:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2324", "1258", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-570x570.jpeg", "", "Reduced by 7.5% (2.5 KB)", "31118", "33638", "", "10", "0", "1", "2021-01-01 15:28:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2325", "1258", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-600x768.jpeg", "", "Reduced by 8.0% (3.6 KB)", "42102", "45755", "", "10", "0", "1", "2021-01-01 15:28:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2326", "1258", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-800x600.jpeg", "", "Reduced by 7.6% (3.5 KB)", "43907", "47535", "", "10", "0", "1", "2021-01-01 15:28:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2327", "1258", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-345x198.jpeg", "", "Reduced by 6.5% (684 B)", "9871", "10555", "", "10", "0", "1", "2021-01-01 15:28:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2328", "1258", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-400x260.jpeg", "", "Reduced by 6.4% (934 B)", "13554", "14488", "", "10", "0", "1", "2021-01-01 15:28:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2329", "1258", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-500x380.jpeg", "", "Reduced by 6.6% (1.5 KB)", "21583", "23104", "", "10", "0", "1", "2021-01-01 15:28:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2330", "1258", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-500x500.jpeg", "", "Reduced by 7.5% (2.0 KB)", "25342", "27388", "", "10", "0", "1", "2021-01-01 15:28:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2331", "1258", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-1000x500.jpeg", "", "Reduced by 7.5% (3.6 KB)", "45582", "49290", "", "10", "0", "1", "2021-01-01 15:28:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2332", "1258", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-500x768.jpeg", "", "Reduced by 7.9% (3.0 KB)", "36062", "39149", "", "10", "0", "1", "2021-01-01 15:28:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2333", "1258", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-1000x768.jpeg", "", "Reduced by 7.8% (5.9 KB)", "70825", "76816", "", "10", "0", "1", "2021-01-01 15:28:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2334", "1258", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-700x525.jpeg", "", "Reduced by 7.5% (2.9 KB)", "36052", "38977", "", "10", "0", "1", "2021-01-01 15:28:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2335", "1258", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-1-539x303.jpeg", "", "Reduced by 6.3% (1.3 KB)", "19223", "20525", "", "10", "0", "1", "2021-01-01 15:28:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2336", "1259", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2.jpeg", "", "Reduced by 2.0% (2.3 KB)", "120588", "122992", "", "10", "0", "1", "2021-01-01 15:28:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2337", "1259", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-300x225.jpeg", "", "Reduced by 6.1% (624 B)", "9662", "10286", "", "10", "0", "1", "2021-01-01 15:28:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2338", "1259", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-150x150.jpeg", "", "Reduced by 9.0% (395 B)", "3986", "4381", "", "10", "0", "1", "2021-01-01 15:28:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2339", "1259", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-768x576.jpeg", "", "Reduced by 7.3% (3.2 KB)", "42036", "45345", "", "10", "0", "1", "2021-01-01 15:28:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2340", "1259", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-570x570.jpeg", "", "Reduced by 7.5% (2.5 KB)", "31118", "33638", "", "10", "0", "1", "2021-01-01 15:28:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2341", "1259", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-600x768.jpeg", "", "Reduced by 8.0% (3.6 KB)", "42102", "45755", "", "10", "0", "1", "2021-01-01 15:28:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2342", "1259", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-800x600.jpeg", "", "Reduced by 7.6% (3.5 KB)", "43907", "47535", "", "10", "0", "1", "2021-01-01 15:28:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2343", "1259", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-345x198.jpeg", "", "Reduced by 6.5% (684 B)", "9871", "10555", "", "10", "0", "1", "2021-01-01 15:28:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2344", "1259", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-400x260.jpeg", "", "Reduced by 6.4% (934 B)", "13554", "14488", "", "10", "0", "1", "2021-01-01 15:28:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2345", "1259", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-500x380.jpeg", "", "Reduced by 6.6% (1.5 KB)", "21583", "23104", "", "10", "0", "1", "2021-01-01 15:28:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2346", "1259", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-500x500.jpeg", "", "Reduced by 7.5% (2.0 KB)", "25342", "27388", "", "10", "0", "1", "2021-01-01 15:28:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2347", "1259", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-1000x500.jpeg", "", "Reduced by 7.5% (3.6 KB)", "45582", "49290", "", "10", "0", "1", "2021-01-01 15:28:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2348", "1259", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-500x768.jpeg", "", "Reduced by 7.9% (3.0 KB)", "36062", "39149", "", "10", "0", "1", "2021-01-01 15:28:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2349", "1259", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-1000x768.jpeg", "", "Reduced by 7.8% (5.9 KB)", "70825", "76816", "", "10", "0", "1", "2021-01-01 15:28:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2350", "1259", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-700x525.jpeg", "", "Reduced by 7.5% (2.9 KB)", "36052", "38977", "", "10", "0", "1", "2021-01-01 15:28:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2351", "1259", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping2-2-539x303.jpeg", "", "Reduced by 6.3% (1.3 KB)", "19223", "20525", "", "10", "0", "1", "2021-01-01 15:28:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2352", "1260", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1.jpeg", "", "Reduced by 1.3% (1.8 KB)", "146380", "148250", "", "10", "0", "1", "2021-01-01 15:28:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2353", "1260", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-300x225.jpeg", "", "Reduced by 8.2% (820 B)", "9177", "9997", "", "10", "0", "1", "2021-01-01 15:28:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2354", "1260", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-150x150.jpeg", "", "Reduced by 11.5% (473 B)", "3646", "4119", "", "10", "0", "1", "2021-01-01 15:28:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2355", "1260", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-768x576.jpeg", "", "Reduced by 7.2% (3.6 KB)", "47508", "51179", "", "10", "0", "1", "2021-01-01 15:28:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2356", "1260", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-570x570.jpeg", "", "Reduced by 7.2% (2.7 KB)", "35745", "38533", "", "10", "0", "1", "2021-01-01 15:28:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2357", "1260", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-600x768.jpeg", "", "Reduced by 7.3% (4.1 KB)", "53313", "57481", "", "10", "0", "1", "2021-01-01 15:28:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2358", "1260", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-800x600.jpeg", "", "Reduced by 7.4% (3.9 KB)", "50597", "54623", "", "10", "0", "1", "2021-01-01 15:28:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2359", "1260", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-345x198.jpeg", "", "Reduced by 8.9% (929 B)", "9479", "10408", "", "10", "0", "1", "2021-01-01 15:28:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2360", "1260", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-400x260.jpeg", "", "Reduced by 8.1% (1.1 KB)", "13187", "14356", "", "10", "0", "1", "2021-01-01 15:28:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2361", "1260", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-500x380.jpeg", "", "Reduced by 7.5% (1.8 KB)", "22452", "24272", "", "10", "0", "1", "2021-01-01 15:28:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2362", "1260", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-500x500.jpeg", "", "Reduced by 7.4% (2.2 KB)", "28310", "30559", "", "10", "0", "1", "2021-01-01 15:28:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2363", "1260", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-1000x500.jpeg", "", "Reduced by 7.8% (4.2 KB)", "51569", "55919", "", "10", "0", "1", "2021-01-01 15:28:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2364", "1260", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-500x768.jpeg", "", "Reduced by 7.3% (3.5 KB)", "45584", "49166", "", "10", "0", "1", "2021-01-01 15:28:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2365", "1260", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-1000x768.jpeg", "", "Reduced by 7.4% (6.7 KB)", "86341", "93212", "", "10", "0", "1", "2021-01-01 15:28:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2366", "1260", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-700x525.jpeg", "", "Reduced by 7.2% (3.0 KB)", "40218", "43330", "", "10", "0", "1", "2021-01-01 15:28:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2367", "1260", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Custom-Champagne-Permatite-Coping3-1-539x303.jpeg", "", "Reduced by 7.7% (1.6 KB)", "19735", "21382", "", "10", "0", "1", "2021-01-01 15:28:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2368", "1261", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1.jpeg", "", "Reduced by 1.9% (9.2 KB)", "482062", "491493", "", "10", "0", "1", "2021-01-01 15:28:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2369", "1261", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-300x221.jpeg", "", "Reduced by 5.7% (703 B)", "11662", "12365", "", "10", "0", "1", "2021-01-01 15:28:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2370", "1261", "media", "large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-1024x753.jpeg", "", "Reduced by 5.7% (5.8 KB)", "97423", "103332", "", "10", "0", "1", "2021-01-01 15:29:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2371", "1261", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-150x150.jpeg", "", "Reduced by 7.5% (390 B)", "4801", "5191", "", "10", "0", "1", "2021-01-01 15:29:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2372", "1261", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-768x565.jpeg", "", "Reduced by 5.3% (3.2 KB)", "58727", "62029", "", "10", "0", "1", "2021-01-01 15:29:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2373", "1261", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-1536x1130.jpeg", "", "Reduced by 6.0% (12.1 KB)", "193920", "206314", "", "10", "0", "1", "2021-01-01 15:29:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2374", "1261", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-2048x1506.jpeg", "", "Reduced by 6.5% (21.0 KB)", "312249", "333804", "", "10", "0", "1", "2021-01-01 15:29:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2375", "1261", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-570x570.jpeg", "", "Reduced by 5.2% (2.4 KB)", "45758", "48265", "", "10", "0", "1", "2021-01-01 15:29:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2376", "1261", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-600x800.jpeg", "", "Reduced by 5.9% (3.7 KB)", "61007", "64837", "", "10", "0", "1", "2021-01-01 15:29:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2377", "1261", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-800x600.jpeg", "", "Reduced by 5.5% (3.6 KB)", "63939", "67670", "", "10", "0", "1", "2021-01-01 15:29:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2378", "1261", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-345x198.jpeg", "", "Reduced by 5.7% (778 B)", "12771", "13549", "", "10", "0", "1", "2021-01-01 15:29:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2379", "1261", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-400x260.jpeg", "", "Reduced by 5.7% (1.0 KB)", "17540", "18592", "", "10", "0", "1", "2021-01-01 15:29:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2380", "1261", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-500x380.jpeg", "", "Reduced by 5.5% (1.6 KB)", "28850", "30531", "", "10", "0", "1", "2021-01-01 15:29:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2381", "1261", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-500x500.jpeg", "", "Reduced by 5.6% (2.1 KB)", "36691", "38865", "", "10", "0", "1", "2021-01-01 15:29:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2382", "1261", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-1000x500.jpeg", "", "Reduced by 5.6% (4.3 KB)", "74370", "78791", "", "10", "0", "1", "2021-01-01 15:29:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2383", "1261", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-500x1000.jpeg", "", "Reduced by 6.1% (3.9 KB)", "60944", "64893", "", "10", "0", "1", "2021-01-01 15:29:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2384", "1261", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-1000x1000.jpeg", "", "Reduced by 6.0% (7.5 KB)", "119055", "126721", "", "10", "0", "1", "2021-01-01 15:29:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2385", "1261", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-700x515.jpeg", "", "Reduced by 5.2% (2.7 KB)", "50756", "53564", "", "10", "0", "1", "2021-01-01 15:29:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2386", "1261", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-1-539x303.jpeg", "", "Reduced by 5.2% (1.4 KB)", "27106", "28579", "", "10", "0", "1", "2021-01-01 15:29:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2387", "1262", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2.jpeg", "", "Reduced by 1.9% (9.2 KB)", "482062", "491493", "", "10", "0", "1", "2021-01-01 15:29:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2388", "1262", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-300x221.jpeg", "", "Reduced by 5.7% (703 B)", "11662", "12365", "", "10", "0", "1", "2021-01-01 15:29:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2389", "1262", "media", "large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-1024x753.jpeg", "", "Reduced by 5.7% (5.8 KB)", "97423", "103332", "", "10", "0", "1", "2021-01-01 15:29:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2390", "1262", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-150x150.jpeg", "", "Reduced by 7.5% (390 B)", "4801", "5191", "", "10", "0", "1", "2021-01-01 15:29:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2391", "1262", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-768x565.jpeg", "", "Reduced by 5.3% (3.2 KB)", "58727", "62029", "", "10", "0", "1", "2021-01-01 15:29:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2392", "1262", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-1536x1130.jpeg", "", "Reduced by 6.0% (12.1 KB)", "193920", "206314", "", "10", "0", "1", "2021-01-01 15:29:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2393", "1262", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-2048x1506.jpeg", "", "Reduced by 6.5% (21.0 KB)", "312249", "333804", "", "10", "0", "1", "2021-01-01 15:29:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2394", "1262", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-570x570.jpeg", "", "Reduced by 5.2% (2.4 KB)", "45758", "48265", "", "10", "0", "1", "2021-01-01 15:29:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2395", "1262", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-600x800.jpeg", "", "Reduced by 5.9% (3.7 KB)", "61007", "64837", "", "10", "0", "1", "2021-01-01 15:29:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2396", "1262", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-800x600.jpeg", "", "Reduced by 5.5% (3.6 KB)", "63939", "67670", "", "10", "0", "1", "2021-01-01 15:29:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2397", "1262", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-345x198.jpeg", "", "Reduced by 5.7% (778 B)", "12771", "13549", "", "10", "0", "1", "2021-01-01 15:29:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2398", "1262", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-400x260.jpeg", "", "Reduced by 5.7% (1.0 KB)", "17540", "18592", "", "10", "0", "1", "2021-01-01 15:29:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2399", "1262", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-500x380.jpeg", "", "Reduced by 5.5% (1.6 KB)", "28850", "30531", "", "10", "0", "1", "2021-01-01 15:29:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2400", "1262", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-500x500.jpeg", "", "Reduced by 5.6% (2.1 KB)", "36691", "38865", "", "10", "0", "1", "2021-01-01 15:29:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2401", "1262", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-1000x500.jpeg", "", "Reduced by 5.6% (4.3 KB)", "74370", "78791", "", "10", "0", "1", "2021-01-01 15:29:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2402", "1262", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-500x1000.jpeg", "", "Reduced by 6.1% (3.9 KB)", "60944", "64893", "", "10", "0", "1", "2021-01-01 15:29:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2403", "1262", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-1000x1000.jpeg", "", "Reduced by 6.0% (7.5 KB)", "119055", "126721", "", "10", "0", "1", "2021-01-01 15:29:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2404", "1262", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-700x515.jpeg", "", "Reduced by 5.2% (2.7 KB)", "50756", "53564", "", "10", "0", "1", "2021-01-01 15:29:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2405", "1262", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal-scaled-2-539x303.jpeg", "", "Reduced by 5.2% (1.4 KB)", "27106", "28579", "", "10", "0", "1", "2021-01-01 15:29:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2406", "1263", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1.jpeg", "", "Reduced by 1.2% (1.3 KB)", "106642", "107951", "", "10", "0", "1", "2021-01-01 15:29:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2407", "1263", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-300x225.jpeg", "", "Reduced by 6.3% (642 B)", "9477", "10119", "", "10", "0", "1", "2021-01-01 15:29:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2408", "1263", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-150x150.jpeg", "", "Reduced by 9.9% (448 B)", "4095", "4543", "", "10", "0", "1", "2021-01-01 15:29:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2409", "1263", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-768x576.jpeg", "", "Reduced by 6.7% (2.7 KB)", "37978", "40699", "", "10", "0", "1", "2021-01-01 15:29:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2410", "1263", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-570x570.jpeg", "", "Reduced by 6.9% (2.2 KB)", "29802", "32016", "", "10", "0", "1", "2021-01-01 15:29:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2411", "1263", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-600x768.jpeg", "", "Reduced by 7.9% (3.2 KB)", "38048", "41293", "", "10", "0", "1", "2021-01-01 15:29:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2412", "1263", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-800x600.jpeg", "", "Reduced by 6.7% (2.8 KB)", "40208", "43095", "", "10", "0", "1", "2021-01-01 15:29:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2413", "1263", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-345x198.jpeg", "", "Reduced by 6.1% (634 B)", "9803", "10437", "", "10", "0", "1", "2021-01-01 15:29:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2414", "1263", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-400x260.jpeg", "", "Reduced by 5.6% (781 B)", "13072", "13853", "", "10", "0", "1", "2021-01-01 15:29:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2415", "1263", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-500x380.jpeg", "", "Reduced by 6.3% (1.4 KB)", "20632", "22020", "", "10", "0", "1", "2021-01-01 15:29:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2416", "1263", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-500x500.jpeg", "", "Reduced by 7.0% (1.8 KB)", "24462", "26308", "", "10", "0", "1", "2021-01-01 15:29:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2417", "1263", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-1000x500.jpeg", "", "Reduced by 6.1% (2.8 KB)", "43644", "46479", "", "10", "0", "1", "2021-01-01 15:29:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2418", "1263", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-500x768.jpeg", "", "Reduced by 7.8% (2.6 KB)", "32071", "34769", "", "10", "0", "1", "2021-01-01 15:29:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2419", "1263", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-1000x768.jpeg", "", "Reduced by 7.5% (4.9 KB)", "62026", "67038", "", "10", "0", "1", "2021-01-01 15:29:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2420", "1263", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-700x525.jpeg", "", "Reduced by 6.5% (2.3 KB)", "33265", "35585", "", "10", "0", "1", "2021-01-01 15:29:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2421", "1263", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-1-539x303.jpeg", "", "Reduced by 5.3% (1.0 KB)", "18595", "19629", "", "10", "0", "1", "2021-01-01 15:29:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2422", "1275", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1.jpg", "", "Reduced by 0.9% (6.4 KB)", "743448", "749995", "", "10", "0", "1", "2021-01-01 15:29:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2423", "1275", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-300x225.jpg", "", "Reduced by 6.1% (969 B)", "14920", "15889", "", "10", "0", "1", "2021-01-01 15:29:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2424", "1275", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-1024x768.jpg", "", "Reduced by 5.3% (7.6 KB)", "138977", "146794", "", "10", "0", "1", "2021-01-01 15:29:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2425", "1275", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-150x150.jpg", "", "Reduced by 8.5% (521 B)", "5591", "6112", "", "10", "0", "1", "2021-01-01 15:29:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2426", "1275", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-768x576.jpg", "", "Reduced by 5.4% (4.6 KB)", "81577", "86258", "", "10", "0", "1", "2021-01-01 15:29:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2427", "1275", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-1536x1152.jpg", "", "Reduced by 5.0% (14.7 KB)", "287440", "302462", "", "10", "0", "1", "2021-01-01 15:29:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2428", "1275", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-2048x1536.jpg", "", "Reduced by 4.7% (22.4 KB)", "468251", "491231", "", "10", "0", "1", "2021-01-01 15:29:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2429", "1275", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-570x570.jpg", "", "Reduced by 5.4% (3.4 KB)", "60712", "64190", "", "10", "0", "1", "2021-01-01 15:29:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2430", "1275", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-600x800.jpg", "", "Reduced by 5.6% (4.9 KB)", "84589", "89623", "", "10", "0", "1", "2021-01-01 15:29:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2431", "1275", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-800x600.jpg", "", "Reduced by 5.5% (5.0 KB)", "87961", "93060", "", "10", "0", "1", "2021-01-01 15:29:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2432", "1275", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-345x198.jpg", "", "Reduced by 6.2% (995 B)", "15047", "16042", "", "10", "0", "1", "2021-01-01 15:29:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2433", "1275", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-400x260.jpg", "", "Reduced by 5.5% (1.2 KB)", "21704", "22956", "", "10", "0", "1", "2021-01-01 15:29:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2434", "1275", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-500x380.jpg", "", "Reduced by 5.3% (2.1 KB)", "37723", "39836", "", "10", "0", "1", "2021-01-01 15:29:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2435", "1275", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-500x500.jpg", "", "Reduced by 5.5% (2.7 KB)", "47792", "50593", "", "10", "0", "1", "2021-01-01 15:29:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2436", "1275", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-1000x500.jpg", "", "Reduced by 5.7% (5.5 KB)", "92655", "98304", "", "10", "0", "1", "2021-01-01 15:29:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2437", "1275", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-500x1000.jpg", "", "Reduced by 5.4% (4.8 KB)", "86548", "91460", "", "10", "0", "1", "2021-01-01 15:29:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2438", "1275", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-1000x1000.jpg", "", "Reduced by 5.2% (8.9 KB)", "165710", "174836", "", "10", "0", "1", "2021-01-01 15:29:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2439", "1275", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-700x525.jpg", "", "Reduced by 5.4% (3.9 KB)", "69001", "72951", "", "10", "0", "1", "2021-01-01 15:29:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2440", "1275", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-1-539x303.jpg", "", "Reduced by 5.3% (1.8 KB)", "32868", "34704", "", "10", "0", "1", "2021-01-01 15:29:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2441", "1268", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2.jpeg", "", "Reduced by 1.3% (2.3 KB)", "181126", "183447", "", "10", "0", "1", "2021-01-01 15:29:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2442", "1268", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-281x300.jpeg", "", "Reduced by 8.1% (1.1 KB)", "13003", "14142", "", "10", "0", "1", "2021-01-01 15:29:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2443", "1268", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-150x150.jpeg", "", "Reduced by 9.6% (461 B)", "4323", "4784", "", "10", "0", "1", "2021-01-01 15:29:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2444", "1268", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-768x821.jpeg", "", "Reduced by 6.9% (5.6 KB)", "77938", "83672", "", "10", "0", "1", "2021-01-01 15:29:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2445", "1268", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-570x570.jpeg", "", "Reduced by 6.7% (3.2 KB)", "44725", "47958", "", "10", "0", "1", "2021-01-01 15:29:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2446", "1268", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-600x800.jpeg", "", "Reduced by 7.0% (4.3 KB)", "59072", "63499", "", "10", "0", "1", "2021-01-01 15:29:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2447", "1268", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-800x600.jpeg", "", "Reduced by 6.7% (4.3 KB)", "61304", "65726", "", "10", "0", "1", "2021-01-01 15:29:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2448", "1268", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-345x198.jpeg", "", "Reduced by 9.0% (1,003 B)", "10194", "11197", "", "10", "0", "1", "2021-01-01 15:29:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2449", "1268", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-400x260.jpeg", "", "Reduced by 8.2% (1.3 KB)", "15224", "16583", "", "10", "0", "1", "2021-01-01 15:29:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2450", "1268", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-500x380.jpeg", "", "Reduced by 7.3% (2.1 KB)", "27048", "29164", "", "10", "0", "1", "2021-01-01 15:29:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2451", "1268", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-500x500.jpeg", "", "Reduced by 7.3% (2.7 KB)", "35504", "38300", "", "10", "0", "1", "2021-01-01 15:29:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2452", "1268", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-857x500.jpeg", "", "Reduced by 8.4% (5.6 KB)", "62405", "68149", "", "10", "0", "1", "2021-01-01 15:29:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2453", "1268", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-500x916.jpeg", "", "Reduced by 7.9% (5.3 KB)", "63281", "68729", "", "10", "0", "1", "2021-01-01 15:29:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2454", "1268", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-700x748.jpeg", "", "Reduced by 6.7% (4.7 KB)", "66496", "71289", "", "10", "0", "1", "2021-01-01 15:29:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2455", "1268", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-2-539x303.jpeg", "", "Reduced by 8.0% (1.8 KB)", "21887", "23780", "", "10", "0", "1", "2021-01-01 15:30:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2456", "1271", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1.jpg", "", "Reduced by 1.4% (7.2 KB)", "525677", "533059", "", "10", "0", "1", "2021-01-01 15:30:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2457", "1271", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-300x225.jpg", "", "Reduced by 7.1% (984 B)", "12953", "13937", "", "10", "0", "1", "2021-01-01 15:30:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2458", "1271", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-1024x768.jpg", "", "Reduced by 4.4% (4.7 KB)", "104432", "109219", "", "10", "0", "1", "2021-01-01 15:30:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2459", "1271", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-150x150.jpg", "", "Reduced by 9.6% (540 B)", "5080", "5620", "", "10", "0", "1", "2021-01-01 15:30:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2460", "1271", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-768x576.jpg", "", "Reduced by 5.0% (3.3 KB)", "63703", "67049", "", "10", "0", "1", "2021-01-01 15:30:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2461", "1271", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-1536x1152.jpg", "", "Reduced by 4.4% (9.3 KB)", "207460", "216955", "", "10", "0", "1", "2021-01-01 15:30:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2462", "1271", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-2048x1536.jpg", "", "Reduced by 4.9% (16.7 KB)", "334868", "351997", "", "10", "0", "1", "2021-01-01 15:30:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2463", "1271", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-570x570.jpg", "", "Reduced by 5.0% (2.4 KB)", "46887", "49342", "", "10", "0", "1", "2021-01-01 15:30:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2464", "1271", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-600x800.jpg", "", "Reduced by 4.6% (2.8 KB)", "60763", "63681", "", "10", "0", "1", "2021-01-01 15:30:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2465", "1271", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-800x600.jpg", "", "Reduced by 5.0% (3.5 KB)", "68270", "71863", "", "10", "0", "1", "2021-01-01 15:30:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2466", "1271", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-345x198.jpg", "", "Reduced by 7.9% (1.1 KB)", "13252", "14386", "", "10", "0", "1", "2021-01-01 15:30:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2467", "1271", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-400x260.jpg", "", "Reduced by 6.7% (1.3 KB)", "18624", "19963", "", "10", "0", "1", "2021-01-01 15:30:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2468", "1271", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-500x380.jpg", "", "Reduced by 5.5% (1.8 KB)", "31130", "32936", "", "10", "0", "1", "2021-01-01 15:30:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2469", "1271", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-500x500.jpg", "", "Reduced by 5.6% (2.2 KB)", "37434", "39648", "", "10", "0", "1", "2021-01-01 15:30:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2470", "1271", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-1000x500.jpg", "", "Reduced by 4.8% (3.4 KB)", "68812", "72276", "", "10", "0", "1", "2021-01-01 15:30:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2471", "1271", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-500x1000.jpg", "", "Reduced by 4.7% (2.8 KB)", "57996", "60888", "", "10", "0", "1", "2021-01-01 15:30:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2472", "1271", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-1000x1000.jpg", "", "Reduced by 4.4% (5.4 KB)", "120357", "125840", "", "10", "0", "1", "2021-01-01 15:30:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2473", "1271", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-700x525.jpg", "", "Reduced by 4.9% (2.8 KB)", "54695", "57536", "", "10", "0", "1", "2021-01-01 15:30:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2474", "1271", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-1-539x303.jpg", "", "Reduced by 6.0% (1.7 KB)", "27290", "29038", "", "10", "0", "1", "2021-01-01 15:30:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2475", "1285", "media", "full", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1.jpeg", "", "Reduced by 2.5% (2.7 KB)", "107263", "109980", "", "10", "0", "1", "2021-01-01 15:30:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2476", "1285", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-300x146.jpeg", "", "Reduced by 7.8% (527 B)", "6190", "6717", "", "10", "0", "1", "2021-01-01 15:30:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2477", "1285", "media", "large", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-1024x498.jpeg", "", "Reduced by 9.9% (4.4 KB)", "41244", "45753", "", "10", "0", "1", "2021-01-01 15:30:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2478", "1285", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-150x150.jpeg", "", "Reduced by 10.7% (408 B)", "3390", "3798", "", "10", "0", "1", "2021-01-01 15:30:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2479", "1285", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-768x373.jpeg", "", "Reduced by 8.8% (2.5 KB)", "25969", "28483", "", "10", "0", "1", "2021-01-01 15:30:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2480", "1285", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-570x570.jpeg", "", "Reduced by 9.6% (2.6 KB)", "25010", "27652", "", "10", "0", "1", "2021-01-01 15:30:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2481", "1285", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-600x618.jpeg", "", "Reduced by 10.3% (3.6 KB)", "32283", "35974", "", "10", "0", "1", "2021-01-01 15:30:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2482", "1285", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-800x600.jpeg", "", "Reduced by 10.6% (4.0 KB)", "34730", "38850", "", "10", "0", "1", "2021-01-01 15:30:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2483", "1285", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-345x198.jpeg", "", "Reduced by 8.3% (757 B)", "8388", "9145", "", "10", "0", "1", "2021-01-01 15:30:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2484", "1285", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-400x260.jpeg", "", "Reduced by 8.1% (968 B)", "11032", "12000", "", "10", "0", "1", "2021-01-01 15:30:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2485", "1285", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-500x380.jpeg", "", "Reduced by 9.1% (1.7 KB)", "17476", "19231", "", "10", "0", "1", "2021-01-01 15:30:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2486", "1285", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-500x500.jpeg", "", "Reduced by 9.7% (2.1 KB)", "20489", "22687", "", "10", "0", "1", "2021-01-01 15:30:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2487", "1285", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-1000x500.jpeg", "", "Reduced by 9.6% (4.2 KB)", "40411", "44719", "", "10", "0", "1", "2021-01-01 15:30:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2488", "1285", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-500x618.jpeg", "", "Reduced by 9.3% (2.6 KB)", "26080", "28767", "", "10", "0", "1", "2021-01-01 15:30:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2489", "1285", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-1000x618.jpeg", "", "Reduced by 11.0% (6.3 KB)", "52517", "59008", "", "10", "0", "1", "2021-01-01 15:30:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2490", "1285", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-700x340.jpeg", "", "Reduced by 9.1% (2.2 KB)", "22895", "25179", "", "10", "0", "1", "2021-01-01 15:30:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2491", "1285", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Carlisle-45-Mil-White-TPO2-1-539x303.jpeg", "", "Reduced by 8.5% (1.5 KB)", "16321", "17835", "", "10", "0", "1", "2021-01-01 15:30:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2492", "1314", "media", "full", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1.jpg", "", "Reduced by 0.6% (3.4 KB)", "535550", "539007", "", "10", "0", "1", "2021-01-01 15:30:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2493", "1314", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-300x225.jpg", "", "Reduced by 5.8% (770 B)", "12491", "13261", "", "10", "0", "1", "2021-01-01 15:30:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2494", "1314", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-150x150.jpg", "", "Reduced by 7.0% (394 B)", "5198", "5592", "", "10", "0", "1", "2021-01-01 15:30:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2495", "1314", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-768x576.jpg", "", "Reduced by 5.1% (3.0 KB)", "56969", "60040", "", "10", "0", "1", "2021-01-01 15:30:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2496", "1314", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-570x570.jpg", "", "Reduced by 5.0% (2.2 KB)", "41933", "44145", "", "10", "0", "1", "2021-01-01 15:30:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2497", "1314", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-600x768.jpg", "", "Reduced by 4.9% (2.9 KB)", "58211", "61196", "", "10", "0", "1", "2021-01-01 15:30:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2498", "1314", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-800x600.jpg", "", "Reduced by 5.2% (3.3 KB)", "60233", "63563", "", "10", "0", "1", "2021-01-01 15:30:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2499", "1314", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-345x198.jpg", "", "Reduced by 5.8% (768 B)", "12411", "13179", "", "10", "0", "1", "2021-01-01 15:30:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2500", "1314", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-400x260.jpg", "", "Reduced by 5.3% (984 B)", "17660", "18644", "", "10", "0", "1", "2021-01-01 15:30:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2501", "1314", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-500x380.jpg", "", "Reduced by 5.2% (1.5 KB)", "28789", "30374", "", "10", "0", "1", "2021-01-01 15:30:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2502", "1314", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-500x500.jpg", "", "Reduced by 5.5% (1.9 KB)", "34086", "36072", "", "10", "0", "1", "2021-01-01 15:30:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2503", "1314", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-1000x500.jpg", "", "Reduced by 5.1% (3.1 KB)", "58576", "61731", "", "10", "0", "1", "2021-01-01 15:30:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2504", "1314", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-500x768.jpg", "", "Reduced by 5.0% (2.6 KB)", "49534", "52146", "", "10", "0", "1", "2021-01-01 15:30:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2505", "1314", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-1000x768.jpg", "", "Reduced by 5.2% (5.2 KB)", "95844", "101148", "", "10", "0", "1", "2021-01-01 15:30:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2506", "1314", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-700x525.jpg", "", "Reduced by 5.2% (2.6 KB)", "48867", "51554", "", "10", "0", "1", "2021-01-01 15:30:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2507", "1314", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC2-1-539x303.jpg", "", "Reduced by 5.0% (1.3 KB)", "25111", "26430", "", "10", "0", "1", "2021-01-01 15:30:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2508", "1292", "media", "full", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2.jpeg", "", "Reduced by 0.3% (767 B)", "220848", "221615", "", "10", "0", "1", "2021-01-01 15:30:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2509", "1292", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-225x300.jpeg", "", "Reduced by 5.4% (811 B)", "14183", "14994", "", "10", "0", "1", "2021-01-01 15:30:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2510", "1292", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-150x150.jpeg", "", "Reduced by 7.1% (395 B)", "5192", "5587", "", "10", "0", "1", "2021-01-01 15:30:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2511", "1292", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-570x570.jpeg", "", "Reduced by 4.9% (2.6 KB)", "52520", "55212", "", "10", "0", "1", "2021-01-01 15:30:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2512", "1292", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-600x800.jpeg", "", "Reduced by 4.6% (3.6 KB)", "78053", "81774", "", "10", "0", "1", "2021-01-01 15:30:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2513", "1292", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-768x600.jpeg", "", "Reduced by 5.4% (4.5 KB)", "81239", "85853", "", "10", "0", "1", "2021-01-01 15:30:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2514", "1292", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-345x198.jpeg", "", "Reduced by 5.6% (783 B)", "13246", "14029", "", "10", "0", "1", "2021-01-01 15:30:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2515", "1292", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-400x260.jpeg", "", "Reduced by 5.3% (1.0 KB)", "19137", "20205", "", "10", "0", "1", "2021-01-01 15:30:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2516", "1292", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-500x380.jpeg", "", "Reduced by 5.1% (1.7 KB)", "32585", "34321", "", "10", "0", "1", "2021-01-01 15:30:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2517", "1292", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-500x500.jpeg", "", "Reduced by 5.0% (2.1 KB)", "41643", "43813", "", "10", "0", "1", "2021-01-01 15:30:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2518", "1292", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-768x500.jpeg", "", "Reduced by 5.4% (3.9 KB)", "69738", "73729", "", "10", "0", "1", "2021-01-01 15:30:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2519", "1292", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-500x1000.jpeg", "", "Reduced by 4.3% (3.3 KB)", "74480", "77867", "", "10", "0", "1", "2021-01-01 15:30:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2520", "1292", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-768x1000.jpeg", "", "Reduced by 5.1% (7.0 KB)", "133759", "140878", "", "10", "0", "1", "2021-01-01 15:30:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2521", "1292", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-700x933.jpeg", "", "Reduced by 4.5% (4.7 KB)", "102522", "107325", "", "10", "0", "1", "2021-01-01 15:30:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2522", "1292", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-TPO2-2-539x303.jpeg", "", "Reduced by 5.0% (1.5 KB)", "28324", "29830", "", "10", "0", "1", "2021-01-01 15:30:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2523", "1302", "media", "full", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2.jpg", "", "Reduced by 0.9% (2.3 KB)", "267699", "270084", "", "10", "0", "1", "2021-01-01 15:30:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2524", "1302", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-300x225.jpg", "", "Reduced by 6.5% (1.1 KB)", "15525", "16607", "", "10", "0", "1", "2021-01-01 15:30:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2525", "1302", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-150x150.jpg", "", "Reduced by 8.4% (521 B)", "5645", "6166", "", "10", "0", "1", "2021-01-01 15:30:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2526", "1302", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-768x576.jpg", "", "Reduced by 6.2% (5.5 KB)", "86009", "91652", "", "10", "0", "1", "2021-01-01 15:30:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2527", "1302", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-570x570.jpg", "", "Reduced by 6.0% (4.0 KB)", "63969", "68082", "", "10", "0", "1", "2021-01-01 15:30:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2528", "1302", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-600x768.jpg", "", "Reduced by 6.7% (6.8 KB)", "97474", "104472", "", "10", "0", "1", "2021-01-01 15:30:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2529", "1302", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-800x600.jpg", "", "Reduced by 6.1% (5.8 KB)", "91852", "97776", "", "10", "0", "1", "2021-01-01 15:30:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2530", "1302", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-345x198.jpg", "", "Reduced by 6.5% (1.0 KB)", "14776", "15806", "", "10", "0", "1", "2021-01-01 15:30:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2531", "1302", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-400x260.jpg", "", "Reduced by 6.1% (1.4 KB)", "22154", "23592", "", "10", "0", "1", "2021-01-01 15:30:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2532", "1302", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-500x380.jpg", "", "Reduced by 6.2% (2.5 KB)", "39763", "42369", "", "10", "0", "1", "2021-01-01 15:30:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2533", "1302", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-500x500.jpg", "", "Reduced by 6.4% (3.4 KB)", "50160", "53607", "", "10", "0", "1", "2021-01-01 15:30:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2534", "1302", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-1000x500.jpg", "", "Reduced by 5.6% (4.9 KB)", "83681", "88672", "", "10", "0", "1", "2021-01-01 15:30:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2535", "1302", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-500x768.jpg", "", "Reduced by 6.8% (5.8 KB)", "81267", "87209", "", "10", "0", "1", "2021-01-01 15:30:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2536", "1302", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-1000x768.jpg", "", "Reduced by 6.4% (10.9 KB)", "162410", "173550", "", "10", "0", "1", "2021-01-01 15:31:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2537", "1302", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-700x525.jpg", "", "Reduced by 6.0% (4.5 KB)", "72460", "77093", "", "10", "0", "1", "2021-01-01 15:31:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2538", "1302", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-2-2-539x303.jpg", "", "Reduced by 5.6% (1.9 KB)", "32291", "34208", "", "10", "0", "1", "2021-01-01 15:31:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2539", "1300", "media", "full", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2.jpeg", "", "Reduced by 0.5% (1.4 KB)", "296877", "298313", "", "10", "0", "1", "2021-01-01 15:31:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2540", "1300", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-300x225.jpeg", "", "Reduced by 6.8% (1.3 KB)", "17749", "19039", "", "10", "0", "1", "2021-01-01 15:31:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2541", "1300", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-150x150.jpeg", "", "Reduced by 7.9% (583 B)", "6807", "7390", "", "10", "0", "1", "2021-01-01 15:31:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2542", "1300", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-768x576.jpeg", "", "Reduced by 5.4% (5.1 KB)", "92286", "97542", "", "10", "0", "1", "2021-01-01 15:31:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2543", "1300", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-570x570.jpeg", "", "Reduced by 5.3% (3.7 KB)", "68124", "71899", "", "10", "0", "1", "2021-01-01 15:31:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2544", "1300", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-600x768.jpeg", "", "Reduced by 5.5% (5.9 KB)", "102529", "108524", "", "10", "0", "1", "2021-01-01 15:31:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2545", "1300", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-800x600.jpeg", "", "Reduced by 5.4% (5.4 KB)", "98059", "103611", "", "10", "0", "1", "2021-01-01 15:31:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2546", "1300", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-345x198.jpeg", "", "Reduced by 6.9% (1.3 KB)", "17961", "19290", "", "10", "0", "1", "2021-01-01 15:31:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2547", "1300", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-400x260.jpeg", "", "Reduced by 6.5% (1.8 KB)", "25871", "27684", "", "10", "0", "1", "2021-01-01 15:31:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2548", "1300", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-500x380.jpeg", "", "Reduced by 5.8% (2.7 KB)", "43987", "46718", "", "10", "0", "1", "2021-01-01 15:31:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2549", "1300", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-500x500.jpeg", "", "Reduced by 5.8% (3.3 KB)", "54406", "57740", "", "10", "0", "1", "2021-01-01 15:31:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2550", "1300", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-1000x500.jpeg", "", "Reduced by 5.0% (4.9 KB)", "94871", "99881", "", "10", "0", "1", "2021-01-01 15:31:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2551", "1300", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-500x768.jpeg", "", "Reduced by 5.6% (5.0 KB)", "86383", "91483", "", "10", "0", "1", "2021-01-01 15:31:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2552", "1300", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-1000x768.jpeg", "", "Reduced by 5.5% (9.6 KB)", "168769", "178567", "", "10", "0", "1", "2021-01-01 15:31:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2553", "1300", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-700x525.jpeg", "", "Reduced by 5.5% (4.4 KB)", "78345", "82865", "", "10", "0", "1", "2021-01-01 15:31:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2554", "1300", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Carlisle-80-Mil-Gray-TPO3-2-539x303.jpeg", "", "Reduced by 5.9% (2.3 KB)", "37663", "40042", "", "10", "0", "1", "2021-01-01 15:31:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2555", "1310", "media", "full", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1.jpg", "", "Reduced by 0.7% (1.6 KB)", "225023", "226686", "", "10", "0", "1", "2021-01-01 15:31:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2556", "1310", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-300x225.jpg", "", "Reduced by 5.9% (924 B)", "14814", "15738", "", "10", "0", "1", "2021-01-01 15:31:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2557", "1310", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-150x150.jpg", "", "Reduced by 8.1% (462 B)", "5275", "5737", "", "10", "0", "1", "2021-01-01 15:31:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2558", "1310", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-768x576.jpg", "", "Reduced by 5.1% (4.0 KB)", "75686", "79745", "", "10", "0", "1", "2021-01-01 15:31:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2559", "1310", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-570x570.jpg", "", "Reduced by 5.3% (2.9 KB)", "53852", "56854", "", "10", "0", "1", "2021-01-01 15:31:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2560", "1310", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-600x768.jpg", "", "Reduced by 6.0% (4.9 KB)", "78679", "83706", "", "10", "0", "1", "2021-01-01 15:31:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2561", "1310", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-800x600.jpg", "", "Reduced by 5.2% (4.3 KB)", "80404", "84805", "", "10", "0", "1", "2021-01-01 15:31:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2562", "1310", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-345x198.jpg", "", "Reduced by 6.3% (876 B)", "13097", "13973", "", "10", "0", "1", "2021-01-01 15:31:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2563", "1310", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-400x260.jpg", "", "Reduced by 5.6% (1.2 KB)", "20007", "21203", "", "10", "0", "1", "2021-01-01 15:31:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2564", "1310", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-500x380.jpg", "", "Reduced by 5.4% (2.0 KB)", "36338", "38418", "", "10", "0", "1", "2021-01-01 15:31:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2565", "1310", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-500x500.jpg", "", "Reduced by 5.5% (2.5 KB)", "42854", "45364", "", "10", "0", "1", "2021-01-01 15:31:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2566", "1310", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-1000x500.jpg", "", "Reduced by 5.6% (3.9 KB)", "67212", "71163", "", "10", "0", "1", "2021-01-01 15:31:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2567", "1310", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-500x768.jpg", "", "Reduced by 6.0% (4.1 KB)", "65932", "70109", "", "10", "0", "1", "2021-01-01 15:31:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2568", "1310", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-1000x768.jpg", "", "Reduced by 5.6% (7.8 KB)", "134821", "142812", "", "10", "0", "1", "2021-01-01 15:31:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2569", "1310", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-700x525.jpg", "", "Reduced by 5.1% (3.4 KB)", "64462", "67918", "", "10", "0", "1", "2021-01-01 15:31:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2570", "1310", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Mule-Hide-Black-EPDM-1-539x303.jpg", "", "Reduced by 5.1% (1.4 KB)", "27396", "28854", "", "10", "0", "1", "2021-01-01 15:31:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2571", "1318", "media", "full", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1.jpg", "", "Reduced by 0.8% (5.7 KB)", "684840", "690633", "", "10", "0", "1", "2021-01-01 15:31:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2572", "1318", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-300x225.jpg", "", "Reduced by 6.5% (1.3 KB)", "18952", "20271", "", "10", "0", "1", "2021-01-01 15:31:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2573", "1318", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-150x150.jpg", "", "Reduced by 8.4% (678 B)", "7399", "8077", "", "10", "0", "1", "2021-01-01 15:31:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2574", "1318", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-768x576.jpg", "", "Reduced by 4.8% (4.6 KB)", "92895", "97615", "", "10", "0", "1", "2021-01-01 15:31:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2575", "1318", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-570x570.jpg", "", "Reduced by 5.0% (3.7 KB)", "71033", "74775", "", "10", "0", "1", "2021-01-01 15:31:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2576", "1318", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-600x768.jpg", "", "Reduced by 5.1% (5.2 KB)", "99481", "104810", "", "10", "0", "1", "2021-01-01 15:31:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2577", "1318", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-800x600.jpg", "", "Reduced by 4.9% (4.9 KB)", "98518", "103569", "", "10", "0", "1", "2021-01-01 15:31:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2578", "1318", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-345x198.jpg", "", "Reduced by 6.8% (1.4 KB)", "19935", "21384", "", "10", "0", "1", "2021-01-01 15:31:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2579", "1318", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-400x260.jpg", "", "Reduced by 6.3% (1.9 KB)", "28414", "30331", "", "10", "0", "1", "2021-01-01 15:31:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2580", "1318", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-500x380.jpg", "", "Reduced by 5.9% (2.8 KB)", "45897", "48781", "", "10", "0", "1", "2021-01-01 15:31:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2581", "1318", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-500x500.jpg", "", "Reduced by 5.6% (3.3 KB)", "57136", "60502", "", "10", "0", "1", "2021-01-01 15:31:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2582", "1318", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-1000x500.jpg", "", "Reduced by 4.6% (4.8 KB)", "101856", "106790", "", "10", "0", "1", "2021-01-01 15:31:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2583", "1318", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-500x768.jpg", "", "Reduced by 5.0% (4.2 KB)", "80607", "84890", "", "10", "0", "1", "2021-01-01 15:31:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2584", "1318", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-1000x768.jpg", "", "Reduced by 4.9% (8.1 KB)", "159420", "167691", "", "10", "0", "1", "2021-01-01 15:31:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2585", "1318", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-700x525.jpg", "", "Reduced by 5.2% (4.2 KB)", "79706", "84036", "", "10", "0", "1", "2021-01-01 15:31:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2586", "1318", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Carlisle-60-Mil-White-KEE-PVC4-1-539x303.jpg", "", "Reduced by 5.8% (2.5 KB)", "42018", "44612", "", "10", "0", "1", "2021-01-01 15:31:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2587", "1264", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2.jpeg", "", "Reduced by 1.2% (1.3 KB)", "106642", "107951", "", "10", "0", "1", "2021-01-01 15:31:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2588", "1264", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-300x225.jpeg", "", "Reduced by 6.3% (642 B)", "9477", "10119", "", "10", "0", "1", "2021-01-01 15:31:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2589", "1264", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-150x150.jpeg", "", "Reduced by 9.9% (448 B)", "4095", "4543", "", "10", "0", "1", "2021-01-01 15:31:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2590", "1264", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-768x576.jpeg", "", "Reduced by 6.7% (2.7 KB)", "37978", "40699", "", "10", "0", "1", "2021-01-01 15:31:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2591", "1264", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-570x570.jpeg", "", "Reduced by 6.9% (2.2 KB)", "29802", "32016", "", "10", "0", "1", "2021-01-01 15:31:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2592", "1264", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-600x768.jpeg", "", "Reduced by 7.9% (3.2 KB)", "38048", "41293", "", "10", "0", "1", "2021-01-01 15:31:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2593", "1264", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-800x600.jpeg", "", "Reduced by 6.7% (2.8 KB)", "40208", "43095", "", "10", "0", "1", "2021-01-01 15:31:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2594", "1264", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-345x198.jpeg", "", "Reduced by 6.1% (634 B)", "9803", "10437", "", "10", "0", "1", "2021-01-01 15:31:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2595", "1264", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-400x260.jpeg", "", "Reduced by 5.6% (781 B)", "13072", "13853", "", "10", "0", "1", "2021-01-01 15:31:42", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2596", "1264", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-500x380.jpeg", "", "Reduced by 6.3% (1.4 KB)", "20632", "22020", "", "10", "0", "1", "2021-01-01 15:31:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2597", "1264", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-500x500.jpeg", "", "Reduced by 7.0% (1.8 KB)", "24462", "26308", "", "10", "0", "1", "2021-01-01 15:31:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2598", "1264", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-1000x500.jpeg", "", "Reduced by 6.1% (2.8 KB)", "43644", "46479", "", "10", "0", "1", "2021-01-01 15:31:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2599", "1264", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-500x768.jpeg", "", "Reduced by 7.8% (2.6 KB)", "32071", "34769", "", "10", "0", "1", "2021-01-01 15:31:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2600", "1264", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-1000x768.jpeg", "", "Reduced by 7.5% (4.9 KB)", "62026", "67038", "", "10", "0", "1", "2021-01-01 15:31:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2601", "1264", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-700x525.jpeg", "", "Reduced by 6.5% (2.3 KB)", "33265", "35585", "", "10", "0", "1", "2021-01-01 15:31:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2602", "1264", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal2-2-539x303.jpeg", "", "Reduced by 5.3% (1.0 KB)", "18595", "19629", "", "10", "0", "1", "2021-01-01 15:31:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2603", "1265", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1.jpeg", "", "Reduced by 1.3% (1.3 KB)", "102823", "104143", "", "10", "0", "1", "2021-01-01 15:31:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2604", "1265", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-300x225.jpeg", "", "Reduced by 8.0% (712 B)", "8157", "8869", "", "10", "0", "1", "2021-01-01 15:31:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2605", "1265", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-150x150.jpeg", "", "Reduced by 10.2% (407 B)", "3582", "3989", "", "10", "0", "1", "2021-01-01 15:31:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2606", "1265", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-768x576.jpeg", "", "Reduced by 8.2% (3.0 KB)", "34883", "37983", "", "10", "0", "1", "2021-01-01 15:31:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2607", "1265", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-570x570.jpeg", "", "Reduced by 8.0% (2.3 KB)", "26914", "29244", "", "10", "0", "1", "2021-01-01 15:31:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2608", "1265", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-600x768.jpeg", "", "Reduced by 8.4% (3.4 KB)", "37488", "40945", "", "10", "0", "1", "2021-01-01 15:31:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2609", "1265", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-800x600.jpeg", "", "Reduced by 8.4% (3.3 KB)", "37240", "40667", "", "10", "0", "1", "2021-01-01 15:31:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2610", "1265", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-345x198.jpeg", "", "Reduced by 8.5% (842 B)", "9022", "9864", "", "10", "0", "1", "2021-01-01 15:31:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2611", "1265", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-400x260.jpeg", "", "Reduced by 7.5% (958 B)", "11796", "12754", "", "10", "0", "1", "2021-01-01 15:31:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2612", "1265", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-500x380.jpeg", "", "Reduced by 8.1% (1.5 KB)", "17990", "19576", "", "10", "0", "1", "2021-01-01 15:31:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2613", "1265", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-500x500.jpeg", "", "Reduced by 7.9% (1.9 KB)", "21974", "23870", "", "10", "0", "1", "2021-01-01 15:31:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2614", "1265", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-1000x500.jpeg", "", "Reduced by 7.7% (3.6 KB)", "43926", "47595", "", "10", "0", "1", "2021-01-01 15:31:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2615", "1265", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-500x768.jpeg", "", "Reduced by 8.4% (2.8 KB)", "31389", "34265", "", "10", "0", "1", "2021-01-01 15:31:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2616", "1265", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-1000x768.jpeg", "", "Reduced by 9.0% (5.7 KB)", "58906", "64706", "", "10", "0", "1", "2021-01-01 15:31:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2617", "1265", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-700x525.jpeg", "", "Reduced by 7.7% (2.5 KB)", "30355", "32891", "", "10", "0", "1", "2021-01-01 15:31:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2618", "1265", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-1-539x303.jpeg", "", "Reduced by 6.9% (1.3 KB)", "17799", "19111", "", "10", "0", "1", "2021-01-01 15:31:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2619", "1266", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2.jpeg", "", "Reduced by 1.3% (1.3 KB)", "102823", "104143", "", "10", "0", "1", "2021-01-01 15:31:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2620", "1266", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-300x225.jpeg", "", "Reduced by 8.0% (712 B)", "8157", "8869", "", "10", "0", "1", "2021-01-01 15:32:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2621", "1266", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-150x150.jpeg", "", "Reduced by 10.2% (407 B)", "3582", "3989", "", "10", "0", "1", "2021-01-01 15:32:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2622", "1266", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-768x576.jpeg", "", "Reduced by 8.2% (3.0 KB)", "34883", "37983", "", "10", "0", "1", "2021-01-01 15:32:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2623", "1266", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-570x570.jpeg", "", "Reduced by 8.0% (2.3 KB)", "26914", "29244", "", "10", "0", "1", "2021-01-01 15:32:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2624", "1266", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-600x768.jpeg", "", "Reduced by 8.4% (3.4 KB)", "37488", "40945", "", "10", "0", "1", "2021-01-01 15:32:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2625", "1266", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-800x600.jpeg", "", "Reduced by 8.4% (3.3 KB)", "37240", "40667", "", "10", "0", "1", "2021-01-01 15:32:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2626", "1266", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-345x198.jpeg", "", "Reduced by 8.5% (842 B)", "9022", "9864", "", "10", "0", "1", "2021-01-01 15:32:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2627", "1266", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-400x260.jpeg", "", "Reduced by 7.5% (958 B)", "11796", "12754", "", "10", "0", "1", "2021-01-01 15:32:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2628", "1266", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-500x380.jpeg", "", "Reduced by 8.1% (1.5 KB)", "17990", "19576", "", "10", "0", "1", "2021-01-01 15:32:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2629", "1266", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-500x500.jpeg", "", "Reduced by 7.9% (1.9 KB)", "21974", "23870", "", "10", "0", "1", "2021-01-01 15:32:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2630", "1266", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-1000x500.jpeg", "", "Reduced by 7.7% (3.6 KB)", "43926", "47595", "", "10", "0", "1", "2021-01-01 15:32:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2631", "1266", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-500x768.jpeg", "", "Reduced by 8.4% (2.8 KB)", "31389", "34265", "", "10", "0", "1", "2021-01-01 15:32:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2632", "1266", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-1000x768.jpeg", "", "Reduced by 9.0% (5.7 KB)", "58906", "64706", "", "10", "0", "1", "2021-01-01 15:32:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2633", "1266", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-700x525.jpeg", "", "Reduced by 7.7% (2.5 KB)", "30355", "32891", "", "10", "0", "1", "2021-01-01 15:32:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2634", "1266", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Sierra-Tan-Coping-Metal3-2-539x303.jpeg", "", "Reduced by 6.9% (1.3 KB)", "17799", "19111", "", "10", "0", "1", "2021-01-01 15:32:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2635", "1267", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1.jpeg", "", "Reduced by 1.3% (2.3 KB)", "181126", "183447", "", "10", "0", "1", "2021-01-01 15:32:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2636", "1267", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-281x300.jpeg", "", "Reduced by 8.1% (1.1 KB)", "13003", "14142", "", "10", "0", "1", "2021-01-01 15:32:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2637", "1267", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-150x150.jpeg", "", "Reduced by 9.6% (461 B)", "4323", "4784", "", "10", "0", "1", "2021-01-01 15:32:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2638", "1267", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-768x821.jpeg", "", "Reduced by 6.9% (5.6 KB)", "77938", "83672", "", "10", "0", "1", "2021-01-01 15:32:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2639", "1267", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-570x570.jpeg", "", "Reduced by 6.7% (3.2 KB)", "44725", "47958", "", "10", "0", "1", "2021-01-01 15:32:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2640", "1267", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-600x800.jpeg", "", "Reduced by 7.0% (4.3 KB)", "59072", "63499", "", "10", "0", "1", "2021-01-01 15:32:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2641", "1267", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-800x600.jpeg", "", "Reduced by 6.7% (4.3 KB)", "61304", "65726", "", "10", "0", "1", "2021-01-01 15:32:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2642", "1267", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-345x198.jpeg", "", "Reduced by 9.0% (1,003 B)", "10194", "11197", "", "10", "0", "1", "2021-01-01 15:32:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2643", "1267", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-400x260.jpeg", "", "Reduced by 8.2% (1.3 KB)", "15224", "16583", "", "10", "0", "1", "2021-01-01 15:32:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2644", "1267", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-500x380.jpeg", "", "Reduced by 7.3% (2.1 KB)", "27048", "29164", "", "10", "0", "1", "2021-01-01 15:32:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2645", "1267", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-500x500.jpeg", "", "Reduced by 7.3% (2.7 KB)", "35504", "38300", "", "10", "0", "1", "2021-01-01 15:32:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2646", "1267", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-857x500.jpeg", "", "Reduced by 8.4% (5.6 KB)", "62405", "68149", "", "10", "0", "1", "2021-01-01 15:32:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2647", "1267", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-500x916.jpeg", "", "Reduced by 7.9% (5.3 KB)", "63281", "68729", "", "10", "0", "1", "2021-01-01 15:32:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2648", "1267", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-700x748.jpeg", "", "Reduced by 6.7% (4.7 KB)", "66496", "71289", "", "10", "0", "1", "2021-01-01 15:32:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2649", "1267", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping-1-539x303.jpeg", "", "Reduced by 8.0% (1.8 KB)", "21887", "23780", "", "10", "0", "1", "2021-01-01 15:32:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2650", "1269", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1.jpeg", "", "Reduced by 5.8% (10.9 KB)", "181457", "192642", "", "10", "0", "1", "2021-01-01 15:32:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2651", "1269", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-300x225.jpeg", "", "Reduced by 6.0% (768 B)", "12097", "12865", "", "10", "0", "1", "2021-01-01 15:32:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2652", "1269", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-150x150.jpeg", "", "Reduced by 8.0% (412 B)", "4762", "5174", "", "10", "0", "1", "2021-01-01 15:32:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2653", "1269", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-768x576.jpeg", "", "Reduced by 5.6% (3.4 KB)", "58876", "62396", "", "10", "0", "1", "2021-01-01 15:32:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2654", "1269", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-570x570.jpeg", "", "Reduced by 5.6% (2.5 KB)", "43196", "45752", "", "10", "0", "1", "2021-01-01 15:32:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2655", "1269", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-600x768.jpeg", "", "Reduced by 6.5% (4.3 KB)", "63356", "67760", "", "10", "0", "1", "2021-01-01 15:32:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2656", "1269", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-800x600.jpeg", "", "Reduced by 5.8% (3.7 KB)", "62373", "66209", "", "10", "0", "1", "2021-01-01 15:32:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2657", "1269", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-345x198.jpeg", "", "Reduced by 6.8% (985 B)", "13597", "14582", "", "10", "0", "1", "2021-01-01 15:32:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2658", "1269", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-400x260.jpeg", "", "Reduced by 5.9% (1.1 KB)", "18173", "19307", "", "10", "0", "1", "2021-01-01 15:32:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2659", "1269", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-500x380.jpeg", "", "Reduced by 5.7% (1.7 KB)", "28473", "30187", "", "10", "0", "1", "2021-01-01 15:32:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2660", "1269", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-500x500.jpeg", "", "Reduced by 5.8% (2.1 KB)", "34525", "36644", "", "10", "0", "1", "2021-01-01 15:32:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2661", "1269", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-1000x500.jpeg", "", "Reduced by 5.5% (4.6 KB)", "80003", "84697", "", "10", "0", "1", "2021-01-01 15:32:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2662", "1269", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-500x768.jpeg", "", "Reduced by 6.5% (3.6 KB)", "53226", "56936", "", "10", "0", "1", "2021-01-01 15:32:27", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2663", "1269", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-1000x768.jpeg", "", "Reduced by 6.3% (7.0 KB)", "107560", "114736", "", "10", "0", "1", "2021-01-01 15:32:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2664", "1269", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-700x525.jpeg", "", "Reduced by 5.5% (2.9 KB)", "50106", "53031", "", "10", "0", "1", "2021-01-01 15:32:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2665", "1269", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-1-539x303.jpeg", "", "Reduced by 5.6% (1.7 KB)", "28867", "30593", "", "10", "0", "1", "2021-01-01 15:32:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2666", "1270", "media", "full", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2.jpeg", "", "Reduced by 5.8% (10.9 KB)", "181457", "192642", "", "10", "0", "1", "2021-01-01 15:32:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2667", "1270", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-300x225.jpeg", "", "Reduced by 6.0% (768 B)", "12097", "12865", "", "10", "0", "1", "2021-01-01 15:32:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2668", "1270", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-150x150.jpeg", "", "Reduced by 8.0% (412 B)", "4762", "5174", "", "10", "0", "1", "2021-01-01 15:32:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2669", "1270", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-768x576.jpeg", "", "Reduced by 5.6% (3.4 KB)", "58876", "62396", "", "10", "0", "1", "2021-01-01 15:32:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2670", "1270", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-570x570.jpeg", "", "Reduced by 5.6% (2.5 KB)", "43196", "45752", "", "10", "0", "1", "2021-01-01 15:32:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2671", "1270", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-600x768.jpeg", "", "Reduced by 6.5% (4.3 KB)", "63356", "67760", "", "10", "0", "1", "2021-01-01 15:32:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2672", "1270", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-800x600.jpeg", "", "Reduced by 5.8% (3.7 KB)", "62373", "66209", "", "10", "0", "1", "2021-01-01 15:32:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2673", "1270", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-345x198.jpeg", "", "Reduced by 6.8% (985 B)", "13597", "14582", "", "10", "0", "1", "2021-01-01 15:32:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2674", "1270", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-400x260.jpeg", "", "Reduced by 5.9% (1.1 KB)", "18173", "19307", "", "10", "0", "1", "2021-01-01 15:32:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2675", "1270", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-500x380.jpeg", "", "Reduced by 5.7% (1.7 KB)", "28473", "30187", "", "10", "0", "1", "2021-01-01 15:32:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2676", "1270", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-500x500.jpeg", "", "Reduced by 5.8% (2.1 KB)", "34525", "36644", "", "10", "0", "1", "2021-01-01 15:32:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2677", "1270", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-1000x500.jpeg", "", "Reduced by 5.5% (4.6 KB)", "80003", "84697", "", "10", "0", "1", "2021-01-01 15:32:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2678", "1270", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-500x768.jpeg", "", "Reduced by 6.5% (3.6 KB)", "53226", "56936", "", "10", "0", "1", "2021-01-01 15:32:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2679", "1270", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-1000x768.jpeg", "", "Reduced by 6.3% (7.0 KB)", "107560", "114736", "", "10", "0", "1", "2021-01-01 15:32:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2680", "1270", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-700x525.jpeg", "", "Reduced by 5.5% (2.9 KB)", "50106", "53031", "", "10", "0", "1", "2021-01-01 15:32:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2681", "1270", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Metal-Era-Weathered-Zinc-Permatite-Coping2-2-539x303.jpeg", "", "Reduced by 5.6% (1.7 KB)", "28867", "30593", "", "10", "0", "1", "2021-01-01 15:32:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2682", "1272", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2.jpg", "", "Reduced by 1.4% (7.2 KB)", "525677", "533059", "", "10", "0", "1", "2021-01-01 15:32:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2683", "1272", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-300x225.jpg", "", "Reduced by 7.1% (984 B)", "12953", "13937", "", "10", "0", "1", "2021-01-01 15:32:43", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2684", "1272", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-1024x768.jpg", "", "Reduced by 4.4% (4.7 KB)", "104432", "109219", "", "10", "0", "1", "2021-01-01 15:32:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2685", "1272", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-150x150.jpg", "", "Reduced by 9.6% (540 B)", "5080", "5620", "", "10", "0", "1", "2021-01-01 15:32:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2686", "1272", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-768x576.jpg", "", "Reduced by 5.0% (3.3 KB)", "63703", "67049", "", "10", "0", "1", "2021-01-01 15:32:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2687", "1272", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-1536x1152.jpg", "", "Reduced by 4.4% (9.3 KB)", "207460", "216955", "", "10", "0", "1", "2021-01-01 15:32:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2688", "1272", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-2048x1536.jpg", "", "Reduced by 4.9% (16.7 KB)", "334868", "351997", "", "10", "0", "1", "2021-01-01 15:32:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2689", "1272", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-570x570.jpg", "", "Reduced by 5.0% (2.4 KB)", "46887", "49342", "", "10", "0", "1", "2021-01-01 15:32:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2690", "1272", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-600x800.jpg", "", "Reduced by 4.6% (2.8 KB)", "60763", "63681", "", "10", "0", "1", "2021-01-01 15:32:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2691", "1272", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-800x600.jpg", "", "Reduced by 5.0% (3.5 KB)", "68270", "71863", "", "10", "0", "1", "2021-01-01 15:32:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2692", "1272", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-345x198.jpg", "", "Reduced by 7.9% (1.1 KB)", "13252", "14386", "", "10", "0", "1", "2021-01-01 15:32:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2693", "1272", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-400x260.jpg", "", "Reduced by 6.7% (1.3 KB)", "18624", "19963", "", "10", "0", "1", "2021-01-01 15:32:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2694", "1272", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-500x380.jpg", "", "Reduced by 5.5% (1.8 KB)", "31130", "32936", "", "10", "0", "1", "2021-01-01 15:32:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2695", "1272", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-500x500.jpg", "", "Reduced by 5.6% (2.2 KB)", "37434", "39648", "", "10", "0", "1", "2021-01-01 15:32:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2696", "1272", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-1000x500.jpg", "", "Reduced by 4.8% (3.4 KB)", "68812", "72276", "", "10", "0", "1", "2021-01-01 15:32:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2697", "1272", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-500x1000.jpg", "", "Reduced by 4.7% (2.8 KB)", "57996", "60888", "", "10", "0", "1", "2021-01-01 15:32:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2698", "1272", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-1000x1000.jpg", "", "Reduced by 4.4% (5.4 KB)", "120357", "125840", "", "10", "0", "1", "2021-01-01 15:32:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2699", "1272", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-700x525.jpg", "", "Reduced by 4.9% (2.8 KB)", "54695", "57536", "", "10", "0", "1", "2021-01-01 15:32:53", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2700", "1272", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal-scaled-2-539x303.jpg", "", "Reduced by 6.0% (1.7 KB)", "27290", "29038", "", "10", "0", "1", "2021-01-01 15:32:54", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2701", "1273", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1.jpg", "", "Reduced by 0.5% (3.5 KB)", "729048", "732637", "", "10", "0", "1", "2021-01-01 15:32:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2702", "1273", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-300x225.jpg", "", "Reduced by 6.4% (1,019 B)", "14953", "15972", "", "10", "0", "1", "2021-01-01 15:32:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2703", "1273", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-1024x768.jpg", "", "Reduced by 4.8% (6.8 KB)", "138919", "145851", "", "10", "0", "1", "2021-01-01 15:32:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2704", "1273", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-150x150.jpg", "", "Reduced by 8.6% (522 B)", "5513", "6035", "", "10", "0", "1", "2021-01-01 15:32:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2705", "1273", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-768x576.jpg", "", "Reduced by 5.0% (4.2 KB)", "82070", "86408", "", "10", "0", "1", "2021-01-01 15:32:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2706", "1273", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-1536x1152.jpg", "", "Reduced by 4.5% (13.0 KB)", "284121", "297395", "", "10", "0", "1", "2021-01-01 15:33:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2707", "1273", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-2048x1536.jpg", "", "Reduced by 4.5% (21.3 KB)", "459778", "481539", "", "10", "0", "1", "2021-01-01 15:33:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2708", "1273", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-570x570.jpg", "", "Reduced by 5.3% (3.4 KB)", "62540", "66014", "", "10", "0", "1", "2021-01-01 15:33:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2709", "1273", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-600x800.jpg", "", "Reduced by 5.4% (4.7 KB)", "85079", "89893", "", "10", "0", "1", "2021-01-01 15:33:03", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2710", "1273", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-800x600.jpg", "", "Reduced by 5.0% (4.5 KB)", "88477", "93135", "", "10", "0", "1", "2021-01-01 15:33:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2711", "1273", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-345x198.jpg", "", "Reduced by 6.9% (1.1 KB)", "14631", "15711", "", "10", "0", "1", "2021-01-01 15:33:04", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2712", "1273", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-400x260.jpg", "", "Reduced by 6.2% (1.4 KB)", "21692", "23134", "", "10", "0", "1", "2021-01-01 15:33:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2713", "1273", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-500x380.jpg", "", "Reduced by 5.7% (2.2 KB)", "38132", "40417", "", "10", "0", "1", "2021-01-01 15:33:05", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2714", "1273", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-500x500.jpg", "", "Reduced by 5.7% (2.9 KB)", "49050", "52015", "", "10", "0", "1", "2021-01-01 15:33:06", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2715", "1273", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-1000x500.jpg", "", "Reduced by 5.1% (4.6 KB)", "88369", "93098", "", "10", "0", "1", "2021-01-01 15:33:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2716", "1273", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-500x1000.jpg", "", "Reduced by 5.1% (4.4 KB)", "83608", "88145", "", "10", "0", "1", "2021-01-01 15:33:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2717", "1273", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-1000x1000.jpg", "", "Reduced by 4.8% (8.3 KB)", "169716", "178187", "", "10", "0", "1", "2021-01-01 15:33:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2718", "1273", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-700x525.jpg", "", "Reduced by 5.1% (3.7 KB)", "69653", "73412", "", "10", "0", "1", "2021-01-01 15:33:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2719", "1273", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-1-539x303.jpg", "", "Reduced by 5.8% (2.0 KB)", "32450", "34465", "", "10", "0", "1", "2021-01-01 15:33:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2720", "1274", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2.jpg", "", "Reduced by 0.5% (3.5 KB)", "729048", "732637", "", "10", "0", "1", "2021-01-01 15:33:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2721", "1274", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-300x225.jpg", "", "Reduced by 6.4% (1,019 B)", "14953", "15972", "", "10", "0", "1", "2021-01-01 15:33:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2722", "1274", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-1024x768.jpg", "", "Reduced by 4.8% (6.8 KB)", "138919", "145851", "", "10", "0", "1", "2021-01-01 15:33:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2723", "1274", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-150x150.jpg", "", "Reduced by 8.6% (522 B)", "5513", "6035", "", "10", "0", "1", "2021-01-01 15:33:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2724", "1274", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-768x576.jpg", "", "Reduced by 5.0% (4.2 KB)", "82070", "86408", "", "10", "0", "1", "2021-01-01 15:33:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2725", "1274", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-1536x1152.jpg", "", "Reduced by 4.5% (13.0 KB)", "284121", "297395", "", "10", "0", "1", "2021-01-01 15:33:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2726", "1274", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-2048x1536.jpg", "", "Reduced by 4.5% (21.3 KB)", "459778", "481539", "", "10", "0", "1", "2021-01-01 15:33:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2727", "1274", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-570x570.jpg", "", "Reduced by 5.3% (3.4 KB)", "62540", "66014", "", "10", "0", "1", "2021-01-01 15:33:18", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2728", "1274", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-600x800.jpg", "", "Reduced by 5.4% (4.7 KB)", "85079", "89893", "", "10", "0", "1", "2021-01-01 15:33:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2729", "1274", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-800x600.jpg", "", "Reduced by 5.0% (4.5 KB)", "88477", "93135", "", "10", "0", "1", "2021-01-01 15:33:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2730", "1274", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-345x198.jpg", "", "Reduced by 6.9% (1.1 KB)", "14631", "15711", "", "10", "0", "1", "2021-01-01 15:33:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2731", "1274", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-400x260.jpg", "", "Reduced by 6.2% (1.4 KB)", "21692", "23134", "", "10", "0", "1", "2021-01-01 15:33:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2732", "1274", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-500x380.jpg", "", "Reduced by 5.7% (2.2 KB)", "38132", "40417", "", "10", "0", "1", "2021-01-01 15:33:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2733", "1274", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-500x500.jpg", "", "Reduced by 5.7% (2.9 KB)", "49050", "52015", "", "10", "0", "1", "2021-01-01 15:33:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2734", "1274", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-1000x500.jpg", "", "Reduced by 5.1% (4.6 KB)", "88369", "93098", "", "10", "0", "1", "2021-01-01 15:33:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2735", "1274", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-500x1000.jpg", "", "Reduced by 5.1% (4.4 KB)", "83608", "88145", "", "10", "0", "1", "2021-01-01 15:33:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2736", "1274", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-1000x1000.jpg", "", "Reduced by 4.8% (8.3 KB)", "169716", "178187", "", "10", "0", "1", "2021-01-01 15:33:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2737", "1274", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-700x525.jpg", "", "Reduced by 5.1% (3.7 KB)", "69653", "73412", "", "10", "0", "1", "2021-01-01 15:33:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2738", "1274", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal2-scaled-2-539x303.jpg", "", "Reduced by 5.8% (2.0 KB)", "32450", "34465", "", "10", "0", "1", "2021-01-01 15:33:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2739", "1276", "media", "full", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2.jpg", "", "Reduced by 0.9% (6.4 KB)", "743448", "749995", "", "10", "0", "1", "2021-01-01 15:33:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2740", "1276", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-300x225.jpg", "", "Reduced by 6.1% (969 B)", "14920", "15889", "", "10", "0", "1", "2021-01-01 15:33:28", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2741", "1276", "media", "large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-1024x768.jpg", "", "Reduced by 5.3% (7.6 KB)", "138977", "146794", "", "10", "0", "1", "2021-01-01 15:33:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2742", "1276", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-150x150.jpg", "", "Reduced by 8.5% (521 B)", "5591", "6112", "", "10", "0", "1", "2021-01-01 15:33:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2743", "1276", "media", "medium_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-768x576.jpg", "", "Reduced by 5.4% (4.6 KB)", "81577", "86258", "", "10", "0", "1", "2021-01-01 15:33:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2744", "1276", "media", "1536x1536", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-1536x1152.jpg", "", "Reduced by 5.0% (14.7 KB)", "287440", "302462", "", "10", "0", "1", "2021-01-01 15:33:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2745", "1276", "media", "2048x2048", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-2048x1536.jpg", "", "Reduced by 4.7% (22.4 KB)", "468251", "491231", "", "10", "0", "1", "2021-01-01 15:33:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2746", "1276", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-570x570.jpg", "", "Reduced by 5.4% (3.4 KB)", "60712", "64190", "", "10", "0", "1", "2021-01-01 15:33:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2747", "1276", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-600x800.jpg", "", "Reduced by 5.6% (4.9 KB)", "84589", "89623", "", "10", "0", "1", "2021-01-01 15:33:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2748", "1276", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-800x600.jpg", "", "Reduced by 5.5% (5.0 KB)", "87961", "93060", "", "10", "0", "1", "2021-01-01 15:33:35", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2749", "1276", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-345x198.jpg", "", "Reduced by 6.2% (995 B)", "15047", "16042", "", "10", "0", "1", "2021-01-01 15:33:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2750", "1276", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-400x260.jpg", "", "Reduced by 5.5% (1.2 KB)", "21704", "22956", "", "10", "0", "1", "2021-01-01 15:33:36", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2751", "1276", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-500x380.jpg", "", "Reduced by 5.3% (2.1 KB)", "37723", "39836", "", "10", "0", "1", "2021-01-01 15:33:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2752", "1276", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-500x500.jpg", "", "Reduced by 5.5% (2.7 KB)", "47792", "50593", "", "10", "0", "1", "2021-01-01 15:33:37", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2753", "1276", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-1000x500.jpg", "", "Reduced by 5.7% (5.5 KB)", "92655", "98304", "", "10", "0", "1", "2021-01-01 15:33:38", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2754", "1276", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-500x1000.jpg", "", "Reduced by 5.4% (4.8 KB)", "86548", "91460", "", "10", "0", "1", "2021-01-01 15:33:39", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2755", "1276", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-1000x1000.jpg", "", "Reduced by 5.2% (8.9 KB)", "165710", "174836", "", "10", "0", "1", "2021-01-01 15:33:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2756", "1276", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-700x525.jpg", "", "Reduced by 5.4% (3.9 KB)", "69001", "72951", "", "10", "0", "1", "2021-01-01 15:33:40", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2757", "1276", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Pro-Panel-II-Charcoal-Metal3-scaled-2-539x303.jpg", "", "Reduced by 5.3% (1.8 KB)", "32868", "34704", "", "10", "0", "1", "2021-01-01 15:33:41", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2758", "1277", "media", "full", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg.jpg", "", "Reduced by 4.0% (3.8 KB)", "94782", "98694", "", "10", "0", "1", "2021-01-01 15:33:44", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2759", "1277", "media", "medium", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-300x140.jpg", "", "Reduced by 8.3% (443 B)", "4924", "5367", "", "10", "0", "1", "2021-01-01 15:33:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2760", "1277", "media", "large", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-1024x478.jpg", "", "Reduced by 7.2% (2.4 KB)", "31314", "33760", "", "10", "0", "1", "2021-01-01 15:33:45", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2761", "1277", "media", "thumbnail", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-150x150.jpg", "", "Reduced by 11.9% (393 B)", "2900", "3293", "", "10", "0", "1", "2021-01-01 15:33:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2762", "1277", "media", "medium_large", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-768x359.jpg", "", "Reduced by 7.1% (1.5 KB)", "20587", "22163", "", "10", "0", "1", "2021-01-01 15:33:46", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2763", "1277", "media", "1536x1536", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-1536x718.jpg", "", "Reduced by 8.9% (5.5 KB)", "57389", "63003", "", "10", "0", "1", "2021-01-01 15:33:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2764", "1277", "media", "portfolio-square", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-570x570.jpg", "", "Reduced by 7.6% (1.7 KB)", "21257", "23007", "", "10", "0", "1", "2021-01-01 15:33:47", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2765", "1277", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-600x800.jpg", "", "Reduced by 8.8% (2.5 KB)", "26881", "29482", "", "10", "0", "1", "2021-01-01 15:33:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2766", "1277", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-800x600.jpg", "", "Reduced by 7.8% (2.5 KB)", "29687", "32207", "", "10", "0", "1", "2021-01-01 15:33:48", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2767", "1277", "media", "menu-featured-post", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-345x198.jpg", "", "Reduced by 6.5% (513 B)", "7339", "7852", "", "10", "0", "1", "2021-01-01 15:33:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2768", "1277", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-400x260.jpg", "", "Reduced by 6.1% (640 B)", "9782", "10422", "", "10", "0", "1", "2021-01-01 15:33:49", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2769", "1277", "media", "portfolio_slider", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-500x380.jpg", "", "Reduced by 7.1% (1.1 KB)", "14931", "16074", "", "10", "0", "1", "2021-01-01 15:33:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2770", "1277", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-500x500.jpg", "", "Reduced by 7.8% (1.5 KB)", "17580", "19067", "", "10", "0", "1", "2021-01-01 15:33:50", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2771", "1277", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-1000x500.jpg", "", "Reduced by 7.8% (2.6 KB)", "31823", "34498", "", "10", "0", "1", "2021-01-01 15:33:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2772", "1277", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-500x897.jpg", "", "Reduced by 9.0% (2.4 KB)", "24634", "27066", "", "10", "0", "1", "2021-01-01 15:33:51", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2773", "1277", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-1000x897.jpg", "", "Reduced by 9.8% (5.0 KB)", "47372", "52508", "", "10", "0", "1", "2021-01-01 15:33:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2774", "1277", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-700x327.jpg", "", "Reduced by 7.1% (1.3 KB)", "17633", "18971", "", "10", "0", "1", "2021-01-01 15:33:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2775", "1277", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/revslider/Atlasroof/sliding-1-bg-539x303.jpg", "", "Reduced by 5.7% (850 B)", "13949", "14799", "", "10", "0", "1", "2021-01-01 15:33:52", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2776", "1278", "media", "full", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1.jpg", "", "Reduced by 1.0% (4.6 KB)", "458815", "463512", "", "10", "0", "1", "2021-01-01 15:33:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2777", "1278", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-225x300.jpg", "", "Reduced by 5.8% (780 B)", "12716", "13496", "", "10", "0", "1", "2021-01-01 15:33:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2778", "1278", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-150x150.jpg", "", "Reduced by 8.3% (480 B)", "5320", "5800", "", "10", "0", "1", "2021-01-01 15:33:55", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2779", "1278", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-570x570.jpg", "", "Reduced by 4.6% (2.2 KB)", "47608", "49904", "", "10", "0", "1", "2021-01-01 15:33:56", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2780", "1278", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-600x800.jpg", "", "Reduced by 4.6% (2.9 KB)", "61213", "64137", "", "10", "0", "1", "2021-01-01 15:33:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2781", "1278", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-768x600.jpg", "", "Reduced by 5.0% (3.3 KB)", "65322", "68745", "", "10", "0", "1", "2021-01-01 15:33:57", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2782", "1278", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-345x198.jpg", "", "Reduced by 5.4% (752 B)", "13076", "13828", "", "10", "0", "1", "2021-01-01 15:33:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2783", "1278", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-400x260.jpg", "", "Reduced by 4.7% (914 B)", "18331", "19245", "", "10", "0", "1", "2021-01-01 15:33:58", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2784", "1278", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-500x380.jpg", "", "Reduced by 4.8% (1.5 KB)", "30092", "31603", "", "10", "0", "1", "2021-01-01 15:33:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2785", "1278", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-500x500.jpg", "", "Reduced by 5.1% (2.0 KB)", "38587", "40646", "", "10", "0", "1", "2021-01-01 15:33:59", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2786", "1278", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-768x500.jpg", "", "Reduced by 4.8% (2.7 KB)", "54882", "57662", "", "10", "0", "1", "2021-01-01 15:34:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2787", "1278", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-500x1000.jpg", "", "Reduced by 5.1% (3.2 KB)", "61419", "64687", "", "10", "0", "1", "2021-01-01 15:34:00", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2788", "1278", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-768x1000.jpg", "", "Reduced by 5.0% (4.9 KB)", "96003", "101005", "", "10", "0", "1", "2021-01-01 15:34:01", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2789", "1278", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-700x933.jpg", "", "Reduced by 4.8% (3.8 KB)", "78540", "82476", "", "10", "0", "1", "2021-01-01 15:34:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2790", "1278", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal-1-539x303.jpg", "", "Reduced by 4.4% (1.2 KB)", "25590", "26771", "", "10", "0", "1", "2021-01-01 15:34:02", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2791", "1280", "media", "full", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner.jpg", "", "Reduced by 3.2% (6.1 KB)", "189199", "195464", "", "10", "0", "1", "2021-01-01 15:34:07", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2792", "1280", "media", "medium", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-300x140.jpg", "", "Reduced by 7.8% (680 B)", "8076", "8756", "", "10", "0", "1", "2021-01-01 15:34:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2793", "1280", "media", "large", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-1024x478.jpg", "", "Reduced by 5.6% (3.3 KB)", "57415", "60842", "", "10", "0", "1", "2021-01-01 15:34:08", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2794", "1280", "media", "thumbnail", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-150x150.jpg", "", "Reduced by 9.3% (498 B)", "4866", "5364", "", "10", "0", "1", "2021-01-01 15:34:09", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2795", "1280", "media", "medium_large", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-768x359.jpg", "", "Reduced by 5.7% (2.2 KB)", "36465", "38675", "", "10", "0", "1", "2021-01-01 15:34:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2796", "1280", "media", "1536x1536", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-1536x718.jpg", "", "Reduced by 5.4% (6.0 KB)", "108454", "114648", "", "10", "0", "1", "2021-01-01 15:34:10", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2797", "1280", "media", "portfolio-square", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-570x570.jpg", "", "Reduced by 5.2% (2.3 KB)", "42545", "44871", "", "10", "0", "1", "2021-01-01 15:34:11", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2798", "1280", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-600x800.jpg", "", "Reduced by 5.0% (2.9 KB)", "56468", "59432", "", "10", "0", "1", "2021-01-01 15:34:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2799", "1280", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-800x600.jpg", "", "Reduced by 5.3% (3.1 KB)", "57491", "60692", "", "10", "0", "1", "2021-01-01 15:34:12", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2800", "1280", "media", "menu-featured-post", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-345x198.jpg", "", "Reduced by 7.4% (959 B)", "12037", "12996", "", "10", "0", "1", "2021-01-01 15:34:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2801", "1280", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-400x260.jpg", "", "Reduced by 6.6% (1.2 KB)", "16785", "17969", "", "10", "0", "1", "2021-01-01 15:34:13", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2802", "1280", "media", "portfolio_slider", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-500x380.jpg", "", "Reduced by 5.8% (1.7 KB)", "27678", "29375", "", "10", "0", "1", "2021-01-01 15:34:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2803", "1280", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-500x500.jpg", "", "Reduced by 5.7% (2.0 KB)", "34314", "36372", "", "10", "0", "1", "2021-01-01 15:34:14", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2804", "1280", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-1000x500.jpg", "", "Reduced by 5.8% (3.5 KB)", "58666", "62254", "", "10", "0", "1", "2021-01-01 15:34:15", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2805", "1280", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-500x897.jpg", "", "Reduced by 5.6% (3.2 KB)", "56149", "59463", "", "10", "0", "1", "2021-01-01 15:34:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2806", "1280", "media", "portfolio_masonry_large", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-1000x897.jpg", "", "Reduced by 5.9% (6.3 KB)", "103866", "110345", "", "10", "0", "1", "2021-01-01 15:34:16", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2807", "1280", "media", "portfolio_masonry_with_space", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-700x327.jpg", "", "Reduced by 6.0% (1.9 KB)", "31243", "33228", "", "10", "0", "1", "2021-01-01 15:34:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2808", "1280", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/revslider/Atlasroof/slider-2-banner-539x303.jpg", "", "Reduced by 6.1% (1.5 KB)", "24010", "25583", "", "10", "0", "1", "2021-01-01 15:34:17", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2809", "1281", "media", "full", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1.jpg", "", "Reduced by 1.7% (3.8 KB)", "222095", "226030", "", "10", "0", "1", "2021-01-01 15:34:19", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2810", "1281", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-225x300.jpg", "", "Reduced by 5.9% (792 B)", "12657", "13449", "", "10", "0", "1", "2021-01-01 15:34:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2811", "1281", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-150x150.jpg", "", "Reduced by 7.8% (434 B)", "5164", "5598", "", "10", "0", "1", "2021-01-01 15:34:20", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2812", "1281", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-570x570.jpg", "", "Reduced by 4.2% (2.0 KB)", "47535", "49600", "", "10", "0", "1", "2021-01-01 15:34:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2813", "1281", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-600x800.jpg", "", "Reduced by 4.3% (2.7 KB)", "61726", "64521", "", "10", "0", "1", "2021-01-01 15:34:21", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2814", "1281", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-686x600.jpg", "", "Reduced by 4.4% (2.8 KB)", "62571", "65454", "", "10", "0", "1", "2021-01-01 15:34:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2815", "1281", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-345x198.jpg", "", "Reduced by 5.7% (805 B)", "13362", "14167", "", "10", "0", "1", "2021-01-01 15:34:22", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2816", "1281", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-400x260.jpg", "", "Reduced by 5.0% (1,006 B)", "18995", "20001", "", "10", "0", "1", "2021-01-01 15:34:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2817", "1281", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-500x380.jpg", "", "Reduced by 4.4% (1.4 KB)", "31282", "32706", "", "10", "0", "1", "2021-01-01 15:34:23", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2818", "1281", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-500x500.jpg", "", "Reduced by 4.4% (1.7 KB)", "38508", "40279", "", "10", "0", "1", "2021-01-01 15:34:24", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2819", "1281", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-686x500.jpg", "", "Reduced by 4.3% (2.3 KB)", "53726", "56126", "", "10", "0", "1", "2021-01-01 15:34:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2820", "1281", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-500x915.jpg", "", "Reduced by 5.1% (3.0 KB)", "58416", "61534", "", "10", "0", "1", "2021-01-01 15:34:25", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2821", "1281", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-1-539x303.jpg", "", "Reduced by 4.0% (1.1 KB)", "26797", "27926", "", "10", "0", "1", "2021-01-01 15:34:26", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2822", "1282", "media", "full", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2.jpg", "", "Reduced by 1.7% (3.8 KB)", "222095", "226030", "", "10", "0", "1", "2021-01-01 15:34:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2823", "1282", "media", "medium", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-225x300.jpg", "", "Reduced by 5.9% (792 B)", "12657", "13449", "", "10", "0", "1", "2021-01-01 15:34:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2824", "1282", "media", "thumbnail", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-150x150.jpg", "", "Reduced by 7.8% (434 B)", "5164", "5598", "", "10", "0", "1", "2021-01-01 15:34:29", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2825", "1282", "media", "portfolio-square", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-570x570.jpg", "", "Reduced by 4.2% (2.0 KB)", "47535", "49600", "", "10", "0", "1", "2021-01-01 15:34:30", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2826", "1282", "media", "portfolio-portrait", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-600x800.jpg", "", "Reduced by 4.3% (2.7 KB)", "61726", "64521", "", "10", "0", "1", "2021-01-01 15:34:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2827", "1282", "media", "portfolio-landscape", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-686x600.jpg", "", "Reduced by 4.4% (2.8 KB)", "62571", "65454", "", "10", "0", "1", "2021-01-01 15:34:31", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2828", "1282", "media", "menu-featured-post", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-345x198.jpg", "", "Reduced by 5.7% (805 B)", "13362", "14167", "", "10", "0", "1", "2021-01-01 15:34:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2829", "1282", "media", "qode-carousel_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-400x260.jpg", "", "Reduced by 5.0% (1,006 B)", "18995", "20001", "", "10", "0", "1", "2021-01-01 15:34:32", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2830", "1282", "media", "portfolio_slider", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-500x380.jpg", "", "Reduced by 4.4% (1.4 KB)", "31282", "32706", "", "10", "0", "1", "2021-01-01 15:34:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2831", "1282", "media", "portfolio_masonry_regular", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-500x500.jpg", "", "Reduced by 4.4% (1.7 KB)", "38508", "40279", "", "10", "0", "1", "2021-01-01 15:34:33", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2832", "1282", "media", "portfolio_masonry_wide", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-686x500.jpg", "", "Reduced by 4.3% (2.3 KB)", "53726", "56126", "", "10", "0", "1", "2021-01-01 15:34:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2833", "1282", "media", "portfolio_masonry_tall", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-500x915.jpg", "", "Reduced by 5.1% (3.0 KB)", "58416", "61534", "", "10", "0", "1", "2021-01-01 15:34:34", NULL);
INSERT INTO `wpev_ewwwio_images` VALUES("2834", "1282", "media", "latest_post_boxes", "ABSPATHwp-content/uploads/2020/12/Sheffield-Snaplock-Panel-Mansard-Brown-Metal2-2-539x303.jpg", "", "Reduced by 4.0% (1.1 KB)", "26797", "27926", "", "10", "0", "1", "2021-01-01 15:34:35", NULL);

/* INSERT TABLE DATA: wpev_options */
INSERT INTO `wpev_options` VALUES("1", "siteurl", "https://atlasroofs.com", "yes");
INSERT INTO `wpev_options` VALUES("2", "home", "https://atlasroofs.com", "yes");
INSERT INTO `wpev_options` VALUES("3", "blogname", "Atlas Roofing Co.", "yes");
INSERT INTO `wpev_options` VALUES("4", "blogdescription", "Excellence In Everything We Do!", "yes");
INSERT INTO `wpev_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpev_options` VALUES("6", "admin_email", "admin@atlasroofs.com", "yes");
INSERT INTO `wpev_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpev_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpev_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpev_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wpev_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wpev_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpev_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpev_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpev_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpev_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpev_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpev_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpev_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wpev_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wpev_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wpev_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpev_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wpev_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wpev_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wpev_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wpev_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `wpev_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wpev_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpev_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpev_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpev_options` VALUES("33", "active_plugins", "a:11:{i:1;s:25:\"duplicator/duplicator.php\";i:2;s:31:\"envato-market/envato-market.php\";i:3;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:5;s:27:\"maintenance/maintenance.php\";i:6;s:45:\"qode-instagram-widget/qode-instagram-feed.php\";i:7;s:39:\"qode-twitter-feed/qode-twitter-feed.php\";i:8;s:17:\"quform/quform.php\";i:9;s:23:\"revslider/revslider.php\";i:10;s:23:\"wordfence/wordfence.php\";i:11;s:24:\"wordpress-seo/wp-seo.php\";i:12;s:24:\"wpforms-lite/wpforms.php\";}", "yes");
INSERT INTO `wpev_options` VALUES("93411", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1628261100;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.4.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2083921\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2083921\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/ewww-image-optimizer\";s:4:\"slug\";s:20:\"ewww-image-optimizer\";s:6:\"plugin\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:11:\"new_version\";s:5:\"6.2.1\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/ewww-image-optimizer/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/ewww-image-optimizer/assets/icon-256x256.png?rev=1582276\";s:2:\"1x\";s:73:\"https://ps.w.org/ewww-image-optimizer/assets/icon-128x128.png?rev=1582276\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/ewww-image-optimizer/assets/banner-1544x500.jpg?rev=1582276\";s:2:\"1x\";s:75:\"https://ps.w.org/ewww-image-optimizer/assets/banner-772x250.jpg?rev=1582276\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.4\";}s:27:\"maintenance/maintenance.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/maintenance\";s:4:\"slug\";s:11:\"maintenance\";s:6:\"plugin\";s:27:\"maintenance/maintenance.php\";s:11:\"new_version\";s:4:\"4.03\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/maintenance/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/maintenance.4.03.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/maintenance/assets/icon-256x256.png?rev=2160987\";s:2:\"1x\";s:64:\"https://ps.w.org/maintenance/assets/icon-128x128.png?rev=2160987\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/maintenance/assets/banner-772x250.png?rev=1637471\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"7.5.4\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.7.5.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=2070855\";s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.6.8.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wpforms-lite.1.6.8.1.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:65:\"https://ps.w.org/wpforms-lite/assets/icon-256x256.png?rev=2574201\";s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=2574198\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=2574198\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"16.8\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.8.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=2363699\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1843435\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1843435\";}s:8:\"requires\";s:3:\"5.6\";}}s:7:\"checked\";a:13:{s:25:\"duplicator/duplicator.php\";s:5:\"1.4.2\";s:31:\"envato-market/envato-market.php\";s:5:\"2.0.6\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:5:\"6.2.1\";s:27:\"LayerSlider/layerslider.php\";s:5:\"6.7.1\";s:27:\"maintenance/maintenance.php\";s:4:\"4.03\";s:45:\"qode-instagram-widget/qode-instagram-feed.php\";s:5:\"1.2.1\";s:39:\"qode-twitter-feed/qode-twitter-feed.php\";s:3:\"1.1\";s:17:\"quform/quform.php\";s:5:\"2.4.1\";s:23:\"revslider/revslider.php\";s:7:\"5.4.7.3\";s:23:\"wordfence/wordfence.php\";s:5:\"7.5.4\";s:27:\"js_composer/js_composer.php\";s:5:\"5.4.7\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.6.8.1\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"16.8\";}}", "no");
INSERT INTO `wpev_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpev_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wpev_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpev_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpev_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpev_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wpev_options` VALUES("40", "template", "bridge", "yes");
INSERT INTO `wpev_options` VALUES("41", "stylesheet", "bridge", "yes");
INSERT INTO `wpev_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wpev_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wpev_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wpev_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wpev_options` VALUES("46", "db_version", "49752", "yes");
INSERT INTO `wpev_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpev_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wpev_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wpev_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wpev_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wpev_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wpev_options` VALUES("53", "show_avatars", "", "yes");
INSERT INTO `wpev_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wpev_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wpev_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpev_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpev_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wpev_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wpev_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wpev_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wpev_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wpev_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wpev_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wpev_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wpev_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wpev_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wpev_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wpev_options` VALUES("69", "thread_comments", "", "yes");
INSERT INTO `wpev_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wpev_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wpev_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wpev_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wpev_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wpev_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpev_options` VALUES("76", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("77", "widget_text", "a:6:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:172:\"<div class=\"top-text\"><i class=\"fa fa-phone\"></i>&nbsp;&nbsp;970.484.7777 <span class=\"line\">|</span><i class=\"fa fa-envelope-o\"></i>&nbsp;&nbsp;office@atlasroofs.com</div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:392:\"<img class=\"alignnone wp-image-344\" src=\"https://atlasroofs.com/wp-content/uploads/2020/03/atlas-logo-white-300x75.png\" alt=\"\" width=\"208\" height=\"50\" />\r\n<p style=\"padding-top: 12px; padding-bottom: 12px;\">Building for the Elements Since 1985</p>\r\n&nbsp;\r\n\r\n<img class=\"alignnone wp-image-411\" src=\"https://atlasroofs.com/wp-content/uploads/2020/03/bbb.gif\" alt=\"\" width=\"125\" height=\"37\" />\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:17:\"Review & Feedback\";s:4:\"text\";s:800:\"&nbsp;\r\n\r\nEnjoy your Experience? Leave us a Review by clicking on a link below!\r\n\r\n<a href=\"https://www.bbb.org/wyoming-and-northern-colorado/customer-reviews/roofing-contractors/atlas-roofing-co-in-loveland-co-46003551/add/\" target=\"_blank\" rel=\"nofollow noopener\"><img style=\"border: 0;\" src=\"https://seal-wynco.bbb.org/customer-reviews/badge-7-bbb-46003551.png\" alt=\"Atlas Roofing Co. BBB Business Review\" /></a><a href=\"https://www.google.com/search?q=Atlas+Roofing+Company+LLC&amp;oq=Atlas+Roofing+Company+LLC&amp;aqs=chrome..69i57j69i59j69i61l3&amp;sourceid=chrome&amp;ie=UTF-8#lrd=0x87694b7d094c87af:0xa9789e6b326bd740,1,,\"><img class=\"alignnone wp-image-1066\" src=\"https://atlasroofs.com/wp-content/uploads/2020/10/googlereviewicon-300x145.png\" alt=\"\" width=\"118\" height=\"57\" /></a>\r\n\r\n&nbsp;\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:5;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:79:\"©Atlas Roofing Co. -  All Right Reserved 2020 |  <a href=\"#\">Privacy info</a>.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("79", "uninstall_plugins", "a:2:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";}", "no");
INSERT INTO `wpev_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wpev_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wpev_options` VALUES("82", "page_on_front", "1222", "yes");
INSERT INTO `wpev_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wpev_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wpev_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpev_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wpev_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wpev_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wpev_options` VALUES("89", "wpev_page_for_privacy_policy", "3", "yes");
INSERT INTO `wpev_options` VALUES("90", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `wpev_options` VALUES("91", "admin_email_lifespan", "1643239229", "yes");
INSERT INTO `wpev_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wpev_options` VALUES("93", "comment_previously_approved", "", "yes");
INSERT INTO `wpev_options` VALUES("94", "auto_plugin_theme_update_emails", "a:1:{s:27:\"LayerSlider/layerslider.php\";s:6:\"6.11.8\";}", "no");
INSERT INTO `wpev_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wpev_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wpev_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wpev_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `wpev_options` VALUES("99", "wpev_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:80:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"quform_full_access\";b:1;s:21:\"quform_view_dashboard\";b:1;s:17:\"quform_list_forms\";b:1;s:16:\"quform_add_forms\";b:1;s:17:\"quform_edit_forms\";b:1;s:19:\"quform_delete_forms\";b:1;s:19:\"quform_view_entries\";b:1;s:19:\"quform_edit_entries\";b:1;s:21:\"quform_delete_entries\";b:1;s:17:\"quform_view_tools\";b:1;s:21:\"quform_export_entries\";b:1;s:19:\"quform_export_forms\";b:1;s:19:\"quform_import_forms\";b:1;s:15:\"quform_settings\";b:1;s:11:\"quform_help\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wpev_options` VALUES("100", "fresh_site", "0", "yes");
INSERT INTO `wpev_options` VALUES("101", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("102", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("103", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("104", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("105", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("106", "sidebars_widgets", "a:20:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:12:\"sidebar_page\";a:2:{i:0;s:13:\"custom_html-7\";i:1;s:13:\"custom_html-2\";}s:11:\"header_left\";a:0:{}s:12:\"header_right\";a:1:{i:0;s:6:\"text-2\";}s:19:\"header_bottom_right\";a:0:{}s:20:\"header_bottom_center\";a:0:{}s:8:\"sidearea\";a:3:{i:0;s:13:\"custom_html-6\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-5\";}s:27:\"fullscreen_menu_area_widget\";a:0:{}s:18:\"vertical_menu_area\";a:0:{}s:15:\"footer_column_1\";a:1:{i:0;s:6:\"text-3\";}s:15:\"footer_column_2\";a:1:{i:0;s:13:\"custom_html-4\";}s:15:\"footer_column_3\";a:1:{i:0;s:10:\"nav_menu-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:6:\"text-4\";}s:11:\"footer_text\";a:1:{i:0;s:6:\"text-5\";}s:16:\"footer_text_left\";a:0:{}s:17:\"footer_text_right\";a:0:{}s:18:\"header_fixed_right\";a:0:{}s:15:\"left_side_fixed\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wpev_options` VALUES("107", "cron", "a:19:{i:1628276346;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1628278705;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1628278713;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1628279092;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1628304288;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628309444;a:2:{s:21:\"quform_upload_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"quform_session_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628313805;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628347488;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628347500;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628347501;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628347784;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628350713;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628352925;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628517600;a:1:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"wpforms_email_summaries_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1628524800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1628525400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"9247cad30454e406573b96d473fbcfed\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1628525400;}}}}i:1628784600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"48ea00badbd7cd8cdd60a7570c867ce8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1628784600;}}}}i:1628866185;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpev_options` VALUES("26059", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wpev_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("115", "widget_nav_menu", "a:2:{i:3;a:2:{s:5:\"title\";s:8:\"Services\";s:8:\"nav_menu\";i:19;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("116", "widget_custom_html", "a:7:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:95:\"<a class=\"request-btn\" href=\"https://atlasroofs.com/request-inspection/\">Request Inspection</a>\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:509:\"<div class=\"callus-layout\">\r\n<h4 style=\"text-align: center; color: #61043b; padding-bottom: 20px;\">Request a Call Back</h4>\r\n<p style=\"text-align: center; color: #61043b; padding-bottom: 20px;font-weight:400;font-size:15px;\">Let us call you!  Give us a little info below and we will call you to discuss your next roofing project.</p>\r\n\r\n<h4 style=\"text-align: center; color: #61043b; padding-bottom: 35px;\"><a class=\"r-i\" href=\"https://atlasroofs.com/request-inspection/\">REQUEST INSPECTION</a></h4>\r\n\r\n</div>\";}i:4;a:2:{s:5:\"title\";s:16:\"Contact our team\";s:7:\"content\";s:406:\"[vc_separator type=\"transparent\" thickness=\"0\" up=\"20\" down=\"0\"]\r\n<p><i class=\"fa fa-map-marker\"></i>&nbsp;&nbsp;&nbsp;506 West 66th Street<br>Loveland, CO 80538\r\n</p>\r\n<p><i class=\"fa fa-phone\"></i>&nbsp;&nbsp;&nbsp;<a href=\"tel:9704847777\">970.484.7777</a></p>\r\n<p><i class=\"fa fa-envelope\"></i>&nbsp;&nbsp;&nbsp;office@atlasroofs.com</p>\r\n[vc_separator type=\"transparent\" thickness=\"0\" up=\"20\" down=\"0\"]\";}i:5;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:492:\"<p style=\"text-align: center;\"><a href=\"https://atlasroofs.com/resources/\"><img class=\"wp-image-1118 aligncenter\" src=\"https://atlasroofs.com/wp-content/uploads/2020/10/recomonded-brands-300x279.jpg\" alt=\"\" width=\"189\" height=\"176\" /></a></p>\r\n<p style=\"text-align: center; color: #61043b;\">Atlas is a Certified Applicator for Carlisle and Durolast and Owens Corning!</p>\r\n\r\n<h6 style=\"text-align: center;\"><span style=\"color: ##61043b;\"><strong>Call us for more details.</strong></span></h6>\";}i:6;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:11:\"&nbsp; <br>\";}i:7;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:676:\"<h3 class=\"has-text-align-center\" style=\"text-align: center;\"><span style=\"color: #ffffff;\"><strong><a style=\"color: #ffffff;\" href=\"https://atlasroofs.com/residential-roofing/\">Residential Roofing</a></strong></span></h3>\r\n<h3 class=\"has-text-align-center\" style=\"text-align: center;\"><span style=\"color: #ffffff;\"><strong>\r\n<a style=\"color: #ffffff;\" href=\"https://atlasroofs.com/commercial-roofing/\">Commercial Roofing</a></strong></span></h3>\r\n<h3 class=\"has-text-align-center\" style=\"text-align: center;\"><span style=\"color: #ffffff;\"><strong>\r\n<a style=\"color: #ffffff;\" href=\"https://atlasroofs.com/repair-maintenance/\">Repair &amp; Maintenance</a></strong></span></h3>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("118", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wpev_options` VALUES("119", "theme_mods_twentytwentyone", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1626967904;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:11:{i:0;s:13:\"custom_html-7\";i:1;s:6:\"text-2\";i:2;s:13:\"custom_html-2\";i:3;s:13:\"custom_html-6\";i:4;s:13:\"custom_html-3\";i:5;s:13:\"custom_html-5\";i:6;s:6:\"text-3\";i:7;s:13:\"custom_html-4\";i:8;s:10:\"nav_menu-3\";i:9;s:6:\"text-4\";i:10;s:6:\"text-5\";}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:0:{}}}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:16;}}", "yes");
INSERT INTO `wpev_options` VALUES("125", "loginizer_2fa_whitelist", "a:0:{}", "yes");
INSERT INTO `wpev_options` VALUES("126", "loginizer_ins_time", "1609512292", "yes");
INSERT INTO `wpev_options` VALUES("127", "loginizer_promo_time", "-1614309943", "yes");
INSERT INTO `wpev_options` VALUES("255", "action_scheduler_lock_async-request-runner", "1628276373", "yes");
INSERT INTO `wpev_options` VALUES("256", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `wpev_options` VALUES("257", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("258", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("259", "vc_version", "5.4.7", "yes");
INSERT INTO `wpev_options` VALUES("22992", "ewww_image_optimizer_wizard_complete", "1", "no");
INSERT INTO `wpev_options` VALUES("166", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:4;}", "yes");
INSERT INTO `wpev_options` VALUES("152", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wpev_options` VALUES("141", "can_compress_scripts", "0", "no");
INSERT INTO `wpev_options` VALUES("167", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wpev_options` VALUES("168", "duplicator_version_plugin", "1.4.2", "yes");
INSERT INTO `wpev_options` VALUES("169", "wpseh_l01gnhdlwp", "?atlasadmin", "yes");
INSERT INTO `wpev_options` VALUES("170", "envato_market", "a:2:{s:16:\"is_plugin_active\";s:1:\"1\";s:17:\"installed_version\";s:5:\"2.0.3\";}", "yes");
INSERT INTO `wpev_options` VALUES("171", "ewww_image_optimizer_relative_migration_status", "done", "yes");
INSERT INTO `wpev_options` VALUES("172", "ls-plugin-version", "6.7.1", "yes");
INSERT INTO `wpev_options` VALUES("173", "ls-db-version", "6.5.5", "yes");
INSERT INTO `wpev_options` VALUES("174", "ls-installed", "1", "yes");
INSERT INTO `wpev_options` VALUES("175", "ls-date-installed", "1609512548", "yes");
INSERT INTO `wpev_options` VALUES("197", "ewww_image_optimizer_background_optimization", "1", "yes");
INSERT INTO `wpev_options` VALUES("178", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:16:\"themepunch.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wpev_options` VALUES("185", "widget_layerslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("186", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("179", "revslider_server_refresh", "1628176102", "yes");
INSERT INTO `wpev_options` VALUES("180", "revslider-update-check-short", "1628194723", "yes");
INSERT INTO `wpev_options` VALUES("181", "revslider-templates-check", "1628005493", "yes");
INSERT INTO `wpev_options` VALUES("153", "recently_activated", "a:1:{s:27:\"LayerSlider/layerslider.php\";i:1627687524;}", "yes");
INSERT INTO `wpev_options` VALUES("154", "maintenance_meta", "a:3:{s:13:\"first_version\";s:3:\"3.8\";s:13:\"first_install\";i:1609512499;s:11:\"old_version\";b:0;}", "yes");
INSERT INTO `wpev_options` VALUES("155", "mtnc_db_version", "2", "yes");
INSERT INTO `wpev_options` VALUES("156", "maintenance_options", "a:24:{s:10:\"page_title\";s:30:\"Site is undergoing maintenance\";s:7:\"heading\";s:22:\"Maintenance mode is on\";s:11:\"description\";s:57:\"Site will be available soon. Thank you for your patience!\";s:11:\"footer_text\";s:15:\"© My Blog 2021\";s:10:\"logo_width\";s:3:\"220\";s:11:\"logo_height\";s:0:\"\";s:4:\"logo\";s:1:\"0\";s:11:\"retina_logo\";s:1:\"0\";s:7:\"body_bg\";s:1:\"5\";s:17:\"bg_image_portrait\";s:1:\"0\";s:13:\"preloader_img\";s:1:\"0\";s:13:\"body_bg_color\";s:7:\"#111111\";s:10:\"font_color\";s:7:\"#ffffff\";s:17:\"controls_bg_color\";s:7:\"#111111\";s:16:\"body_font_family\";s:9:\"Open Sans\";s:16:\"body_font_subset\";s:3:\"300\";s:15:\"gg_analytics_id\";s:0:\"\";s:14:\"blur_intensity\";s:1:\"5\";s:8:\"is_login\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:5:\"state\";i:0;s:2:\"ID\";i:0;s:6:\"filter\";s:2:\"db\";s:16:\"default_settings\";b:0;}", "yes");
INSERT INTO `wpev_options` VALUES("163", "A2_Optimized_Plugin__version", "2.0.11.1.1", "yes");
INSERT INTO `wpev_options` VALUES("164", "A2_Optimized_Plugin__installed", "1", "yes");
INSERT INTO `wpev_options` VALUES("301", "wpforms_email_summaries_fetch_info_blocks_last_run", "1628176167", "yes");
INSERT INTO `wpev_options` VALUES("187", "widget_qode_instagram_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("188", "widget_qode_twitter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("189", "widget_quform-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("190", "widget_quform-popup-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("191", "quform_version", "2.4.1", "yes");
INSERT INTO `wpev_options` VALUES("192", "quform_options", "a:50:{s:19:\"defaultEmailAddress\";s:21:\"office@atlasroofs.com\";s:16:\"defaultEmailName\";s:0:\"\";s:23:\"defaultFromEmailAddress\";s:21:\"office@atlasroofs.com\";s:20:\"defaultFromEmailName\";s:11:\"Atlas Roofs\";s:10:\"licenseKey\";s:0:\"\";s:6:\"locale\";s:5:\"en-US\";s:12:\"dateFormatJs\";s:0:\"\";s:12:\"timeFormatJs\";s:0:\"\";s:10:\"dateFormat\";s:0:\"\";s:10:\"timeFormat\";s:0:\"\";s:3:\"rtl\";s:0:\"\";s:16:\"recaptchaSiteKey\";s:40:\"6Ld5wIsaAAAAAPyKGcjwunKgcUFvefYRHX2mTAZn\";s:18:\"recaptchaSecretKey\";s:40:\"6Ld5wIsaAAAAAJHOQ-SigXKgfzu7QJJnxHoR-rZ9\";s:9:\"customCss\";s:0:\"\";s:15:\"customCssTablet\";s:0:\"\";s:14:\"customCssPhone\";s:0:\"\";s:8:\"customJs\";s:0:\"\";s:11:\"loadScripts\";s:6:\"always\";s:17:\"loadScriptsCustom\";a:0:{}s:14:\"disabledStyles\";a:6:{s:11:\"fontAwesome\";b:0;s:7:\"select2\";b:0;s:4:\"qtip\";b:0;s:8:\"fancybox\";b:0;s:9:\"fancybox2\";b:0;s:13:\"magnificPopup\";b:0;}s:15:\"disabledScripts\";a:10:{s:10:\"fileUpload\";b:0;s:8:\"scrollTo\";b:0;s:7:\"select2\";b:0;s:4:\"qtip\";b:0;s:8:\"fancybox\";b:0;s:9:\"fancybox2\";b:0;s:13:\"magnificPopup\";b:0;s:13:\"infieldLabels\";b:0;s:10:\"datepicker\";b:0;s:10:\"timepicker\";b:0;}s:10:\"combineCss\";b:1;s:9:\"combineJs\";b:1;s:12:\"popupEnabled\";b:0;s:11:\"popupScript\";s:10:\"fancybox-2\";s:6:\"rawFix\";b:0;s:12:\"scrollOffset\";s:2:\"50\";s:11:\"scrollSpeed\";s:3:\"800\";s:17:\"allowAllFileTypes\";b:0;s:12:\"showEditLink\";b:1;s:14:\"csrfProtection\";b:1;s:18:\"supportPageCaching\";b:1;s:11:\"toolbarMenu\";b:1;s:15:\"dashboardWidget\";b:1;s:16:\"insertFormButton\";b:1;s:11:\"preventFouc\";b:0;s:17:\"secureApiRequests\";b:1;s:15:\"saveIpAddresses\";b:1;s:15:\"referralEnabled\";b:0;s:12:\"referralText\";s:17:\"Powered by Quform\";s:16:\"referralUsername\";s:0:\"\";s:12:\"activeThemes\";a:0:{}s:13:\"activeLocales\";a:0:{}s:17:\"activeDatepickers\";a:0:{}s:17:\"activeTimepickers\";a:0:{}s:23:\"activeEnhancedUploaders\";a:0:{}s:21:\"activeEnhancedSelects\";a:0:{}s:15:\"activeCustomCss\";a:1:{i:1;b:1;}s:17:\"inactiveCustomCss\";a:0:{}s:11:\"cacheBuster\";i:1617077448;}", "yes");
INSERT INTO `wpev_options` VALUES("196", "envato_market_state", "activated", "yes");
INSERT INTO `wpev_options` VALUES("195", "revslider-library-check", "1628266204", "yes");
INSERT INTO `wpev_options` VALUES("200", "ewww_image_optimizer_debug", "", "yes");
INSERT INTO `wpev_options` VALUES("201", "ewww_image_optimizer_metadata_remove", "1", "yes");
INSERT INTO `wpev_options` VALUES("202", "rs-library", "a:3:{s:4:\"hash\";s:32:\"0fbedf953c0042911e0f27a364cf4227\";s:7:\"objects\";a:179:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wpev_options` VALUES("203", "ewww_image_optimizer_jpg_level", "10", "yes");
INSERT INTO `wpev_options` VALUES("204", "ewww_image_optimizer_png_level", "0", "yes");
INSERT INTO `wpev_options` VALUES("205", "revslider_checktables", "1", "yes");
INSERT INTO `wpev_options` VALUES("206", "ewww_image_optimizer_gif_level", "0", "yes");
INSERT INTO `wpev_options` VALUES("207", "ewww_image_optimizer_pdf_level", "0", "yes");
INSERT INTO `wpev_options` VALUES("208", "ewww_image_optimizer_svg_level", "0", "yes");
INSERT INTO `wpev_options` VALUES("209", "ewww_image_optimizer_jpg_quality", "", "yes");
INSERT INTO `wpev_options` VALUES("210", "ewww_image_optimizer_webp_quality", "", "yes");
INSERT INTO `wpev_options` VALUES("211", "ewww_image_optimizer_exactdn", "", "yes");
INSERT INTO `wpev_options` VALUES("212", "ewww_image_optimizer_exactdn_plan_id", "0", "yes");
INSERT INTO `wpev_options` VALUES("213", "exactdn_all_the_things", "1", "yes");
INSERT INTO `wpev_options` VALUES("214", "exactdn_lossy", "1", "yes");
INSERT INTO `wpev_options` VALUES("215", "exactdn_exclude", "", "yes");
INSERT INTO `wpev_options` VALUES("216", "ewww_image_optimizer_lazy_load", "", "yes");
INSERT INTO `wpev_options` VALUES("217", "ewww_image_optimizer_ll_exclude", "", "yes");
INSERT INTO `wpev_options` VALUES("218", "ewww_image_optimizer_disable_pngout", "1", "yes");
INSERT INTO `wpev_options` VALUES("219", "ewww_image_optimizer_disable_svgcleaner", "1", "yes");
INSERT INTO `wpev_options` VALUES("220", "ewww_image_optimizer_optipng_level", "2", "yes");
INSERT INTO `wpev_options` VALUES("221", "ewww_image_optimizer_pngout_level", "2", "yes");
INSERT INTO `wpev_options` VALUES("222", "ewww_image_optimizer_webp_for_cdn", "", "yes");
INSERT INTO `wpev_options` VALUES("223", "ewww_image_optimizer_force_gif2webp", "1", "yes");
INSERT INTO `wpev_options` VALUES("224", "ewww_image_optimizer_picture_webp", "", "yes");
INSERT INTO `wpev_options` VALUES("225", "ewww_image_optimizer_webp_rewrite_exclude", "", "yes");
INSERT INTO `wpev_options` VALUES("226", "exactdn_never_been_active", "1", "no");
INSERT INTO `wpev_options` VALUES("227", "ewww_image_optimizer_bulk_resume", "", "yes");
INSERT INTO `wpev_options` VALUES("228", "ewww_image_optimizer_aux_resume", "", "yes");
INSERT INTO `wpev_options` VALUES("229", "ewww_image_optimizer_flag_attachments", "", "no");
INSERT INTO `wpev_options` VALUES("230", "ewww_image_optimizer_ngg_attachments", "", "no");
INSERT INTO `wpev_options` VALUES("231", "ewww_image_optimizer_review_time", "1610117371", "no");
INSERT INTO `wpev_options` VALUES("232", "ewww_image_optimizer_version", "621", "yes");
INSERT INTO `wpev_options` VALUES("276", "wpforms_review", "a:2:{s:4:\"time\";i:1609512597;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wpev_options` VALUES("237", "rs_tables_created", "1", "yes");
INSERT INTO `wpev_options` VALUES("238", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `wpev_options` VALUES("239", "revslider-global-settings", "a:0:{}", "yes");
INSERT INTO `wpev_options` VALUES("242", "action_scheduler_hybrid_store_demarkation", "6", "yes");
INSERT INTO `wpev_options` VALUES("243", "schema-ActionScheduler_StoreSchema", "3.0.1609512576", "yes");
INSERT INTO `wpev_options` VALUES("244", "schema-ActionScheduler_LoggerSchema", "2.0.1609512576", "yes");
INSERT INTO `wpev_options` VALUES("245", "wpforms_version", "1.6.5", "yes");
INSERT INTO `wpev_options` VALUES("246", "wpforms_version_lite", "1.6.5", "yes");
INSERT INTO `wpev_options` VALUES("247", "wpforms_activated", "a:1:{s:4:\"lite\";i:1609512577;}", "yes");
INSERT INTO `wpev_options` VALUES("250", "wpseo", "a:45:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:13:\"first_install\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:4:\"16.8\";s:16:\"previous_version\";s:4:\"16.4\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1609512585;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:22:\"https://atlasroofs.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:6:{s:18:\"portfolio_category\";s:18:\"portfolio-category\";s:13:\"portfolio_tag\";s:13:\"portfolio-tag\";s:21:\"testimonials_category\";s:21:\"testimonials-category\";s:15:\"slides_category\";s:15:\"slides-category\";s:18:\"carousels_category\";s:18:\"carousels-category\";s:24:\"masonry_gallery_category\";s:24:\"masonry-gallery-category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;}", "yes");
INSERT INTO `wpev_options` VALUES("251", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"16.8\";}", "yes");
INSERT INTO `wpev_options` VALUES("252", "wpseo_titles", "a:180:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:20:\"title-portfolio_page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-portfolio_page\";s:0:\"\";s:22:\"noindex-portfolio_page\";b:0;s:33:\"display-metabox-pt-portfolio_page\";b:1;s:33:\"post_types-portfolio_page-maintax\";i:0;s:31:\"schema-page-type-portfolio_page\";s:7:\"WebPage\";s:34:\"schema-article-type-portfolio_page\";s:4:\"None\";s:27:\"social-title-portfolio_page\";s:9:\"%%title%%\";s:33:\"social-description-portfolio_page\";s:0:\"\";s:31:\"social-image-url-portfolio_page\";s:0:\"\";s:30:\"social-image-id-portfolio_page\";i:0;s:30:\"title-ptarchive-portfolio_page\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-ptarchive-portfolio_page\";s:0:\"\";s:32:\"bctitle-ptarchive-portfolio_page\";s:0:\"\";s:32:\"noindex-ptarchive-portfolio_page\";b:0;s:37:\"social-title-ptarchive-portfolio_page\";s:21:\"%%pt_plural%% Archive\";s:43:\"social-description-ptarchive-portfolio_page\";s:0:\"\";s:41:\"social-image-url-ptarchive-portfolio_page\";s:0:\"\";s:40:\"social-image-id-ptarchive-portfolio_page\";i:0;s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:38:\"display-metabox-tax-portfolio_category\";b:1;s:30:\"noindex-tax-portfolio_category\";b:0;s:35:\"social-title-tax-portfolio_category\";s:23:\"%%term_title%% Archives\";s:41:\"social-description-tax-portfolio_category\";s:0:\"\";s:39:\"social-image-url-tax-portfolio_category\";s:0:\"\";s:38:\"social-image-id-tax-portfolio_category\";i:0;s:36:\"taxonomy-portfolio_category-ptparent\";i:0;s:23:\"title-tax-portfolio_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-portfolio_tag\";s:0:\"\";s:33:\"display-metabox-tax-portfolio_tag\";b:1;s:25:\"noindex-tax-portfolio_tag\";b:0;s:30:\"social-title-tax-portfolio_tag\";s:23:\"%%term_title%% Archives\";s:36:\"social-description-tax-portfolio_tag\";s:0:\"\";s:34:\"social-image-url-tax-portfolio_tag\";s:0:\"\";s:33:\"social-image-id-tax-portfolio_tag\";i:0;s:31:\"taxonomy-portfolio_tag-ptparent\";i:0;s:31:\"title-tax-testimonials_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-tax-testimonials_category\";s:0:\"\";s:41:\"display-metabox-tax-testimonials_category\";b:1;s:33:\"noindex-tax-testimonials_category\";b:0;s:38:\"social-title-tax-testimonials_category\";s:23:\"%%term_title%% Archives\";s:44:\"social-description-tax-testimonials_category\";s:0:\"\";s:42:\"social-image-url-tax-testimonials_category\";s:0:\"\";s:41:\"social-image-id-tax-testimonials_category\";i:0;s:39:\"taxonomy-testimonials_category-ptparent\";i:0;s:25:\"title-tax-slides_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-slides_category\";s:0:\"\";s:35:\"display-metabox-tax-slides_category\";b:1;s:27:\"noindex-tax-slides_category\";b:0;s:32:\"social-title-tax-slides_category\";s:23:\"%%term_title%% Archives\";s:38:\"social-description-tax-slides_category\";s:0:\"\";s:36:\"social-image-url-tax-slides_category\";s:0:\"\";s:35:\"social-image-id-tax-slides_category\";i:0;s:33:\"taxonomy-slides_category-ptparent\";i:0;s:28:\"title-tax-carousels_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-carousels_category\";s:0:\"\";s:38:\"display-metabox-tax-carousels_category\";b:1;s:30:\"noindex-tax-carousels_category\";b:0;s:35:\"social-title-tax-carousels_category\";s:23:\"%%term_title%% Archives\";s:41:\"social-description-tax-carousels_category\";s:0:\"\";s:39:\"social-image-url-tax-carousels_category\";s:0:\"\";s:38:\"social-image-id-tax-carousels_category\";i:0;s:36:\"taxonomy-carousels_category-ptparent\";i:0;s:34:\"title-tax-masonry_gallery_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:37:\"metadesc-tax-masonry_gallery_category\";s:0:\"\";s:44:\"display-metabox-tax-masonry_gallery_category\";b:1;s:36:\"noindex-tax-masonry_gallery_category\";b:0;s:41:\"social-title-tax-masonry_gallery_category\";s:23:\"%%term_title%% Archives\";s:47:\"social-description-tax-masonry_gallery_category\";s:0:\"\";s:45:\"social-image-url-tax-masonry_gallery_category\";s:0:\"\";s:44:\"social-image-id-tax-masonry_gallery_category\";i:0;s:42:\"taxonomy-masonry_gallery_category-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `wpev_options` VALUES("253", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `wpev_options` VALUES("254", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wpev_options` VALUES("314", "ewww_image_optimizer_dismiss_exec_notice", "1", "yes");
INSERT INTO `wpev_options` VALUES("316", "revslider-valid-notice", "false", "yes");
INSERT INTO `wpev_options` VALUES("317", "current_theme", "Bridge", "yes");
INSERT INTO `wpev_options` VALUES("318", "theme_mods_bridge", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:14:\"top-navigation\";i:16;s:16:\"popup-navigation\";i:0;}s:18:\"custom_css_post_id\";i:1344;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1626970295;s:4:\"data\";a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:12:\"sidebar_page\";a:1:{i:0;s:13:\"custom_html-7\";}s:11:\"header_left\";a:0:{}s:12:\"header_right\";a:1:{i:0;s:6:\"text-2\";}s:19:\"header_bottom_right\";a:1:{i:0;s:13:\"custom_html-2\";}s:20:\"header_bottom_center\";a:0:{}s:8:\"sidearea\";a:3:{i:0;s:13:\"custom_html-6\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-5\";}s:27:\"fullscreen_menu_area_widget\";a:0:{}s:18:\"vertical_menu_area\";a:0:{}s:15:\"footer_column_1\";a:1:{i:0;s:6:\"text-3\";}s:15:\"footer_column_2\";a:1:{i:0;s:13:\"custom_html-4\";}s:15:\"footer_column_3\";a:1:{i:0;s:10:\"nav_menu-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:6:\"text-4\";}s:11:\"footer_text\";a:1:{i:0;s:6:\"text-5\";}s:16:\"footer_text_left\";a:0:{}s:17:\"footer_text_right\";a:0:{}s:18:\"header_fixed_right\";a:0:{}s:15:\"left_side_fixed\";a:0:{}}}}", "yes");
INSERT INTO `wpev_options` VALUES("319", "theme_switched", "", "yes");
INSERT INTO `wpev_options` VALUES("320", "widget_qode_sticky_sidebar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("321", "widget_qode_latest_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("322", "widget_related_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("323", "widget_latest_posts_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("324", "widget_call_to_action_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("325", "widget_qode_social_icon_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpev_options` VALUES("326", "qode_required_plugins", "a:6:{i:0;s:11:\"js_composer\";i:1;s:11:\"LayerSlider\";i:2;s:9:\"revslider\";i:3;s:13:\"envato-market\";i:4;s:17:\"qode-twitter-feed\";i:5;s:21:\"qode-instagram-widget\";}", "yes");
INSERT INTO `wpev_options` VALUES("277", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wpev_options` VALUES("285", "wpseo_ryte", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1628261394;}", "yes");
INSERT INTO `wpev_options` VALUES("286", "recovery_mode_email_last_sent", "1617726094", "yes");
INSERT INTO `wpev_options` VALUES("315", "ewww_image_optimizer_tracking_notice", "1", "yes");
INSERT INTO `wpev_options` VALUES("302", "wpforms_notifications", "a:4:{s:6:\"update\";i:1628276239;s:4:\"feed\";a:2:{i:0;a:6:{s:5:\"title\";s:86:\"Updated in WPForms 1.6.8! A Fresh Form Builder Experience + Tons of New Form Templates\";s:7:\"content\";s:402:\"WPForms 1.6.8 includes a big revamp to the form builder you know and love, with visual updates + reorganization and optimization. Plus, in addition to the new templates available for all users, those with WPForms Pro can now instantly access hundreds more newly built templates, so you’ll never have to build a form from scratch again. It’s easier than ever before to build and maintain your forms.\";s:4:\"type\";a:1:{i:0;s:4:\"lite\";}s:2:\"id\";i:82;s:4:\"btns\";a:2:{s:4:\"main\";a:2:{s:3:\"url\";s:194:\"https://wpforms.com/introducing-wpforms-1-6-8-refreshed-form-builder-new-templates/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=Plugin Notification&utm_content=WPForms 168 Learn More\";s:4:\"text\";s:10:\"Learn More\";}s:3:\"alt\";a:2:{s:3:\"url\";s:157:\"https://wpforms.com/wpforms-lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=Plugin Notification&utm_content=WPForms 168 Get WPForms Pro\";s:4:\"text\";s:15:\"Get WPForms Pro\";}}s:5:\"start\";s:19:\"2021-07-28 00:00:00\";}i:1;a:6:{s:5:\"title\";s:29:\"Geolocation Got a Huge Revamp\";s:7:\"content\";s:181:\"Address Autocomplete is here for both Address and Single Line Text fields! Plus smart location detection, interactive address maps, and more in the latest Geolocation Addon update. \";s:4:\"type\";a:1:{i:0;s:4:\"lite\";}s:2:\"id\";i:68;s:4:\"btns\";a:2:{s:4:\"main\";a:2:{s:3:\"url\";s:195:\"https://wpforms.com/announcing-geolocation-2-0-excel-entry-export-notification-cloning/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=Plugin Notification&utm_content=Geo Lite Learn More\";s:4:\"text\";s:10:\"Learn More\";}s:3:\"alt\";a:2:{s:3:\"url\";s:154:\"https://wpforms.com/wpforms-lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=Plugin Notification&utm_content=Geo Lite Get WPForms Pro\";s:4:\"text\";s:15:\"Get WPForms Pro\";}}s:5:\"start\";s:19:\"2021-05-21 00:00:00\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wpev_options` VALUES("93400", "WPLANG", "", "yes");
INSERT INTO `wpev_options` VALUES("93401", "new_admin_email", "webdesign@milpond.com", "yes");
INSERT INTO `wpev_options` VALUES("93402", "adminhash", "a:2:{s:4:\"hash\";s:32:\"49c7fe72687abda1b40b0eefd7ec81b7\";s:8:\"newemail\";s:21:\"webdesign@milpond.com\";}", "yes");
INSERT INTO `wpev_options` VALUES("93424", "ls-store-data", "a:4:{s:12:\"last_updated\";s:10:\"2020-11-18\";s:7:\"sliders\";a:93:{s:15:\"back-to-the-80s\";a:7:{s:8:\"released\";s:10:\"2020-09-29\";s:4:\"name\";s:15:\"Back To The 80s\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:54:\"new,premium,sliders,parallax,loop,blend,specialeffects\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/back-to-the-80s/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/back-to-the-80s.jpg\";}s:17:\"love-with-flowers\";a:7:{s:8:\"released\";s:10:\"2020-07-28\";s:4:\"name\";s:17:\"LOVE with Flowers\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:38:\"new,free,landing,sliders,parallax,loop\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/love-with-flowers/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/love-with-flowers.jpg\";}s:6:\"people\";a:7:{s:8:\"released\";s:10:\"2020-07-13\";s:4:\"name\";s:6:\"People\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:47:\"new,premium,landing,blend,static,specialeffects\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/people/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/people.jpg\";}s:16:\"music-is-my-life\";a:7:{s:8:\"released\";s:10:\"2020-07-06\";s:4:\"name\";s:16:\"Music Is My Life\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:24:\"new,premium,slider,blend\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/music-is-my-life/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/music-is-my-life.jpg\";}s:21:\"product-showcase-dark\";a:7:{s:8:\"released\";s:10:\"2020-07-01\";s:4:\"name\";s:25:\"Product Showcase – Dark\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"new,premium,slider\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/sliders/product-showcase-dark/\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-dark.jpg\";}s:13:\"team-showcase\";a:7:{s:8:\"released\";s:10:\"2020-06-24\";s:4:\"name\";s:13:\"Team Showcase\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:25:\"new,premium,slider,static\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/team-showcase/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/team-showcase.jpg\";}s:14:\"furniture-shop\";a:7:{s:8:\"released\";s:10:\"2020-06-09\";s:4:\"name\";s:14:\"Furniture Shop\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:27:\"new,premium,landing,website\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/furniture-shop/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-shop.jpg\";}s:14:\"product-banner\";a:7:{s:8:\"released\";s:10:\"2020-06-02\";s:4:\"name\";s:14:\"Product Banner\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/product-banner/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-banner.jpg\";}s:19:\"architecture-slider\";a:7:{s:8:\"released\";s:10:\"2020-05-26\";s:4:\"name\";s:19:\"Architecture Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/architecture-slider/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/architecture-slider.jpg\";}s:22:\"product-showcase-light\";a:7:{s:8:\"released\";s:10:\"2020-05-18\";s:4:\"name\";s:26:\"Product Showcase – Light\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:25:\"new,premium,slider,static\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/product-showcase-light/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-light.jpg\";}s:12:\"fashion-shop\";a:7:{s:8:\"released\";s:10:\"2020-05-12\";s:4:\"name\";s:12:\"Fashion Shop\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/fashion-shop/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/fashion-shop.jpg\";}s:12:\"pixel-agency\";a:7:{s:8:\"released\";s:10:\"2020-05-05\";s:4:\"name\";s:12:\"PIXEL Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:55:\"new,premium,fullwidth,landing,website,text,popup,static\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/pixel-agency/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/pixel-agency.jpg\";}s:11:\"mode-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-28\";s:4:\"name\";s:11:\"Mode Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:30:\"new,free,fullwidth,slider,text\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/mode-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mode-slider.jpg\";}s:13:\"mountain-bike\";a:7:{s:8:\"released\";s:10:\"2020-04-22\";s:4:\"name\";s:13:\"Mountain Bike\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:45:\"premium,new,fullsize,landing,pack,static,text\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/mountain-bike/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/mountain-bike.jpg\";}s:18:\"aerial-photography\";a:7:{s:8:\"released\";s:10:\"2020-04-14\";s:4:\"name\";s:18:\"Aerial Photography\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,new,slider,static,text,kenburns\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/aerial-photography/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/aerial-photography.jpg\";}s:24:\"simple-fullscreen-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-07\";s:4:\"name\";s:24:\"Simple Fullscreen Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:46:\"free,new,fullsize,landing,static,text,kenburns\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/sliders/simple-fullscreen-slider/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-fullscreen-slider.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/#covid-19-notification\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/popups/#top-bar-notice\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-snow-globe.jpg\";}s:9:\"xmas-2019\";a:7:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:9:\"Xmas 2019\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:32:\"free,parallax,slider,loop,filter\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/xmas-2019/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas-2019.jpg\";}s:18:\"creative-portraits\";a:7:{s:8:\"released\";s:10:\"2019-12-09\";s:4:\"name\";s:18:\"Creative Portraits\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/creative-portraits/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-portraits.jpg\";}s:13:\"parallax-city\";a:7:{s:8:\"released\";s:10:\"2019-12-02\";s:4:\"name\";s:13:\"Parallax City\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:58:\"premium,landing,pack,parallax,text,blend,fullwidth,website\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/parallax-city/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/parallax-city.jpg\";}s:10:\"cybertruck\";a:7:{s:8:\"released\";s:10:\"2019-11-28\";s:4:\"name\";s:10:\"Cybertruck\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,fullsize,landing,specialeffects\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/cybertruck/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/cybertruck.jpg\";}s:17:\"summer-collection\";a:7:{s:8:\"released\";s:10:\"2019-11-21\";s:4:\"name\";s:17:\"Summer Collection\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:21:\"free,fullwidth,sli